/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.gift.BigGift;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.PorterDuff;
import android.graphics.SurfaceTexture;
import android.view.TextureView;
import com.yy.mobile.ui.gift.BigGift.BigGiftDrawThread;
import com.yy.mobile.ui.gift.BigGiftEffectController;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.ICoreManagerBase;
import java.io.File;

public class BigGiftEffectTextureView
extends TextureView
implements TextureView.SurfaceTextureListener {
    public static int STATE_CURRENT;
    public static long mspf;
    public Bitmap bigEffectBitmap;
    private String mResHeadPath = ICoreManagerBase.getContext().getFilesDir() + File.separator;
    private Context mContext;
    private int screenWidht;
    private int screenHeight;
    private int frameIndex;
    private int frame;
    private String giftType;
    private boolean animationEnd = false;
    private boolean isEnd = false;
    private int imageWidth;
    private int imageHeight;
    private BitmapFactory.Options options;
    private long duration;
    private float scaleValue = 1.0f;
    private BigGiftDrawThread mBigGiftDrawThread;
    private BigGiftEffectController.AnimationListener animationListener;
    private int drawImagePosX;
    private int drawImagePosY;
    private int bottom;
    private boolean leaveCurrentChannel = false;
    private boolean isDebugLog = true;
    private boolean isInfoLog = true;

    public BigGiftEffectTextureView(Context context) {
        super(context);
        this.mContext = context;
        float tempScaleValue = (float)ResolutionUtils.getScreenWidth((Context)this.mContext) / 640.0f;
        float f = this.scaleValue = tempScaleValue > 1.8f ? 1.8f : tempScaleValue;
        if (this.scaleValue < 1.0f) {
            this.scaleValue = 1.0f;
        }
        this.options = new BitmapFactory.Options();
        this.setOpaque(false);
        this.setSurfaceTextureListener(this);
        this.screenWidht = ResolutionUtils.getScreenWidth((Context)context);
        this.screenHeight = ResolutionUtils.getScreenHeight((Context)context);
        this.bottom = (int)ResolutionUtils.convertDpToPixel((float)50.0f, (Context)context);
        STATE_CURRENT = 2;
    }

    public void setAnimationListener(BigGiftEffectController.AnimationListener animationListener) {
        this.animationListener = animationListener;
    }

    public void play() {
        this.starDrawThread();
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public int getFrameIndex() {
        return this.frameIndex;
    }

    public void setFrameIndex(int frameIndex) {
        this.frameIndex = frameIndex;
    }

    public int getFrame() {
        return this.frame;
    }

    public void setFrame(int frame) {
        this.frame = frame;
    }

    public void setGiftType(String giftType) {
        this.giftType = giftType;
    }

    public void setLandscape(boolean landscape) {
        this.screenWidht = ResolutionUtils.getScreenWidth((Context)this.mContext);
        this.screenHeight = ResolutionUtils.getScreenHeight((Context)this.mContext);
    }

    private String getResPath() {
        String frameName = this.frameIndex < 10 ? String.format("0%d.png", this.frameIndex) : String.format("%d.png", this.frameIndex);
        String path = String.format("%s%s%s", this.mResHeadPath, this.giftType, frameName);
        return path;
    }

    public void doDraw(Canvas canvas) {
        if (this.bigEffectBitmap != null) {
            canvas.drawBitmap(this.bigEffectBitmap, (float)this.drawImagePosX, (float)this.drawImagePosY, null);
        }
    }

    public void logic() {
        if (this.getFrameIndex() <= this.getFrame()) {
            if (this.isEnd) {
                this.isEnd = false;
                this.animationEnd = false;
            }
            try {
                if (this.bigEffectBitmap != null && !this.bigEffectBitmap.isRecycled()) {
                    this.bigEffectBitmap.recycle();
                    this.bigEffectBitmap = null;
                }
                this.options.inBitmap = this.bigEffectBitmap;
                this.options.inJustDecodeBounds = true;
                BitmapFactory.decodeFile((String)this.getResPath(), (BitmapFactory.Options)this.options);
                this.options.inJustDecodeBounds = false;
                int picWidth = (int)(this.scaleValue * (float)this.options.outWidth);
                int picHeight = (int)(this.scaleValue * (float)this.options.outHeight);
                if (this.imageWidth == 0) {
                    this.imageWidth = picWidth;
                }
                if (this.imageHeight == 0) {
                    this.imageHeight = picHeight;
                }
                this.drawImagePosX = (this.screenWidht - picWidth) / 2;
                this.drawImagePosY = this.screenHeight - picHeight - this.bottom;
                this.bigEffectBitmap = Bitmap.createScaledBitmap((Bitmap)BitmapFactory.decodeFile((String)this.getResPath(), (BitmapFactory.Options)this.options), (int)picWidth, (int)picHeight, (boolean)true);
                int frameIndex = this.getFrameIndex() + 1;
                this.setFrameIndex(frameIndex);
            }
            catch (OutOfMemoryError e) {
                this.printILog((Object)this, "wwd BigGfitEffect is oom!", new Object[0]);
                if (!this.animationEnd && !this.isEnd) {
                    this.isEnd = true;
                    this.setAnimationEnd(true);
                }
                STATE_CURRENT = 3;
            }
            catch (Exception e) {
                this.printILog((Object)this, "wwd \u8d44\u6e90\u83b7\u53d6\u5931\u8d25!", new Object[0]);
                if (!this.animationEnd && !this.isEnd) {
                    this.isEnd = true;
                    this.setAnimationEnd(true);
                }
                STATE_CURRENT = 3;
            }
        } else if (STATE_CURRENT != 2) {
            STATE_CURRENT = 0;
            if (!this.animationEnd && !this.isEnd) {
                this.isEnd = true;
                this.setAnimationEnd(true);
            }
        }
    }

    public void endDraw() {
        if (this.animationListener != null) {
            this.animationListener.animationEnd();
        }
    }

    public void callBackMessage(int messageId) {
        if (this.animationListener != null) {
            this.animationListener.callBackMessage(messageId);
        }
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
        if (STATE_CURRENT == 2 && this.mBigGiftDrawThread != null) {
            BigGiftDrawThread bigGiftDrawThread = this.mBigGiftDrawThread;
            synchronized (bigGiftDrawThread) {
                this.mBigGiftDrawThread.notifyAll();
            }
        }
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
        this.printDLog((Object)this, "wwd onSurfaceTextureDestroyed(SurfaceTexture surface)", new Object[0]);
        this.stopDrawThread();
        return true;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surface) {
        if (this.leaveCurrentChannel) {
            this.printDLog((Object)this, "wwd \u79bb\u5f00\u9891\u9053! onSurfaceTextureUpdated()", new Object[0]);
            this.leaveCurrentChannel = false;
            if (STATE_CURRENT != 2) {
                STATE_CURRENT = 2;
            }
        }
    }

    public boolean initDrawThread() {
        if (this.mBigGiftDrawThread == null) {
            STATE_CURRENT = 1;
            this.mBigGiftDrawThread = new BigGiftDrawThread(this);
            this.mBigGiftDrawThread.setRun(true);
            this.mBigGiftDrawThread.start();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void starDrawThread() {
        mspf = this.getDuration();
        boolean bInintDrawThread = this.initDrawThread();
        if (!(bInintDrawThread || STATE_CURRENT != 2 && STATE_CURRENT != 0)) {
            STATE_CURRENT = 1;
            if (MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)"BigGiftEffectTextureView", (String)("wwd synchronized (mBigGiftDrawThread.mWaitLock) thread state=" + this.mBigGiftDrawThread.isRun()), (Object[])new Object[0]);
            }
            BigGiftDrawThread bigGiftDrawThread = this.mBigGiftDrawThread;
            synchronized (bigGiftDrawThread) {
                this.mBigGiftDrawThread.notifyAll();
            }
        }
    }

    public void pauseDraw() {
        this.printILog((Object)this, "wwd textureView pauseDraw()", new Object[0]);
        STATE_CURRENT = 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeDraw() {
        this.printILog((Object)this, "wwd textureView resumeDraw()", new Object[0]);
        if (this.mBigGiftDrawThread != null && STATE_CURRENT == 2) {
            if (!this.mBigGiftDrawThread.isRun()) {
                this.printDLog((Object)this, "wwd textureView create a new drawThread!", new Object[0]);
                STATE_CURRENT = 1;
                this.callBackMessage(1);
                this.mBigGiftDrawThread = new BigGiftDrawThread(this);
                this.mBigGiftDrawThread.setRun(true);
                this.mBigGiftDrawThread.start();
            } else if (this.getEffectSize() > 0) {
                this.printDLog((Object)this, "wwd textureView effectSize > 0 \uff01notify waitLock is Run", new Object[0]);
                STATE_CURRENT = 1;
                this.callBackMessage(1);
                BigGiftDrawThread bigGiftDrawThread = this.mBigGiftDrawThread;
                synchronized (bigGiftDrawThread) {
                    this.mBigGiftDrawThread.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopDrawThread() {
        if (this.mBigGiftDrawThread != null) {
            this.mBigGiftDrawThread.setRun(false);
            BigGiftDrawThread bigGiftDrawThread = this.mBigGiftDrawThread;
            synchronized (bigGiftDrawThread) {
                this.mBigGiftDrawThread.notifyAll();
            }
            STATE_CURRENT = 2;
            try {
                this.mBigGiftDrawThread.join();
            }
            catch (InterruptedException e) {
                MLog.info((Object)"BigGiftEffectTextureView", (String)e.getMessage(), (Object[])new Object[0]);
            }
            this.reset();
        }
    }

    public void clearScreen() {
        Canvas canvas = null;
        try {
            canvas = this.lockCanvas();
            if (canvas != null) {
                canvas.drawColor(0, PorterDuff.Mode.CLEAR);
            }
        }
        catch (Exception e) {
            MLog.info((Object)"BigGiftEffectTextureView", (String)e.getMessage(), (Object[])new Object[0]);
        }
        finally {
            if (canvas != null) {
                try {
                    this.unlockCanvasAndPost(canvas);
                }
                catch (Exception e) {
                    MLog.info((Object)"BigGiftEffectTextureView", (String)e.getMessage(), (Object[])new Object[0]);
                }
            }
        }
    }

    public void setLeaveCurrentChannel(boolean leaveCurrentChannel) {
        this.leaveCurrentChannel = leaveCurrentChannel;
        if (this.mBigGiftDrawThread != null && STATE_CURRENT != 2) {
            STATE_CURRENT = 2;
        }
    }

    public boolean isAnimationEnd() {
        return this.animationEnd;
    }

    public void setAnimationEnd(boolean animationEnd) {
        this.animationEnd = animationEnd;
    }

    public void onDisponse() {
        if (this.mBigGiftDrawThread != null) {
            this.mBigGiftDrawThread = null;
        }
        if (this.bigEffectBitmap != null && !this.bigEffectBitmap.isRecycled()) {
            this.bigEffectBitmap.recycle();
            this.bigEffectBitmap = null;
        }
    }

    public boolean isDrawAnimation() {
        if (this.mBigGiftDrawThread != null) {
            return this.mBigGiftDrawThread.isRun();
        }
        return true;
    }

    public void reset() {
        this.setFrameIndex(1);
        this.setFrame(0);
        this.setGiftType("");
        this.setDuration(0);
        STATE_CURRENT = 2;
    }

    public int getEffectSize() {
        if (this.animationListener != null) {
            return this.animationListener.getAnimationLinkedListSize();
        }
        return 0;
    }

    private void printDLog(Object obj, String format, Object ... args) {
        if (this.isDebugLog && MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)obj, (String)format, (Object[])args);
        }
    }

    private void printILog(Object obj, String format, Object ... args) {
        if (this.isInfoLog) {
            MLog.info((Object)obj, (String)format, (Object[])args);
        }
    }

    static {
        mspf = 33L;
    }
}

