/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.gift.BigGift;

import android.content.Context;
import android.text.SpannableString;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;
import com.yy.mobile.image.ImageConfig;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.util.ResolutionUtils;

public class BigGiftBanner {
    public static int bannerWidth = 0;
    public static int bannerHeight = 0;
    private View mRootView;
    private Context mContext;
    private RecycleImageView mIvBannerImageBg;
    private TextView mTvSendName;
    private TextView mTvGiftName;
    private RecycleImageView mIvGiftIcon;
    private TextView mTvGiftNumber;
    private int giftNumber = 0;
    private String tempSendName;
    private String tempGiftName;

    public BigGiftBanner(Context context) {
        this.mContext = context;
        this.mRootView = LayoutInflater.from((Context)context).inflate(R.layout.banner_big_gift_layout, null);
        this.init();
    }

    public View getBannerView() {
        return this.mRootView;
    }

    private void init() {
        this.mIvBannerImageBg = (RecycleImageView)this.mRootView.findViewById(R.id.banner_bg_id);
        bannerWidth = (int)ResolutionUtils.convertDpToPixel((float)260.0f, (Context)this.mContext);
        bannerHeight = (int)ResolutionUtils.convertDpToPixel((float)22.0f, (Context)this.mContext);
        this.mTvSendName = (TextView)this.mRootView.findViewById(R.id.banner_userName);
        this.mTvGiftName = (TextView)this.mRootView.findViewById(R.id.banner_giftName);
        this.mIvGiftIcon = (RecycleImageView)this.mRootView.findViewById(R.id.banner_giftIcon);
        this.mTvGiftNumber = (TextView)this.mRootView.findViewById(R.id.banner_giftNumber);
        this.setGiftNumber(1);
        this.setBannerBackground(R.drawable.big_gift_effect_bg);
    }

    public void setBannerBackground(int resId) {
        if (this.mIvBannerImageBg != null) {
            this.mIvBannerImageBg.setBackgroundResource(resId);
        }
    }

    public void setBannerInfo(String name, String giftName, int giftNum, String giftIconUrl, int nobleLevel) {
        if (name == null || giftName == null) {
            return;
        }
        if (!name.equals(this.tempSendName)) {
            this.tempSendName = name;
            if (this.mTvSendName != null) {
                if (name.length() > 10) {
                    name = name.substring(0, 10);
                }
                this.mTvSendName.setText((CharSequence)name);
                this.mTvSendName.setPadding(0, (int)ResolutionUtils.convertDpToPixel((float)2.0f, (Context)this.mContext), 0, 0);
            }
        }
        if (!giftName.equals(this.tempGiftName)) {
            this.tempGiftName = giftName;
            if (this.mTvGiftName != null) {
                String strGiftName = String.format("\u9001%s", giftName);
                this.mTvGiftName.setText((CharSequence)strGiftName);
            }
        }
        this.setGiftNumber(giftNum);
        if (this.mIvGiftIcon != null) {
            ImageLoader.loadImage((String)giftIconUrl, (RecycleImageView)this.mIvGiftIcon, (ImageConfig)ImageConfig.defaultImageConfig(), (int)R.drawable.lr_ic_default_gift);
        }
    }

    public void setGiftAreaText(SpannableString spannableStr) {
        if (this.mTvGiftName != null && spannableStr != null) {
            this.tempGiftName = spannableStr.toString();
            this.mTvGiftName.setText((CharSequence)spannableStr);
        }
    }

    public void setGiftNumber(int giftNumber) {
        if (this.giftNumber != giftNumber) {
            this.giftNumber = giftNumber;
            String strGiftNumber = String.format("x%d", giftNumber);
            this.mTvGiftNumber.setText((CharSequence)strGiftNumber);
        }
    }
}

