/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.fullservicebroadcast;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.text.SpannableString;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.log.MLog;
import com.yyproto.utils.FP;

public class BroadcastLinearLayout
extends LinearLayout {
    public LinearLayout llBoardcastBc;
    public TextView tvBoardcastBcInfo;
    private AnimatorSet mHengFuAnimatorSet;
    public AnimatorSet mTxtAnimatorSet;
    private AnimatorSet mSidAnimatorSet;
    private AnimatorSet mTotalAnimatorSet;
    private int type = 0;

    public BroadcastLinearLayout(Context context) {
        super(context);
        this.initViews();
    }

    private void initViews() {
        RelativeLayout root = (RelativeLayout)LayoutInflater.from((Context)this.getContext()).inflate(R.layout.layout_boardcast_all, null);
        root.measure(0, 0);
        this.addView((View)root, new ViewGroup.LayoutParams(-1, -2));
        this.llBoardcastBc = (LinearLayout)this.findViewById(R.id.ll_boardcast_bc);
        this.tvBoardcastBcInfo = (TextView)this.findViewById(R.id.tv_boardcast_bc_info);
        this.mHengFuAnimatorSet = new AnimatorSet();
        this.mTxtAnimatorSet = new AnimatorSet();
        this.mSidAnimatorSet = new AnimatorSet();
    }

    private void buildHengfuAnim() {
        int h = this.llBoardcastBc.getMeasuredHeight();
        final RelativeLayout.LayoutParams lp = (RelativeLayout.LayoutParams)this.llBoardcastBc.getLayoutParams();
        ValueAnimator scaleIn = ValueAnimator.ofInt((int[])new int[]{0, h});
        scaleIn.setDuration(160L);
        scaleIn.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                lp.height = (Integer)animation.getAnimatedValue();
                BroadcastLinearLayout.this.llBoardcastBc.requestLayout();
            }
        });
        ObjectAnimator translationRight = ObjectAnimator.ofFloat((Object)this.llBoardcastBc, (String)"translationX", (float[])new float[]{0.0f, ResolutionUtils.convertDpToPixel((float)8.0f, (Context)this.getContext())});
        translationRight.setDuration(160L);
        ObjectAnimator translationLeft = ObjectAnimator.ofFloat((Object)this.llBoardcastBc, (String)"translationX", (float[])new float[]{ResolutionUtils.convertDpToPixel((float)8.0f, (Context)this.getContext()), (float)(-this.llBoardcastBc.getMeasuredWidth()) * 0.8f});
        translationLeft.setDuration(1480L);
        translationRight.setStartDelay(5000L);
        this.mHengFuAnimatorSet.play((Animator)translationLeft).after((Animator)translationRight);
        this.mHengFuAnimatorSet.play((Animator)scaleIn).with((Animator)translationRight);
        this.mHengFuAnimatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                super.onAnimationStart(animation);
                BroadcastLinearLayout.this.llBoardcastBc.setVisibility(0);
                BroadcastLinearLayout.this.llBoardcastBc.setTranslationX(0.0f);
                if (MLog.isLogLevelAboveDebug()) {
                    MLog.debug((Object)"BroadcastLinearLayout", (String)"[buildHengfuAnim] onAnimationStart()", (Object[])new Object[0]);
                }
            }

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                if (BroadcastLinearLayout.this.llBoardcastBc != null) {
                    BroadcastLinearLayout.this.llBoardcastBc.setVisibility(4);
                }
                BroadcastLinearLayout.this.setVisibility(4);
                if (MLog.isLogLevelAboveDebug()) {
                    MLog.debug((Object)"BroadcastLinearLayout", (String)"[buildHengfuAnim] onAnimationEnd()", (Object[])new Object[0]);
                }
            }
        });
    }

    private void buildTxtAnim() {
        this.llBoardcastBc.measure(0, 0);
        this.tvBoardcastBcInfo.measure(0, 0);
        ObjectAnimator translationIn = ObjectAnimator.ofFloat((Object)this.tvBoardcastBcInfo, (String)"translationX", (float[])new float[]{this.llBoardcastBc.getMeasuredWidth(), 0.0f});
        int width = this.llBoardcastBc.getMeasuredWidth() / 2 - this.tvBoardcastBcInfo.getMeasuredWidth() / 2;
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)((Object)this), (String)("[buildTxtAnim],ll_boardcast_bc_width::" + this.llBoardcastBc.getMeasuredWidth() + ",width::" + width + ",tvBoardcastBcInfo.getMeasuredWidth()::" + this.tvBoardcastBcInfo.getMeasuredWidth()), (Object[])new Object[0]);
        }
        MLog.debug((Object)"chenbinhao", (String)("[buildTxtAnim],ll_boardcast_bc_width::" + this.llBoardcastBc.getMeasuredWidth() + ",width::" + width + ",tvBoardcastBcInfo.getMeasuredWidth()::" + this.tvBoardcastBcInfo.getMeasuredWidth()), (Object[])new Object[0]);
        translationIn.setDuration(1360L);
        ObjectAnimator fadeOut = ObjectAnimator.ofFloat((Object)this.tvBoardcastBcInfo, (String)"alpha", (float[])new float[]{1.0f, 0.0f});
        fadeOut.setDuration(240L);
        fadeOut.setStartDelay(5120L);
        this.mTxtAnimatorSet.play((Animator)translationIn).with((Animator)fadeOut);
        this.mTxtAnimatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                if (MLog.isLogLevelAboveDebug()) {
                    MLog.debug((Object)"BroadcastLinearLayout", (String)"[buildTxtAnim] onAnimationStart", (Object[])new Object[0]);
                }
                BroadcastLinearLayout.this.tvBoardcastBcInfo.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        BroadcastLinearLayout.this.tvBoardcastBcInfo.setTranslationX((float)BroadcastLinearLayout.this.llBoardcastBc.getMeasuredWidth());
                        BroadcastLinearLayout.this.tvBoardcastBcInfo.setVisibility(0);
                        BroadcastLinearLayout.this.tvBoardcastBcInfo.setAlpha(1.0f);
                        if (MLog.isLogLevelAboveDebug()) {
                            MLog.debug((Object)"BroadcastLinearLayout", (String)"[buildTxtAnim] postDelayed()", (Object[])new Object[0]);
                        }
                    }
                }, BroadcastLinearLayout.this.mTxtAnimatorSet.getStartDelay());
            }

            public void onAnimationEnd(Animator animation) {
                if (MLog.isLogLevelAboveDebug()) {
                    MLog.debug((Object)"BroadcastLinearLayout", (String)"[buildTxtAnim] onAnimationEnd", (Object[])new Object[0]);
                }
                BroadcastLinearLayout.this.tvBoardcastBcInfo.setVisibility(4);
            }
        });
    }

    private int getBoardcastBcWidth() {
        int screenWidth = ResolutionUtils.getScreenWidth((Context)this.getContext());
        int margin = (int)ResolutionUtils.convertDpToPixel((float)16.0f, (Context)BasicConfig.getInstance().getAppContext());
        return screenWidth - margin;
    }

    private void buildSidAnim() {
    }

    public void playTotalAnim() {
        if (this.mHengFuAnimatorSet != null) {
            this.mHengFuAnimatorSet.removeAllListeners();
            this.mHengFuAnimatorSet.end();
        }
        if (this.mTxtAnimatorSet != null) {
            this.mTxtAnimatorSet.removeAllListeners();
            this.mTxtAnimatorSet.end();
        }
        if (this.mSidAnimatorSet != null) {
            this.mSidAnimatorSet.removeAllListeners();
            this.mSidAnimatorSet.end();
        }
        if (this.mTotalAnimatorSet != null && this.mTotalAnimatorSet.isRunning()) {
            this.mTotalAnimatorSet.removeAllListeners();
            this.mTotalAnimatorSet.end();
        }
        this.setVisibility(0);
        this.buildHengfuAnim();
        this.buildTxtAnim();
        this.buildSidAnim();
        this.mTxtAnimatorSet.setStartDelay(640L);
        this.mTotalAnimatorSet = new AnimatorSet();
        this.mTotalAnimatorSet.play((Animator)this.mHengFuAnimatorSet).with((Animator)this.mTxtAnimatorSet).with((Animator)this.mSidAnimatorSet);
        this.mTotalAnimatorSet.start();
    }

    public void setTxtInfo(SpannableString ss) {
        this.tvBoardcastBcInfo.setText((CharSequence)ss);
    }

    public void setSid(SpannableString sidInfo) {
    }

    public void setSid(long sid) {
    }

    public void setCommonSid(long sid) {
    }

    public void setHengFuBg(int resId) {
        this.llBoardcastBc.setBackgroundResource(resId);
    }

    public void setHengFuUrlBkg(final String url) {
        if (FP.empty((CharSequence)url)) {
            return;
        }
        BitmapDrawable bitmapDrawable = ImageLoader.getBitmapFromCache((String)url);
        if (bitmapDrawable != null) {
            this.llBoardcastBc.setBackgroundDrawable((Drawable)bitmapDrawable);
        } else {
            ImageLoader.loadBitmap((Context)BasicConfig.getInstance().getAppContext(), (String)url, (ImageLoader.BitmapLoadListener)new ImageLoader.BitmapLoadListener(){

                public void onLoadFailed(Exception e) {
                    MLog.error((Object)"CommonRevenueMessage", (String)("->buildSpan onLoadFailed " + url), (Object[])new Object[0]);
                }

                public void onResourceReady(Bitmap bitmap) {
                    BitmapDrawable bitmapDrawable = new BitmapDrawable(bitmap);
                    BroadcastLinearLayout.this.llBoardcastBc.setBackgroundDrawable((Drawable)bitmapDrawable);
                    ImageLoader.addBitmapToCache((String)url, (BitmapDrawable)bitmapDrawable);
                }
            });
        }
    }

    public void setSidBg(int resId) {
    }

    public void onDestroy() {
        if (this.mTotalAnimatorSet != null && this.mTotalAnimatorSet.isRunning()) {
            this.mTotalAnimatorSet.end();
        }
        this.setVisibility(8);
    }

    public void setTextType(int type) {
        this.type = type;
    }
}

