/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.comfessionwall;

import android.content.Context;
import android.graphics.Color;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.image.CircleImageView;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.comfessionwall.ConfessionUtils;
import com.yy.mobile.util.ResolutionUtils;

public class ConfessionWallItemView
extends LinearLayout {
    private Context mContext;
    private final int width = (int)ResolutionUtils.convertDpToPixel((float)18.0f, (Context)BasicConfig.getInstance().getAppContext());
    private CircleImageView userCircleImg;
    private CircleImageView anchorCircleImg;
    private RecycleImageView hearImg;
    private RecycleImageView line;
    private boolean isCreatedView = false;

    public ConfessionWallItemView(Context context) {
        super(context);
        this.mContext = context;
        this.setOrientation(0);
    }

    public void init(String userUrl, String anchroUrl, int type) {
        if (!this.isCreatedView) {
            this.userCircleImg = new CircleImageView(this.mContext);
            LinearLayout.LayoutParams userCircleImgLayoutParams = new LinearLayout.LayoutParams(-2, -2);
            userCircleImgLayoutParams.width = this.width;
            userCircleImgLayoutParams.height = this.width;
            this.addView((View)this.userCircleImg, (ViewGroup.LayoutParams)userCircleImgLayoutParams);
            this.hearImg = new RecycleImageView(this.mContext);
            int drawableId = ConfessionUtils.getHeartIconDrawableId(type);
            this.hearImg.setImageDrawable(this.mContext.getResources().getDrawable(drawableId));
            LinearLayout.LayoutParams hearImgLayoutParams = new LinearLayout.LayoutParams(-2, -2);
            hearImgLayoutParams.gravity = 16;
            this.addView((View)this.hearImg, (ViewGroup.LayoutParams)hearImgLayoutParams);
            this.anchorCircleImg = new CircleImageView(this.mContext);
            LinearLayout.LayoutParams anchorCircleImgLayoutParams = new LinearLayout.LayoutParams(-2, -2);
            anchorCircleImgLayoutParams.width = this.width;
            anchorCircleImgLayoutParams.height = this.width;
            this.addView((View)this.anchorCircleImg, (ViewGroup.LayoutParams)anchorCircleImgLayoutParams);
            this.line = new RecycleImageView(this.mContext);
            this.line.setBackgroundColor(Color.parseColor((String)"#66ffffff"));
            LinearLayout.LayoutParams lineParams = new LinearLayout.LayoutParams(-2, -2);
            lineParams.height = (int)ResolutionUtils.convertDpToPixel((float)13.0f, (Context)BasicConfig.getInstance().getAppContext());
            lineParams.width = (int)ResolutionUtils.convertDpToPixel((float)0.5f, (Context)BasicConfig.getInstance().getAppContext());
            lineParams.gravity = 16;
            lineParams.leftMargin = (int)ResolutionUtils.convertDpToPixel((float)6.0f, (Context)BasicConfig.getInstance().getAppContext());
            this.addView((View)this.line, (ViewGroup.LayoutParams)lineParams);
            this.isCreatedView = true;
        }
        ImageLoader.loadImage((RecycleImageView)this.userCircleImg, (String)userUrl, (int)R.drawable.default_portrait);
        ImageLoader.loadImage((RecycleImageView)this.anchorCircleImg, (String)anchroUrl, (int)R.drawable.default_portrait);
    }

    public void update(String userUrl, String anchroUrl, int type) {
        if (this.userCircleImg != null) {
            ImageLoader.loadImage((RecycleImageView)this.userCircleImg, (String)userUrl, (int)R.drawable.default_portrait);
        }
        if (this.anchorCircleImg != null) {
            ImageLoader.loadImage((RecycleImageView)this.anchorCircleImg, (String)anchroUrl, (int)R.drawable.default_portrait);
        }
        if (this.hearImg != null) {
            int drawableId = ConfessionUtils.getHeartIconDrawableId(type);
            this.hearImg.setImageDrawable(this.mContext.getResources().getDrawable(drawableId));
        }
    }
}

