/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.comfessionwall;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.text.SpannableStringBuilder;
import android.text.style.ForegroundColorSpan;
import android.text.style.StyleSpan;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.image.ImageConfig;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.comfessionwall.ConfessionUtils;
import com.yy.mobile.ui.comfessionwall.WallDetailBean;
import com.yy.mobile.ui.publicchat.ui.RevenueMarqueeLayout;
import com.yy.mobile.ui.widget.CustomImageSpan;
import com.yy.mobile.util.ResolutionUtils;

public class ConfessionWallBroadcastView
extends RelativeLayout {
    private Context mContext;
    private RelativeLayout.LayoutParams layoutParams;
    public static final int BroadCastViewWidth = (int)ResolutionUtils.convertDpToPixel((float)227.0f, (Context)BasicConfig.getInstance().getAppContext());
    public static final int BroadCastViewHeight = (int)ResolutionUtils.convertDpToPixel((float)22.0f, (Context)BasicConfig.getInstance().getAppContext());
    private final int commonMargin = (int)ResolutionUtils.convertDpToPixel((float)3.0f, (Context)BasicConfig.getInstance().getAppContext());
    private final int mMarqueWidth = (int)ResolutionUtils.convertDpToPixel((float)154.0f, (Context)BasicConfig.getInstance().getAppContext());
    private final int drawablMargin = (int)ResolutionUtils.convertDpToPixel((float)5.0f, (Context)BasicConfig.getInstance().getAppContext());
    private final int giftIconSize = (int)ResolutionUtils.convertDpToPixel((float)16.0f, (Context)BasicConfig.getInstance().getAppContext());
    private RecycleImageView mTagRiv;
    private RelativeLayout.LayoutParams mTagRivLp;
    private TextView mCountDownTimeTv;
    private RelativeLayout.LayoutParams mCountDownTimeLp;
    private RecycleImageView turnRiv;
    private RelativeLayout.LayoutParams turnRivLp;
    private RevenueMarqueeLayout mMarqueLayout;
    private RelativeLayout.LayoutParams mMarqueLayoutLp;
    private String node = "[gift]";
    public OnBroadcastViewClickListener mListener;

    public void setListener(OnBroadcastViewClickListener listener2) {
        this.mListener = listener2;
    }

    public ConfessionWallBroadcastView(Context context, int topMargin) {
        super(context);
        this.mContext = context;
        this.layoutParams = new RelativeLayout.LayoutParams(BroadCastViewWidth, BroadCastViewHeight);
        this.layoutParams.topMargin = topMargin;
        this.setLayoutParams((ViewGroup.LayoutParams)this.layoutParams);
        this.setBackgroundDrawable(this.mContext.getResources().getDrawable(R.drawable.bg_comfessionwall_leve_1));
        this.createBroadCastViewItem();
        this.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (ConfessionWallBroadcastView.this.mListener != null) {
                    ConfessionWallBroadcastView.this.mListener.onClickBroadCast(view);
                }
            }
        });
    }

    private void createBroadCastViewItem() {
        if (this.mTagRiv == null) {
            this.mTagRiv = new RecycleImageView(this.mContext);
            this.mTagRiv.setId(R.id.comfessionwall_broadcast_mtagriv);
            this.mTagRivLp = new RelativeLayout.LayoutParams(-2, -2);
            this.mTagRivLp.addRule(9);
            this.mTagRivLp.addRule(15);
            this.mTagRiv.setImageDrawable(this.mContext.getResources().getDrawable(R.drawable.icon_liveroom_confession));
            this.mTagRivLp.leftMargin = (int)ResolutionUtils.convertDpToPixel((float)6.0f, (Context)BasicConfig.getInstance().getAppContext());
            this.mTagRiv.setLayoutParams((ViewGroup.LayoutParams)this.mTagRivLp);
            this.addView((View)this.mTagRiv);
        }
        if (this.mCountDownTimeTv == null) {
            this.mCountDownTimeTv = new TextView(this.mContext);
            this.mCountDownTimeTv.setId(R.id.comfeesionwall_broadcast_countdown_tv);
            this.mCountDownTimeLp = new RelativeLayout.LayoutParams(-2, -2);
            this.mCountDownTimeLp.addRule(15);
            this.mCountDownTimeLp.addRule(1, R.id.comfessionwall_broadcast_mtagriv);
            this.mCountDownTimeLp.leftMargin = (int)ResolutionUtils.convertDpToPixel((float)2.0f, (Context)BasicConfig.getInstance().getAppContext());
            this.mCountDownTimeTv.setLayoutParams((ViewGroup.LayoutParams)this.mCountDownTimeLp);
            this.mCountDownTimeTv.setTextSize(10.0f);
            this.mCountDownTimeTv.setTextColor(Color.parseColor((String)"#ffdd00"));
            this.addView((View)this.mCountDownTimeTv);
        }
        if (this.mMarqueLayout == null) {
            this.mMarqueLayout = new RevenueMarqueeLayout(this.mContext, null);
            this.mMarqueLayoutLp = new RelativeLayout.LayoutParams(-2, -2);
            this.mMarqueLayoutLp.addRule(1, R.id.comfeesionwall_broadcast_countdown_tv);
            this.mMarqueLayoutLp.addRule(0, R.id.comfeesionwall_broadcast_turnriv);
            this.mMarqueLayoutLp.addRule(15);
            this.mMarqueLayoutLp.leftMargin = this.commonMargin;
            this.mMarqueLayoutLp.rightMargin = this.commonMargin;
            this.mMarqueLayout.setLayoutParams((ViewGroup.LayoutParams)this.mMarqueLayoutLp);
            this.mMarqueLayout.setMarqueWidth(this.mMarqueWidth);
            this.addView((View)this.mMarqueLayout);
        }
        if (this.turnRiv == null) {
            this.turnRiv = new RecycleImageView(this.mContext);
            this.turnRiv.setId(R.id.comfeesionwall_broadcast_turnriv);
            this.turnRiv.setImageDrawable(this.mContext.getResources().getDrawable(R.drawable.icon_liveroom_confession_turn));
            this.turnRivLp = new RelativeLayout.LayoutParams(-2, -2);
            this.turnRivLp.addRule(15);
            this.turnRivLp.addRule(11);
            this.turnRivLp.rightMargin = (int)ResolutionUtils.convertDpToPixel((float)9.0f, (Context)BasicConfig.getInstance().getAppContext());
            this.turnRiv.setLayoutParams((ViewGroup.LayoutParams)this.turnRivLp);
            this.addView((View)this.turnRiv);
        }
    }

    public void setData(final WallDetailBean bean) {
        if (bean == null) {
            return;
        }
        if (bean.type > 0) {
            int bgDrawableId = ConfessionUtils.getBgLevelDrawableId(bean.type);
            this.setBackgroundDrawable(this.mContext.getResources().getDrawable(bgDrawableId));
        }
        this.setCountDownTime(bean.time);
        if (this.mMarqueLayout != null) {
            int anchorlen;
            int userNameLen = bean.userNick.length();
            boolean needEnd = false;
            if (userNameLen > 8) {
                bean.userNick = bean.userNick.substring(0, 8);
                needEnd = true;
            }
            if (needEnd) {
                StringBuilder sb = new StringBuilder(bean.userNick);
                sb.append("...");
                bean.userNick = sb.toString();
                needEnd = false;
            }
            if ((anchorlen = bean.anchorNick.length()) > 8) {
                bean.anchorNick = bean.anchorNick.substring(0, 8);
                needEnd = true;
            }
            if (needEnd) {
                StringBuilder sb = new StringBuilder(bean.anchorNick);
                sb.append("...");
                bean.anchorNick = sb.toString();
            }
            StringBuilder contentSb = new StringBuilder();
            contentSb.append(bean.userNick);
            contentSb.append(" \u9001\u7ed9 ");
            contentSb.append(bean.anchorNick);
            contentSb.append(this.node);
            contentSb.append(bean.giftInfo);
            SpannableStringBuilder spannedString = new SpannableStringBuilder((CharSequence)contentSb.toString());
            spannedString.setSpan((Object)new StyleSpan(1), 0, bean.userNick.length(), 33);
            spannedString.setSpan((Object)new ForegroundColorSpan(-1), 0, bean.userNick.length(), 33);
            int start2 = bean.userNick.length();
            int end = bean.userNick.length() + 4;
            spannedString.setSpan((Object)new ForegroundColorSpan(Color.parseColor((String)"#ffdd00")), start2, end, 33);
            spannedString.setSpan((Object)new StyleSpan(1), start2, end, 33);
            int start1 = end;
            int end1 = end + bean.anchorNick.length();
            spannedString.setSpan((Object)new StyleSpan(1), start1, end1, 33);
            spannedString.setSpan((Object)new ForegroundColorSpan(-1), start1, end1, 33);
            int start22 = end1;
            int end2 = end1 + this.node.length();
            final ImageConfig config = new ImageConfig(this.giftIconSize, this.giftIconSize);
            BitmapDrawable bitmapDrawable = ImageLoader.getBitmapFromCache((String)bean.getGiftUrl(), (ImageConfig)config);
            if (bitmapDrawable == null) {
                ImageLoader.loadBitmap((Context)BasicConfig.getInstance().getAppContext(), (String)bean.getGiftUrl(), (ImageLoader.BitmapLoadListener)new ImageLoader.BitmapLoadListener(){

                    public void onLoadFailed(Exception e) {
                    }

                    public void onResourceReady(Bitmap bitmap) {
                        if (bitmap != null) {
                            BitmapDrawable bitmapDrawable = new BitmapDrawable(BasicConfig.getInstance().getAppContext().getResources(), bitmap);
                            ImageLoader.addBitmapToCache((String)bean.getGiftUrl(), (BitmapDrawable)bitmapDrawable, (ImageConfig)config);
                        }
                    }
                });
                bitmapDrawable = this.mContext.getResources().getDrawable(R.drawable.lr_ic_default_gift);
            }
            bitmapDrawable.setBounds(0, 0, this.giftIconSize, this.giftIconSize);
            spannedString.setSpan((Object)new CustomImageSpan((Drawable)bitmapDrawable, 2, (float)this.drawablMargin, (float)this.drawablMargin), start22, end2, 33);
            int start3 = end2;
            int end3 = end2 + bean.giftInfo.length();
            spannedString.setSpan((Object)new StyleSpan(1), start3, end3, 33);
            spannedString.setSpan((Object)new ForegroundColorSpan(Color.parseColor((String)"#ffdd00")), start3, end3, 33);
            this.mMarqueLayout.setTextDelay((CharSequence)spannedString, 0, false, 1500L);
        }
    }

    public void setCountDownTimeSec(int sec) {
        if (sec > 0 && this.mCountDownTimeTv != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(sec).append("s");
            this.mCountDownTimeTv.setText((CharSequence)sb.toString());
        }
    }

    public void onDisponse() {
        if (this.mMarqueLayout != null) {
            this.mMarqueLayout.reserverAnimation();
            this.mMarqueLayout = null;
        }
    }

    public void setCountDownTime(int time) {
        if (this.mCountDownTimeTv != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(time).append("s");
            this.mCountDownTimeTv.setText((CharSequence)sb.toString());
        }
    }

    static interface OnBroadcastViewClickListener {
        public void onClickBroadCast(View var1);
    }
}

