/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.chatemotion;

import android.content.Context;
import android.text.TextUtils;
import android.widget.TextView;
import com.unionyy.mobile.spdt.Spdt;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.liveapi.chatemotion.uicore.IChatEmotionCore;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.richtext.ChannelTicketFilter;
import com.yy.mobile.richtext.EmoticonFilter;
import com.yy.mobile.richtext.XmlFilter;
import com.yy.mobile.richtext.YCommonTicketFilter;
import com.yy.mobile.richtext.YGroupTicketFilter;
import com.yy.mobile.ui.chatemotion.SpdtSendMessage;
import com.yy.mobile.ui.utils.SingleToastUtil;
import com.yy.mobile.util.NetworkUtils;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.basechannel.IChannelLinkCore;
import com.yymobile.core.channel.MsgValidator;
import com.yymobile.core.mobilelive.IMobileLiveCore;
import com.yymobile.core.user.UserInfo;
import javax.annotation.Nullable;

public class SendChatPresenter {
    private Context mContext;
    private IChatEmotionCore chatEmotionCore;
    private IChannelLinkCore linkChannelCore;

    public SendChatPresenter(Context context) {
        this.mContext = context;
        this.chatEmotionCore = (IChatEmotionCore)ICoreManagerBase.getCore(IChatEmotionCore.class);
        this.linkChannelCore = ICoreManagerBase.getChannelLinkCore();
    }

    public void sendMessage(String message, @Nullable TextView editInputContent, boolean[] isSendFromBtn, String isDefault) {
        if (TextUtils.isEmpty((CharSequence)message)) {
            return;
        }
        if (!NetworkUtils.isNetworkAvailable((Context)this.mContext)) {
            SingleToastUtil.showToast((int)R.string.str_net_error_common);
        }
        if (!this.isContainSensitiveWords(message) && !this.isForbidUrlAndTicket(message)) {
            int length;
            IChatEmotionCore.ChatMsgInfo chatMsgInfo = new IChatEmotionCore.ChatMsgInfo();
            chatMsgInfo.originMsg = message;
            chatMsgInfo.msgToSend = message;
            if (ChannelTicketFilter.isChannelTicketMessage((CharSequence)message) || YGroupTicketFilter.isYGroupTicketMessage((CharSequence)message)) {
                String ticketWithGivenStr = ChannelTicketFilter.replaceChannelTicketWithGivenStr((String)message, (String)"1");
                length = EmoticonFilter.getInstance().parseSpannableLength(ticketWithGivenStr);
            } else {
                length = EmoticonFilter.getInstance().parseSpannableLength(message);
            }
            chatMsgInfo.msgLength = length;
            chatMsgInfo.shouldSend = true;
            chatMsgInfo.mIsDefaultChat = isDefault;
            MLog.info((Object)"SendChatPresenter", (String)"[ouyangyj] ChatEmotionComponent: send message out for check", (Object[])new Object[0]);
            this.chatEmotionCore.setSendCurrentTime(System.currentTimeMillis());
            chatMsgInfo = this.chatEmotionCore.checkChatMsg(chatMsgInfo);
            if (!TextUtils.isEmpty((CharSequence)chatMsgInfo.msgToSend) && chatMsgInfo.msgLength > 0 && chatMsgInfo.shouldSend) {
                this.sendMessageShow(chatMsgInfo.msgToSend);
                this.chatEmotionCore.sendMessage(chatMsgInfo);
                if ("3".equals(ICoreManagerBase.getChannelLinkCore().getTemplateId()) && !StringUtils.isNullOrEmpty((String)chatMsgInfo.originMsg)) {
                    this.sendMobilelLiveVideoMsg(chatMsgInfo.originMsg);
                }
                MLog.info((Object)"SendChatPresenter", (String)"[ouyangyj] ChatEmotionComponent: component send to sdk by self", (Object[])new Object[0]);
                if (isSendFromBtn[0]) {
                    ((IChatEmotionCore)ICoreManagerBase.getCore(IChatEmotionCore.class)).setInputMsgCache("");
                    if (editInputContent != null) {
                        editInputContent.setText(null);
                    }
                    isSendFromBtn[0] = false;
                }
                if ((StringUtils.equal((String)chatMsgInfo.originMsg, (String)"1") || StringUtils.equal((String)chatMsgInfo.originMsg, (String)"2")) && !StringUtils.isEmpty((String)message).booleanValue()) {
                    this.chatEmotionCore.setMsgSendState(-1);
                } else {
                    this.chatEmotionCore.setMsgSendState(3);
                }
            } else {
                MLog.info((Object)"SendChatPresenter", (String)"[ouyangyj] ChatEmotionComponent: msg send by other holder", (Object[])new Object[0]);
                if (!chatMsgInfo.shouldKeepMsg && isSendFromBtn[0]) {
                    ((IChatEmotionCore)ICoreManagerBase.getCore(IChatEmotionCore.class)).setInputMsgCache("");
                    if (editInputContent != null) {
                        editInputContent.setText(null);
                    }
                    isSendFromBtn[0] = false;
                }
            }
        }
    }

    private void sendMobilelLiveVideoMsg(String message) {
        UserInfo userInfo = ICoreManagerBase.getUserCore().getCacheLoginUserInfo();
        if (userInfo == null) {
            ICoreManagerBase.getUserCore().requestDetailUserInfo(LoginUtil.getUid(), false);
            userInfo = ICoreManagerBase.getUserCore().getCacheLoginUserInfo();
        }
        String headUrl = "";
        if (userInfo != null) {
            if (userInfo.iconIndex > 0) {
                headUrl = BasicConfig.getInstance().getAppContext() != null ? BasicConfig.getInstance().getAppContext().getString(R.string.str_friend_head_index_url_format, new Object[]{userInfo.iconIndex}) : userInfo.iconUrl_100_100;
            } else if (!StringUtils.isNullOrEmpty((String)userInfo.iconUrl_100_100)) {
                headUrl = userInfo.iconUrl_100_100;
            } else if (!StringUtils.isNullOrEmpty((String)userInfo.iconUrl_144_144)) {
                headUrl = userInfo.iconUrl_144_144;
            } else if (!StringUtils.isNullOrEmpty((String)userInfo.iconUrl_640_640)) {
                headUrl = userInfo.iconUrl_640_640;
            }
        } else {
            ICoreManagerBase.getUserCore().requestDetailUserInfo(LoginUtil.getUid(), false);
        }
        message = StringUtils.isNullOrEmpty((String)headUrl) ? XmlFilter.creatXmlMobileLiveChannelMessage((String)message, (String)"") : XmlFilter.creatXmlMobileLiveChannelMessage((String)message, (String)headUrl);
        long anchorUid = ((IMobileLiveCore)ICoreManagerBase.getCore(IMobileLiveCore.class)).getCurrentMobileLiveInfo().anchorUid;
        if (anchorUid <= 0L) {
            anchorUid = ICoreManagerBase.getChannelLinkCore().getCurrentTopMicId();
        }
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)"SendChatPresenter", (String)("[sendMobilelLiveVideoMsg] ent taplate mobilelive video message send to private server, msg=" + message), (Object[])new Object[0]);
        }
        ((IMobileLiveCore)ICoreManagerBase.getCore(IMobileLiveCore.class)).sendMobileLiveFansSendMessage(anchorUid, message);
    }

    private boolean isForbidUrlAndTicket(String message) {
        if (!TextUtils.isEmpty((CharSequence)message) && (MsgValidator.matchUrl((String)message) || ChannelTicketFilter.isChannelTicketMessage((CharSequence)message) || YGroupTicketFilter.isYGroupTicketMessage((CharSequence)message) || YCommonTicketFilter.isCommonTicketMessage((CharSequence)message))) {
            if (this.linkChannelCore.getCurrentChannelInfo().forbidGuestSendUrl && this.linkChannelCore.getCurrentChannelInfo().forbidMemberSendUrl && (this.isChannelGuest() || this.isChannelMember())) {
                MLog.info((Object)"SendChatPresenter", (String)"sendMessage  guest and member -> forbidGuestSendUrl", (Object[])new Object[0]);
                if (((SpdtSendMessage)Spdt.of(SpdtSendMessage.class)).showTicketOrUrlLocal()) {
                    this.sendMessageShow(message);
                }
                SingleToastUtil.showToast((String)((SpdtSendMessage)Spdt.of(SpdtSendMessage.class)).getForbidMemberTicketOrUrlToast());
                return true;
            }
            if (this.linkChannelCore.getCurrentChannelInfo().forbidGuestSendUrl && !this.linkChannelCore.getCurrentChannelInfo().forbidMemberSendUrl && this.isChannelGuest()) {
                MLog.info((Object)"SendChatPresenter", (String)"sendMessage  guest -> forbidGuestSendUrl", (Object[])new Object[0]);
                if (((SpdtSendMessage)Spdt.of(SpdtSendMessage.class)).showTicketOrUrlLocal()) {
                    this.sendMessageShow(message);
                }
                SingleToastUtil.showToast((String)((SpdtSendMessage)Spdt.of(SpdtSendMessage.class)).getForbidGuestTicketOrUrlToast());
                return true;
            }
            if (this.linkChannelCore.getCurrentChannelInfo().forbidGuestSendUrl && !this.linkChannelCore.getCurrentChannelInfo().forbidMemberSendUrl) {
                MLog.info((Object)"SendChatPresenter", (String)"sendMessage  all -> forbidGuestSendUrl", (Object[])new Object[0]);
                if (((SpdtSendMessage)Spdt.of(SpdtSendMessage.class)).showTicketOrUrlLocal()) {
                    this.sendMessageShow(message);
                }
                SingleToastUtil.showToast((String)((SpdtSendMessage)Spdt.of(SpdtSendMessage.class)).getForbidTicketOrUrlToast());
                return true;
            }
        }
        return false;
    }

    private boolean isContainSensitiveWords(String message) {
        if (this.linkChannelCore.isChannelPOLICE()) {
            this.sendMessageShow(message);
            SingleToastUtil.showToast((int)R.string.str_forbid_send_with_userInfo_channelPolice);
            return true;
        }
        return false;
    }

    private boolean isChannelMember() {
        return this.linkChannelCore.getCurrentChannelLoginUserPowerInfo().isChannelMember(this.linkChannelCore.getCurrentChannelInfo().topSid, this.linkChannelCore.getCurrentChannelInfo().subSid);
    }

    private boolean isChannelGuest() {
        return this.linkChannelCore.getCurrentChannelLoginUserPowerInfo().isChannelGuest(this.linkChannelCore.getCurrentChannelInfo().topSid, this.linkChannelCore.getCurrentChannelInfo().subSid);
    }

    private boolean isMobileChannelManager() {
        IChannelLinkCore linkChannelCore = ICoreManagerBase.getChannelLinkCore();
        long topSid = linkChannelCore.getCurrentChannelInfo().topSid;
        long subSid = linkChannelCore.getCurrentChannelInfo().subSid;
        return ICoreManagerBase.getChannelLinkCore().getCurrentChannelLoginUserPowerInfo().isChannelMA(topSid, subSid);
    }

    public void sendMessageShow(String msg) {
        if (this.chatEmotionCore != null) {
            this.chatEmotionCore.sendOwnMessage(msg);
        }
    }

    public boolean onPreSendMessage(String msg, @Nullable TextView editText, boolean[] isFromButton, String isDefault) {
        String errorMsg = this.chatEmotionCore.getErrorResultForInvalidChat();
        if (errorMsg == null) {
            long currentTime = System.currentTimeMillis();
            if ((currentTime - this.chatEmotionCore.getLastSendTime()) / 1000L < 2L) {
                MLog.info((Object)"SendChatPresenter", (String)"[sendMessage] send chat msg too fast", (Object[])new Object[0]);
                SingleToastUtil.showToast((int)R.string.str_chat_text_counter_limited_tip);
                return false;
            }
            this.sendMessage(msg, editText, isFromButton, isDefault);
            return true;
        }
        this.sendMessageShow(msg);
        SingleToastUtil.showToast((String)errorMsg);
        return false;
    }

    public boolean onPreSendMessage(String msg, @Nullable TextView editText) {
        return this.onPreSendMessage(msg, editText, new boolean[]{true}, "0");
    }

    public boolean onPreSendMessage(String msg) {
        return this.onPreSendMessage(msg, null);
    }
}

