/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.basicvideomodel;

import android.content.Context;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.duowan.mobile.entlive.events.IPKClient_onPKStart_EventArgs;
import com.duowan.mobile.entlive.events.IPKClient_onPKStop_EventArgs;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.mobile.base.mvp.presenter.BindPresenter;
import com.yy.mobile.base.mvp.view.BaseView;
import com.yy.mobile.plugin.main.events.IChatEmotionClient_onChatInputSwitch_EventArgs;
import com.yy.mobile.plugin.main.events.IMobileLiveClient_onBasketballStateChanged_EventArgs;
import com.yy.mobile.plugin.main.events.IPublicChatBroadcastClient_onShowRevenueMarqueByCommonBc_EventArgs;
import com.yy.mobile.plugin.main.events.IPublicChatBroadcastClient_onShowRevenueMarque_EventArgs;
import com.yy.mobile.plugin.pluginunionlive.PluginBus;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.basefunction.followguide.ShowLoginGuideFlowerEventArgs;
import com.yy.mobile.ui.basicvideomodel.BasicChatComponentWidthChangeEventArgs;
import com.yy.mobile.ui.basicvideomodel.BasicChatPluginComponent;
import com.yy.mobile.ui.basicvideomodel.BasicChatPresenter$$EventBinder;
import com.yy.mobile.ui.basicvideomodel.ChatFragmentAdapter;
import com.yy.mobile.ui.basicvideomodel.IBasicChatView;
import com.yy.mobile.ui.publicchat.MergeChannelMessage;
import com.yy.mobile.ui.publicchat.PublicChatController;
import com.yy.mobile.ui.publicchat.PublicChatRevenueController;
import com.yy.mobile.ui.publicchat.model.IPublicChatViewListener;
import com.yy.mobile.ui.publicchat.model.PublicChatBaseModel;
import com.yy.mobile.ui.publicchat.model.PublicChatLiveModel;
import com.yy.mobile.ui.publicchat.model.PublicChatRecordModel;
import com.yy.mobile.ui.utils.DensityUtil;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.RxUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.channel.ChannelMessage;
import com.yymobile.core.gift.GiftChannelMessage;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class BasicChatPresenter
extends BindPresenter<IBasicChatView> {
    protected PublicChatController mController;
    protected PublicChatRevenueController mPublicChatRevenueController;
    protected PublicChatBaseModel publicChatModel;
    protected final PublicChatBaseModel.ModelType modelType;
    protected ChatFragmentAdapter mAdapter;
    private List<ChannelMessage> mChatMessageData = new LinkedList<ChannelMessage>();
    protected boolean mFreezeData = false;
    protected boolean isSmallMode;
    protected List<Disposable> mDisposableList = new ArrayList<Disposable>();
    protected IPublicChatViewListener publicChatViewListener = new IPublicChatViewListener(){

        @Override
        public void onMeasureUILocation(boolean chatInputSwitch) {
            ((IBasicChatView)BasicChatPresenter.this.mView).measureUILocation(chatInputSwitch);
        }

        @Override
        public void onSetChatListLayoutParams(boolean chatInputSwitch) {
            ((IBasicChatView)BasicChatPresenter.this.mView).setChatListLayoutParams(chatInputSwitch);
        }

        @Override
        public void onSetSmallChatListLayoutParams(boolean chatInputSwitch, int width) {
            ((IBasicChatView)BasicChatPresenter.this.mView).setSmallChatListLayoutParams(chatInputSwitch, width);
        }

        @Override
        public int onGetLayoutWidth(boolean chatInputSwitch) {
            return ((IBasicChatView)BasicChatPresenter.this.mView).getLayoutWidth(chatInputSwitch);
        }

        @Override
        public void onSetChatData(List<ChannelMessage> data) {
            MLog.debug((Object)"BasicChatPresenter", (String)("onSetChatData:" + FP.size(data)), (Object[])new Object[0]);
            BasicChatPresenter.this.flushChatData(data);
        }

        @Override
        public void onUpdateGiftDrawable(GiftChannelMessage msg) {
            BasicChatPresenter.this.updateGiftDrawable(msg);
        }

        @Override
        public void onUpdateMergeMessage(MergeChannelMessage msg) {
            BasicChatPresenter.this.updateMergeMessage(msg);
        }

        @Override
        public void onUpdateLayoutParams(RelativeLayout.LayoutParams params) {
            if (params != null && params.height != 0) {
                ((IBasicChatView)BasicChatPresenter.this.mView).setLayoutWidthAndHeight(params.width, params.height);
            } else {
                ((IBasicChatView)BasicChatPresenter.this.mView).measureUILocation(false);
            }
        }
    };
    private EventBinder mBasicChatPresenterSniperEventBinder;

    public BasicChatPresenter(PublicChatBaseModel.ModelType modelType) {
        this.modelType = modelType;
    }

    public void createChatRevenueController(Bundle savedInstanceState, ViewGroup revenueLayout) {
        if (this.publicChatModel == null || !(this.publicChatModel instanceof PublicChatLiveModel)) {
            this.publicChatModel = new PublicChatLiveModel(1);
        }
        this.mPublicChatRevenueController = new PublicChatRevenueController(this.publicChatModel);
        this.mPublicChatRevenueController.attach(((IBasicChatView)this.mView).getChatActivity());
        this.mPublicChatRevenueController.create(savedInstanceState, revenueLayout);
    }

    public ChatFragmentAdapter getChatFragmentAdapter() {
        if (this.mAdapter == null) {
            this.mAdapter = new ChatFragmentAdapter((Context)((IBasicChatView)this.mView).getChatActivity());
        }
        return this.mAdapter;
    }

    public void setMarqueWidth(int width) {
        if (this.mPublicChatRevenueController != null) {
            this.mPublicChatRevenueController.setMarqueWidth(width);
        }
    }

    public void attachView(IBasicChatView view) {
        super.attachView((BaseView)view);
        this.initChatPresenter();
    }

    public void detachView() {
        super.detachView();
        this.releaseChatPresenter();
    }

    protected void initChatPresenter() {
        if (this.modelType == PublicChatBaseModel.ModelType.REPLAY) {
            if (this.publicChatModel == null || !(this.publicChatModel instanceof PublicChatRecordModel)) {
                this.publicChatModel = new PublicChatRecordModel();
            }
        } else if (this.publicChatModel == null || !(this.publicChatModel instanceof PublicChatLiveModel)) {
            this.publicChatModel = new PublicChatLiveModel(1);
        }
        this.mController = new PublicChatController(this.publicChatModel);
        this.mController.init((Context)((IBasicChatView)this.mView).getChatActivity());
        this.mController.setPublicChatViewListener(this.publicChatViewListener);
        this.registerShowLiveLoginGuideEvent();
    }

    private void releaseChatPresenter() {
        if (this.mController != null) {
            this.mController.onDispose();
        }
        if (this.mPublicChatRevenueController != null) {
            this.mPublicChatRevenueController.onDispose(false);
        }
        if (this.mAdapter != null) {
            this.mAdapter.destory();
            this.mAdapter = null;
        }
        if (!FP.empty(this.mDisposableList)) {
            for (Disposable disposable2 : this.mDisposableList) {
                if (disposable2 == null || disposable2.isDisposed()) continue;
                disposable2.dispose();
            }
            this.mDisposableList.clear();
        }
    }

    public void flushChatData(List<ChannelMessage> data) {
        if (data == null) {
            data = new ArrayList<ChannelMessage>();
        }
        MLog.info((Object)"BasicChatPresenter", (String)("flushChatData " + data.size() + ", mFreezeData = " + this.mFreezeData), (Object[])new Object[0]);
        if (data.isEmpty()) {
            this.mFreezeData = false;
        } else if (this.mFreezeData) {
            this.mChatMessageData = data;
            return;
        }
        this.mChatMessageData = data;
        if (((IBasicChatView)this.mView).isReadyForChangData()) {
            this.mAdapter.setChatData(this.mChatMessageData);
            ((IBasicChatView)this.mView).scrollToBottom(true);
        } else {
            MLog.error((Object)"BasicChatPresenter", (String)"flushChatData but view is not ready.", (Object[])new Object[0]);
        }
    }

    @BusEvent(sync=true)
    public void onShowRevenueMarque(IPublicChatBroadcastClient_onShowRevenueMarque_EventArgs busEventArgs) {
        boolean isShow = busEventArgs.getIsShow();
        ((IBasicChatView)this.mView).setRevenueLayoutVisible(isShow);
    }

    @BusEvent(sync=true)
    public void onShowRevenueMarqueByCommonBc(IPublicChatBroadcastClient_onShowRevenueMarqueByCommonBc_EventArgs busEventArgs) {
        boolean isShow = busEventArgs.getIsShow();
        ((IBasicChatView)this.mView).setRevenueLayoutVisible(isShow);
    }

    public void onOrientationChange(boolean isLandscape) {
        if (!isLandscape) {
            this.mAdapter.setChatData(this.mChatMessageData);
        }
    }

    public void updateGiftDrawable(GiftChannelMessage msg) {
        if (this.mAdapter != null) {
            this.mAdapter.onUpdateGiftDrawable(msg);
        }
    }

    public void updateMergeMessage(MergeChannelMessage msg) {
        if (this.mAdapter != null) {
            this.mAdapter.onUpdateMergeMessage(msg);
        }
    }

    public void setDataFreeze(boolean freeze) {
        MLog.info((Object)"BasicChatPresenter", (String)("setDataFreeze freeze = " + freeze), (Object[])new Object[0]);
        this.mFreezeData = freeze;
        if (!freeze) {
            this.flushChatData(this.mChatMessageData == null ? Collections.emptyList() : this.mChatMessageData);
        }
    }

    public boolean isDataFreeze() {
        return this.mFreezeData;
    }

    public boolean isSmallMode() {
        return this.isSmallMode;
    }

    @BusEvent(sync=true)
    public void onPKStart(IPKClient_onPKStart_EventArgs busEventArgs) {
        ((IBasicChatView)this.mView).setSmallChatListLayoutParams(false, 0);
        ((IBasicChatView)this.mView).updateRevenueMarginTop(12);
    }

    @BusEvent(sync=true)
    public void onPKStop(IPKClient_onPKStop_EventArgs busEventArgs) {
        if (ICoreManagerBase.getMediaCore().getStreamListSize() >= 2) {
            ((IBasicChatView)this.mView).measureUILocation(false);
        } else {
            ((IBasicChatView)this.mView).setChatListLayoutParams(false);
        }
        ((IBasicChatView)this.mView).updateRevenueMarginTop(0);
    }

    @BusEvent(sync=true)
    public void onBasketballStateChanged(IMobileLiveClient_onBasketballStateChanged_EventArgs busEventArgs) {
        boolean isStart = busEventArgs.getIsStart();
        if (isStart) {
            ((IBasicChatView)this.mView).setSmallChatListLayoutParams(false, 0);
            ((IBasicChatView)this.mView).updateRevenueMarginTop(32);
        } else {
            if (ICoreManagerBase.getMediaCore().getStreamListSize() >= 2) {
                ((IBasicChatView)this.mView).measureUILocation(false);
            } else {
                ((IBasicChatView)this.mView).setChatListLayoutParams(false);
            }
            ((IBasicChatView)this.mView).updateRevenueMarginTop(0);
        }
    }

    @BusEvent
    public void basicChatComponentWidthChangeEventAccept(BasicChatComponentWidthChangeEventArgs args) {
        MLog.info((Object)"BasicChatPresenter", (String)("basicChatComponentWidthChangeEventAccept() : arg=" + args), (Object[])new Object[0]);
        if (args.extendInfo.containsKey("small_mode")) {
            this.isSmallMode = Boolean.parseBoolean(args.extendInfo.get("small_mode"));
        }
        if (args.useWideSize) {
            ((IBasicChatView)this.mView).setSmallChatListLayoutParams(true, 0);
        } else {
            ((IBasicChatView)this.mView).setSmallChatListLayoutParams(true, ((IBasicChatView)this.mView).getScreenWidth() - DensityUtil.dip2px((Context)((IBasicChatView)this.mView).getChatActivity(), (float)140.0f));
        }
    }

    private FragmentManager getChildFragmentManager() {
        FragmentManager fragmentManager = ((IBasicChatView)this.mView).getViewFragmentManager();
        if (fragmentManager == null && this.mView instanceof BasicChatPluginComponent) {
            fragmentManager = ((BasicChatPluginComponent)this.mView).getChildFragmentManager();
        }
        return fragmentManager;
    }

    @BusEvent(sync=true)
    public void onChatInputSwitch(IChatEmotionClient_onChatInputSwitch_EventArgs busEventArgs) {
        boolean chatInputSwitch = busEventArgs.getChatInputSwitch();
        MLog.info((Object)"BasicChatPresenter", (String)("onChatInputSwitch: " + chatInputSwitch), (Object[])new Object[0]);
        if (chatInputSwitch) {
            FragmentManager fragmentManager = this.getChildFragmentManager();
            Fragment followGuideComponent = fragmentManager.findFragmentById(R.id.rl_follow_guide_chat_container);
            FragmentTransaction transaction = fragmentManager.beginTransaction();
            if (followGuideComponent != null) {
                transaction.remove(followGuideComponent);
                transaction.commitAllowingStateLoss();
            }
        }
    }

    protected void registerShowLiveLoginGuideEvent() {
        Disposable disposable1 = PluginBus.INSTANCE.get().register(ShowLoginGuideFlowerEventArgs.class).observeOn(AndroidSchedulers.mainThread()).subscribeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<ShowLoginGuideFlowerEventArgs>(){

            public void accept(ShowLoginGuideFlowerEventArgs eventArgs) throws Exception {
                ((IBasicChatView)BasicChatPresenter.this.mView).showLoginGuideFlower();
            }
        }, RxUtils.errorConsumer((String)"BasicChatPresenter", (String)"registerShowLiveLoginGuideEvent: ShowLoginGuideFlowerEventArgs: error"));
        this.mDisposableList.add(disposable1);
    }

    public void onEventBind() {
        super.onEventBind();
        if (this.mBasicChatPresenterSniperEventBinder == null) {
            this.mBasicChatPresenterSniperEventBinder = new BasicChatPresenter$$EventBinder();
        }
        this.mBasicChatPresenterSniperEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        super.onEventUnBind();
        if (this.mBasicChatPresenterSniperEventBinder != null) {
            this.mBasicChatPresenterSniperEventBinder.unBindEvent();
        }
    }
}

