/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.basicgunview.danmuopengl;

import android.content.Context;
import android.content.res.Resources;
import android.opengl.GLES20;
import android.opengl.GLSurfaceView;
import android.os.SystemClock;
import android.util.Log;
import com.yy.mobile.ui.basicgunview.danmuopengl.DanmakuSurfaceView;
import com.yy.mobile.ui.basicgunview.danmuopengl.gunpower.DanmuItem;
import com.yy.mobile.ui.basicgunview.danmuopengl.util.MatrixUtils;
import com.yy.mobile.ui.basicgunview.danmuopengl.util.ShaderUtils;
import com.yy.mobile.ui.basicgunview.newgunpower.IDanmuSwitchListener;
import com.yy.mobile.util.CommonUtils;
import com.yy.mobile.util.log.MLog;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

public class DanmakuSurfaceViewRenderer
implements GLSurfaceView.Renderer {
    private CopyOnWriteArrayList<DanmuItem> mDanmakus = new CopyOnWriteArrayList();
    private Context mContext;
    private RenderListener mListener;
    private String mVertexShader;
    private String mFragmentShader;
    private int mViewWidth;
    private int mViewHeight;
    private float mSpeed;
    private List<DanmuItem> mShouldRemove = new ArrayList<DanmuItem>();
    public boolean isOpenCloseSwitch = false;
    private int frameRate = 34;
    private float intervalTime;
    private float detalOffset;
    private DanmuItem danmaku;
    private float mDanmuAlpha;

    public DanmakuSurfaceViewRenderer(Context context, DanmakuSurfaceView danmakuView) {
        this.mContext = context.getApplicationContext();
        if (danmakuView != null) {
            danmakuView.setOnSwitchListener(new IDanmuSwitchListener(){

                public void openSwitch() {
                    DanmakuSurfaceViewRenderer.this.isOpenCloseSwitch = true;
                }

                public void closeSwitch() {
                    DanmakuSurfaceViewRenderer.this.isOpenCloseSwitch = false;
                    DanmakuSurfaceViewRenderer.this.clearDanmuKu();
                }
            });
        }
    }

    public void setListener(RenderListener listener2) {
        this.mListener = listener2;
    }

    public void setSpeed(float speed) {
        this.mSpeed = speed;
        this.intervalTime = (float)this.frameRate / 1000.0f;
        this.detalOffset = this.mSpeed * this.intervalTime;
    }

    public void addDanmaku(DanmuItem danmaku) {
        danmaku.setShader(this.mVertexShader, this.mFragmentShader);
        danmaku.setViewSize(this.mViewWidth, this.mViewHeight);
        this.mDanmakus.add(danmaku);
    }

    public CopyOnWriteArrayList<DanmuItem> getmDanmakus() {
        return this.mDanmakus;
    }

    public void clearDanmuKu() {
        if (this.mDanmakus != null) {
            for (int i = 0; i < this.mDanmakus.size(); ++i) {
                this.mDanmakus.get(i).recyle();
            }
            this.mDanmakus.clear();
        }
    }

    public void onSurfaceCreated(GL10 gl10, EGLConfig eglConfig) {
        CommonUtils.setGLSurfaceViewThreadName((String)"DanmakuSurfaceView GLThread");
        GLES20.glEnable((int)2884);
        GLES20.glCullFace((int)1028);
        GLES20.glEnable((int)3042);
        GLES20.glBlendFunc((int)770, (int)771);
        this.mVertexShader = ShaderUtils.loadFromAssetsFile((String)"vertex.sh", (Resources)this.mContext.getResources());
        this.mFragmentShader = ShaderUtils.loadFromAssetsFile((String)"frag.sh", (Resources)this.mContext.getResources());
    }

    public void onSurfaceChanged(GL10 gl10, int width, int height) {
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)"DanmakuRenderer", (String)("onSurfaceChanged width = " + width + " height = " + height), (Object[])new Object[0]);
        }
        this.mViewWidth = width;
        this.mViewHeight = height;
        GLES20.glViewport((int)0, (int)0, (int)width, (int)height);
        MatrixUtils.setProjectOrtho((float)-1.0f, (float)1.0f, (float)-1.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        MatrixUtils.setCamera((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        if (this.mListener != null) {
            this.mListener.onInited();
        }
        try {
            if (this.mDanmakus != null && this.mDanmakus.size() > 0) {
                for (int i = 0; i < this.mDanmakus.size(); ++i) {
                    DanmuItem danmaku = this.mDanmakus.get(i);
                    danmaku.setViewSize(width, height);
                    danmaku.initVertexData();
                }
            }
        }
        catch (Throwable throwable) {
            MLog.error((Object)"DanmakuRenderer", (Throwable)throwable);
        }
        if (this.mListener != null) {
            this.mListener.onSurfaceChanged(width, height);
        }
    }

    public void onDrawFrame(GL10 gl10) {
        long currentTime = SystemClock.elapsedRealtime();
        this.clearCanvas();
        if (this.mDanmakus != null && this.mDanmakus.size() > 0) {
            int size = this.mDanmakus.size();
            try {
                for (int i = 0; i < size; ++i) {
                    this.danmaku = this.mDanmakus.get(i);
                    if (!this.isOpenCloseSwitch) break;
                    if (this.danmaku == null) continue;
                    float newOffset = this.detalOffset + this.danmaku.getCurrentOffsetX();
                    this.danmaku.setAlpha(this.mDanmuAlpha);
                    this.danmaku.setOffsetX(newOffset);
                    if (newOffset <= (float)(this.mViewWidth + this.danmaku.getBitmapWidth())) {
                        if (!this.isOpenCloseSwitch) continue;
                        this.danmaku.drawDanmaku();
                        continue;
                    }
                    this.mShouldRemove.add(this.danmaku);
                    this.danmaku.recyle();
                }
                this.mListener.onOpenDanmuSwitch();
                this.mListener.onListInit(this.mDanmakus);
            }
            catch (IndexOutOfBoundsException e) {
                MLog.error((Object)"DanmakuRenderer", (String)"", (Object[])new Object[0]);
            }
            this.mDanmakus.removeAll(this.mShouldRemove);
            this.mShouldRemove.clear();
        } else {
            this.mListener.onInitDrawMode();
        }
        long dt = SystemClock.elapsedRealtime() - currentTime;
        if (dt < (long)this.frameRate) {
            this.waitForSync((long)this.frameRate - dt);
        }
    }

    public void waitForSync(long t) {
        try {
            Thread.sleep(t);
        }
        catch (InterruptedException e) {
            Log.e((String)"DanmakuSurfaceViewR..", (String)"Empty Catch on waitForSync", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    public void clearCanvas() {
        GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GLES20.glClear((int)16640);
    }

    public void setDanmuAlpha(float mDanmuAlpha) {
        this.mDanmuAlpha = mDanmuAlpha;
    }

    public static interface RenderListener {
        public void onInited();

        public void onOpenDanmuSwitch();

        public void onInitDrawMode();

        public void onListInit(CopyOnWriteArrayList<DanmuItem> var1);

        public void onSurfaceChanged(int var1, int var2);
    }
}

