/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.basicgunview.danmucanvas.model.android;

import com.yy.mobile.ui.basicgunview.danmucanvas.Bean.BaseDanmaku;
import com.yy.mobile.ui.basicgunview.danmucanvas.Bean.Danmaku;
import com.yy.mobile.ui.basicgunview.danmucanvas.model.IDanmakuIterator;
import com.yy.mobile.ui.basicgunview.danmucanvas.model.IDanmakus;
import com.yy.mobile.util.log.MLog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;

public class Danmakus
implements IDanmakus {
    public Collection<BaseDanmaku> items;
    private Danmakus subItems;
    private BaseDanmaku startItem;
    private BaseDanmaku endItem;
    private BaseDanmaku endSubItem;
    private BaseDanmaku startSubItem;
    private DanmakuIterator iterator;
    public int mSize = 0;
    private int mSortType = 0;
    private boolean mDuplicateMergingEnabled;

    public Danmakus() {
        this(0, false);
    }

    public Danmakus(int sortType) {
        this(sortType, false);
    }

    public Danmakus(int sortType, boolean duplicateMergingEnabled) {
        if (sortType == 4) {
            this.items = Collections.synchronizedCollection(new ArrayList());
        }
        this.mSortType = sortType;
        this.mSize = 0;
        this.iterator = new DanmakuIterator(this.items);
    }

    public Danmakus(Collection<BaseDanmaku> items) {
        this.setItems(items);
    }

    public Danmakus(boolean duplicateMergingEnabled) {
        this(0, duplicateMergingEnabled);
    }

    private void clearIterator() {
        if (this.iterator != null) {
            this.iterator.setDatas(null);
        }
    }

    @Override
    public IDanmakuIterator iterator() {
        this.iterator.reset();
        return this.iterator;
    }

    @Override
    public boolean addItem(BaseDanmaku item2) {
        if (this.items != null) {
            try {
                if (this.items.add(item2)) {
                    ++this.mSize;
                    return true;
                }
            }
            catch (Throwable e) {
                MLog.error((Object)"Danmakus", (String)("Empty Catch on addItem" + e), (Object[])new Object[0]);
            }
        }
        return false;
    }

    @Override
    public boolean removeItem(BaseDanmaku item2) {
        if (item2 == null) {
            return false;
        }
        if (item2.isOutside()) {
            item2.setVisibility(false);
        }
        if (this.items.remove(item2)) {
            --this.mSize;
            return true;
        }
        return false;
    }

    private Collection<BaseDanmaku> subset(long startTime, long endTime) {
        if (this.mSortType == 4 || this.items == null || this.items.size() == 0) {
            return null;
        }
        if (this.subItems == null) {
            this.subItems = new Danmakus(this.mDuplicateMergingEnabled);
        }
        if (this.startSubItem == null) {
            this.startSubItem = this.createItem("start");
        }
        if (this.endSubItem == null) {
            this.endSubItem = this.createItem("end");
        }
        this.startSubItem.time = startTime;
        this.endSubItem.time = endTime;
        return ((SortedSet)this.items).subSet(this.startSubItem, this.endSubItem);
    }

    @Override
    public IDanmakus subnew(long startTime, long endTime) {
        Collection<BaseDanmaku> subset = this.subset(startTime, endTime);
        if (subset == null || subset.isEmpty()) {
            return null;
        }
        ArrayList<BaseDanmaku> newSet = new ArrayList<BaseDanmaku>(subset);
        return new Danmakus(newSet);
    }

    @Override
    public IDanmakus sub(long startTime, long endTime) {
        long dtime;
        if (this.items == null || this.items.size() == 0) {
            return null;
        }
        if (this.subItems == null) {
            if (this.mSortType == 4) {
                this.subItems = new Danmakus(4);
                this.subItems.setItems(this.items);
            } else {
                this.subItems = new Danmakus(this.mDuplicateMergingEnabled);
            }
        }
        if (this.mSortType == 4) {
            return this.subItems;
        }
        if (this.startItem == null) {
            this.startItem = this.createItem("start");
        }
        if (this.endItem == null) {
            this.endItem = this.createItem("end");
        }
        if (this.subItems != null && (dtime = startTime - this.startItem.time) >= 0L && endTime <= this.endItem.time) {
            return this.subItems;
        }
        this.startItem.time = startTime;
        this.endItem.time = endTime;
        if (this.subItems != null) {
            this.subItems.setItems(((SortedSet)this.items).subSet(this.startItem, this.endItem));
        }
        return this.subItems;
    }

    private BaseDanmaku createItem(String text) {
        return new Danmaku(text);
    }

    @Override
    public int size() {
        return this.items.size();
    }

    @Override
    public Collection getItems() {
        return this.items;
    }

    public void setItems(Collection<BaseDanmaku> items) {
        if (this.mDuplicateMergingEnabled && this.mSortType != 4) {
            this.clearIterator();
            this.items.clear();
            this.items.addAll(items);
            items = this.items;
        } else {
            this.items = items;
        }
        if (items instanceof List) {
            this.mSortType = 4;
        }
        int n = this.mSize = items == null ? 0 : items.size();
        if (this.iterator == null) {
            this.iterator = new DanmakuIterator(items);
        } else {
            this.iterator.setDatas(items);
        }
    }

    @Override
    public void clear() {
        if (this.items != null) {
            this.clearIterator();
            this.items.clear();
            this.mSize = 0;
            this.iterator = new DanmakuIterator(this.items);
        }
        if (this.subItems != null) {
            this.subItems = null;
            this.startItem = this.createItem("start");
            this.endItem = this.createItem("end");
        }
    }

    @Override
    public BaseDanmaku first() {
        if (this.items != null && !this.items.isEmpty()) {
            if (this.mSortType == 4) {
                return (BaseDanmaku)((ArrayList)this.items).get(0);
            }
            return (BaseDanmaku)((SortedSet)this.items).first();
        }
        return null;
    }

    @Override
    public BaseDanmaku last() {
        if (this.items != null && !this.items.isEmpty()) {
            if (this.mSortType == 4) {
                return (BaseDanmaku)((ArrayList)this.items).get(this.items.size() - 1);
            }
            return (BaseDanmaku)((SortedSet)this.items).last();
        }
        return null;
    }

    @Override
    public boolean contains(BaseDanmaku item2) {
        return this.items != null && this.items.contains(item2);
    }

    @Override
    public boolean isEmpty() {
        return this.items == null || this.items.isEmpty();
    }

    private void setDuplicateMergingEnabled(boolean enable) {
        this.mDuplicateMergingEnabled = enable;
    }

    @Override
    public void setSubItemsDuplicateMergingEnabled(boolean enable) {
        this.mDuplicateMergingEnabled = enable;
        this.endItem = null;
        this.startItem = null;
        if (this.subItems == null) {
            this.subItems = new Danmakus(enable);
        }
        this.subItems.setDuplicateMergingEnabled(enable);
    }

    private class DanmakuIterator
    implements IDanmakuIterator {
        private Collection<BaseDanmaku> mData;
        private Iterator<BaseDanmaku> it;
        private boolean mIteratorUsed;

        DanmakuIterator(Collection<BaseDanmaku> datas) {
            this.setDatas(datas);
        }

        @Override
        public synchronized void reset() {
            if (!this.mIteratorUsed && this.it != null) {
                return;
            }
            this.it = this.mData != null && this.mData.size() > 0 ? this.mData.iterator() : null;
            this.mIteratorUsed = false;
        }

        public synchronized void setDatas(Collection<BaseDanmaku> datas) {
            if (this.mData != datas) {
                this.mIteratorUsed = false;
                this.it = null;
            }
            this.mData = datas;
        }

        @Override
        public synchronized BaseDanmaku next() {
            this.mIteratorUsed = true;
            try {
                return this.it != null ? this.it.next() : null;
            }
            catch (Throwable throwable) {
                MLog.error((Object)"DanmakuIterator", (Throwable)throwable);
                return null;
            }
        }

        @Override
        public synchronized boolean hasNext() {
            return this.it != null && this.it.hasNext();
        }

        @Override
        public synchronized void remove() {
            this.mIteratorUsed = true;
            if (this.it != null) {
                this.it.remove();
                int n = Danmakus.this.mSize--;
            }
        }
    }
}

