/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.basicgunview.danmucanvas.Bean;

import android.graphics.Bitmap;
import com.yy.mobile.ui.basicgunview.danmucanvas.model.GlobalFlagValues;
import com.yy.mobile.ui.basicgunview.danmucanvas.model.IDisplayer;

public abstract class BaseDanmaku {
    public int yPosition = 0;
    public String content = "";
    public long gunId;
    public int poolPos = -1;
    public long time;
    public int padding = 0;
    public float paintWidth = -1.0f;
    public float paintHeight = -1.0f;
    public int index;
    public int visibility;
    public int measureResetFlag = 0;
    public Bitmap cache;
    public GlobalFlagValues flags = null;
    private int visibleResetFlag = 0;

    public int draw(IDisplayer displayer) {
        return displayer.draw(this);
    }

    public void measure(IDisplayer displayer, boolean fromWorkerThread) {
        displayer.measure(this, fromWorkerThread);
        this.measureResetFlag = this.flags.measureRestFlag;
    }

    public boolean isShown() {
        return this.visibility == 1 && this.visibleResetFlag == this.flags.visibleRestFlag;
    }

    public boolean isTimeOut() {
        return this.getLeft() < 0.0f && Math.abs(this.getLeft()) > this.paintWidth;
    }

    public boolean isOutside() {
        return this.paintWidth < 0.0f || this.getLeft() < 0.0f && Math.abs(this.getLeft()) > this.paintWidth;
    }

    public void setVisibility(boolean b) {
        if (b) {
            this.visibleResetFlag = this.flags.visibleRestFlag;
            this.visibility = 1;
        } else {
            this.visibility = 0;
        }
    }

    public abstract void layout(IDisplayer var1, float var2, float var3, float var4, float var5);

    public abstract float getLeft();

    public abstract float getTop();

    public abstract void setTop(float var1);

    public abstract float getRight();

    public abstract float getBottom();

    public void setYPos(int pos) {
        this.yPosition = pos;
    }

    public float getYByPos(float density) {
        return (float)this.yPosition * density * 26.0f;
    }
}

