/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.basicfunction.report;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.android.sniper.api.event.EventCompat;
import com.yy.mobile.plugin.main.events.IReportClient_onReport_EventArgs;
import com.yy.mobile.plugin.main.events.IReportUploadClient_onUploadFail_EventArgs;
import com.yy.mobile.plugin.main.events.IReportUploadClient_onUploadSuccess_EventArgs;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.basicfunction.report.BaseModule;
import com.yy.mobile.ui.basicfunction.report.ReplayReportModule$$EventBinder;
import com.yy.mobile.ui.basicfunction.uicore.IBasicFunctionCore;
import com.yy.mobile.ui.widget.dialog.ReportPopupDialog;
import com.yy.mobile.ui.widget.toast.Toast;
import com.yy.mobile.util.CommonUtils;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.YYFileUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.mobilelive.IMobileLiveCore;
import com.yymobile.core.report.IReportCore;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ReplayReportModule
extends BaseModule
implements EventCompat {
    private ReportPopupDialog mReportPopupDialog;
    public String mReplayTitle;
    private int mCurrentPlayTime;
    private long mUid;
    private String mPid;
    private EventBinder mReplayReportModuleSniperEventBinder;

    public void onEventBind() {
        if (this.mReplayReportModuleSniperEventBinder == null) {
            this.mReplayReportModuleSniperEventBinder = new ReplayReportModule$$EventBinder();
        }
        this.mReplayReportModuleSniperEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        if (this.mReplayReportModuleSniperEventBinder != null) {
            this.mReplayReportModuleSniperEventBinder.unBindEvent();
        }
    }

    public ReplayReportModule(Activity mActivity, String title, int currentPlayTime, long uid, String pid) {
        super(mActivity);
        this.mReplayTitle = title;
        this.mCurrentPlayTime = currentPlayTime;
        this.mUid = uid;
        this.mPid = pid;
    }

    public void setCurrentPlayTime(int currentPlayTime) {
        this.mCurrentPlayTime = currentPlayTime;
    }

    public void showReport(final String path) {
        if (this.mReportPopupDialog == null) {
            this.mReportPopupDialog = new ReportPopupDialog((Context)this.getActivity());
        }
        if (this.mReportPopupDialog != null) {
            this.mReportPopupDialog.setOnReportItemClickListener(new ReportPopupDialog.OnReportItemClickListener(){

                public void onReportItemClick(int style2, String reason) {
                }
            });
            this.mReportPopupDialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

                public void onDismiss(DialogInterface dialog) {
                    ((IMobileLiveCore)ICoreManagerBase.getCore(IMobileLiveCore.class)).reportReplayFinish();
                }
            });
            this.mReportPopupDialog.setBeforeReportListener(new ReportPopupDialog.BeforeReportListener(){

                public boolean beforeReport(int style2) {
                    if (ReplayReportModule.this.getActivity() != null) {
                        ReplayReportModule.this.compress(path);
                        MLog.info((Object)"ReplayReportModule", (String)("uploadScreenshot path=" + path), (Object[])new Object[0]);
                        ((IReportCore)CoreFactory.getCore(IReportCore.class)).uploadScreenshot(path, style2, ReplayReportModule.this.mReplayTitle, "ReplayReportModule");
                    } else {
                        MLog.info((Object)"ReplayReportModule", (String)("Activity = " + ReplayReportModule.this.getActivity()), (Object[])new Object[0]);
                    }
                    return false;
                }
            });
        }
        this.mReportPopupDialog.setCancelable(true);
        this.mReportPopupDialog.setCanceledOnTouchOutside(true);
        this.mReportPopupDialog.show();
    }

    public void compress(String srcPath) {
        BitmapFactory.Options newOpts = new BitmapFactory.Options();
        newOpts.inJustDecodeBounds = true;
        Bitmap bitmap = BitmapFactory.decodeFile((String)srcPath, (BitmapFactory.Options)newOpts);
        newOpts.inJustDecodeBounds = false;
        int w = newOpts.outWidth;
        int h = newOpts.outHeight;
        int be = 1;
        if ((float)w > 720.0f) {
            be = (int)((float)w / 720.0f) + 1;
        }
        if (be <= 0) {
            be = 1;
        }
        newOpts.inSampleSize = be;
        try {
            YYFileUtils.saveBitmap((Bitmap)BitmapFactory.decodeFile((String)srcPath, (BitmapFactory.Options)newOpts), (String)srcPath, (Bitmap.CompressFormat)Bitmap.CompressFormat.PNG, (int)100);
        }
        catch (Exception e) {
            MLog.error((Object)"ReplayReportModule", (String)("compress faild " + e.toString()), (Object[])new Object[0]);
        }
    }

    @BusEvent(sync=true)
    public void onReport(IReportClient_onReport_EventArgs busEventArgs) {
        int code = busEventArgs.getCode();
        Map extendInfo = busEventArgs.getData();
        if (extendInfo != null && extendInfo.size() > 0 && extendInfo.containsKey("ReportContext")) {
            MLog.info((Object)"ReplayReportModule", (String)("onReport code =" + code), (Object[])new Object[0]);
            if (code == 0) {
                Toast.makeText((Context)this.getActivity(), (int)R.string.str_report_success_new, (int)0).show();
            } else if (code == -1) {
                Toast.makeText((Context)this.getActivity(), (int)R.string.str_report_fail, (int)0).show();
            } else if (code == -2) {
                Toast.makeText((Context)this.getActivity(), (int)R.string.str_report_exception, (int)0).show();
            } else if (code == 1) {
                Toast.makeText((Context)this.getActivity(), (int)R.string.str_report_repeat, (int)0).show();
            } else {
                Toast.makeText((Context)this.getActivity(), (int)R.string.str_report_fail, (int)0).show();
            }
        } else {
            MLog.info((Object)"ReplayReportModule", (String)("onReport extendInfo =" + extendInfo), (Object[])new Object[0]);
        }
    }

    @BusEvent(sync=true)
    public void onUploadFail(IReportUploadClient_onUploadFail_EventArgs busEventArgs) {
        String context = busEventArgs.getContext();
        if (!StringUtils.isEmptyString((String)context) && context.equals("ReplayReportModule")) {
            MLog.info((Object)"ReplayReportModule", (String)"onUploadFail", (Object[])new Object[0]);
            Toast.makeText((Context)this.getActivity(), (int)R.string.str_report_fail, (int)0).show();
        } else {
            MLog.info((Object)"ReplayReportModule", (String)("onUploadFail context = " + context), (Object[])new Object[0]);
        }
    }

    @BusEvent(sync=true)
    public void onUploadSuccess(IReportUploadClient_onUploadSuccess_EventArgs busEventArgs) {
        String url = busEventArgs.getUrl();
        int style2 = busEventArgs.getStyle();
        String title = busEventArgs.getTitle();
        String context = busEventArgs.getContext();
        if (!StringUtils.isEmptyString((String)context) && context.equals("ReplayReportModule")) {
            this.onReplayUploadSuccess(url, style2, title);
        } else {
            MLog.info((Object)"ReplayReportModule", (String)("onUploadSuccess context = " + context), (Object[])new Object[0]);
        }
    }

    private void onReplayUploadSuccess(String url, int style2, String title) {
        int type = 2;
        int child = 19;
        String content = this.buildReportContent(url);
        String extParUrlEncoder = this.buildExtParUrlEncoder();
        String extProductParam = this.buildExtProductParam(url);
        MLog.info((Object)"ReplayReportModule", (String)("type=" + type + "child=" + child + "style=" + style2 + "anchoruid=" + this.mUid + "content=" + content + "extParUrlEncoder=" + extParUrlEncoder + "extProductParam" + extProductParam + "title=" + title), (Object[])new Object[0]);
        HashMap<String, String> extendInfo = new HashMap<String, String>();
        extendInfo.put("ReportContext", "ReplayReportModule");
        ((IBasicFunctionCore)ICoreManagerBase.getCore(IBasicFunctionCore.class)).sendReportBasic(type, (long)child, style2, this.mUid, content, extParUrlEncoder, extProductParam, extendInfo);
    }

    private String buildReportContent(String picUrl) {
        JSONObject jContent = new JSONObject();
        try {
            Date currentDate = new Date();
            SimpleDateFormat formatter = CommonUtils.getSimpleDateFormat((String)"yyyy-MM-dd HH:mm");
            String dateString = formatter.format(currentDate);
            jContent.put("id", (Object)("r_" + System.currentTimeMillis()));
            jContent.put("title", (Object)this.mReplayTitle);
            jContent.put("type", 3);
            jContent.put("createTime", (Object)dateString);
            JSONArray jcontentArray = new JSONArray();
            JSONObject picItem = new JSONObject();
            picItem.put("type", 2);
            picItem.put("value", (Object)picUrl);
            jcontentArray.put((Object)picItem);
            jContent.put("contents", (Object)jcontentArray);
        }
        catch (JSONException e) {
            MLog.error((Object)"ReplayReportModule", (Throwable)e);
        }
        return jContent.toString();
    }

    private String buildExtParUrlEncoder() {
        JSONObject jExtParUrlEncoder = new JSONObject();
        try {
            jExtParUrlEncoder.put("uid", this.mUid);
            jExtParUrlEncoder.put("pid", (Object)this.mPid);
        }
        catch (JSONException e) {
            MLog.error((Object)"ReplayReportModule", (String)("Empty Catch on buildExtParUrlEncoder" + (Object)((Object)e)), (Object[])new Object[0]);
        }
        return jExtParUrlEncoder.toString();
    }

    private String buildExtProductParam(String picUrl) {
        JSONObject jExtProductParam = new JSONObject();
        try {
            jExtProductParam.put("captureTime", (Object)this.formatFromMillisToTime(this.mCurrentPlayTime / 1000));
        }
        catch (JSONException e) {
            MLog.error((Object)"ReplayReportModule", (Throwable)e);
        }
        return jExtProductParam.toString();
    }

    public String formatFromMillisToTime(long i) {
        int minute = (int)(i % 3600L / 60L) + (int)(i / 3600L * 60L);
        int second = (int)(i % 3600L % 60L);
        return this.formatFromIntToString(minute) + ":" + this.formatFromIntToString(second);
    }

    public String formatFromIntToString(int i) {
        String s = i + "";
        if (s.length() == 1) {
            s = "0" + s;
        }
        return s;
    }
}

