/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.basicfunction;

import android.app.Activity;
import android.content.Context;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.View;
import com.yy.mobile.ui.meidabasicvideoview.MediaVideoViewSize;
import com.yy.mobile.ui.utils.DensityUtil;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.log.MLog;
import java.lang.reflect.Method;

public class ScreenSizeUtils {
    public static MediaVideoViewSize getFullScreenSize(Activity context, boolean isLandScape, View rootView) {
        int layoutViewHeight;
        int screenWidth;
        MediaVideoViewSize mediaVideoViewSize = new MediaVideoViewSize();
        if (rootView == null || context == null) {
            MLog.error((Object)"ScreenSizeUtils", (String)("getFullScreenSize : rootView = " + rootView + ", context = " + context), (Object[])new Object[0]);
            return mediaVideoViewSize;
        }
        if (isLandScape) {
            screenWidth = rootView.getWidth();
            if (screenWidth == 0) {
                screenWidth = context.getResources().getDisplayMetrics().widthPixels;
            }
            layoutViewHeight = context.getResources().getDisplayMetrics().heightPixels;
        } else {
            layoutViewHeight = rootView.getHeight();
            if (layoutViewHeight == 0) {
                layoutViewHeight = context.getResources().getDisplayMetrics().heightPixels;
                int resourceId = 0;
                try {
                    resourceId = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
                }
                catch (Throwable e) {
                    MLog.error((Object)"ScreenSizeUtils", (Throwable)e);
                }
                int statusBarHeight = resourceId > 0 ? context.getResources().getDimensionPixelSize(resourceId) : DensityUtil.dip2px((Context)context, (float)25.0f);
                layoutViewHeight -= statusBarHeight;
            }
            screenWidth = context.getResources().getDisplayMetrics().widthPixels;
        }
        mediaVideoViewSize.videoHeight = layoutViewHeight;
        mediaVideoViewSize.screenWidth = screenWidth;
        MLog.info((Object)"ScreenSizeUtils", (String)("getFullScreenSize : layoutViewHeight = " + layoutViewHeight + ", screenWidth = " + screenWidth), (Object[])new Object[0]);
        return mediaVideoViewSize;
    }

    public static int getWindowHeightIncludeBars(Activity activity) {
        Display display = activity.getWindowManager().getDefaultDisplay();
        DisplayMetrics dm = new DisplayMetrics();
        try {
            Class<?> c = Class.forName("android.view.Display");
            Method method = c.getMethod("getRealMetrics", DisplayMetrics.class);
            method.invoke((Object)display, dm);
            MLog.info((Object)"ScreenSizeUtils", (String)("curr window widthPixels = " + dm.widthPixels), (Object[])new Object[0]);
            return dm.widthPixels;
        }
        catch (Exception e) {
            MLog.error((Object)"ScreenSizeUtils", (String)e.getLocalizedMessage(), (Object[])new Object[0]);
            return ResolutionUtils.getScreenHeight((Context)activity);
        }
    }
}

