/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.basicfunction;

import android.app.Activity;
import android.content.ContentResolver;
import android.net.Uri;
import android.provider.Settings;
import android.util.Log;
import android.view.WindowManager;
import com.yy.mobile.util.log.MLog;

public class BrightnessUtils {
    public static boolean isAutoBrightness(Activity activity) {
        boolean automicBrightness = false;
        try {
            automicBrightness = Settings.System.getInt((ContentResolver)activity.getContentResolver(), (String)"screen_brightness_mode") == 1;
        }
        catch (Settings.SettingNotFoundException e) {
            Log.e((String)"BrightnessUtils", (String)"Empty Catch on isAutoBrightness", (Throwable)e);
        }
        return automicBrightness;
    }

    public static int getScreenBrightness(Activity activity) {
        if (BrightnessUtils.isAutoBrightness(activity)) {
            return BrightnessUtils.getAutoScreenBrightness(activity);
        }
        return BrightnessUtils.getManualScreenBrightness(activity);
    }

    public static int getManualScreenBrightness(Activity activity) {
        int nowBrightnessValue = 0;
        ContentResolver resolver = activity.getContentResolver();
        try {
            nowBrightnessValue = Settings.System.getInt((ContentResolver)resolver, (String)"screen_brightness");
        }
        catch (Exception e) {
            Log.e((String)"BrightnessUtils", (String)"Empty Catch on getManualScreenBrightness", (Throwable)e);
        }
        return nowBrightnessValue;
    }

    public static int getAutoScreenBrightness(Activity activity) {
        float nowBrightnessValue = 0.0f;
        ContentResolver resolver = activity.getContentResolver();
        try {
            nowBrightnessValue = Settings.System.getFloat((ContentResolver)resolver, (String)"screen_auto_brightness_adj");
            Log.d((String)"BrightnessUtils", (String)("[getAutoScreenBrightness] Original AutoBrightness Value:" + nowBrightnessValue));
        }
        catch (Throwable e) {
            MLog.error((Object)"BrightnessUtils", (String)("[getAutoScreenBrightness Throwable] " + e), (Object[])new Object[0]);
        }
        float tempBrightness = nowBrightnessValue + 1.0f;
        float fValue = tempBrightness / 2.0f * 255.0f;
        Log.d((String)"BrightnessUtils", (String)("[getAutoScreenBrightness] Converted Value: " + fValue));
        return (int)fValue;
    }

    public static void setBrightness(Activity activity, int brightness) {
        try {
            WindowManager.LayoutParams lp = activity.getWindow().getAttributes();
            lp.screenBrightness = Float.valueOf(brightness).floatValue() * 0.003921569f;
            if (MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)"BrightnessUtils", (String)("set  lp.screenBrightness == " + lp.screenBrightness), (Object[])new Object[0]);
            }
            activity.getWindow().setAttributes(lp);
        }
        catch (Exception ex) {
            Log.e((String)"BrightnessUtils", (String)"Empty Catch on setBrightness", (Throwable)ex);
        }
    }

    public static void stopAutoBrightness(Activity activity) {
        try {
            Settings.System.putInt((ContentResolver)activity.getContentResolver(), (String)"screen_brightness_mode", (int)0);
        }
        catch (Exception ex) {
            Log.e((String)"BrightnessUtils", (String)"Empty Catch on stopAutoBrightness", (Throwable)ex);
        }
    }

    public static void startAutoBrightness(Activity activity) {
        try {
            Settings.System.putInt((ContentResolver)activity.getContentResolver(), (String)"screen_brightness_mode", (int)1);
        }
        catch (Exception ex) {
            Log.e((String)"BrightnessUtils", (String)"Empty Catch on startAutoBrightness", (Throwable)ex);
        }
    }

    public static void saveBrightness(Activity activity, int brightness) {
        try {
            Uri uri = Settings.System.getUriFor((String)"screen_brightness");
            Settings.System.putInt((ContentResolver)activity.getContentResolver(), (String)"screen_brightness", (int)brightness);
            activity.getContentResolver().notifyChange(uri, null);
        }
        catch (Exception ex) {
            Log.e((String)"BrightnessUtils", (String)"Empty Catch on saveBrightness", (Throwable)ex);
        }
    }
}

