/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.basefunction.followguide;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.AnimationUtils;
import android.view.animation.ScaleAnimation;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import com.trello.rxlifecycle2.android.FragmentEvent;
import com.yy.mobile.RxBus;
import com.yy.mobile.plugin.main.events.IGiftUIListener_showGiftIconAnim_EventArgs;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.basefunction.followguide.KeyBehaviorGuideStatistic;
import com.yy.mobile.ui.basicchanneltemplate.component.BasePopupComponent;
import com.yy.mobile.ui.screencapture.CaptureConstant;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.RxUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.plugincenter.IPluginCenterCore;
import com.yymobile.liveapi.plugincenter.SinglePluginInfo;
import com.yyproto.utils.StringUtils;
import io.reactivex.Flowable;
import io.reactivex.FlowableTransformer;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import java.util.concurrent.TimeUnit;

public class LoginGuideFlowerPopupComponent
extends BasePopupComponent {
    private ViewGroup mRootView;
    public LinearLayout mllViewContainer;
    private Disposable mCountDownHiddenTimer;
    private ScaleAnimation mScaleInAnimation;
    private AnimationSet mScaleOutAnimationSet;
    public AlphaAnimation mScaleOutAnimation;
    public Disposable disposable;

    public static LoginGuideFlowerPopupComponent newInstance() {
        return new LoginGuideFlowerPopupComponent();
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Dialog mDialog = super.onCreateDialog(savedInstanceState);
        mDialog.setCanceledOnTouchOutside(true);
        mDialog.requestWindowFeature(1);
        mDialog.getWindow().setBackgroundDrawableResource(R.color.transparent);
        mDialog.getWindow().setWindowAnimations(R.style.slide_shake_animation);
        mDialog.getWindow().setGravity(17);
        mDialog.getWindow().setLayout(-1, -1);
        WindowManager.LayoutParams lp = mDialog.getWindow().getAttributes();
        lp.dimAmount = 0.0f;
        mDialog.getWindow().setAttributes(lp);
        mDialog.getWindow().clearFlags(2);
        return mDialog;
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.mRootView = (ViewGroup)inflater.inflate(R.layout.fragment_login_guide_flower_popup, container, false);
        this.mllViewContainer = (LinearLayout)this.mRootView.findViewById(R.id.ll_flower_view_container);
        this.init();
        return this.mRootView;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setStyle(0, 16973831);
        KeyBehaviorGuideStatistic.reportLoginGuideSuccessEvent();
    }

    private void init() {
        this.mScaleOutAnimation = (AlphaAnimation)AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.scale_out_from_center);
        this.mScaleInAnimation = (ScaleAnimation)AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.scale_in_from_center);
        this.mScaleInAnimation.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                MLog.debug((Object)"LoginGuideFlowerPopupComponent", (String)"mScaleInAnimation: onAnimationEnd:", (Object[])new Object[0]);
                RxUtils.dispose((Disposable)LoginGuideFlowerPopupComponent.this.disposable);
                LoginGuideFlowerPopupComponent.this.disposable = Flowable.timer((long)1500L, (TimeUnit)TimeUnit.MILLISECONDS).compose((FlowableTransformer)LoginGuideFlowerPopupComponent.this.bindUntilEvent(FragmentEvent.DETACH)).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<Object>(){

                    public void accept(Object o) throws Exception {
                        if (LoginGuideFlowerPopupComponent.this.mllViewContainer != null && LoginGuideFlowerPopupComponent.this.mScaleOutAnimation != null) {
                            LoginGuideFlowerPopupComponent.this.startCountDownTimer();
                        } else {
                            LoginGuideFlowerPopupComponent.this.hideSelf();
                        }
                    }
                }, RxUtils.errorConsumer((String)"LoginGuideFlowerPopupComponent"));
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        this.mllViewContainer.setVisibility(0);
        this.mllViewContainer.startAnimation((Animation)this.mScaleInAnimation);
    }

    public void startCountDownTimer() {
        SinglePluginInfo pluginInfo = ((IPluginCenterCore)ICoreManagerBase.getCore(IPluginCenterCore.class)).getCurrentActivatedPlugin();
        MLog.debug((Object)"LoginGuideFlowerPopupComponent", (String)("startCountDownTimer: pluginInfo=" + pluginInfo), (Object[])new Object[0]);
        if (pluginInfo != null && StringUtils.equal((String)pluginInfo.getAndroidId(), (String)"34")) {
            this.mScaleOutAnimation.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                }

                public void onAnimationEnd(Animation animation) {
                    MLog.info((Object)"LoginGuideFlowerPopupComponent", (String)"mScaleOutAnimation end", (Object[])new Object[0]);
                    IGiftUIListener_showGiftIconAnim_EventArgs eventArgs = new IGiftUIListener_showGiftIconAnim_EventArgs();
                    eventArgs.type = 0;
                    RxBus.getDefault().post((Object)eventArgs);
                    LoginGuideFlowerPopupComponent.this.hideSelf();
                }

                public void onAnimationRepeat(Animation animation) {
                }
            });
            this.mllViewContainer.setVisibility(4);
            this.mllViewContainer.startAnimation((Animation)this.mScaleOutAnimation);
            return;
        }
        ImageView oldImg = (ImageView)this.mRootView.findViewById(R.id.img_close_login_bar);
        int startX = (int)(this.mllViewContainer.getX() + oldImg.getX());
        int startY = (int)((float)CaptureConstant.STATUS_BAR_HEIGHT + this.mllViewContainer.getY() + oldImg.getY());
        int endX = ResolutionUtils.getScreenWidth((Context)this.mRootView.getContext()) - oldImg.getMeasuredWidth();
        int endY = ResolutionUtils.getScreenHeight((Context)this.mRootView.getContext()) - oldImg.getMeasuredHeight();
        ImageView newImg = new ImageView(this.getContext());
        newImg.setImageResource(R.drawable.icon_hua);
        int width = (int)ResolutionUtils.convertDpToPixel((float)55.0f, (Context)this.getContext());
        RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(width, width);
        this.mRootView.addView((View)newImg, (ViewGroup.LayoutParams)lp);
        oldImg.setVisibility(4);
        newImg.setVisibility(0);
        MLog.info((Object)"LoginGuideFlowerPopupComponent", (String)("startX : " + startX + " endX : " + endX + " startY : " + startY + " endY : " + endY), (Object[])new Object[0]);
        ObjectAnimator moveX = ObjectAnimator.ofFloat((Object)newImg, (String)"translationX", (float[])new float[]{startX, endX});
        ObjectAnimator moveY = ObjectAnimator.ofFloat((Object)newImg, (String)"translationY", (float[])new float[]{startY, endY});
        ObjectAnimator scaleX = ObjectAnimator.ofFloat((Object)newImg, (String)"scaleX", (float[])new float[]{1.0f, 0.0f});
        ObjectAnimator scaleY = ObjectAnimator.ofFloat((Object)newImg, (String)"scaleY", (float[])new float[]{1.0f, 0.0f});
        scaleX.setStartDelay(200L);
        scaleY.setStartDelay(200L);
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(new Animator[]{moveX, moveY, scaleX, scaleY});
        animatorSet.setDuration(300L);
        animatorSet.start();
        animatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                super.onAnimationStart(animation);
            }

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                MLog.info((Object)"LoginGuideFlowerPopupComponent", (String)"animatorSet end", (Object[])new Object[0]);
                IGiftUIListener_showGiftIconAnim_EventArgs eventArgs = new IGiftUIListener_showGiftIconAnim_EventArgs();
                eventArgs.type = 0;
                RxBus.getDefault().post((Object)eventArgs);
                LoginGuideFlowerPopupComponent.this.hideSelf();
            }
        });
        this.mllViewContainer.startAnimation((Animation)this.mScaleOutAnimation);
    }

    private void releaseCountDownHiddenTimer() {
        if (this.mCountDownHiddenTimer != null && !this.mCountDownHiddenTimer.isDisposed()) {
            this.mCountDownHiddenTimer.dispose();
        }
        this.mCountDownHiddenTimer = null;
    }

    public void onDismiss(DialogInterface dialog) {
        super.onDismiss(dialog);
        this.releaseCountDownHiddenTimer();
    }

    public void onDestroy() {
        super.onDestroy();
        this.releaseCountDownHiddenTimer();
        this.mCountDownHiddenTimer = null;
        RxUtils.dispose((Disposable)this.disposable);
        if (this.mScaleInAnimation != null) {
            this.mScaleInAnimation.cancel();
            this.mScaleInAnimation = null;
        }
        if (this.mScaleOutAnimation != null) {
            this.mScaleOutAnimation.cancel();
            this.mScaleOutAnimation = null;
        }
        if (this.mScaleOutAnimationSet != null) {
            this.mScaleOutAnimationSet.cancel();
            this.mScaleOutAnimationSet = null;
        }
    }
}

