/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.basefunction.followguide;

import com.duowan.mobile.basemedia.watchlive.template.IChannelBaseParam;
import com.duowan.mobile.basemedia.watchlive.template.Scene;
import com.yy.mobile.ui.basefunction.followguide.ABTestFollowGuideHandler;
import com.yy.mobile.ui.basefunction.followguide.ActionFollowGuideHandler;
import com.yy.mobile.ui.basefunction.followguide.LiveLoginGuideHandler;
import com.yy.mobile.util.log.MLog;

public class LoginFollowGuideManager {
    private ActionFollowGuideHandler mActionFollowGuideHandler = new ActionFollowGuideHandler();
    private ABTestFollowGuideHandler mABTestFollowGuideHandler = new ABTestFollowGuideHandler();
    private LiveLoginGuideHandler mLiveLoginGuideHandler = new LiveLoginGuideHandler();
    private Scene mCurrentScene;
    private IChannelBaseParam mChannelParam;
    private boolean mIsLandscape;
    private static LoginFollowGuideManager INSTANCE;

    private LoginFollowGuideManager() {
    }

    public static LoginFollowGuideManager instance() {
        if (INSTANCE == null) {
            INSTANCE = new LoginFollowGuideManager();
        }
        return INSTANCE;
    }

    public void init() {
        this.mActionFollowGuideHandler.init();
        this.mABTestFollowGuideHandler.init();
        this.mLiveLoginGuideHandler.init();
    }

    public void setIsLandscape(boolean isLandscape) {
        MLog.info((Object)"LoginFollowGuideManager", (String)("setIsLandscape: " + isLandscape), (Object[])new Object[0]);
        this.mIsLandscape = isLandscape;
    }

    public void setLiveScene(Scene scene, IChannelBaseParam channelParam) {
        MLog.info((Object)"LoginFollowGuideManager", (String)("setLiveScene: " + scene + ", mChannelParam=" + channelParam), (Object[])new Object[0]);
        this.mCurrentScene = scene;
        this.mChannelParam = channelParam;
    }

    public Scene getLiveScene() {
        return this.mCurrentScene;
    }

    public void uninit() {
        this.mActionFollowGuideHandler.release();
        this.mABTestFollowGuideHandler.release();
        this.mLiveLoginGuideHandler.release();
    }

    public void sceneInitDone() {
        this.mABTestFollowGuideHandler.sceneInitDone();
        this.mLiveLoginGuideHandler.sceneInitDone();
    }

    public void showFollowGuide(int type) {
        MLog.info((Object)"LoginFollowGuideManager", (String)("showFollowGuide: scene=" + this.mCurrentScene + ", type=" + type + ", mIsLandscape=" + this.mIsLandscape), (Object[])new Object[0]);
        if (this.isAbleToShowFollowGuide() && type == 1) {
            this.mActionFollowGuideHandler.showFollowGuide();
        }
    }

    public void updateFollowGuideShownState(int type, boolean isShown) {
        switch (type) {
            case 1: {
                this.mActionFollowGuideHandler.updateFollowGuideShownState(isShown);
                break;
            }
            case 3: {
                this.mABTestFollowGuideHandler.updateFollowGuideShownState(isShown);
                break;
            }
            case 4: {
                this.mABTestFollowGuideHandler.updateFollowGuideShownState(isShown);
                break;
            }
            case 2: {
                this.mLiveLoginGuideHandler.updateFollowGuideShownState(isShown);
                break;
            }
        }
    }

    public void followAnchorSuccess(int type) {
        switch (type) {
            case 1: {
                this.mActionFollowGuideHandler.followAnchorSuccess();
                break;
            }
            case 3: {
                this.mABTestFollowGuideHandler.followAnchorSuccess();
                break;
            }
            case 4: {
                this.mABTestFollowGuideHandler.followAnchorSuccess();
                break;
            }
        }
    }

    public void navToLoginFromGuide() {
        this.mLiveLoginGuideHandler.navToLoginFromGuide();
    }

    public void initFollowGuideCarrier(String fromTag) {
        MLog.debug((Object)"LoginFollowGuideManager", (String)("initFollowGuideCarrier: " + fromTag), (Object[])new Object[0]);
        this.mActionFollowGuideHandler.enterLiveRoom();
        this.mABTestFollowGuideHandler.enterLiveRoom();
    }

    public void checkShowLoginFlower() {
        this.mLiveLoginGuideHandler.checkShowLoginFlower();
    }

    public int getFollowGuideShowState(int type) {
        if (type == 1) {
            return this.mActionFollowGuideHandler.getFollowGuideShowState();
        }
        if (type == 3 || type == 4) {
            return this.mABTestFollowGuideHandler.getFollowGuideShowState();
        }
        return 0;
    }

    public boolean isAbleToShowFollowGuide() {
        if (this.mIsLandscape) {
            return false;
        }
        return this.mCurrentScene == Scene.ENTERTAINMENT;
    }
}

