/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.basefunction.followguide;

import android.app.Activity;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.channel.core.AbsChannelControllerCore;
import com.yy.mobile.image.ImageConfig;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_leaveCurrentChannel_EventArgs;
import com.yy.mobile.plugin.main.events.ISubscribeClient_onSubscribeResult_EventArgs;
import com.yy.mobile.plugin.main.events.IUserClient_onRequestDetailUserInfo_EventArgs;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.basefunction.followguide.FollowGuideComponent$$EventBinder;
import com.yy.mobile.ui.basefunction.followguide.KeyBehaviorGuideStatistic;
import com.yy.mobile.ui.basefunction.followguide.LoginFollowGuideManager;
import com.yy.mobile.ui.basicchanneltemplate.component.Component;
import com.yy.mobile.ui.home.BasicFaceHelper;
import com.yy.mobile.ui.home.FaceHelperFactory;
import com.yy.mobile.ui.subscribeNotify.SubscribedNotify;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.ylink.bridge.CoreApiManager;
import com.yy.mobile.ylink.bridge.coreapi.BaseFragmentApi;
import com.yymobile.core.CoreError;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.subscribe.ISubscribeCore;
import com.yymobile.core.user.IUserCore;
import com.yymobile.core.user.UserInfo;
import com.yyproto.utils.FP;

public class FollowGuideComponent
extends Component
implements View.OnClickListener {
    private int mShowType = 0;
    private ViewGroup mRootView;
    private RecycleImageView mAnchorImg;
    private long mUid;
    private EventBinder mFollowGuideComponentSniperEventBinder;

    public static FollowGuideComponent getInstance(int type) {
        FollowGuideComponent component = new FollowGuideComponent();
        Bundle bundle = new Bundle();
        bundle.putInt("SHOW_TYPE_PARAM_KEY", type);
        component.setArguments(bundle);
        return component;
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        if (savedInstanceState != null) {
            this.mShowType = savedInstanceState.getInt("SHOW_TYPE_PARAM_KEY");
        } else if (this.getArguments() != null) {
            this.mShowType = this.getArguments().getInt("SHOW_TYPE_PARAM_KEY");
        }
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.mRootView = (ViewGroup)inflater.inflate(R.layout.layout_live_follow_guide, container, false);
        this.mAnchorImg = (RecycleImageView)this.mRootView.findViewById(R.id.img_anchor_head);
        this.mRootView.setOnClickListener((View.OnClickListener)this);
        this.init();
        return this.mRootView;
    }

    public void onResume() {
        super.onResume();
        LoginFollowGuideManager.instance().updateFollowGuideShownState(this.mShowType, true);
    }

    public void onPause() {
        super.onPause();
    }

    public void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putInt("SHOW_TYPE_PARAM_KEY", this.mShowType);
    }

    private void init() {
        this.mUid = ICoreManagerBase.getChannelLinkCore().getCurrentTopMicId();
        if (this.mUid > 0L) {
            UserInfo userInfo = ICoreManagerBase.getUserCore().getCacheUserInfoByUid(this.mUid);
            if (userInfo != null) {
                this.showAchorIcon(userInfo);
            } else {
                ((IUserCore)ICoreManagerBase.getCore(IUserCore.class)).requestDetailUserInfo(this.mUid, true);
            }
        }
    }

    @BusEvent
    public void onRequestDetailUserInfo(IUserClient_onRequestDetailUserInfo_EventArgs busEventArgs) {
        long userId = busEventArgs.getUserId();
        UserInfo info = busEventArgs.getInfo();
        boolean isLocalData = busEventArgs.getIsLocalData();
        CoreError error = busEventArgs.getError();
        if (error == null && info != null && userId > 0L && userId == this.mUid) {
            this.showAchorIcon(info);
        }
    }

    private void showAchorIcon(UserInfo info) {
        String iconUrl = "";
        if (!FP.empty((CharSequence)info.iconUrl)) {
            iconUrl = info.iconUrl;
        } else if (!FP.empty((CharSequence)info.iconUrl_100_100)) {
            iconUrl = info.iconUrl_100_100;
        } else if (!FP.empty((CharSequence)info.iconUrl_144_144)) {
            iconUrl = info.iconUrl_144_144;
        }
        if (this.mAnchorImg != null) {
            BasicFaceHelper.loadFace((String)iconUrl, (int)info.iconIndex, (FaceHelperFactory.FaceType)FaceHelperFactory.FaceType.FriendFace, (RecycleImageView)this.mAnchorImg, (ImageConfig)ImageConfig.defaultImageConfig(), (int)R.drawable.default_portrait);
        }
    }

    public void onClick(View v) {
        KeyBehaviorGuideStatistic.reportFollowGuideBarButtonClickEvent(this.mShowType);
        if (!LoginUtil.isLogined()) {
            if (CoreApiManager.getInstance().getApi(BaseFragmentApi.class) != null) {
                ((BaseFragmentApi)CoreApiManager.getInstance().getApi(BaseFragmentApi.class)).showLoginDialog((Activity)this.getActivity());
            }
            return;
        }
        if (this.mUid > 0L) {
            MLog.info((Object)"FollowGuideComponent", (String)("subscribe: mUid = " + this.mUid), (Object[])new Object[0]);
            ((ISubscribeCore)ICoreManagerBase.getCore(ISubscribeCore.class)).subscribe(this.mUid);
        }
    }

    @BusEvent
    public void onSubscribeResult(ISubscribeClient_onSubscribeResult_EventArgs busEventArgs) {
        long anchorUid = busEventArgs.getAnchorUid();
        boolean success = busEventArgs.getSuccess();
        String errorMsg = busEventArgs.getErrorMsg();
        if (this.mUid != 0L && anchorUid == this.mUid) {
            LoginFollowGuideManager.instance().followAnchorSuccess(this.mShowType);
            AbsChannelControllerCore absChannelControllerCore = (AbsChannelControllerCore)ICoreManagerBase.getCore(AbsChannelControllerCore.class);
            if (absChannelControllerCore == null || !absChannelControllerCore.interceptSuceefulNotify()) {
                SubscribedNotify.instance().subcribedSuceefulNotifyMessage(this.getContext(), SubscribedNotify.TYPE.Subcribe);
            }
            this.hideSelf();
        }
    }

    @BusEvent(sync=true)
    public void leaveCurrentChannel(IChannelLinkClient_leaveCurrentChannel_EventArgs busEventArgs) {
        this.hideSelf();
    }

    public void onDestroy() {
        super.onDestroy();
    }

    protected void onViewCreated(View view, Bundle bundle) {
        if (this.mFollowGuideComponentSniperEventBinder == null) {
            this.mFollowGuideComponentSniperEventBinder = new FollowGuideComponent$$EventBinder();
        }
        this.mFollowGuideComponentSniperEventBinder.bindEvent((Object)this);
        super.onViewCreated(view, bundle);
    }

    protected void onDestroyView() {
        super.onDestroyView();
        if (this.mFollowGuideComponentSniperEventBinder != null) {
            this.mFollowGuideComponentSniperEventBinder.unBindEvent();
        }
    }
}

