/*
 * Decompiled with CFR 0.152.
 */
package com.yy.live.module.vote.ui;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.yy.live.module.vote.core.IVoteCore;
import com.yy.live.module.vote.ui.VoteAnimListen;
import com.yy.live.module.vote.ui.VoteBaseAdapter;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.ICoreManagerBase;
import java.util.HashMap;
import java.util.List;

public class VoteVSListAdapter
extends VoteBaseAdapter {
    public VoteVSListAdapter(Context context, List<HashMap<String, Object>> dataList, int item2, VoteAnimListen val, int totalTickets, int voteStatus) {
        super(context, dataList, item2, val, totalTickets, voteStatus);
    }

    @Override
    public int getCount() {
        return this.dataList.size();
    }

    @Override
    public Object getItem(int position) {
        if (this.dataList != null && position < this.getCount() && position >= 0) {
            return this.dataList.get(position);
        }
        return null;
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        Button voteBtn;
        ProgressBar pb;
        TextView rightTextView;
        TextView leftTextView;
        HashMap tmp = (HashMap)this.dataList.get(position);
        if (convertView == null) {
            convertView = this.lif.inflate(this.item, null);
            leftTextView = (TextView)convertView.findViewById(R.id.vote_left_team);
            rightTextView = (TextView)convertView.findViewById(R.id.vote_right_team);
            pb = (ProgressBar)convertView.findViewById(R.id.vote_progress);
            voteBtn = (Button)convertView.findViewById(R.id.vote_btn);
            voteBtn.setTag((Object)position);
            voteBtn.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    try {
                        HashMap tmp = (HashMap)VoteVSListAdapter.this.dataList.get(Integer.parseInt(v.getTag().toString()));
                        if (tmp == null || !tmp.containsKey("option_id")) {
                            return;
                        }
                        ((IVoteCore)ICoreManagerBase.getCore(IVoteCore.class)).sendVote(Integer.parseInt(tmp.get("option_id").toString()), 1);
                        VoteVSListAdapter.this.val.startAddOneAnim(400, v);
                        VoteVSListAdapter.this.notifyDataSetChanged();
                    }
                    catch (Exception e) {
                        MLog.info((Object)"VoteVSListAdapter", (String)("vote vs adapter e=" + e.getMessage()), (Object[])new Object[0]);
                    }
                }
            });
            convertView.setTag((Object)new DataWrapper(leftTextView, pb, rightTextView, voteBtn));
        } else {
            DataWrapper dw = (DataWrapper)convertView.getTag();
            leftTextView = dw.leftTextView;
            rightTextView = dw.rightTextView;
            voteBtn = dw.voteBtn;
            pb = dw.vpb;
            voteBtn.setTag((Object)position);
        }
        leftTextView.setText((CharSequence)tmp.get("option_info").toString());
        int tickets = Integer.parseInt(tmp.get("option_voted_tickets").toString());
        rightTextView.setText((CharSequence)(tickets + ""));
        if (Integer.parseInt(tmp.get("option_user_tickets").toString()) <= 0 || this.totalTickets <= 0 || this.voteStatus == 1) {
            voteBtn.setEnabled(false);
        } else {
            voteBtn.setEnabled(true);
        }
        pb.setMax(this.totalTicketCount);
        pb.setProgress(tickets);
        return convertView;
    }

    public static class DataWrapper {
        public TextView leftTextView;
        public TextView rightTextView;
        public Button voteBtn;
        public ProgressBar vpb;

        public DataWrapper(TextView leftTextView, ProgressBar vpb, TextView rightTextView, Button voteBtn) {
            this.leftTextView = leftTextView;
            this.rightTextView = rightTextView;
            this.voteBtn = voteBtn;
            this.vpb = vpb;
        }
    }
}

