/*
 * Decompiled with CFR 0.152.
 */
package com.yy.live.module.vote.ui;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.yy.live.module.vote.core.IVoteCore;
import com.yy.live.module.vote.ui.VoteAnimListen;
import com.yy.live.module.vote.ui.VoteBaseAdapter;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.ICoreManagerBase;
import java.util.HashMap;
import java.util.List;

public class VoteListAdapter
extends VoteBaseAdapter {
    public VoteListAdapter(Context context, List<HashMap<String, Object>> dataList, int item2, VoteAnimListen val, int totalTickets, int voteStatus) {
        super(context, dataList, item2, val, totalTickets, voteStatus);
    }

    @Override
    public View getView(int position, View convertView, ViewGroup viewGroup) {
        TextView rightText;
        TextView leftText;
        Button voteBtn;
        ProgressBar pb;
        if (this.dataList == null) {
            return null;
        }
        HashMap tmpData = (HashMap)this.dataList.get(position);
        if (convertView == null) {
            convertView = this.lif.inflate(this.item, null);
            pb = (ProgressBar)convertView.findViewById(R.id.vote_progress);
            pb.setMax(100);
            voteBtn = (Button)convertView.findViewById(R.id.vote_btn);
            leftText = (TextView)convertView.findViewById(R.id.vote_left_text);
            rightText = (TextView)convertView.findViewById(R.id.vote_right_text);
            voteBtn.setTag((Object)position);
            voteBtn.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    try {
                        HashMap tmp = (HashMap)VoteListAdapter.this.dataList.get(Integer.parseInt(view.getTag().toString()));
                        if (tmp == null || !tmp.containsKey("option_id")) {
                            return;
                        }
                        ((IVoteCore)ICoreManagerBase.getCore(IVoteCore.class)).sendVote(Integer.parseInt(tmp.get("option_id").toString()), 1);
                        VoteListAdapter.this.val.startAddOneAnim(400, view);
                        VoteListAdapter.this.notifyDataSetChanged();
                    }
                    catch (Exception e) {
                        MLog.info((Object)"VoteListAdapter", (String)("vote adapter e=" + e.getMessage()), (Object[])new Object[0]);
                    }
                }
            });
            convertView.setTag((Object)new DataWrapper(voteBtn, pb, leftText, rightText));
        } else {
            DataWrapper dwp = (DataWrapper)convertView.getTag();
            pb = dwp.vpb;
            voteBtn = dwp.btnVote;
            voteBtn.setTag((Object)position);
            leftText = dwp.leftText;
            rightText = dwp.rightText;
        }
        leftText.setText((CharSequence)tmpData.get("option_info").toString());
        rightText.setText((CharSequence)tmpData.get("option_voted_tickets").toString());
        int tickets = Integer.parseInt(tmpData.get("option_voted_tickets").toString());
        if (Integer.parseInt(tmpData.get("option_user_tickets").toString()) <= 0 || this.totalTickets <= 0 || this.voteStatus == 1) {
            voteBtn.setEnabled(false);
        } else {
            voteBtn.setEnabled(true);
        }
        if (this.dataList.size() > 1) {
            int totalCount = 0;
            for (int i = 0; i < this.dataList.size(); ++i) {
                totalCount += Integer.parseInt(((HashMap)this.dataList.get(i)).get("option_voted_tickets").toString());
            }
            pb.setMax(totalCount);
        } else if (tickets >= pb.getMax()) {
            pb.setMax(pb.getMax() * 10);
        }
        pb.setProgress(tickets);
        return convertView;
    }

    private static class DataWrapper {
        public Button btnVote;
        public ProgressBar vpb;
        public TextView leftText;
        public TextView rightText;

        DataWrapper(Button btnVote, ProgressBar vpb, TextView leftText, TextView rightText) {
            this.btnVote = btnVote;
            this.vpb = vpb;
            this.leftText = leftText;
            this.rightText = rightText;
        }
    }
}

