/*
 * Decompiled with CFR 0.152.
 */
package com.yy.live.module.treasure;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TextView;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.live.module.treasure.TreasureCardFragment;
import com.yy.live.module.treasure.TreasureGroupRankFragment;
import com.yy.live.module.treasure.TreasureProfileFragment$$EventBinder;
import com.yy.live.module.treasure.TrueLoveAnchorUtil;
import com.yy.live.module.treasure.UIResHelper;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.image.ImageConfig;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.liveapi.live.statistic.LiveStatistic;
import com.yy.mobile.plugin.main.events.IProfileClient_onRequestProfile_EventArgs;
import com.yy.mobile.plugin.main.events.ITrueLoveClient_onQueryTreasureGroupInfo_EventArgs;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.basicchanneltemplate.component.Component;
import com.yy.mobile.ui.profile.uicore.IProfileBasicCore;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.ylink.bridge.CoreApiManager;
import com.yy.mobile.ylink.bridge.coreapi.NavigationUtilApi;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.basechannel.IChannelLinkCore;
import com.yymobile.core.noble.EntIdentity;
import com.yymobile.core.profile.EntUserInfo;
import com.yymobile.core.statistic.IHiidoStatisticCore;
import com.yymobile.core.truelove.TrueLoveInfo;

public class TreasureProfileFragment
extends Component
implements View.OnClickListener {
    View mRootView;
    RecycleImageView mIvTreasureGroupIcon;
    TextView mTvGroupNick;
    TextView mTvGroupMedia;
    TextView mTvGroupLevel;
    TextView mTvGroupInfo;
    TextView mTvGroupRankInfo;
    TextView mTvGroupNotice;
    Button mBtnFance;
    Button mBtnRank;
    Button mBtnCharge;
    RecycleImageView mIconTreasureAbout;
    boolean isAnchor;
    private ViewGroup parent;
    private IChannelLinkCore channelLinkCore;
    private EventBinder mTreasureProfileFragmentSniperEventBinder;

    public static TreasureProfileFragment instance(ViewGroup viewGroup) {
        TreasureProfileFragment treasureProfileFragment = new TreasureProfileFragment();
        treasureProfileFragment.parent = viewGroup;
        return treasureProfileFragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.isAnchor = savedInstanceState != null ? savedInstanceState.getBoolean("KEY_IS_ANCHOR") : TrueLoveAnchorUtil.isMyselfTopMicAndAnchor();
        this.channelLinkCore = ICoreManagerBase.getChannelLinkCore();
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (outState != null) {
            outState.putBoolean("KEY_IS_ANCHOR", this.isAnchor);
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.mRootView = inflater.inflate(R.layout.treasure_fragment_profile, container, false);
        this.initView();
        return this.mRootView;
    }

    private void initView() {
        this.mIvTreasureGroupIcon = (RecycleImageView)this.mRootView.findViewById(R.id.iv_treasure_icon);
        this.mTvGroupLevel = (TextView)this.mRootView.findViewById(R.id.tv_group_level);
        this.mTvGroupMedia = (TextView)this.mRootView.findViewById(R.id.tv_group_media);
        this.mTvGroupNick = (TextView)this.mRootView.findViewById(R.id.tv_group_nick);
        this.mTvGroupInfo = (TextView)this.mRootView.findViewById(R.id.tv_group_info);
        this.mTvGroupRankInfo = (TextView)this.mRootView.findViewById(R.id.tv_group_rank_info);
        this.mTvGroupNotice = (TextView)this.mRootView.findViewById(R.id.tv_treasure_notice);
        this.mBtnCharge = (Button)this.mRootView.findViewById(R.id.btn_charge);
        this.mBtnRank = (Button)this.mRootView.findViewById(R.id.btn_rank);
        this.mBtnFance = (Button)this.mRootView.findViewById(R.id.btn_fance);
        this.mIconTreasureAbout = (RecycleImageView)this.mRootView.findViewById(R.id.icon_treasure_about);
        this.mBtnCharge.setOnClickListener((View.OnClickListener)this);
        this.mBtnRank.setOnClickListener((View.OnClickListener)this);
        this.mBtnFance.setOnClickListener((View.OnClickListener)this);
        this.mIconTreasureAbout.setOnClickListener((View.OnClickListener)this);
        this.toggleBtn();
        TrueLoveInfo.TreasureGroupData treasureGroupData = (TrueLoveInfo.TreasureGroupData)TrueLoveInfo.MyTrueLoveInfo.treasureGroupDataArrayMap.get((Object)(String.valueOf(LoginUtil.getUid()) + String.valueOf(this.channelLinkCore.getCurrentTopMicId())));
        if (treasureGroupData != null) {
            this.onQueryTreasureGroupInfo(treasureGroupData);
        }
    }

    private void toggleBtn() {
        if (this.isAnchor) {
            this.mBtnCharge.setVisibility(8);
        } else {
            this.mBtnCharge.setVisibility(0);
        }
    }

    public void onHiddenChanged(boolean hidden) {
        super.onHiddenChanged(hidden);
        if (!hidden) {
            this.isAnchor = TrueLoveAnchorUtil.isMyselfTopMicAndAnchor();
        }
        this.toggleBtn();
    }

    private String getRes(long total) {
        if (total > 10000L) {
            int index;
            String res = String.format("%.2f", (double)total / 10000.0);
            if (MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)"TreasureProfileFragment", (String)"getRes=%s", (Object[])new Object[]{res});
            }
            if (res.charAt((index = res.indexOf(".")) + 1) == '0' && res.charAt(index + 2) == '0') {
                res = res.substring(0, index);
            } else if (res.charAt(index + 1) != '0' && res.charAt(index + 2) == '0') {
                res = res.substring(0, index + 2);
            }
            return res + "\u4e07";
        }
        return total + "";
    }

    @BusEvent
    public void onQueryTreasureGroupInfo(ITrueLoveClient_onQueryTreasureGroupInfo_EventArgs busEventArgs) {
        TrueLoveInfo.TreasureGroupData treasureGroupData = busEventArgs.getTreasureGroupData();
        this.onQueryTreasureGroupInfo(treasureGroupData);
    }

    public void onQueryTreasureGroupInfo(TrueLoveInfo.TreasureGroupData treasureGroupData) {
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)"TreasureProfileFragment", (String)("onQueryTreasureGroupInfo treasureGroupData=" + treasureGroupData), (Object[])new Object[0]);
        }
        if (treasureGroupData != null && treasureGroupData.result == 0L && treasureGroupData.uid == LoginUtil.getUid()) {
            ImageLoader.loadImage((String)treasureGroupData.groupPic, (RecycleImageView)this.mIvTreasureGroupIcon, (ImageConfig)new ImageConfig(140, 140), (int)R.drawable.truelove_default_group_icon);
            if (treasureGroupData.groupLevel > 0) {
                this.mTvGroupLevel.setText((CharSequence)("LV" + treasureGroupData.groupLevel));
            }
            if (!FP.empty((CharSequence)treasureGroupData.groupNick)) {
                this.mTvGroupNick.setText((CharSequence)treasureGroupData.groupNick);
            }
            if (treasureGroupData.maxLevel - (long)treasureGroupData.groupLevel > 0L) {
                long val = treasureGroupData.nextLevel - treasureGroupData.vitality;
                this.mTvGroupInfo.setText((CharSequence)this.getResources().getString(R.string.treasure_group_info, new Object[]{this.getRes(treasureGroupData.vitality), this.getRes(val)}));
            } else {
                this.mTvGroupInfo.setText((CharSequence)this.getResources().getString(R.string.treasure_group_info2, new Object[]{this.getRes(treasureGroupData.vitality)}));
            }
            this.mTvGroupRankInfo.setText((CharSequence)this.getResources().getString(R.string.treasure_group_rank_info, new Object[]{String.valueOf(treasureGroupData.groupRank), String.valueOf(treasureGroupData.numb), String.valueOf(treasureGroupData.score)}));
            if (!FP.empty((CharSequence)treasureGroupData.notice)) {
                this.mTvGroupNotice.setText((CharSequence)treasureGroupData.notice);
            }
            if (!FP.empty((CharSequence)treasureGroupData.groupMedalName)) {
                this.mTvGroupMedia.setText((CharSequence)treasureGroupData.groupMedalName);
                this.mTvGroupMedia.setBackgroundResource(UIResHelper.getTreasureGroupMedalRes(treasureGroupData.groupLevel));
            }
        }
    }

    public void onClick(View view) {
        int id2;
        if (ICoreManagerBase.getCore(IProfileBasicCore.class) != null) {
            ((IProfileBasicCore)ICoreManagerBase.getCore(IProfileBasicCore.class)).hidePersonalPageComponent(view);
        }
        if ((id2 = view.getId()) == R.id.btn_fance) {
            this.toTreasureCard();
        } else if (id2 == R.id.btn_rank) {
            this.toGroupRank();
        } else if (id2 == R.id.btn_charge) {
            ((IHiidoStatisticCore)ICoreManagerBase.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "51006", "0002", LiveStatistic.createliveChannelBaseProperty());
            String url = EntIdentity.appendUrlParams((EntIdentity.WebEntry)EntIdentity.WebEntry.channelTrueLoveRecharge, (long)this.channelLinkCore.getCurrentTopMicId(), (long)this.channelLinkCore.getCurrentChannelInfo().topSid, (long)this.channelLinkCore.getCurrentChannelInfo().subSid, (long)LoginUtil.getUid());
            if (CoreApiManager.getInstance() != null && CoreApiManager.getInstance().getApi(NavigationUtilApi.class) != null) {
                ((NavigationUtilApi)CoreApiManager.getInstance().getApi(NavigationUtilApi.class)).toJSSupportedWebView((Activity)this.getActivity(), url);
            }
        } else if (id2 == R.id.icon_treasure_about) {
            String url2 = EntIdentity.appendUrlParams((EntIdentity.WebEntry)EntIdentity.WebEntry.truelove_introduce, (long)this.channelLinkCore.getCurrentTopMicId(), (long)this.channelLinkCore.getCurrentChannelInfo().topSid, (long)this.channelLinkCore.getCurrentChannelInfo().subSid, (long)LoginUtil.getUid());
            if (CoreApiManager.getInstance() != null && CoreApiManager.getInstance().getApi(NavigationUtilApi.class) != null) {
                ((NavigationUtilApi)CoreApiManager.getInstance().getApi(NavigationUtilApi.class)).toJSSupportedWebView((Activity)this.getActivity(), url2);
            }
        }
    }

    @BusEvent(sync=true)
    public void onRequestProfile(IProfileClient_onRequestProfile_EventArgs busEventArgs) {
        EntUserInfo info = busEventArgs.getInfo();
        if (ICoreManagerBase.getChannelLinkCore().getCurrentTopMicId() == LoginUtil.getUid() && LoginUtil.getUid() == info.uid) {
            this.isAnchor = info.userType == 1;
            this.toggleBtn();
        }
    }

    private void toTreasureCard() {
        FragmentManager fm = this.getActivity().getSupportFragmentManager();
        Fragment fragment = fm.findFragmentByTag("card");
        FragmentTransaction ft = fm.beginTransaction();
        if (fragment == null) {
            fragment = Fragment.instantiate((Context)this.getActivity(), (String)TreasureCardFragment.class.getCanonicalName());
        }
        if (fragment.isDetached()) {
            ft.attach(fragment);
        } else if (!fragment.isAdded()) {
            ft.add(this.parent.getId(), fragment, "card");
        } else if (fragment.isHidden()) {
            ft.show(fragment);
        }
        ft.commitAllowingStateLoss();
    }

    private void toGroupRank() {
        FragmentManager fm = this.getActivity().getSupportFragmentManager();
        Fragment fragment = fm.findFragmentByTag("treasure_group_rank");
        FragmentTransaction ft = fm.beginTransaction();
        if (fragment == null) {
            fragment = Fragment.instantiate((Context)this.getActivity(), (String)TreasureGroupRankFragment.class.getCanonicalName());
        }
        if (fragment.isDetached()) {
            ft.attach(fragment);
        } else if (!fragment.isAdded()) {
            ft.add(this.parent.getId(), fragment, "treasure_group_rank");
        } else if (fragment.isHidden()) {
            ft.show(fragment);
        }
        ft.commitAllowingStateLoss();
    }

    public void onDestroy() {
        super.onDestroy();
        this.parent = null;
    }

    protected void onViewCreated(View view, Bundle bundle) {
        if (this.mTreasureProfileFragmentSniperEventBinder == null) {
            this.mTreasureProfileFragmentSniperEventBinder = new TreasureProfileFragment$$EventBinder();
        }
        this.mTreasureProfileFragmentSniperEventBinder.bindEvent((Object)this);
        super.onViewCreated(view, bundle);
    }

    protected void onDestroyView() {
        super.onDestroyView();
        if (this.mTreasureProfileFragmentSniperEventBinder != null) {
            this.mTreasureProfileFragmentSniperEventBinder.unBindEvent();
        }
    }
}

