/*
 * Decompiled with CFR 0.152.
 */
package com.yy.live.module.treasure;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.android.sniper.api.event.EventCompat;
import com.yy.live.module.treasure.TreasureCardFragment;
import com.yy.live.module.treasure.TreasureGroupRankFragment;
import com.yy.live.module.treasure.TreasureProfileCard$$EventBinder;
import com.yy.live.module.treasure.TrueLoveAnchorUtil;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.image.ImageConfig;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.liveapi.live.statistic.LiveStatistic;
import com.yy.mobile.plugin.main.events.ITrueLoveClient_onQueryTreasureGroupInfo_EventArgs;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.basicchanneltemplate.component.PopupComponent;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.ylink.bridge.CoreApiManager;
import com.yy.mobile.ylink.bridge.coreapi.NavigationUtilApi;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.basechannel.IChannelLinkCore;
import com.yymobile.core.noble.EntIdentity;
import com.yymobile.core.statistic.IHiidoStatisticCore;
import com.yymobile.core.truelove.TrueLoveInfo;

public class TreasureProfileCard
extends PopupComponent
implements EventCompat,
View.OnClickListener {
    private static ViewGroup parentId;
    boolean isAnchor;
    private TextView userNick;
    private TextView treasureLevel;
    private TextView treasurePaiHang;
    private TextView nums;
    private TextView treasureUpgrade;
    private TextView treasureCharge;
    private RecycleImageView groupIcon;
    private TextView treasureNotice;
    private IChannelLinkCore channelLinkCore;
    private EventBinder mTreasureProfileCardSniperEventBinder;

    public static TreasureProfileCard newInstance(ViewGroup viewGroup) {
        TreasureProfileCard treasureProfileCard = new TreasureProfileCard();
        parentId = viewGroup;
        return treasureProfileCard;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.isAnchor = savedInstanceState != null ? savedInstanceState.getBoolean("KEY_IS_ANCHOR") : TrueLoveAnchorUtil.isMyselfTopMicAndAnchor();
        this.channelLinkCore = ICoreManagerBase.getChannelLinkCore();
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (outState != null) {
            outState.putBoolean("KEY_IS_ANCHOR", this.isAnchor);
        }
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Dialog dialog = super.onCreateDialog(savedInstanceState);
        dialog.setCanceledOnTouchOutside(true);
        dialog.requestWindowFeature(1);
        dialog.getWindow().setWindowAnimations(R.style.DialogAnimation);
        dialog.getWindow().setBackgroundDrawableResource(R.color.transparent);
        dialog.getWindow().setFlags(1024, 1024);
        dialog.getWindow().clearFlags(2);
        dialog.getWindow().setGravity(17);
        dialog.getWindow().setLayout((int)ResolutionUtils.convertDpToPixel((float)305.0f, (Context)this.getActivity()), -2);
        return dialog;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.treasure_profile_card, null);
        this.initView(view);
        return view;
    }

    public void onClick(View view) {
        int i = view.getId();
        if (i == R.id.btn_close_person_card_new) {
            this.dismiss();
        } else if (i == R.id.profile_help_new_imageview) {
            String url2 = EntIdentity.appendUrlParams((EntIdentity.WebEntry)EntIdentity.WebEntry.truelove_introduce, (long)this.channelLinkCore.getCurrentTopMicId(), (long)this.channelLinkCore.getCurrentChannelInfo().topSid, (long)this.channelLinkCore.getCurrentChannelInfo().subSid, (long)LoginUtil.getUid());
            if (CoreApiManager.getInstance() != null && CoreApiManager.getInstance().getApi(NavigationUtilApi.class) != null) {
                ((NavigationUtilApi)CoreApiManager.getInstance().getApi(NavigationUtilApi.class)).toJSSupportedWebView((Activity)this.getActivity(), url2);
            }
        } else if (i == R.id.fan_Tv_new) {
            this.dismiss();
            this.toTreasureCard();
        } else if (i == R.id.charge_tv_new) {
            ((IHiidoStatisticCore)ICoreManagerBase.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "51006", "0002", LiveStatistic.createliveChannelBaseProperty());
            String url = EntIdentity.appendUrlParams((EntIdentity.WebEntry)EntIdentity.WebEntry.channelTrueLoveRecharge, (long)this.channelLinkCore.getCurrentTopMicId(), (long)this.channelLinkCore.getCurrentChannelInfo().topSid, (long)this.channelLinkCore.getCurrentChannelInfo().subSid, (long)LoginUtil.getUid());
            if (CoreApiManager.getInstance() != null && CoreApiManager.getInstance().getApi(NavigationUtilApi.class) != null) {
                ((NavigationUtilApi)CoreApiManager.getInstance().getApi(NavigationUtilApi.class)).toJSSupportedWebView((Activity)this.getActivity(), url);
            }
        } else if (i == R.id.tv_layout_paihang_new) {
            this.dismiss();
            this.toGroupRank();
        }
    }

    private void initView(View view) {
        view.findViewById(R.id.btn_close_person_card_new).setOnClickListener((View.OnClickListener)this);
        this.userNick = (TextView)view.findViewById(R.id.user_name);
        this.treasureLevel = (TextView)view.findViewById(R.id.user_level_new);
        this.treasurePaiHang = (TextView)view.findViewById(R.id.treasure_paihang_new);
        this.nums = (TextView)view.findViewById(R.id.num_new);
        this.treasureUpgrade = (TextView)view.findViewById(R.id.upgrage_treasure_new);
        view.findViewById(R.id.profile_help_new_imageview).setOnClickListener((View.OnClickListener)this);
        view.findViewById(R.id.fan_Tv_new).setOnClickListener((View.OnClickListener)this);
        view.findViewById(R.id.tv_layout_paihang_new).setOnClickListener((View.OnClickListener)this);
        this.treasureCharge = (TextView)view.findViewById(R.id.charge_tv_new);
        this.groupIcon = (RecycleImageView)view.findViewById(R.id.default_head_new);
        this.treasureNotice = (TextView)view.findViewById(R.id.treasure_notice_new);
        this.treasureCharge.setOnClickListener((View.OnClickListener)this);
        this.toggleBtn();
        TrueLoveInfo.TreasureGroupData treasureGroupData = (TrueLoveInfo.TreasureGroupData)TrueLoveInfo.MyTrueLoveInfo.treasureGroupDataArrayMap.get((Object)(String.valueOf(LoginUtil.getUid()) + String.valueOf(this.channelLinkCore.getCurrentTopMicId())));
        if (treasureGroupData != null) {
            this.onQueryTreasureGroupInfo(treasureGroupData);
        }
    }

    private void toggleBtn() {
        if (this.isAnchor) {
            this.treasureCharge.setVisibility(8);
        } else {
            this.treasureCharge.setVisibility(0);
        }
    }

    private String getRes(long total) {
        if (total > 10000L) {
            int index;
            String res = String.format("%.2f", (double)total / 10000.0);
            if (MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)"TreasureProfileCard", (String)"getRes=%s", (Object[])new Object[]{res});
            }
            if (res.charAt((index = res.indexOf(".")) + 1) == '0' && res.charAt(index + 2) == '0') {
                res = res.substring(0, index);
            } else if (res.charAt(index + 1) != '0' && res.charAt(index + 2) == '0') {
                res = res.substring(0, index + 2);
            }
            return res + "\u4e07";
        }
        return total + "";
    }

    @BusEvent
    public void onQueryTreasureGroupInfo(ITrueLoveClient_onQueryTreasureGroupInfo_EventArgs busEventArgs) {
        TrueLoveInfo.TreasureGroupData treasureGroupData = busEventArgs.getTreasureGroupData();
        this.onQueryTreasureGroupInfo(treasureGroupData);
    }

    public void onQueryTreasureGroupInfo(TrueLoveInfo.TreasureGroupData treasureGroupData) {
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)"TreasureProfileCard", (String)("onQueryTreasureGroupInfo treasureGroupData=" + treasureGroupData), (Object[])new Object[0]);
        }
        if (treasureGroupData != null && treasureGroupData.result == 0L && treasureGroupData.uid == LoginUtil.getUid()) {
            ImageLoader.loadImage((String)treasureGroupData.groupPic, (RecycleImageView)this.groupIcon, (ImageConfig)new ImageConfig(80, 80), (int)R.drawable.truelove_default_group_icon);
            if (treasureGroupData.groupLevel > 0) {
                this.treasureLevel.setText((CharSequence)("LV" + treasureGroupData.groupLevel));
            }
            if (!FP.empty((CharSequence)treasureGroupData.groupNick)) {
                this.userNick.setText((CharSequence)treasureGroupData.groupNick);
            }
            if (treasureGroupData.maxLevel - (long)treasureGroupData.groupLevel > 0L) {
                long val = treasureGroupData.nextLevel - treasureGroupData.vitality;
                this.treasureUpgrade.setText((CharSequence)this.getResources().getString(R.string.treasure_group_info_new, new Object[]{this.getRes(treasureGroupData.vitality), treasureGroupData.groupLevel + 1, this.getRes(val)}));
            } else {
                this.treasureUpgrade.setText((CharSequence)this.getResources().getString(R.string.treasure_group_info2, new Object[]{this.getRes(treasureGroupData.vitality)}));
            }
            this.treasurePaiHang.setText((CharSequence)String.valueOf(treasureGroupData.groupRank));
            this.nums.setText((CharSequence)String.valueOf(treasureGroupData.numb));
            if (!FP.empty((CharSequence)treasureGroupData.notice)) {
                this.treasureNotice.setText((CharSequence)treasureGroupData.notice);
            }
        }
    }

    private void toTreasureCard() {
        FragmentManager fm = this.getActivity().getSupportFragmentManager();
        Fragment fragment = fm.findFragmentByTag("card");
        FragmentTransaction ft = fm.beginTransaction();
        if (fragment == null) {
            fragment = Fragment.instantiate((Context)this.getActivity(), (String)TreasureCardFragment.class.getCanonicalName());
        }
        if (fragment.isDetached()) {
            ft.attach(fragment);
        } else if (!fragment.isAdded()) {
            ft.add(parentId.getId(), fragment, "card");
        } else if (fragment.isHidden()) {
            ft.show(fragment);
        }
        ft.commitAllowingStateLoss();
    }

    private void toGroupRank() {
        FragmentManager fm = this.getActivity().getSupportFragmentManager();
        Fragment fragment = fm.findFragmentByTag("treasure_group_rank");
        FragmentTransaction ft = fm.beginTransaction();
        if (fragment == null) {
            fragment = Fragment.instantiate((Context)this.getActivity(), (String)TreasureGroupRankFragment.class.getCanonicalName());
        }
        if (fragment.isDetached()) {
            ft.attach(fragment);
        } else if (!fragment.isAdded()) {
            ft.add(parentId.getId(), fragment, "treasure_group_rank");
        } else if (fragment.isHidden()) {
            ft.show(fragment);
        }
        ft.commitAllowingStateLoss();
    }

    public void onEventBind() {
        super.onEventBind();
        if (this.mTreasureProfileCardSniperEventBinder == null) {
            this.mTreasureProfileCardSniperEventBinder = new TreasureProfileCard$$EventBinder();
        }
        this.mTreasureProfileCardSniperEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        super.onEventUnBind();
        if (this.mTreasureProfileCardSniperEventBinder != null) {
            this.mTreasureProfileCardSniperEventBinder.unBindEvent();
        }
    }
}

