/*
 * Decompiled with CFR 0.152.
 */
package com.yy.live.module.treasure;

import android.app.Activity;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TextView;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.live.module.treasure.TreasureIntroduceFragment$$EventBinder;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.image.CircleImageView;
import com.yy.mobile.image.ImageConfig;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.liveapi.live.statistic.LiveStatistic;
import com.yy.mobile.plugin.main.events.IUserClient_onRequestDetailUserInfo_EventArgs;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.basicchanneltemplate.component.Component;
import com.yy.mobile.ui.profile.uicore.IProfileBasicCore;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.ylink.bridge.CoreApiManager;
import com.yy.mobile.ylink.bridge.coreapi.NavigationUtilApi;
import com.yymobile.core.CoreError;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.basechannel.IChannelLinkCore;
import com.yymobile.core.noble.EntIdentity;
import com.yymobile.core.statistic.IHiidoStatisticCore;
import com.yymobile.core.user.UserInfo;

public class TreasureIntroduceFragment
extends Component
implements View.OnClickListener {
    View mRootView;
    CircleImageView mIvTreasureIcon;
    TextView mTvTreasureIntro;
    Button mBtnJoin;
    private UserInfo userInfo;
    private long mAnchorId;
    private IChannelLinkCore channelLinkCore;
    private EventBinder mTreasureIntroduceFragmentSniperEventBinder;

    public static TreasureIntroduceFragment instance() {
        TreasureIntroduceFragment treasureIntroduceFragment = new TreasureIntroduceFragment();
        return treasureIntroduceFragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.channelLinkCore = ICoreManagerBase.getChannelLinkCore();
        this.mAnchorId = this.channelLinkCore.getCurrentTopMicId();
        this.userInfo = ICoreManagerBase.getUserCore().getCacheUserInfoByUid(this.mAnchorId);
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)"TreasureIntroduceFragment", (String)"onCreate anchorid=%d", (Object[])new Object[]{this.mAnchorId});
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.mRootView = inflater.inflate(R.layout.treasure_fragment_introduce, container, false);
        this.mIvTreasureIcon = (CircleImageView)this.mRootView.findViewById(R.id.iv_treasure_icon);
        this.mTvTreasureIntro = (TextView)this.mRootView.findViewById(R.id.tv_treasure_intro);
        this.mBtnJoin = (Button)this.mRootView.findViewById(R.id.btn_treasure_join);
        this.mBtnJoin.setOnClickListener((View.OnClickListener)this);
        this.init();
        return this.mRootView;
    }

    @BusEvent
    public void onRequestDetailUserInfo(IUserClient_onRequestDetailUserInfo_EventArgs busEventArgs) {
        long userId = busEventArgs.getUserId();
        UserInfo info = busEventArgs.getInfo();
        boolean isLocalData = busEventArgs.getIsLocalData();
        CoreError error = busEventArgs.getError();
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)"TreasureIntroduceFragment", (String)"onRequestDetailUserInfo userId=%d,info.uid=%d,mAnchorId=%d", (Object[])new Object[]{userId, info.userId, this.mAnchorId});
        }
        if (userId == this.mAnchorId) {
            this.userInfo = info;
            this.init();
        }
    }

    private void init() {
        if (this.userInfo == null) {
            if (MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)"TreasureIntroduceFragment", (String)"init userinfo=null", (Object[])new Object[0]);
            }
            ICoreManagerBase.getUserCore().requestDetailUserInfo(this.mAnchorId, true);
            return;
        }
        if (this.userInfo.iconIndex != 10001 && this.userInfo.iconIndex != Short.MAX_VALUE) {
            if (MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)"TreasureIntroduceFragment", (String)"anchor icon url=%s", (Object[])new Object[]{this.getFriendHeadUrl(this.userInfo.iconUrl_100_100, this.userInfo.iconIndex)});
            }
            ImageLoader.loadImage((String)this.getFriendHeadUrl(this.userInfo.iconUrl_100_100, this.userInfo.iconIndex), (RecycleImageView)this.mIvTreasureIcon, (ImageConfig)ImageConfig.fullImageConfig(), (int)R.drawable.info_header_bg);
        } else {
            ImageLoader.loadImageResource((int)R.drawable.info_header_bg, (RecycleImageView)this.mIvTreasureIcon, (ImageConfig)ImageConfig.fullImageConfig());
        }
        String nick = this.userInfo.nickName;
        if (!FP.empty((CharSequence)nick)) {
            if (nick.length() > 7) {
                nick = nick.substring(0, 7) + "..";
            }
            this.mTvTreasureIntro.setText((CharSequence)this.getResources().getString(R.string.treasure_introduce_s1, new Object[]{nick}));
        }
    }

    public void onClick(View v) {
        if (v == this.mBtnJoin) {
            ((IProfileBasicCore)ICoreManagerBase.getCore(IProfileBasicCore.class)).hidePersonalPageComponent(v);
            ((IHiidoStatisticCore)ICoreManagerBase.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "51006", "0001", LiveStatistic.createliveChannelBaseProperty());
            String url = EntIdentity.appendUrlParams((EntIdentity.WebEntry)EntIdentity.WebEntry.channelTrueLoveOpen, (long)this.channelLinkCore.getCurrentTopMicId(), (long)this.channelLinkCore.getCurrentChannelInfo().topSid, (long)this.channelLinkCore.getCurrentChannelInfo().subSid, (long)LoginUtil.getUid());
            if (CoreApiManager.getInstance() != null && CoreApiManager.getInstance().getApi(NavigationUtilApi.class) != null) {
                ((NavigationUtilApi)CoreApiManager.getInstance().getApi(NavigationUtilApi.class)).toJSSupportedWebView((Activity)this.getActivity(), url);
            }
        }
    }

    public void onHiddenChanged(boolean hidden) {
        super.onHiddenChanged(hidden);
        if (hidden) {
            return;
        }
        if (this.mAnchorId != this.channelLinkCore.getCurrentTopMicId()) {
            this.mAnchorId = this.channelLinkCore.getCurrentTopMicId();
            this.userInfo = ICoreManagerBase.getUserCore().getCacheUserInfoByUid(this.mAnchorId);
            this.init();
        }
    }

    private String getFriendHeadUrl(String url, int index) {
        if (index != 999 && index > 0) {
            return this.getActivity().getResources().getString(R.string.str_friend_head_index_url_format, new Object[]{index});
        }
        return url;
    }

    public void onDestroy() {
        super.onDestroy();
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)"TreasureIntroduceFragment", (String)"[onDestroy] @@@", (Object[])new Object[0]);
        }
    }

    protected void onViewCreated(View view, Bundle bundle) {
        if (this.mTreasureIntroduceFragmentSniperEventBinder == null) {
            this.mTreasureIntroduceFragmentSniperEventBinder = new TreasureIntroduceFragment$$EventBinder();
        }
        this.mTreasureIntroduceFragmentSniperEventBinder.bindEvent((Object)this);
        super.onViewCreated(view, bundle);
    }

    protected void onDestroyView() {
        super.onDestroyView();
        if (this.mTreasureIntroduceFragmentSniperEventBinder != null) {
            this.mTreasureIntroduceFragmentSniperEventBinder.unBindEvent();
        }
    }
}

