/*
 * Decompiled with CFR 0.152.
 */
package com.yy.live.module.treasure;

import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.live.module.treasure.TreasureGuideFragment$$EventBinder;
import com.yy.live.module.treasure.TreasureIntroduceFragment;
import com.yy.live.module.treasure.TreasureProfileFragment;
import com.yy.live.module.treasure.TrueLoveAnchorUtil;
import com.yy.mobile.plugin.main.events.ITrueLoveClient_onQueryTreasureGroupInfo_EventArgs;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.basicchanneltemplate.component.Component;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.yyprotocol.core.Uint32;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.basechannel.IChannelLinkCore;
import com.yymobile.core.truelove.TrueLoveInfo;

public class TreasureGuideFragment
extends Component {
    private static ViewGroup parent;
    View mRootView;
    String mTag;
    private IChannelLinkCore channelLinkCore;
    private EventBinder mTreasureGuideFragmentSniperEventBinder;

    public static TreasureGuideFragment instance(ViewGroup viewGroup) {
        TreasureGuideFragment treasureGuideFragment = new TreasureGuideFragment();
        parent = viewGroup;
        return treasureGuideFragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.channelLinkCore = ICoreManagerBase.getChannelLinkCore();
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.init();
    }

    private void init() {
        if (TrueLoveAnchorUtil.isMyselfTopMicAndAnchor()) {
            this.showContent("tag_profile");
        } else if (!TrueLoveInfo.MyTrueLoveInfo.isTrueLoveUserLv((Uint32)new Uint32(this.channelLinkCore.getCurrentTopMicId()))) {
            this.showContent("tag_introduce");
        } else {
            this.showContent("tag_profile");
        }
    }

    private void showContent(String tag) {
        this.mTag = tag;
        FragmentManager fm = this.getChildFragmentManager();
        FragmentTransaction ft = fm.beginTransaction();
        Object f = fm.findFragmentByTag(tag);
        if (null != f) {
            ft.show(f);
        } else if ("tag_introduce".equals(tag)) {
            f = TreasureIntroduceFragment.instance();
        } else if ("tag_profile".equals(tag)) {
            if (MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)"TreasureGuideFragment", (String)("[showContent],parent---" + parent), (Object[])new Object[0]);
            }
            f = TreasureProfileFragment.instance(parent);
        }
        if (null == f) {
            return;
        }
        if (f.isDetached()) {
            ft.attach(f);
        } else if (!f.isAdded()) {
            ft.add(this.getView().findViewById(R.id.treasure_container).getId(), f, tag);
        }
        int result = ft.commitAllowingStateLoss();
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.mRootView = inflater.inflate(R.layout.treasure_fragment_guide, container, false);
        this.mRootView.findViewById(R.id.screen_all_truelove).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (MLog.isLogLevelAboveDebug()) {
                    MLog.debug((Object)"TreasureGuideFragment", (String)"all screen click @@@", (Object[])new Object[0]);
                }
                TreasureGuideFragment.this.hideSelf();
            }
        });
        return this.mRootView;
    }

    @BusEvent
    public void onQueryTreasureGroupInfo(ITrueLoveClient_onQueryTreasureGroupInfo_EventArgs busEventArgs) {
        TrueLoveInfo.TreasureGroupData treasureGroupData = busEventArgs.getTreasureGroupData();
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)"TreasureGuideFragment", (String)"onQueryTreasureGroupInfo", (Object[])new Object[0]);
        }
        this.updateContent();
    }

    public void hideSelf() {
        super.hideSelf();
    }

    private void updateContent() {
        if (this.getView() != null) {
            boolean isTrueLove = TrueLoveInfo.MyTrueLoveInfo.isTrueLoveUserLv((Uint32)new Uint32(this.channelLinkCore.getCurrentTopMicId()));
            boolean isMyselfAncorAndTopMic = TrueLoveAnchorUtil.isMyselfTopMicAndAnchor();
            if (MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)"TreasureGuideFragment", (String)"updateContent tag=%s,topMicId=%d,isTrueLove=%b,isMyselfTopMicAndAnchor=%b", (Object[])new Object[]{this.mTag, this.channelLinkCore.getCurrentTopMicId(), isTrueLove, isMyselfAncorAndTopMic});
            }
            if (isMyselfAncorAndTopMic) {
                if ("tag_introduce".equals(this.mTag)) {
                    this.getChildFragmentManager().beginTransaction().replace(this.getView().findViewById(R.id.treasure_container).getId(), (Fragment)TreasureProfileFragment.instance(parent), "tag_profile").commitAllowingStateLoss();
                }
            } else if ("tag_introduce".equals(this.mTag)) {
                if (isTrueLove) {
                    this.getChildFragmentManager().beginTransaction().replace(this.getView().findViewById(R.id.treasure_container).getId(), (Fragment)TreasureProfileFragment.instance(parent), "tag_profile").commitAllowingStateLoss();
                }
            } else if ("tag_profile".equals(this.mTag) && !isTrueLove) {
                this.getChildFragmentManager().beginTransaction().replace(this.getView().findViewById(R.id.treasure_container).getId(), (Fragment)TreasureIntroduceFragment.instance(), "tag_introduce").commitAllowingStateLoss();
            }
        }
    }

    public void onHiddenChanged(boolean hidden) {
        super.onHiddenChanged(hidden);
        if (hidden) {
            return;
        }
        this.updateContent();
    }

    public void onDestroy() {
        super.onDestroy();
    }

    protected void onViewCreated(View view, Bundle bundle) {
        if (this.mTreasureGuideFragmentSniperEventBinder == null) {
            this.mTreasureGuideFragmentSniperEventBinder = new TreasureGuideFragment$$EventBinder();
        }
        this.mTreasureGuideFragmentSniperEventBinder.bindEvent((Object)this);
        super.onViewCreated(view, bundle);
    }

    protected void onDestroyView() {
        super.onDestroyView();
        if (this.mTreasureGuideFragmentSniperEventBinder != null) {
            this.mTreasureGuideFragmentSniperEventBinder.unBindEvent();
        }
    }
}

