/*
 * Decompiled with CFR 0.152.
 */
package com.yy.live.module.pk;

import android.annotation.SuppressLint;
import android.app.Dialog;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TextView;
import com.unionyy.mobile.spdt.Spdt;
import com.yy.mobile.image.ImageConfig;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.basicchanneltemplate.component.PopupComponent;
import com.yy.mobile.ui.widget.RoundedRelativeLayout;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.gift.GiftConfigItemBase;
import com.yymobile.core.gift.GiftConfigParser;
import com.yymobile.core.gift.IGiftCore;
import java.util.HashMap;

public class PKSendGiftPopupComponent
extends PopupComponent
implements View.OnClickListener {
    private RoundedRelativeLayout infoWebLayout;
    private RecycleImageView imgviewClose;
    protected RecycleImageView imgviewGift;
    protected TextView tvTips;
    protected TextView tvTitle;
    protected TextView tvPrice;
    private Button btnSendGift;
    protected int maxCount = 66;
    protected float price = 0.9f;
    private String url = "";
    private int loadingBitmapResourceId = -1;
    private boolean mIsHotGift;
    protected String mTitle;
    protected String mMsg;
    protected GiftConfigItemBase mItem;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.getArguments() != null) {
            this.mIsHotGift = this.getArguments().getBoolean("args_hot_gift");
            this.mTitle = this.getArguments().getString("args_title");
            this.mMsg = this.getArguments().getString("args_msg");
            this.mItem = (GiftConfigItemBase)this.getArguments().getSerializable("args_item");
        }
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view;
        try {
            view = inflater.inflate(R.layout.popup_component_pk_sendgift, null);
        }
        catch (Throwable throwable) {
            MLog.error((Object)"PKSendGiftPopupComponent", (String)throwable.getMessage(), (Object[])new Object[0]);
            return null;
        }
        this.infoWebLayout = (RoundedRelativeLayout)view.findViewById(R.id.rv_send_gift_info);
        this.imgviewGift = (RecycleImageView)view.findViewById(R.id.img_pk_gift);
        this.imgviewClose = (RecycleImageView)view.findViewById(R.id.iv_close_pk_send_hotgift);
        this.tvTips = (TextView)view.findViewById(R.id.tv_send_gift_tip);
        this.tvTitle = (TextView)view.findViewById(R.id.text);
        this.tvPrice = (TextView)view.findViewById(R.id.tv_price_gift);
        this.btnSendGift = (Button)view.findViewById(R.id.btn_send_pk_gift);
        this.imgviewGift.setOnClickListener((View.OnClickListener)this);
        this.imgviewClose.setOnClickListener((View.OnClickListener)this);
        this.tvTips.setOnClickListener((View.OnClickListener)this);
        this.tvPrice.setOnClickListener((View.OnClickListener)this);
        this.btnSendGift.setOnClickListener((View.OnClickListener)this);
        this.updateDialogData();
        return view;
    }

    @SuppressLint(value={"SetTextI18n"})
    protected void updateDialogData() {
        this.tvPrice.setText((CharSequence)(this.price + Spdt.string((int)R.string.red_packet_price_unit_user, (Object[])new Object[0])));
        this.tvTips.setText((CharSequence)("\u7d2f\u8ba1\u9053\u5177" + this.maxCount + "\uff0c\u7ed9\u4e3b\u64ad\u52a0\u5195"));
        if (!FP.empty((CharSequence)this.mTitle)) {
            this.tvTitle.setText((CharSequence)this.mTitle);
        }
        if (!FP.empty((CharSequence)this.mMsg)) {
            this.tvTips.setText((CharSequence)this.mMsg);
        }
        if (this.mItem instanceof GiftConfigParser.PaidGiftConfigItem) {
            GiftConfigParser.PaidGiftConfigItem paidItem = (GiftConfigParser.PaidGiftConfigItem)this.mItem;
            this.setDataInfo(paidItem.price, paidItem.iconPath);
        } else if (this.mItem instanceof GiftConfigParser.PrePaidGiftConfigItem) {
            GiftConfigParser.PrePaidGiftConfigItem paidItem = (GiftConfigParser.PrePaidGiftConfigItem)this.mItem;
            this.setDataInfo(paidItem.price, paidItem.iconPath);
        }
    }

    protected void setDataInfo(Integer price, String iconPath) {
        if (price != null) {
            String balanceStrTemp = String.valueOf(price);
            double balance = StringUtils.safeParseDouble((String)balanceStrTemp) / 100.0;
            String balanceStr = String.format("%.01f", balance);
            this.tvPrice.setText((CharSequence)String.format("%s%s", balanceStr, Spdt.string((int)R.string.red_packet_price_unit_user, (Object[])new Object[0])));
        }
        ImageLoader.loadImage((RecycleImageView)this.imgviewGift, (String)iconPath, (int)R.drawable.lr_ic_default_gift);
    }

    public PKSendGiftPopupComponent setMaxCount(int maxCount) {
        this.maxCount = maxCount;
        return this;
    }

    public PKSendGiftPopupComponent setGiftImageInfo(String url, int loadingBitmapResourceId) {
        this.url = url;
        this.loadingBitmapResourceId = loadingBitmapResourceId;
        ImageLoader.loadImage((String)this.url, (RecycleImageView)this.imgviewGift, (ImageConfig)ImageConfig.defaultImageConfig(), (int)this.loadingBitmapResourceId);
        return this;
    }

    public PKSendGiftPopupComponent setPrice(float price) {
        this.price = price;
        return this;
    }

    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Dialog dialog = super.onCreateDialog(savedInstanceState);
        dialog.setCanceledOnTouchOutside(true);
        dialog.requestWindowFeature(1);
        dialog.getWindow().setWindowAnimations(R.style.right_popup_menu_animation);
        dialog.getWindow().setBackgroundDrawableResource(R.color.transparent);
        if (this.getResources().getConfiguration().orientation == 2) {
            dialog.getWindow().setFlags(1024, 1024);
        }
        dialog.getWindow().setGravity(17);
        dialog.getWindow().setSoftInputMode(18);
        dialog.getWindow().setLayout(-1, -1);
        return dialog;
    }

    public void onPause() {
        super.onPause();
    }

    public void onResume() {
        super.onResume();
    }

    public void onClick(View view) {
        if (view.getId() == R.id.iv_close_pk_send_hotgift) {
            this.dismissAllowingStateLoss();
        } else if (view.getId() == R.id.btn_send_pk_gift) {
            if (this.mItem == null) {
                return;
            }
            if (this.mIsHotGift && this.mItem.type != null) {
                HashMap<String, String> extend = new HashMap<String, String>();
                extend.put("PBUY_KEY_PRODUCTINFO", "{\"isHitGift\": \"true\"}");
                ((IGiftCore)ICoreManagerBase.getCore(IGiftCore.class)).sendGift(this.mItem.type.intValue(), ICoreManagerBase.getChannelLinkCore().getCurrentTopMicId(), 1, 1, extend);
            } else {
                HashMap<String, String> extend = new HashMap<String, String>();
                extend.put("isGlobalGift", "1");
                ((IGiftCore)ICoreManagerBase.getCore(IGiftCore.class)).sendGift(this.mItem.type.intValue(), ICoreManagerBase.getChannelLinkCore().getCurrentTopMicId(), 1, 1, extend);
            }
            this.dismissAllowingStateLoss();
        }
    }
}

