/*
 * Decompiled with CFR 0.152.
 */
package com.yy.live.module.heart;

import com.yy.mobile.util.CommonUtils;
import com.yy.mobile.util.log.MLog;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class SignInTipsController {

    public static class SignDate
    implements Comparable<SignDate> {
        int year;
        int month;
        int day;

        public SignDate(String formatString) {
            if (formatString != null) {
                SimpleDateFormat sdf = CommonUtils.getSimpleDateFormat((String)"yyyyMMdd");
                try {
                    this.initDate(sdf.parse(formatString));
                }
                catch (ParseException e) {
                    MLog.error((Object)"SignInTipsController", (String)("yyyyMMdd transform error and formatString=" + formatString), (Object[])new Object[0]);
                }
            }
        }

        public SignDate() {
            this.initDate(null);
        }

        public String getFormatString() {
            return String.format("%d%02d%02d", this.year, this.month, this.day);
        }

        private void initDate(Date date) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeZone(TimeZone.getTimeZone("GMT+8"));
            if (date != null) {
                calendar.setTime(date);
            }
            this.year = calendar.get(1);
            this.month = calendar.get(2) + 1;
            this.day = calendar.get(5);
        }

        @Override
        public int compareTo(SignDate another) {
            if (another == null) {
                return -1;
            }
            if (this.year != another.year) {
                return this.year - another.year;
            }
            if (this.month != another.month) {
                return this.month - another.month;
            }
            return this.day - another.day;
        }

        public int compareToToday() {
            return this.compareTo(new SignDate());
        }
    }
}

