/*
 * Decompiled with CFR 0.152.
 */
package com.yy.live.module.giftdanmu;

import android.content.Context;
import android.text.Spannable;
import android.text.SpannableString;
import com.yy.live.module.giftdanmu.ChannelAirFilter;
import com.yy.live.module.giftdanmu.DanmuAirTicketFilter;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.richtext.BaseRichTextFilter;
import com.yy.mobile.richtext.EmoticonFilter;
import com.yy.mobile.richtext.RichTextManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DanmuTextManager {
    public static boolean flag;
    private static Map<RichTextManager.Feature, BaseRichTextFilter> filterMap;

    public static void init() {
        if (flag) {
            return;
        }
        filterMap = new HashMap<RichTextManager.Feature, BaseRichTextFilter>();
        filterMap.put(RichTextManager.Feature.CHANNELAIRTICKET, new ChannelAirFilter(R.drawable.icon_plane20));
        filterMap.put(RichTextManager.Feature.EMOTICON, (BaseRichTextFilter)EmoticonFilter.getInstance());
        flag = true;
    }

    public static Spannable getSpannableString(Context context, CharSequence charSequence, List<RichTextManager.Feature> featureList) {
        return DanmuTextManager.getSpannableString(context, charSequence, featureList, Integer.MAX_VALUE);
    }

    public static Spannable getSpannableString(Context context, CharSequence charSequence, List<RichTextManager.Feature> featureList, int maxWidth) {
        Object spannable = charSequence instanceof Spannable ? (Spannable)charSequence : new SpannableString(charSequence);
        for (RichTextManager.Feature feature : featureList) {
            BaseRichTextFilter filter = filterMap.get(feature);
            if (filter instanceof DanmuAirTicketFilter) {
                spannable = ((DanmuAirTicketFilter)filter).filterSpan(context, (Spannable)spannable);
                continue;
            }
            if (filter == null) continue;
            filter.parseSpannable(context, spannable, maxWidth > 0 ? maxWidth : Integer.MAX_VALUE);
        }
        return spannable;
    }

    public static void filterAll(Context context, CharSequence charSequence, int maxWidth) {
        DanmuTextManager.filterAll(context, charSequence, maxWidth, null);
    }

    public static void filterAll(Context context, CharSequence charSequence, int maxWidth, Object tag) {
        Object spannable = charSequence instanceof Spannable ? (Spannable)charSequence : new SpannableString(charSequence);
        for (Map.Entry<RichTextManager.Feature, BaseRichTextFilter> entry : filterMap.entrySet()) {
            BaseRichTextFilter filter = entry.getValue();
            if (maxWidth <= 0) {
                maxWidth = Integer.MAX_VALUE;
            }
            if (tag == null) {
                filter.parseSpannable(context, spannable, maxWidth);
                continue;
            }
            filter.parseSpannable(context, spannable, maxWidth, tag);
        }
    }
}

