/*
 * Decompiled with CFR 0.152.
 */
package com.yy.live.module.giftdanmu;

import android.content.Context;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.style.UnderlineSpan;
import com.yy.live.module.giftdanmu.DanmuAirTicketFilter;
import com.yy.mobile.richtext.ChannelAirTicketParser;
import com.yy.mobile.ui.widget.CustomImageSpan;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.log.MLog;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ChannelAirFilter
extends DanmuAirTicketFilter {
    private static final Pattern NUMBER_PATTERN = Pattern.compile("[0-9]+");

    public ChannelAirFilter(int id2) {
        super(id2);
    }

    public static List<ChannelTicketInfo> parseChannelTicket(String msg) {
        ArrayList<ChannelTicketInfo> infoList = new ArrayList<ChannelTicketInfo>();
        CharSequence complateFormatMsg = ChannelAirTicketParser.parseCompleteFormatMsg((CharSequence)msg);
        Matcher matcher = ChannelAirTicketParser.AIR_TICKET_PATTERN.matcher(complateFormatMsg);
        while (matcher.find()) {
            String channelMsg = complateFormatMsg.toString().substring(matcher.start(), matcher.end());
            Matcher m = NUMBER_PATTERN.matcher(channelMsg);
            long sid = 0L;
            long subSid = 0L;
            try {
                if (m.find()) {
                    sid = Long.parseLong(channelMsg.substring(m.start(), m.end()));
                }
                if (channelMsg.contains("subid=") && m.find()) {
                    subSid = Long.parseLong(channelMsg.substring(m.start(), m.end()));
                }
            }
            catch (NumberFormatException e) {
                MLog.error((Object)"hjinw", (String)"parse Channel sid or subSid error :%s", (Throwable)e, (Object[])new Object[0]);
            }
            if (MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)"hjinw", (String)"sid = %d, subSid = %d", (Object[])new Object[]{sid, subSid});
            }
            infoList.add(new ChannelTicketInfo(matcher.start(), matcher.end(), sid, subSid));
        }
        return infoList;
    }

    public static boolean isChannelTicketMessage(CharSequence msg) {
        return ChannelAirTicketParser.isChannelTicketMessage((CharSequence)msg);
    }

    public static String replaceChannelTicketWithGivenStr(String message, String givenStr) {
        CharSequence complateFormatMsg = ChannelAirTicketParser.parseCompleteFormatMsg((CharSequence)message);
        Matcher m = ChannelAirTicketParser.AIR_TICKET_PATTERN.matcher(complateFormatMsg);
        return m.replaceAll(givenStr).trim();
    }

    public void parseSpannable(Context context, Spannable spannable, int maxWidth) {
        this.parseSpannable(context, spannable, maxWidth, null);
    }

    public void parseSpannable(Context context, Spannable spannable, int maxWidth, Object tag) {
        if (!ChannelAirFilter.isChannelTicketMessage((CharSequence)spannable)) {
            return;
        }
        if (this.ticketDrawable == null) {
            this.ticketDrawable = this.getTicketDrawable(context);
        }
        this.setSpannable(spannable, context);
    }

    private void setSpannable(Spannable spannable, Context context) {
        List<ChannelTicketInfo> infos = ChannelAirFilter.parseChannelTicket(spannable.toString());
        for (ChannelTicketInfo info : infos) {
            String s = spannable.toString();
            StringBuilder sb = new StringBuilder(s);
            sb.replace(info.start, info.end, "{air}\u70b9\u51fb\u8fdb\u5165" + info.sid + "\u623f\u95f4");
            SpannableString spannable1 = new SpannableString((CharSequence)sb);
            spannable1.setSpan((Object)new CustomImageSpan(this.ticketDrawable, 2, ResolutionUtils.convertDpToPixel((float)6.0f, (Context)context), ResolutionUtils.convertDpToPixel((float)6.0f, (Context)context)), 0, "{air}".length(), 33);
            spannable = spannable1;
        }
    }

    @Override
    public Spannable filterSpan(Context context, Spannable spannable) {
        if (!ChannelAirFilter.isChannelTicketMessage((CharSequence)spannable)) {
            return spannable;
        }
        if (this.ticketDrawable == null) {
            this.ticketDrawable = this.getTicketDrawable(context);
        }
        List<ChannelTicketInfo> infos = ChannelAirFilter.parseChannelTicket(spannable.toString());
        for (ChannelTicketInfo info : infos) {
            String s = spannable.toString();
            StringBuilder sb = new StringBuilder(s);
            String planeStr = "{air}\u70b9\u51fb\u8fdb\u5165" + info.sid + "\u9891\u9053";
            sb.replace(info.start, info.end, planeStr);
            SpannableString spannable1 = new SpannableString((CharSequence)sb);
            spannable1.setSpan((Object)new CustomImageSpan(this.ticketDrawable, 2, ResolutionUtils.convertDpToPixel((float)6.0f, (Context)context), ResolutionUtils.convertDpToPixel((float)6.0f, (Context)context)), info.start, info.start + "{air}".length(), 33);
            UnderlineSpan span = new UnderlineSpan();
            spannable1.setSpan((Object)span, info.start, info.start + planeStr.length(), 33);
            spannable = spannable1;
        }
        return spannable;
    }

    public static class ChannelTicketInfo {
        public int start;
        public int end;
        public long sid;
        public long subSid;

        public ChannelTicketInfo(int start2, int end, long sid, long subSid) {
            this.start = start2;
            this.end = end;
            this.sid = sid;
            this.subSid = subSid;
        }

        public String toString() {
            return "[start = " + this.start + "; end = " + this.end + "; sid = " + this.sid + "; subSid = " + this.subSid + "]";
        }
    }
}

