/*
 * Decompiled with CFR 0.152.
 */
package com.yy.social.ui;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.text.SpannableString;
import android.text.style.StyleSpan;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.duowan.mobile.entlive.events.INNobleClient_onNobleEnterBroadCast_EventArgs;
import com.duowan.mobile.entlive.events.IPublicChatBroadcastClient_appendRevenueMessage_EventArgs;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.plugin.main.events.ICavalierClient_onComsueTaskMarquee_EventArgs;
import com.yy.mobile.plugin.main.events.IPublicChatBroadcastClient_onShowRevenueMarque_EventArgs;
import com.yy.mobile.plugin.pluginunionlive.PluginBus;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.basicchanneltemplate.component.Component;
import com.yy.mobile.ui.marquee.MarqueeController;
import com.yy.mobile.ui.publicchat.PublicChatRevenueController;
import com.yy.mobile.ui.startask.TaskChannelMessage;
import com.yy.mobile.ui.streamlight.EntIdentityIconSet;
import com.yy.mobile.ui.widget.CustomImageSpan;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.log.MLog;
import com.yy.social.ui.MarqueeComponent$$EventBinder;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.noble.INNobleCore;
import com.yymobile.core.noble.NNobleEnterBroadCastEntity;
import java.util.HashMap;
import java.util.Map;

public class MarqueeComponent
extends Component {
    private static final String TAG = "MarqueeComponent";
    private View mRootView;
    private MarqueeController mMarqueeController;
    private EventBinder mMarqueeComponentSniperEventBinder;

    public static MarqueeComponent newInstance() {
        MarqueeComponent component = new MarqueeComponent();
        return component;
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.mRootView = inflater.inflate(R.layout.fragment_marquee_view, container, false);
        RelativeLayout parentView = (RelativeLayout)this.mRootView.findViewById(R.id.marquee_component);
        this.mMarqueeController = new MarqueeController(this.getContext(), (ViewGroup)parentView, MarqueeController.LiveRoomType.ILIVE);
        MLog.info((Object)TAG, (String)"MarqueeComponent onCreateView", (Object[])new Object[0]);
        NNobleEnterBroadCastEntity enterBroadCastEntity = ((INNobleCore)ICoreManagerBase.getCore(INNobleCore.class)).getNobleEnterBroadCastEntity();
        if (enterBroadCastEntity != null && !enterBroadCastEntity.isRead) {
            ((INNobleCore)ICoreManagerBase.getCore(INNobleCore.class)).setNobleEnterBroadCastReadState(true);
            this.setBroadCastMessage(LoginUtil.getUid(), enterBroadCastEntity.nick, 0, enterBroadCastEntity.extendInfo, enterBroadCastEntity.nobleType, TaskChannelMessage.MessageType.Noble);
        }
        return this.mRootView;
    }

    @BusEvent(sync=true)
    public void onComsueTaskMarquee(ICavalierClient_onComsueTaskMarquee_EventArgs busEventArgs) {
        long uid = busEventArgs.getUid();
        int level = busEventArgs.getLevel();
        String name = busEventArgs.getName();
        int nobleLevel = busEventArgs.getNobleLevel();
        MLog.info((Object)TAG, (String)("onComsueTaskMarquee uid:" + uid + ", level:" + level + ", name:" + name + ", nobleLevel:" + nobleLevel), (Object[])new Object[0]);
        if (this.mMarqueeController != null) {
            String text = this.setMessageFormat(name, nobleLevel, level);
            Drawable nobleDrawable = null;
            if (nobleLevel > 0 && level > 0) {
                int width = (int)ResolutionUtils.convertDpToPixel((float)20.0f, (Context)this.getContext());
                int height = (int)ResolutionUtils.convertDpToPixel((float)20.0f, (Context)this.getContext());
                nobleDrawable = this.getResources().getDrawable(EntIdentityIconSet.getIconResId((int)nobleLevel));
                nobleDrawable.setBounds(0, 0, width, height);
            }
            SpannableString spannableString = new SpannableString((CharSequence)text);
            int len = name.length();
            spannableString.setSpan((Object)new StyleSpan(0), 0, 2, 33);
            int tag = 2;
            if (nobleDrawable != null) {
                int start2 = text.indexOf("[noblelv]");
                int end = start2 + "[noblelv]".length();
                int padding = (int)ResolutionUtils.convertDpToPixel((float)3.0f, (Context)this.getContext());
                spannableString.setSpan((Object)new CustomImageSpan(nobleDrawable, 2, (float)padding, (float)padding), start2, end, 33);
                tag = end;
            }
            spannableString.setSpan((Object)new StyleSpan(1), tag, tag + len, 33);
            spannableString.setSpan((Object)new StyleSpan(0), tag + len, text.length(), 33);
            if (level == 0 && nobleLevel > 0) {
                this.mMarqueeController.setNolbleStyle(nobleLevel, spannableString, busEventArgs.getmExtendInfo());
            } else {
                this.mMarqueeController.setStyle(level, spannableString);
            }
        }
    }

    private String setMessageFormat(String name, int nobleLevel, int level) {
        StringBuilder sb = new StringBuilder();
        sb.append("\u6b22\u8fce ");
        if (nobleLevel > 0 && level > 0) {
            sb.append("[noblelv]");
        }
        sb.append(name);
        sb.append(" \u8fdb\u5165\u76f4\u64ad\u95f4");
        return sb.toString();
    }

    @BusEvent(sync=true)
    public void onShowRevenueMarque(IPublicChatBroadcastClient_onShowRevenueMarque_EventArgs busEventArgs) {
        boolean isShow = busEventArgs.getIsShow();
        if (this.mMarqueeController != null && !isShow) {
            this.mMarqueeController.hideView();
        }
    }

    @BusEvent(busType=1, busName="plugin_pluginunionlive", sync=true)
    public void onNobleEnterBroadCast(INNobleClient_onNobleEnterBroadCast_EventArgs busEventArgs) {
        long uid = busEventArgs.mUid;
        String nick = busEventArgs.mNick;
        int type = busEventArgs.mType;
        HashMap extendInfo = busEventArgs.mExtendInfo;
        if (this.isLandScape()) {
            return;
        }
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"wwd onNobleEnterBroadCast", (Object[])new Object[0]);
        }
        this.setBroadCastMessage(uid, nick, 0, extendInfo, type, TaskChannelMessage.MessageType.Noble);
    }

    private void setBroadCastMessage(long uid, String name, int level, Map<String, String> extendInfo, int nobleLevel, TaskChannelMessage.MessageType type) {
        TaskChannelMessage message = new TaskChannelMessage();
        message.uid = uid;
        message.nickname = name;
        if (type == TaskChannelMessage.MessageType.Normal) {
            message.time = 4000;
        } else if (type == TaskChannelMessage.MessageType.Noble) {
            message.time = 3000;
        }
        message.level = level;
        message.nobleLevel = nobleLevel;
        message.extendInfo = extendInfo;
        PluginBus.INSTANCE.get().post((Object)new IPublicChatBroadcastClient_appendRevenueMessage_EventArgs(message, PublicChatRevenueController.Priority.COMSUME_TASK));
    }

    public void onOrientationChanged(boolean isLandscape) {
        super.onOrientationChanged(isLandscape);
        if (this.mMarqueeController != null) {
            this.mMarqueeController.onOrientationChanges(isLandscape);
        }
    }

    public void onResume() {
        super.onResume();
        if (this.mMarqueeController != null) {
            this.mMarqueeController.onResume();
        }
    }

    public void onPause() {
        super.onPause();
        if (this.mMarqueeController != null) {
            this.mMarqueeController.onPause();
        }
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.mMarqueeController != null) {
            this.mMarqueeController.onDestroy();
        }
    }

    protected boolean isLandScape() {
        if (this.getActivity() != null) {
            return this.getActivity().getResources().getConfiguration().orientation == 2;
        }
        return false;
    }

    protected void onViewCreated(View view, Bundle bundle) {
        if (this.mMarqueeComponentSniperEventBinder == null) {
            this.mMarqueeComponentSniperEventBinder = new MarqueeComponent$$EventBinder();
        }
        this.mMarqueeComponentSniperEventBinder.bindEvent((Object)this);
        super.onViewCreated(view, bundle);
    }

    protected void onDestroyView() {
        super.onDestroyView();
        if (this.mMarqueeComponentSniperEventBinder != null) {
            this.mMarqueeComponentSniperEventBinder.unBindEvent();
        }
    }
}

