/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.widget.swipeloadingview;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Canvas;
import android.os.Handler;
import android.os.Looper;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.widget.TextView;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.touch.BrightnessAndVolumnSetter;
import com.yy.mobile.ui.widget.swipeloadingview.OnSwipeListener;
import com.yy.mobile.ui.widget.swipeloadingview.util.LogUtil;
import com.yy.mobile.ui.widget.toast.Toast;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.uicore.ITouchCore;
import java.util.concurrent.atomic.AtomicBoolean;

public class SwipeDetectorView
extends View {
    public static final String TAG = "SwipeDetectorLayout";
    ITouchEventProxy iTouchEventProxy;
    OnSwipeListener mOnSwipeListener;
    AtomicBoolean isCreated = new AtomicBoolean();
    View mMaskView;
    View mTranslateView;
    float mSwipeXRatio;
    float mSwipeYRatio;
    int mMinimumThreshold = 100;
    int mMaximumThreshold = 200;
    int mTopLimitSwipeHeight = 0;
    int mBottomLimitSwipeHeight = 0;
    int mMinimumLandScapeThreshold = 20;
    int mMaximumLandScapeThreshold = 1080;
    int screenWidth = 1080;
    int screenHeight = 1920;
    int vTrackerThreshold = 3000;
    float mYpre = 0.0f;
    private float mXpre = 0.0f;
    float mYdown = 0.0f;
    private float mXdown = 0.0f;
    int mDirection = -1;
    boolean isBeginSwipe = false;
    boolean isMultiTouch = false;
    boolean isHasActionDown = false;
    boolean isBeginSwipeLandScape = false;
    View mTipContainer;
    TextView mTipTextView;
    private float mSwipeXRatioThreshold = 0.2f;
    private float mSwipeRatioThreshold;
    private int mDuration = 200;
    private int mWorkingMode = 2;
    private boolean mIsEnable = true;
    private boolean mHorizontalTouchEnable = true;
    private boolean mVerticalTouchEnable = true;
    private Handler mHandler;
    private int currentPosition = -1;
    private VelocityTracker vTracker = null;
    private boolean ismIsIntercept = false;
    private GestureDetector mGestureDetector;
    private Animator.AnimatorListener mTranslationXLeftAnimatorListener;
    private Animator.AnimatorListener mTranslationXRightAnimatorListener;
    private boolean disableSwipeToRight = false;
    private boolean disableSwipeToUpOrDown = false;
    private boolean isLandscape = false;
    private boolean mEnableSwipe = true;
    private BrightnessAndVolumnSetter.VolumeSetter mVolumeSetter;
    private BrightnessAndVolumnSetter.BrightnessSetter mBrightnessSetter;
    private float mMaxDistance = 0.0f;

    public SwipeDetectorView(Context context) {
        super(context);
        this.init();
    }

    public SwipeDetectorView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public SwipeDetectorView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    @TargetApi(value=21)
    public SwipeDetectorView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init();
    }

    public void setDisableSwipeToRight(boolean mDisable) {
        this.disableSwipeToRight = mDisable;
    }

    public void setDisableSwipeToUpOrDown(boolean disableSwipeToUpOrDown) {
        this.disableSwipeToUpOrDown = disableSwipeToUpOrDown;
    }

    private void init() {
        this.mHandler = new Handler(Looper.getMainLooper());
        this.isCreated.set(false);
        this.mSwipeRatioThreshold = 0.25f;
        this.mTopLimitSwipeHeight = this.getResources().getDimensionPixelSize(R.dimen.basic_func_program_info_height);
        boolean bl = this.isLandscape = this.getResources().getConfiguration().orientation == 2;
        if (this.getContext() != null) {
            this.mMinimumThreshold = (int)ResolutionUtils.convertDpToPixel((float)20.0f, (Context)this.getContext());
            this.mMaximumThreshold = (int)ResolutionUtils.convertDpToPixel((float)70.0f, (Context)this.getContext());
            this.mBottomLimitSwipeHeight = ResolutionUtils.getScreenHeight((Context)this.getContext()) - this.getResources().getDimensionPixelSize(R.dimen.basic_interactive_expand_height);
            this.screenWidth = this.getScreenWidth(this.getContext());
            this.screenHeight = ResolutionUtils.getScreenHeight((Context)this.getContext());
        }
        this.iTouchEventProxy = new ITouchEventProxy(){

            @Override
            public int getMinimumThreshold() {
                LogUtil.i(SwipeDetectorView.TAG, "[getThreshold] mMinimumThreshold =" + SwipeDetectorView.this.mMinimumThreshold);
                return SwipeDetectorView.this.mMinimumThreshold;
            }

            @Override
            public int getMaximumThreshold() {
                LogUtil.i(SwipeDetectorView.TAG, "[getThreshold] threshold =" + SwipeDetectorView.this.mMaximumThreshold);
                return SwipeDetectorView.this.mMaximumThreshold;
            }

            @Override
            public void onPreTouch(int direction) {
                if (SwipeDetectorView.this.isLandscape && (direction == 1 || direction == 3) && SwipeDetectorView.this.mTipTextView != null) {
                    return;
                }
                LogUtil.i(SwipeDetectorView.TAG, "[onPreTouch] start swipe, direction = " + direction);
                if (direction == 1) {
                    SwipeDetectorView.this.resetLoadingViewPosition(2);
                }
                if (direction == 3) {
                    SwipeDetectorView.this.resetLoadingViewPosition(0);
                }
                if (SwipeDetectorView.this.mOnSwipeListener != null) {
                    SwipeDetectorView.this.mOnSwipeListener.setSwipeIntercetpTouch(true);
                    SwipeDetectorView.this.mOnSwipeListener.onSwipeStart(SwipeDetectorView.this.mDirection);
                }
            }

            @Override
            public void onTouchOffsetY(float offsetY, int direction) {
                if (SwipeDetectorView.this.mMaskView == null) {
                    LogUtil.w(SwipeDetectorView.TAG, "[onTouchOffsetY] mMaskView is null");
                    return;
                }
                if (SwipeDetectorView.this.isLandscape && SwipeDetectorView.this.mTipTextView != null) {
                    SwipeDetectorView.this.volumeAndBrightnessChange(offsetY);
                    return;
                }
                float targetTranslationY = SwipeDetectorView.this.mMaskView.getTranslationY() + offsetY;
                if (direction == 1) {
                    SwipeDetectorView.this.mSwipeYRatio = 1.0f - targetTranslationY / (float)SwipeDetectorView.this.getTotalHeight();
                    LogUtil.d(SwipeDetectorView.TAG, "[onTouchOffsetY] direction =" + direction);
                    LogUtil.d(SwipeDetectorView.TAG, "[onTouchOffsetY] mSwipeRatio =" + SwipeDetectorView.this.mSwipeYRatio);
                    LogUtil.d(SwipeDetectorView.TAG, "[onTouchOffsetY] offsetY =" + offsetY + " mMaskView.getTranslationY() = " + SwipeDetectorView.this.mMaskView.getTranslationY() + " targetTranslationY=" + targetTranslationY);
                    if (!SwipeDetectorView.this.isCanTouchOffsetY(targetTranslationY)) {
                        return;
                    }
                    if (offsetY < 0.0f && targetTranslationY < 0.0f) {
                        LogUtil.i(SwipeDetectorView.TAG, "[onTouchOffsetY] can not continue swipe up!");
                        SwipeDetectorView.this.resetLoadingViewPosition(1);
                        return;
                    }
                } else {
                    SwipeDetectorView.this.mSwipeYRatio = targetTranslationY / (float)SwipeDetectorView.this.getTotalHeight() + 1.0f;
                    LogUtil.d(SwipeDetectorView.TAG, "[onTouchOffsetY] direction =" + direction);
                    LogUtil.d(SwipeDetectorView.TAG, "[onTouchOffsetY] mSwipeRatio =" + SwipeDetectorView.this.mSwipeYRatio);
                    LogUtil.d(SwipeDetectorView.TAG, "[onTouchOffsetY] offsetY =" + offsetY + " mMaskView.getTranslationY() = " + SwipeDetectorView.this.mMaskView.getTranslationY() + " targetTranslationY=" + targetTranslationY);
                    if (!SwipeDetectorView.this.isCanTouchOffsetY(targetTranslationY)) {
                        return;
                    }
                    if (offsetY > 0.0f && targetTranslationY > (float)SwipeDetectorView.this.getTotalHeight()) {
                        LogUtil.i(SwipeDetectorView.TAG, "[onTouchOffsetY] can not continue swipe down!");
                        SwipeDetectorView.this.resetLoadingViewPosition(1);
                        return;
                    }
                }
                SwipeDetectorView.this.translateLoadingView(targetTranslationY);
                LogUtil.d(SwipeDetectorView.TAG, "[onTouchOffsetY] Notify swipe event's progress.");
                if (SwipeDetectorView.this.mOnSwipeListener != null) {
                    SwipeDetectorView.this.mOnSwipeListener.onSwiping(SwipeDetectorView.this.mSwipeYRatio, SwipeDetectorView.this.mDirection);
                }
            }

            @Override
            public void onPostTouch(int direction) {
                if (SwipeDetectorView.this.mMaskView == null) {
                    LogUtil.w(SwipeDetectorView.TAG, "[onPostTouch] mMaskView is null");
                    return;
                }
                if (SwipeDetectorView.this.isLandscape && (direction == 1 || direction == 3) && SwipeDetectorView.this.mTipTextView != null) {
                    SwipeDetectorView.this.mTipContainer.setVisibility(8);
                    return;
                }
                if (SwipeDetectorView.this.mOnSwipeListener != null) {
                    SwipeDetectorView.this.mOnSwipeListener.setSwipeIntercetpTouch(false);
                }
                if (SwipeDetectorView.this.mMaskView.getTranslationY() > (float)SwipeDetectorView.this.getTotalHeight()) {
                    LogUtil.i(SwipeDetectorView.TAG, "[onPostTouch] below the bottom end");
                    SwipeDetectorView.this.resetLoadingViewPosition(2);
                    if (SwipeDetectorView.this.mOnSwipeListener != null) {
                        SwipeDetectorView.this.mOnSwipeListener.onSwipeCanceled(SwipeDetectorView.this.mDirection);
                    }
                } else if (SwipeDetectorView.this.mMaskView.getTranslationY() < (float)(-SwipeDetectorView.this.getTotalHeight())) {
                    LogUtil.i(SwipeDetectorView.TAG, "[onPostTouch] above the top end");
                    SwipeDetectorView.this.resetLoadingViewPosition(0);
                    if (SwipeDetectorView.this.mOnSwipeListener != null) {
                        SwipeDetectorView.this.mOnSwipeListener.onSwipeCanceled(SwipeDetectorView.this.mDirection);
                    }
                } else if (SwipeDetectorView.this.mSwipeYRatio >= SwipeDetectorView.this.mSwipeRatioThreshold || SwipeDetectorView.this.vTracker != null && Math.abs(SwipeDetectorView.this.vTracker.getYVelocity()) >= (float)SwipeDetectorView.this.vTrackerThreshold && !SwipeDetectorView.this.disableSwipeToRight) {
                    if (SwipeDetectorView.this.mOnSwipeListener != null) {
                        SwipeDetectorView.this.mOnSwipeListener.onPostSwipe(SwipeDetectorView.this.mDirection);
                    }
                    SwipeDetectorView.this.showLoadingView(true, direction, (Animator.AnimatorListener)new AnimatorListenerAdapter(){

                        public void onAnimationEnd(Animator animation) {
                            SwipeDetectorView.this.ismIsIntercept = false;
                            LogUtil.i(SwipeDetectorView.TAG, "[onPostTouch] Swipe Finish");
                        }

                        public void onAnimationStart(Animator animation) {
                            SwipeDetectorView.this.ismIsIntercept = true;
                            super.onAnimationStart(animation);
                        }
                    });
                } else {
                    SwipeDetectorView.this.hideLoadingView(true, direction, (Animator.AnimatorListener)new AnimatorListenerAdapter(){

                        public void onAnimationEnd(Animator animation) {
                            SwipeDetectorView.this.ismIsIntercept = false;
                            LogUtil.i(SwipeDetectorView.TAG, "[onPostTouch] Swipe Cancel");
                            if (SwipeDetectorView.this.mOnSwipeListener != null) {
                                SwipeDetectorView.this.mOnSwipeListener.onSwipeCanceled(SwipeDetectorView.this.mDirection);
                            }
                        }

                        public void onAnimationStart(Animator animation) {
                            SwipeDetectorView.this.ismIsIntercept = true;
                            super.onAnimationStart(animation);
                        }
                    });
                }
            }

            @Override
            public void onSwipeToLeft() {
                if (SwipeDetectorView.this.mOnSwipeListener != null) {
                    SwipeDetectorView.this.mOnSwipeListener.onSwipeLandScape(0);
                }
            }

            @Override
            public void onSwipeToRight() {
                if (SwipeDetectorView.this.mOnSwipeListener != null) {
                    SwipeDetectorView.this.mOnSwipeListener.onSwipeLandScape(2);
                }
            }

            @Override
            public void onPreTouchX(int direction) {
                if (SwipeDetectorView.this.mTranslateView == null) {
                    return;
                }
                if (SwipeDetectorView.this.mOnSwipeListener != null) {
                    SwipeDetectorView.this.mOnSwipeListener.setSwipeIntercetpTouch(true);
                }
                if (SwipeDetectorView.this.getContext() != null) {
                    SwipeDetectorView.this.screenWidth = SwipeDetectorView.this.getScreenWidth(SwipeDetectorView.this.getContext());
                    SwipeDetectorView.this.screenHeight = ResolutionUtils.getScreenHeight((Context)SwipeDetectorView.this.getContext());
                } else {
                    SwipeDetectorView.this.screenWidth = SwipeDetectorView.this.getMeasuredWidth();
                    SwipeDetectorView.this.screenHeight = SwipeDetectorView.this.getMeasuredHeight();
                }
                if (direction == 0) {
                    if (SwipeDetectorView.this.mTranslateView != null && (SwipeDetectorView.this.mTranslateView.getVisibility() == 4 || SwipeDetectorView.this.mTranslateView.getVisibility() == 8) && ((ITouchCore)ICoreManagerBase.getCore(ITouchCore.class)).getClearScreenSate()) {
                        SwipeDetectorView.this.currentPosition = 2;
                        SwipeDetectorView.this.resetTraslateViewPosition(3, false);
                        SwipeDetectorView.this.mTranslateView.setVisibility(0);
                        if (MLog.isLogLevelAboveDebug()) {
                            MLog.debug((Object)SwipeDetectorView.TAG, (String)"[ouyangyj] resetTraslateViewPosition", (Object[])new Object[0]);
                        }
                    }
                    if (SwipeDetectorView.this.currentPosition != direction && SwipeDetectorView.this.mTranslateView.getTranslationX() > 0.0f) {
                        SwipeDetectorView.this.resetTraslateViewPosition(3, false);
                        if (MLog.isLogLevelAboveDebug()) {
                            MLog.debug((Object)SwipeDetectorView.TAG, (String)"[ouyangyj] resetTraslateViewPosition", (Object[])new Object[0]);
                        }
                    }
                }
                if (direction == 2) {
                    if (SwipeDetectorView.this.mTranslateView != null && (SwipeDetectorView.this.mTranslateView.getVisibility() == 4 || SwipeDetectorView.this.mTranslateView.getVisibility() == 8)) {
                        SwipeDetectorView.this.mTranslateView.setVisibility(0);
                    }
                    if (SwipeDetectorView.this.currentPosition != direction && SwipeDetectorView.this.mTranslateView.getTranslationX() <= (float)SwipeDetectorView.this.screenWidth) {
                        SwipeDetectorView.this.resetTraslateViewPosition(4, false);
                    }
                }
                LogUtil.d(SwipeDetectorView.TAG, "[onPreTouchX] [1] translate mTranslateView, mTranslateView.getTranslationX()== " + SwipeDetectorView.this.mTranslateView.getTranslationX() + "direction == " + direction);
                if (SwipeDetectorView.this.mOnSwipeListener != null) {
                    SwipeDetectorView.this.mOnSwipeListener.onSwipeStart(SwipeDetectorView.this.mDirection);
                }
            }

            @Override
            public void onTouchOffsetX(float offsetX, int direction) {
                if (SwipeDetectorView.this.mTranslateView == null) {
                    return;
                }
                if (direction == 0) {
                    SwipeDetectorView.this.mSwipeXRatio = 1.0f - Math.abs(SwipeDetectorView.this.mTranslateView.getTranslationX() + offsetX) / (float)SwipeDetectorView.this.screenWidth;
                    if (SwipeDetectorView.this.mTranslateView.getTranslationX() <= 0.0f) {
                        return;
                    }
                    SwipeDetectorView.this.translateView(SwipeDetectorView.this.mTranslateView, SwipeDetectorView.this.mTranslateView.getTranslationX() + offsetX, direction);
                    if (SwipeDetectorView.this.mOnSwipeListener != null && Math.abs(offsetX) > 2.0f) {
                        SwipeDetectorView.this.mOnSwipeListener.onSwipeDistance(SwipeDetectorView.this.mTranslateView.getTranslationX() + offsetX);
                    }
                }
                if (direction == 2) {
                    SwipeDetectorView.this.mSwipeXRatio = Math.abs(SwipeDetectorView.this.mTranslateView.getTranslationX() + offsetX) / (float)SwipeDetectorView.this.screenWidth;
                    if (SwipeDetectorView.this.disableSwipeToRight) {
                        return;
                    }
                    if (SwipeDetectorView.this.mTranslateView.getTranslationX() >= (float)SwipeDetectorView.this.screenWidth) {
                        return;
                    }
                    SwipeDetectorView.this.translateView(SwipeDetectorView.this.mTranslateView, SwipeDetectorView.this.mTranslateView.getTranslationX() + offsetX, direction);
                    if (SwipeDetectorView.this.mOnSwipeListener != null && Math.abs(offsetX) > 2.0f) {
                        SwipeDetectorView.this.mOnSwipeListener.onSwipeDistance(SwipeDetectorView.this.mTranslateView.getTranslationX() + offsetX);
                    }
                }
            }

            @Override
            public void onPostXTouch(int direction) {
                if (direction == 0) {
                    if (SwipeDetectorView.this.mSwipeXRatio < SwipeDetectorView.this.mSwipeXRatioThreshold) {
                        LogUtil.d(SwipeDetectorView.TAG, "[onPostXTouch] [4] translate mTranslateView, direction== " + direction + "mSwipeXRatio< mSwipeXRatioThreshold");
                        if (SwipeDetectorView.this.mOnSwipeListener != null) {
                            SwipeDetectorView.this.mOnSwipeListener.setSwipeIntercetpTouch(false);
                        }
                        if (SwipeDetectorView.this.mOnSwipeListener != null) {
                            SwipeDetectorView.this.mOnSwipeListener.onSwipeDistance(SwipeDetectorView.this.screenWidth);
                        }
                        SwipeDetectorView.this.resetTraslateViewPosition(3, true);
                    } else {
                        LogUtil.d(SwipeDetectorView.TAG, "[onPostXTouch] [4] translate mTranslateView, direction== " + direction + "mSwipeXRatio > mSwipeXRatioThreshold");
                        SwipeDetectorView.this.resetTraslateViewPosition(4, true);
                        SwipeDetectorView.this.iTouchEventProxy.onSwipeToLeft();
                        SwipeDetectorView.this.currentPosition = SwipeDetectorView.this.mDirection;
                    }
                }
                if (direction == 2) {
                    if (SwipeDetectorView.this.mSwipeXRatio < SwipeDetectorView.this.mSwipeXRatioThreshold) {
                        if (SwipeDetectorView.this.mOnSwipeListener != null) {
                            SwipeDetectorView.this.mOnSwipeListener.setSwipeIntercetpTouch(false);
                        }
                        if (SwipeDetectorView.this.mOnSwipeListener != null) {
                            SwipeDetectorView.this.mOnSwipeListener.onSwipeDistance(0.0f);
                        }
                        LogUtil.d(SwipeDetectorView.TAG, "[onPostXTouch] [4] translate mTranslateView, direction== " + direction + "mSwipeXRatio< mSwipeXRatioThreshold");
                        SwipeDetectorView.this.resetTraslateViewPosition(4, true);
                        if (SwipeDetectorView.this.disableSwipeToRight) {
                            Toast.makeText((Context)SwipeDetectorView.this.getContext(), (CharSequence)"\u8be5\u76f4\u64ad\u95f4\u6682\u65f6\u4e0d\u652f\u6301\u6e05\u5c4f\u54e6", (int)0).show();
                        }
                    } else {
                        if (SwipeDetectorView.this.disableSwipeToRight) {
                            SwipeDetectorView.this.resetTraslateViewPosition(4, true);
                            Toast.makeText((Context)SwipeDetectorView.this.getContext(), (CharSequence)"\u8be5\u76f4\u64ad\u95f4\u6682\u65f6\u4e0d\u652f\u6301\u6e05\u5c4f\u54e6", (int)0).show();
                            return;
                        }
                        LogUtil.d(SwipeDetectorView.TAG, "[onPostXTouch] [4] translate mTranslateView, direction== " + direction + "mSwipeXRatio > mSwipeXRatioThreshold");
                        SwipeDetectorView.this.resetTraslateViewPosition(3, true);
                        SwipeDetectorView.this.iTouchEventProxy.onSwipeToRight();
                        SwipeDetectorView.this.currentPosition = SwipeDetectorView.this.mDirection;
                    }
                }
            }

            @Override
            public void onPostYTouch(int direction) {
                if (SwipeDetectorView.this.isLandscape && (direction == 1 || direction == 3) && SwipeDetectorView.this.mTipTextView != null) {
                    return;
                }
                if (MLog.isLogLevelAboveDebug()) {
                    MLog.debug((Object)SwipeDetectorView.TAG, (String)("onPostYTouch:" + direction), (Object[])new Object[0]);
                }
                if (SwipeDetectorView.this.mOnSwipeListener != null) {
                    SwipeDetectorView.this.mOnSwipeListener.setSwipeIntercetpTouch(false);
                    SwipeDetectorView.this.mOnSwipeListener.onSwipeCanceled(direction);
                }
                if (direction == 1) {
                    SwipeDetectorView.this.resetLoadingViewPosition(2);
                } else if (direction == 3) {
                    SwipeDetectorView.this.resetLoadingViewPosition(0);
                }
                Toast.makeText((Context)SwipeDetectorView.this.getContext(), (CharSequence)"\u8be5\u76f4\u64ad\u95f4\u6682\u65f6\u4e0d\u652f\u6301\u4e0a\u4e0b\u6ed1\u52a8\u54e6", (int)0).show();
            }
        };
    }

    private int getScreenWidth(Context context) {
        int width = this.getWidth();
        if (width == 0) {
            width = ResolutionUtils.getScreenWidth((Context)context);
            MLog.info((Object)TAG, (String)(" width : " + width), (Object[])new Object[0]);
        }
        return width;
    }

    public void setCurrentPosition(int currentPosition) {
        this.currentPosition = currentPosition;
    }

    private void translateLoadingView(float translate) {
        if (this.mMaskView == null) {
            LogUtil.w(TAG, "[translateLoadingView] mMaskView is null");
            return;
        }
        LogUtil.d(TAG, "[translateLoadingView] translate mMaskView, translate= " + translate);
        ViewCompat.setTranslationY((View)this.mMaskView, (float)translate);
    }

    public void translateView(View view, float translate, int direction) {
        if (view == null) {
            LogUtil.w(TAG, "[translateView] translateView is null");
            return;
        }
        if (translate >= 0.0f && translate <= (float)this.screenWidth) {
            ViewCompat.setTranslationX((View)view, (float)translate);
            LogUtil.d(TAG, "[translateView] [3] translate translateView, translate= " + translate + " direction == " + direction);
        }
    }

    public void translateViewByAnim(View mTranslateView, float translate, int direction) {
        ObjectAnimator objectAnimator;
        if (mTranslateView == null) {
            LogUtil.w(TAG, "[translateView] translateView is null");
            return;
        }
        LogUtil.d(TAG, "[translateView] [3] translate translateView, translate= " + translate + " direction == " + direction);
        if (direction == 2) {
            objectAnimator = ObjectAnimator.ofFloat((Object)mTranslateView, (String)"translationX", (float[])new float[]{mTranslateView.getTranslationX(), 0.0f});
            objectAnimator.setDuration(180L);
            if (this.mTranslationXRightAnimatorListener != null) {
                objectAnimator.addListener(this.mTranslationXRightAnimatorListener);
            }
            objectAnimator.start();
        }
        if (direction == 0) {
            objectAnimator = ObjectAnimator.ofFloat((Object)mTranslateView, (String)"translationX", (float[])new float[]{mTranslateView.getTranslationX(), this.screenWidth});
            objectAnimator.setDuration(180L);
            if (this.mTranslationXLeftAnimatorListener != null) {
                objectAnimator.addListener(this.mTranslationXLeftAnimatorListener);
            }
            objectAnimator.start();
        }
    }

    public void hideLoadingView(boolean isShowAnimation, int direction, Animator.AnimatorListener listener2) {
        float targetTranslateY;
        if (this.mMaskView == null) {
            LogUtil.w(TAG, "[hideLoadingView] mMaskView is null");
            return;
        }
        LogUtil.d(TAG, "[hideLoadingView] isShowAnimation = " + isShowAnimation + " direction= " + direction);
        if (direction == -1) {
            if (listener2 != null) {
                listener2.onAnimationStart(null);
            }
            this.resetLoadingViewPosition(2);
            if (listener2 != null) {
                listener2.onAnimationEnd(null);
            }
            return;
        }
        if (direction == 1) {
            if (!isShowAnimation) {
                if (listener2 != null) {
                    listener2.onAnimationStart(null);
                }
                this.resetLoadingViewPosition(2);
                if (listener2 != null) {
                    listener2.onAnimationEnd(null);
                }
                return;
            }
            targetTranslateY = this.getTotalHeight();
        } else {
            if (!isShowAnimation) {
                if (listener2 != null) {
                    listener2.onAnimationStart(null);
                }
                this.resetLoadingViewPosition(0);
                if (listener2 != null) {
                    listener2.onAnimationEnd(null);
                }
                return;
            }
            targetTranslateY = -this.getTotalHeight();
        }
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)this.mMaskView, (String)"translationY", (float[])new float[]{this.mMaskView.getTranslationY(), targetTranslateY});
        objectAnimator.setDuration((long)this.mDuration);
        if (listener2 != null) {
            objectAnimator.addListener(listener2);
        }
        objectAnimator.start();
    }

    public void showLoadingView(boolean isShowAnimation, int direction, Animator.AnimatorListener listener2) {
        if (this.mMaskView == null) {
            LogUtil.w(TAG, "[showLoadingView] mMaskView is null");
            return;
        }
        LogUtil.d(TAG, "[showLoadingView] isShowAnimation = " + isShowAnimation + " direction= " + direction);
        if (direction == -1) {
            if (listener2 != null) {
                listener2.onAnimationStart(null);
            }
            this.resetLoadingViewPosition(1);
            if (listener2 != null) {
                listener2.onAnimationEnd(null);
            }
        }
        if (!isShowAnimation) {
            if (listener2 != null) {
                listener2.onAnimationStart(null);
            }
            this.resetLoadingViewPosition(1);
            if (listener2 != null) {
                listener2.onAnimationEnd(null);
            }
            return;
        }
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)this.mMaskView, (String)"translationY", (float[])new float[]{this.mMaskView.getTranslationY(), 0.0f});
        objectAnimator.setDuration((long)this.mDuration);
        if (listener2 != null) {
            objectAnimator.addListener(listener2);
        }
        objectAnimator.start();
    }

    private boolean isCanTouchOffsetY(float targetTranslationY) {
        if (this.disableSwipeToUpOrDown) {
            if (this.mSwipeYRatio > 0.15f) {
                return false;
            }
            this.translateLoadingView(targetTranslationY);
            LogUtil.d(TAG, "[onTouchOffsetY] Notify swipe event's progress.");
            if (this.mOnSwipeListener != null) {
                this.mOnSwipeListener.onSwiping(this.mSwipeYRatio, this.mDirection);
            }
            return false;
        }
        return true;
    }

    public void resetLoadingViewPosition() {
        this.resetLoadingViewPosition(0);
        if (this.currentPosition == 2) {
            this.screenWidth = this.getMeasuredWidth();
            this.screenHeight = this.getMeasuredHeight();
            if (MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)TAG, (String)("zy resetLoadingViewPosition  screenWidth ==" + this.screenWidth), (Object[])new Object[0]);
            }
            this.resetTraslateViewPosition(3, false);
        }
    }

    private void resetLoadingViewPosition(int mode) {
        if (this.mMaskView == null) {
            LogUtil.w(TAG, "[resetLoadingViewPosition] mMaskView is null");
            return;
        }
        switch (mode) {
            case 0: {
                ViewCompat.setTranslationY((View)this.mMaskView, (float)(-this.getTotalHeight()));
                break;
            }
            case 1: {
                ViewCompat.setTranslationY((View)this.mMaskView, (float)0.0f);
                break;
            }
            case 2: {
                ViewCompat.setTranslationY((View)this.mMaskView, (float)this.getTotalHeight());
                break;
            }
        }
    }

    private void resetTraslateViewPosition(int mode, boolean isShowAnim) {
        if (this.mTranslateView == null) {
            LogUtil.w(TAG, "[resetTraslateViewPosition] mTranslateView is null");
            return;
        }
        LogUtil.d(TAG, "[resetTraslateViewPosition] [5] mode == " + mode + "isShowAnim == " + isShowAnim + "mTranslateView.getTranslationX() ==" + this.mTranslateView.getTranslationX());
        switch (mode) {
            case 3: {
                if (isShowAnim) {
                    this.translateViewByAnim(this.mTranslateView, this.screenWidth, 0);
                    break;
                }
                this.translateView(this.mTranslateView, this.screenWidth, 0);
                break;
            }
            case 4: {
                if (isShowAnim) {
                    this.translateViewByAnim(this.mTranslateView, 0.0f, 2);
                    break;
                }
                this.translateView(this.mTranslateView, 0.0f, 2);
                break;
            }
        }
    }

    private int getTotalHeight() {
        return this.getMeasuredHeight();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (!this.isCreated.get()) {
            this.hideLoadingView(false, -1, null);
            this.isCreated.set(true);
        }
    }

    public void setEnableSwipe(boolean enableSwipe) {
        this.mEnableSwipe = enableSwipe;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.mEnableSwipe) {
            this.iTouchEventProxy = null;
        }
        if (this.mGestureDetector != null) {
            this.mGestureDetector.onTouchEvent(event);
        }
        if (event.getPointerCount() > 1) {
            return true;
        }
        if (!this.mIsEnable) {
            return super.onTouchEvent(event);
        }
        if (this.iTouchEventProxy == null) {
            return super.onTouchEvent(event);
        }
        switch (event.getAction()) {
            case 0: {
                this.logEventInfo("ACTION_DOWN", event);
                this.mYdown = event.getY(0);
                this.mYpre = event.getY(0);
                this.mXdown = event.getX(0);
                this.mXpre = event.getX(0);
                if (this.mYdown <= (float)this.getTopLimitSwipeHeight() || this.mYdown > (float)this.getBottomLimitSwipeHeight()) {
                    return true;
                }
                if (this.vTracker == null) {
                    this.vTracker = VelocityTracker.obtain();
                } else {
                    this.vTracker.clear();
                    this.vTracker.addMovement(event);
                }
                this.mDirection = -1;
                this.isBeginSwipe = false;
                this.isHasActionDown = true;
                this.isBeginSwipeLandScape = false;
                break;
            }
            case 2: {
                this.logEventInfo("ACTION_MOVE", event);
                if (this.vTracker != null) {
                    this.vTracker.addMovement(event);
                    this.vTracker.computeCurrentVelocity(1000);
                }
                if (this.isBeginSwipe && !this.isBeginSwipeLandScape && !this.ismIsIntercept) {
                    if (!this.mVerticalTouchEnable) {
                        if (!MLog.isLogLevelAboveDebug()) break;
                        MLog.debug((Object)TAG, (String)("[zy mVerticalTouchEnable] mVerticalTouchEnable == " + this.mVerticalTouchEnable), (Object[])new Object[0]);
                        break;
                    }
                    this.iTouchEventProxy.onTouchOffsetY(event.getY(0) - this.mYpre, this.mDirection);
                } else if (Math.abs(event.getY(0) - this.mYdown) >= (float)this.iTouchEventProxy.getMinimumThreshold() && Math.abs(event.getY(0) - this.mYdown) <= (float)this.iTouchEventProxy.getMaximumThreshold() && !this.isBeginSwipeLandScape && !this.ismIsIntercept) {
                    if (!this.mVerticalTouchEnable) {
                        if (!MLog.isLogLevelAboveDebug()) break;
                        MLog.debug((Object)TAG, (String)("[zy mVerticalTouchEnable] first mVerticalTouchEnable == " + this.mVerticalTouchEnable), (Object[])new Object[0]);
                        break;
                    }
                    this.isBeginSwipeLandScape = false;
                    if (this.mWorkingMode == 2) {
                        this.mDirection = event.getY(0) <= this.mYdown ? 1 : 3;
                        this.iTouchEventProxy.onPreTouch(this.mDirection);
                        this.isBeginSwipe = true;
                        this.iTouchEventProxy.onTouchOffsetY(event.getY(0) - this.mYpre, this.mDirection);
                    } else if (this.mWorkingMode == 0) {
                        if (event.getY(0) <= this.mYdown) {
                            this.mDirection = 1;
                            this.iTouchEventProxy.onPreTouch(this.mDirection);
                            this.isBeginSwipe = true;
                            this.iTouchEventProxy.onTouchOffsetY(event.getY(0) - this.mYpre, this.mDirection);
                        }
                    } else if (event.getY(0) > this.mYdown) {
                        this.mDirection = 3;
                        this.iTouchEventProxy.onPreTouch(this.mDirection);
                        this.isBeginSwipe = true;
                        this.iTouchEventProxy.onTouchOffsetY(event.getY(0) - this.mYpre, this.mDirection);
                    }
                }
                if (!this.isBeginSwipe && this.isBeginSwipeLandScape) {
                    if (!this.mHorizontalTouchEnable) {
                        if (!MLog.isLogLevelAboveDebug()) break;
                        MLog.debug((Object)TAG, (String)("[zy mHorizontalTouchEnable] mHorizontalTouchEnable == " + this.mHorizontalTouchEnable), (Object[])new Object[0]);
                        break;
                    }
                    if (this.mDirection == 2) {
                        this.iTouchEventProxy.onTouchOffsetX(event.getX(0) - this.mXpre, this.mDirection);
                    } else if (this.currentPosition != this.mDirection) {
                        this.iTouchEventProxy.onTouchOffsetX(event.getX(0) - this.mXpre, this.mDirection);
                    }
                } else if (Math.abs(event.getX(0) - this.mXdown) >= (float)this.mMinimumLandScapeThreshold && Math.abs(event.getX(0) - this.mXdown) <= (float)this.mMaximumLandScapeThreshold && !this.isBeginSwipe) {
                    if (!this.mHorizontalTouchEnable) {
                        if (!MLog.isLogLevelAboveDebug()) break;
                        MLog.debug((Object)TAG, (String)("[zy mHorizontalTouchEnable] first mHorizontalTouchEnable == " + this.mHorizontalTouchEnable), (Object[])new Object[0]);
                        break;
                    }
                    if (event.getX(0) > this.mXdown) {
                        this.mDirection = 2;
                        this.iTouchEventProxy.onPreTouchX(this.mDirection);
                        this.isBeginSwipeLandScape = true;
                        this.iTouchEventProxy.onTouchOffsetX(event.getX(0) - this.mXpre, this.mDirection);
                    }
                    if (event.getX(0) <= this.mXdown) {
                        this.mDirection = 0;
                        this.iTouchEventProxy.onPreTouchX(this.mDirection);
                        this.isBeginSwipeLandScape = true;
                        this.iTouchEventProxy.onTouchOffsetX(event.getX(0) - this.mXpre, this.mDirection);
                    }
                }
                this.mXpre = event.getX(0);
                this.mYpre = event.getY(0);
                break;
            }
            default: {
                LogUtil.i(TAG, "Action = " + event.getAction());
                this.logEventInfo("ACTION_OTHERS", event);
                if ((this.mDirection == 2 || this.mDirection == 0) && this.isBeginSwipeLandScape) {
                    this.iTouchEventProxy.onPostXTouch(this.mDirection);
                }
                this.mYdown = 0.0f;
                this.mYpre = 0.0f;
                this.mXdown = 0.0f;
                this.isHasActionDown = false;
                if ((this.mDirection == 1 || this.mDirection == 3) && this.disableSwipeToUpOrDown) {
                    this.iTouchEventProxy.onPostYTouch(this.mDirection);
                    if (this.vTracker != null) {
                        this.vTracker.clear();
                    }
                    return true;
                }
                if (this.isBeginSwipe) {
                    this.isBeginSwipe = false;
                    this.iTouchEventProxy.onPostTouch(this.mDirection);
                    return true;
                }
                if (this.isBeginSwipeLandScape) {
                    this.isBeginSwipeLandScape = false;
                    return true;
                }
                if (this.vTracker == null) break;
                this.vTracker.clear();
            }
        }
        return super.onTouchEvent(event);
    }

    public GestureDetector getGestureDetector() {
        return this.mGestureDetector;
    }

    public void setGestureDetector(GestureDetector mGestureDetector) {
        this.mGestureDetector = mGestureDetector;
    }

    private void logEventInfo(String type, MotionEvent event) {
        LogUtil.d(TAG, "[onTouchEvent][logEventInfo] " + type + " getY= " + event.getY(0) + "; getRawY=" + event.getRawY());
    }

    public void onDestroyView() {
        this.resetLoadingViewPosition(2);
        this.mOnSwipeListener = null;
        this.mMaskView = null;
        this.mTranslateView = null;
        this.mTranslationXLeftAnimatorListener = null;
        this.mTranslationXRightAnimatorListener = null;
    }

    private void volumeAndBrightnessChange(float offset) {
        int value;
        float distance = this.mYpre + offset - this.mYdown;
        if (this.mXdown > (float)(this.screenWidth / 2)) {
            if (this.mVolumeSetter == null) {
                this.mVolumeSetter = new BrightnessAndVolumnSetter.VolumeSetter(this.getContext());
            }
            value = Math.round(this.mVolumeSetter.changeVolume(this.mYdown, this.convertPix2Value(distance)) * 100.0f);
        } else {
            if (this.mBrightnessSetter == null) {
                this.mBrightnessSetter = new BrightnessAndVolumnSetter.BrightnessSetter((Activity)this.getContext());
            }
            value = Math.round(this.mBrightnessSetter.changeBrightness(this.mYdown, this.convertPix2Value(distance)) * 100.0f);
        }
        LogUtil.d(TAG, "TouchChange distance " + distance);
        LogUtil.d(TAG, "TouchChange: " + value);
        if (this.mTipTextView != null) {
            this.mTipContainer.setVisibility(0);
            this.mTipTextView.setCompoundDrawablesWithIntrinsicBounds(this.mXdown > (float)(this.screenWidth / 2) ? R.drawable.icon_voice : R.drawable.icon_brigh, 0, 0, 0);
            this.mTipTextView.setText((CharSequence)String.format("%s%%", value));
        }
    }

    private float convertPix2Value(float f) {
        float rv;
        if (this.mMaxDistance == 0.0f) {
            this.mMaxDistance = (float)this.screenHeight * 1.5f;
        }
        return (rv = -f / this.mMaxDistance) > 1.0f ? 1.0f : (rv < -1.0f ? -1.0f : rv);
    }

    public void initTipView(View view) {
        this.mTipContainer = view;
        this.mTipTextView = (TextView)view.findViewById(R.id.swipe_text_control_tip);
    }

    public void setIsVolumeBrightness() {
        this.isLandscape = true;
    }

    public void setLoadingView(View loadingView) {
        this.mMaskView = loadingView;
    }

    public void setmTranslateView(View translateView) {
        this.mTranslateView = translateView;
        if (this.mTranslateView != null && ((ITouchCore)ICoreManagerBase.getCore(ITouchCore.class)).getClearScreenSate()) {
            this.currentPosition = 2;
            this.mTranslateView.setVisibility(0);
            this.resetTraslateViewPosition(3, false);
        }
    }

    public void setTranslateXLeftAnimatorListener(Animator.AnimatorListener listener2) {
        this.mTranslationXLeftAnimatorListener = listener2;
    }

    public void setTranslateXRightAnimatorListener(Animator.AnimatorListener listener2) {
        this.mTranslationXRightAnimatorListener = listener2;
    }

    public int getDirection() {
        return this.mDirection;
    }

    public void setDirection(int direction) {
        this.mDirection = direction;
    }

    public void setAnimationDuration(int duration) {
        this.mDuration = duration;
    }

    public void setWorkingMode(int workingMode) {
        this.mWorkingMode = workingMode;
    }

    public void setEnable(boolean isEnable) {
        this.mIsEnable = isEnable;
    }

    public void setHorizontalTouchEnable(boolean mHorizontalTouchEnable) {
        this.mHorizontalTouchEnable = mHorizontalTouchEnable;
    }

    public void setVerticalTouchEnable(boolean mVerticalTouchEnable) {
        this.mVerticalTouchEnable = mVerticalTouchEnable;
    }

    public void setMinimumLandScapeThreshold(int minimumLandScapeThreshold) {
        this.mMinimumLandScapeThreshold = minimumLandScapeThreshold;
    }

    public void setMaximumLandScapeThreshold(int maximumLandScapeThreshold) {
        this.mMaximumLandScapeThreshold = maximumLandScapeThreshold;
    }

    public ITouchEventProxy getTouchEventProxy() {
        return this.iTouchEventProxy;
    }

    public OnSwipeListener getOnSwipeListener() {
        return this.mOnSwipeListener;
    }

    public void setOnSwipeListener(OnSwipeListener onSwipeListener) {
        this.mOnSwipeListener = onSwipeListener;
    }

    public int getTopLimitSwipeHeight() {
        LogUtil.i(TAG, "[getLimitSwipeHeight] mTopLimitSwipeHeight =" + this.mTopLimitSwipeHeight);
        return this.mTopLimitSwipeHeight;
    }

    public void setTopLimitSwipeHeight(int topLimitSwipeHeight) {
        this.mTopLimitSwipeHeight = topLimitSwipeHeight;
    }

    public int getBottomLimitSwipeHeight() {
        LogUtil.i(TAG, "[getLimitSwipeHeight] mBottomLimitSwipeHeight =" + this.mBottomLimitSwipeHeight);
        return this.mBottomLimitSwipeHeight;
    }

    public void setBottomLimitSwipeHeight(int topBottomSwipeHeight) {
        this.mBottomLimitSwipeHeight = topBottomSwipeHeight;
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        try {
            super.onConfigurationChanged(newConfig);
            if (this.getResources().getConfiguration().orientation == 2) {
                this.isLandscape = true;
                if (this.getContext() != null) {
                    this.screenWidth = this.getScreenWidth(this.getContext());
                    this.screenHeight = ResolutionUtils.getScreenHeight((Context)this.getContext());
                    this.mTopLimitSwipeHeight = this.getResources().getDimensionPixelSize(R.dimen.basic_func_program_info_height) / 4;
                    this.mBottomLimitSwipeHeight = ResolutionUtils.getScreenHeight((Context)this.getContext());
                } else {
                    this.screenWidth = this.getMeasuredWidth();
                    this.screenHeight = this.getMeasuredHeight();
                    this.mTopLimitSwipeHeight = this.getResources().getDimensionPixelSize(R.dimen.basic_func_program_info_height) / 4;
                    this.mBottomLimitSwipeHeight = this.getMeasuredHeight();
                }
                if (MLog.isLogLevelAboveDebug()) {
                    MLog.debug((Object)TAG, (String)("zy onConfigurationChanged Configuration.ORIENTATION_LANDSCAPE screenWidth ==" + this.screenWidth), (Object[])new Object[0]);
                }
            } else if (this.getResources().getConfiguration().orientation == 1) {
                this.isLandscape = false;
                if (this.getContext() != null) {
                    this.screenWidth = this.getScreenWidth(this.getContext());
                    this.screenHeight = ResolutionUtils.getScreenHeight((Context)this.getContext());
                    this.mTopLimitSwipeHeight = this.getResources().getDimensionPixelSize(R.dimen.basic_func_program_info_height) / 3;
                    this.mBottomLimitSwipeHeight = ResolutionUtils.getScreenHeight((Context)this.getContext()) - this.getResources().getDimensionPixelSize(R.dimen.basic_interactive_expand_height);
                } else {
                    this.screenWidth = this.getMeasuredWidth();
                    this.screenHeight = this.getMeasuredHeight();
                    this.mTopLimitSwipeHeight = this.getResources().getDimensionPixelSize(R.dimen.basic_func_program_info_height) / 3;
                    this.mBottomLimitSwipeHeight = this.getMeasuredHeight() - this.getResources().getDimensionPixelSize(R.dimen.basic_interactive_expand_height);
                }
                if (MLog.isLogLevelAboveDebug()) {
                    MLog.debug((Object)TAG, (String)("zy onConfigurationChanged Configuration.ORIENTATION_PORTRAIT screenWidth ==" + this.screenWidth), (Object[])new Object[0]);
                }
            }
        }
        catch (Throwable throwable) {
            MLog.error((Object)TAG, (String)"zy onConfigurationChanged error", (Object[])new Object[0]);
        }
    }

    public static interface ITouchEventProxy {
        public int getMinimumThreshold();

        public int getMaximumThreshold();

        public void onPreTouch(int var1);

        public void onTouchOffsetY(float var1, int var2);

        public void onPostTouch(int var1);

        public void onSwipeToLeft();

        public void onSwipeToRight();

        public void onPreTouchX(int var1);

        public void onTouchOffsetX(float var1, int var2);

        public void onPostXTouch(int var1);

        public void onPostYTouch(int var1);
    }
}

