/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.turntable.v2.widget;

import android.animation.ValueAnimator;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.text.SpannableString;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.FrameLayout;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.widget.MarqueeLayout;
import com.yy.mobile.ui.widget.MarqueeTextView;
import com.yy.mobile.util.StringUtils;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;

public class TurntableBroadCastTextView
extends FrameLayout {
    public static final String TAG = "TurntableBroadCastTextView";
    private static final int animDuration = 1000;
    private static final int queueInfoStayTime = 5000;
    private final String winGiftIdKey = "win_gift";
    private final String onlyKey = "only_key";
    private final String nameKey = "name";
    private final String redNumkey = "red_num";
    private final String descKey = "desc";
    private final String chIdKey = "ch_id";
    private final String winNumKey = "win_num";
    private final String nameSpkey = "[name]";
    private final String numSpKey = "[num]";
    private final String shortIdSpKey = "[short_chId]";
    private final String winNumSpKey = "[win_num]";
    public static final int TextLineOneIndex = 1;
    public static final int TextLineTwoIndex = 2;
    private boolean broadCastStayEnd = true;
    private MarqueeLayout mMarqueeLayoutOut;
    private MarqueeLayout mMarqueeLayoutIn;
    private MarqueeTextView mMarqueeTextViewOut;
    private MarqueeTextView mMarqueeTextViewIn;
    private ValueAnimator objectAnimator;
    private ConcurrentLinkedQueue<SpannableString> broadcastList = new ConcurrentLinkedQueue();
    private HashSet<String> set = new HashSet();
    private Handler handler = new Handler(Looper.getMainLooper());
    private boolean queueIsStart = false;
    private int showIndex = -1;
    private int areaHeight = 48;
    private Runnable broadCastStayRunnable = new Runnable(){

        @Override
        public void run() {
            if (TurntableBroadCastTextView.this.broadcastList.size() > 0) {
                TurntableBroadCastTextView.this.start();
                TurntableBroadCastTextView.this.handler.postDelayed((Runnable)this, 5000L);
            } else {
                TurntableBroadCastTextView.this.broadCastStayEnd = true;
                TurntableBroadCastTextView.this.queueIsStart = false;
            }
        }
    };

    public TurntableBroadCastTextView(Context context) {
        super(context);
        this.init();
    }

    public void addMessage(Map<String, String> map) {
        String onlyKeyTemp = map.get("only_key");
        String winGiftType = map.get("win_gift");
        StringBuilder key = new StringBuilder();
        key.append(onlyKeyTemp).append("_").append(winGiftType);
        if (this.set.contains(key.toString())) {
            return;
        }
        this.set.add(key.toString());
        String name = map.get("name");
        String num = map.get("red_num");
        String ss = map.get("desc");
        String channel = map.get("ch_id");
        String winNum = map.get("win_num");
        if (ss == null || ss.length() == 0) {
            return;
        }
        StringBuilder sb = new StringBuilder("\u202d" + ss + "\u202c");
        int i1 = sb.lastIndexOf("[num]");
        int i2 = sb.lastIndexOf("[name]");
        int i3 = sb.lastIndexOf("[short_chId]");
        int i4 = sb.lastIndexOf("[win_num]");
        if (i1 > 0) {
            sb.replace(i1, i1 + "[num]".length(), num);
        }
        if (i2 > 0) {
            if (name.length() >= 12) {
                name = name.substring(0, 12) + "...";
            }
            i2 = sb.lastIndexOf("[name]");
            sb.replace(i2, i2 + "[name]".length(), name);
        }
        if (i3 > 0) {
            i3 = sb.lastIndexOf("[short_chId]");
            sb.replace(i3, i3 + "[short_chId]".length(), channel);
        }
        if (i4 > 0 && !StringUtils.isEmpty((String)winNum).booleanValue()) {
            i4 = sb.lastIndexOf("[win_num]");
            sb.replace(i4, i4 + "[win_num]".length(), winNum);
        }
        SpannableString sp = new SpannableString((CharSequence)sb);
        this.broadcastList.add(sp);
        if (!this.queueIsStart && this.broadCastStayEnd) {
            this.queueIsStart = true;
            this.broadCastStayEnd = false;
            this.handler.postDelayed(this.broadCastStayRunnable, 0L);
        }
    }

    public void onDestroy() {
        this.clearAnimator(this.objectAnimator);
        this.handler.removeCallbacksAndMessages(null);
        this.queueIsStart = false;
        this.broadCastStayEnd = true;
    }

    public void setAreaHeight(int areaHeight) {
        this.areaHeight = areaHeight;
    }

    private void init() {
        this.mMarqueeLayoutOut = this.createMarqueeLayout(ViewType.OUT);
        this.mMarqueeLayoutIn = this.createMarqueeLayout(ViewType.IN);
        this.addView((View)this.mMarqueeLayoutOut);
        this.addView((View)this.mMarqueeLayoutIn);
        this.objectAnimator = this.createAnimator();
        this.objectAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                if (animation != null) {
                    int value = (Integer)animation.getAnimatedValue();
                    if (TurntableBroadCastTextView.this.showIndex == 1) {
                        TurntableBroadCastTextView.this.mMarqueeLayoutOut.setTranslationY((float)(-value));
                        TurntableBroadCastTextView.this.mMarqueeLayoutIn.setTranslationY((float)(TurntableBroadCastTextView.this.areaHeight - value));
                        if (TurntableBroadCastTextView.this.areaHeight - value == 0) {
                            TurntableBroadCastTextView.this.showIndex = 2;
                        }
                    } else if (TurntableBroadCastTextView.this.showIndex == 2) {
                        TurntableBroadCastTextView.this.mMarqueeLayoutIn.setTranslationY((float)(-value));
                        TurntableBroadCastTextView.this.mMarqueeLayoutOut.setTranslationY((float)(TurntableBroadCastTextView.this.areaHeight - value));
                        if (TurntableBroadCastTextView.this.areaHeight - value == 0) {
                            TurntableBroadCastTextView.this.showIndex = 1;
                        }
                    }
                }
            }
        });
    }

    private void start() {
        SpannableString sp = this.broadcastList.poll();
        if (this.showIndex < 0) {
            this.mMarqueeTextViewOut.setText((CharSequence)sp);
            this.mMarqueeLayoutOut.setTranslationY(0.0f);
            this.showIndex = 1;
        } else {
            if (this.showIndex == 1) {
                this.mMarqueeLayoutIn.setTranslationY((float)this.areaHeight);
                this.mMarqueeTextViewIn.setText((CharSequence)sp);
                this.mMarqueeLayoutIn.setTranslationY(0.0f);
            } else if (this.showIndex == 2) {
                this.mMarqueeLayoutOut.setTranslationY((float)this.areaHeight);
                this.mMarqueeTextViewOut.setText((CharSequence)sp);
                this.mMarqueeLayoutOut.setTranslationY(0.0f);
            }
            this.objectAnimator.start();
        }
    }

    private void clearAnimator(ValueAnimator animator2) {
        if (animator2 != null && (animator2.isRunning() || animator2.isStarted())) {
            animator2.removeAllListeners();
            animator2.removeAllUpdateListeners();
            animator2.end();
        }
    }

    private ValueAnimator createAnimator() {
        ValueAnimator translateY = ValueAnimator.ofInt((int[])new int[]{1, this.areaHeight});
        translateY.setDuration(1000L);
        return translateY;
    }

    private MarqueeLayout createMarqueeLayout(ViewType type) {
        View view = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.turntable_v2_broadcast_marquee, null);
        MarqueeLayout marqueeLayout = (MarqueeLayout)view.findViewById(R.id.layout_marquee);
        if (type == ViewType.IN) {
            this.mMarqueeTextViewIn = (MarqueeTextView)view.findViewById(R.id.broadcast_content);
            this.mMarqueeTextViewIn.setGravity(16);
        } else if (type == ViewType.OUT) {
            this.mMarqueeTextViewOut = (MarqueeTextView)view.findViewById(R.id.broadcast_content);
            this.mMarqueeTextViewOut.setGravity(16);
        }
        return marqueeLayout;
    }

    static enum ViewType {
        IN,
        OUT;

    }
}

