/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.turntable.v2.bigwinner.widget;

import android.graphics.Color;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentStatePagerAdapter;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import com.yy.mobile.RxBus;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.basicchanneltemplate.component.Component;
import com.yy.mobile.ui.turntable.v2.bigwinner.widget.HistoryFragment;
import com.yy.mobile.ui.turntable.v2.event.TurnTableCommonEvent;
import com.yy.mobile.ui.utils.ViewUtils;
import com.yy.mobile.ui.widget.ControlTouchViewPager;
import com.yy.mobile.util.RxUtils;
import com.yy.mobile.util.log.MLog;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.functions.Consumer;
import java.util.ArrayList;
import java.util.List;

public class WinnerHistoryComponent
extends Component {
    public static final String TAG_HISTORY_COMPONENT = "history_component";
    private static final String TAG = "WinnerHistoryComponent";
    public static final int TAB_HISTORY = 0;
    public static final int TAB_MY_HISTORY = 1;
    private ControlTouchViewPager mContainer;
    private RadioGroup mTabGroup;
    private RadioButton mHistoryBtn;
    private RadioButton mMyHistoryBtn;
    private View mCloseBtn;
    private List<Fragment> mHistoryFragments = new ArrayList<Fragment>(2);
    private int mCurTabType = 0;
    private CompositeDisposable mCompositeDisposable = new CompositeDisposable();

    public static WinnerHistoryComponent newInstance() {
        return new WinnerHistoryComponent();
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.component_winner_history, container, false);
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        view.setBackgroundResource(R.drawable.bg_bigwinner);
        this.mContainer = (ControlTouchViewPager)view.findViewById(R.id.container);
        this.mTabGroup = (RadioGroup)view.findViewById(R.id.tab);
        this.mCloseBtn = view.findViewById(R.id.back_btn);
        this.mHistoryBtn = (RadioButton)view.findViewById(R.id.history_btn);
        this.mMyHistoryBtn = (RadioButton)view.findViewById(R.id.my_history_btn);
        this.mCompositeDisposable.add(ViewUtils.clicks((View)this.mCloseBtn, (long)500L).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<Object>(){

            public void accept(Object o) throws Exception {
                WinnerHistoryComponent.this.hide();
            }
        }, RxUtils.errorConsumer((String)TAG)));
        this.initTabFragments();
        TurnTableCommonEvent event = new TurnTableCommonEvent(0, false);
        RxBus.getDefault().post((Object)event);
    }

    private void hide() {
        Fragment fragment;
        if (null != this.getFragmentManager() && (fragment = this.getFragmentManager().findFragmentByTag(TAG_HISTORY_COMPONENT)) != null) {
            this.getFragmentManager().popBackStack();
        }
    }

    private void initTabFragments() {
        this.mHistoryFragments.add(HistoryFragment.Companion.newInstance(0));
        this.mHistoryFragments.add(HistoryFragment.Companion.newInstance(1));
        this.mContainer.setAdapter((PagerAdapter)new FragmentStatePagerAdapter(this.getChildFragmentManager()){

            public int getCount() {
                return WinnerHistoryComponent.this.mHistoryFragments.size();
            }

            public Fragment getItem(int position) {
                return (Fragment)WinnerHistoryComponent.this.mHistoryFragments.get(position);
            }
        });
        this.mContainer.setCurrentItem(this.mCurTabType);
        this.mTabGroup.setOnCheckedChangeListener(new RadioGroup.OnCheckedChangeListener(){

            public void onCheckedChanged(RadioGroup radioGroup, int checkId) {
                if (checkId == R.id.my_history_btn) {
                    WinnerHistoryComponent.this.mCurTabType = 1;
                    WinnerHistoryComponent.this.mMyHistoryBtn.setTextColor(Color.parseColor((String)"#ffffff"));
                    WinnerHistoryComponent.this.mHistoryBtn.setTextColor(Color.parseColor((String)"#66ffffff"));
                } else if (checkId == R.id.history_btn) {
                    WinnerHistoryComponent.this.mCurTabType = 0;
                    WinnerHistoryComponent.this.mHistoryBtn.setTextColor(Color.parseColor((String)"#ffffff"));
                    WinnerHistoryComponent.this.mMyHistoryBtn.setTextColor(Color.parseColor((String)"#66ffffff"));
                }
                MLog.debug((Object)WinnerHistoryComponent.TAG, (String)("mCurTabType :" + WinnerHistoryComponent.this.mCurTabType), (Object[])new Object[0]);
                WinnerHistoryComponent.this.mContainer.setCurrentItem(WinnerHistoryComponent.this.mCurTabType);
            }
        });
        this.mContainer.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            }

            public void onPageSelected(int position) {
                if (position == 0) {
                    WinnerHistoryComponent.this.mTabGroup.check(R.id.history_btn);
                } else if (position == 1) {
                    WinnerHistoryComponent.this.mTabGroup.check(R.id.my_history_btn);
                }
            }

            public void onPageScrollStateChanged(int state) {
            }
        });
    }

    public void setUserVisibleHint(boolean isVisibleToUser) {
        TurnTableCommonEvent event = new TurnTableCommonEvent(0, !isVisibleToUser);
        RxBus.getDefault().post((Object)event);
    }

    public void onDestroyView() {
        super.onDestroyView();
        this.mCurTabType = 0;
        this.mHistoryFragments.clear();
        this.mCompositeDisposable.clear();
        TurnTableCommonEvent event = new TurnTableCommonEvent(0, true);
        RxBus.getDefault().post((Object)event);
    }
}

