/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.treasurechest;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.widget.ImageView;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.target.SimpleTarget;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.request.transition.Transition;
import com.opensource.svgaplayer.SVGAImageView;
import com.unionyy.mobile.spdt.Spdt;
import com.yy.android.sniper.annotation.mvp.DelegateBind;
import com.yy.mobile.android.arouter.launcher.ARouter;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.basicchanneltemplate.component.Component;
import com.yy.mobile.ui.treasurechest.ITreasureChestComponent;
import com.yy.mobile.ui.treasurechest.ObtainTicketDialog;
import com.yy.mobile.ui.treasurechest.TreasureChestH5Dialog;
import com.yy.mobile.ui.treasurechest.TreasureChestPresenter;
import com.yy.mobile.ui.utils.DensityUtil;
import com.yy.mobile.ui.utils.RxBindingKt;
import com.yy.mobile.ui.utils.StringUtil;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.ylink.bridge.CoreApiManager;
import com.yy.mobile.ylink.bridge.coreapi.NavigationUtilApi;
import com.yymobile.core.LinkUriProvider;
import com.yymobile.core.statistic.IDataReportCore;
import io.reactivex.functions.Consumer;

@DelegateBind(presenter=TreasureChestPresenter.class)
public class TreasureChestComponent
extends Component<TreasureChestPresenter, ITreasureChestComponent>
implements ITreasureChestComponent {
    private static final String TAG = "TreasureChestComponent";
    @Nullable
    private View mRootView;
    @Nullable
    private ViewStub mStub;
    @Nullable
    private ImageView ivTreasureChest;
    @Nullable
    private TextView tvTimer;
    @Nullable
    private SVGAImageView ivTreasureSVGA;
    private TreasureChestH5Dialog mH5Dialog;
    private ObtainTicketDialog obtainTicketDialog;
    private boolean mIsLandscape = false;

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.mStub = new ViewStub(this.getContext());
        this.mStub.setLayoutResource(R.layout.fragment_treasure_chest);
        return this.mStub;
    }

    @SuppressLint(value={"CheckResult"})
    private void lazyCreateView() {
        if (this.mRootView == null && this.mStub != null) {
            this.mRootView = this.mStub.inflate();
            this.ivTreasureChest = (ImageView)this.mRootView.findViewById(R.id.iv_treasure_chest);
            this.ivTreasureSVGA = (SVGAImageView)this.mRootView.findViewById(R.id.iv_treasure_chest_svga);
            this.tvTimer = (TextView)this.mRootView.findViewById(R.id.tv_timer);
            this.tvTimer.bringToFront();
            this.updateEntranceImage();
            View container = this.mRootView.findViewById(R.id.fl_treasure_container);
            ViewGroup.LayoutParams param = container.getLayoutParams();
            if (param instanceof ViewGroup.MarginLayoutParams) {
                ((ViewGroup.MarginLayoutParams)param).topMargin = DensityUtil.dip2px((Context)this.getContext(), (float)280.0f);
                container.setLayoutParams(param);
            }
            if (this.ivTreasureChest != null) {
                RxBindingKt.clicks((View)this.ivTreasureChest, (boolean)true, (long)1000L).subscribe((Consumer)new Consumer<View>(){

                    public void accept(View view) {
                        ((TreasureChestPresenter)TreasureChestComponent.this.mPresenter).onTreasureChestClick();
                    }
                });
            }
            if (this.ivTreasureSVGA != null) {
                RxBindingKt.clicks((View)this.ivTreasureSVGA, (boolean)true, (long)1000L).subscribe((Consumer)new Consumer<View>(){

                    public void accept(View view) {
                        ((TreasureChestPresenter)TreasureChestComponent.this.mPresenter).onTreasureChestClick();
                    }
                });
            }
        }
    }

    public void onOrientationChanged(boolean isLandscape) {
        this.mIsLandscape = isLandscape;
        if ((((TreasureChestPresenter)this.getPresenter()).hasRollTime() || !LoginUtil.isLogined()) && this.mRootView != null) {
            this.setComponentVisibility(!isLandscape);
        }
    }

    @Override
    public void updateTimerView(String timeText) {
        if (this.tvTimer != null) {
            this.tvTimer.setText((CharSequence)timeText);
        }
    }

    @Override
    public void setTimerVisibility(boolean visible) {
        if (this.tvTimer == null && visible) {
            this.lazyCreateView();
        }
        if (this.tvTimer != null) {
            if (visible && !((TreasureChestPresenter)this.mPresenter).isOnlyPic()) {
                this.tvTimer.setVisibility(0);
            } else {
                this.tvTimer.setVisibility(4);
            }
        }
    }

    @Override
    public void setComponentVisibility(boolean visible) {
        this.setComponentVisibility(visible, false);
    }

    @Override
    public void setComponentVisibility(boolean visible, boolean causeKeyboard) {
        if (this.mRootView == null && visible && !causeKeyboard) {
            this.lazyCreateView();
        }
        if (this.mRootView != null) {
            if (this.mIsLandscape) {
                MLog.info((Object)TAG, (String)"setComponentVisibility: current is landscape", (Object[])new Object[0]);
                this.mRootView.setVisibility(8);
                return;
            }
            if (visible && !((TreasureChestPresenter)this.mPresenter).isChatInputSwitch()) {
                IDataReportCore core;
                MLog.info((Object)TAG, (String)"setComponentVisibility: set visible", (Object[])new Object[0]);
                this.mRootView.setVisibility(0);
                this.updateEntranceImage();
                if (!causeKeyboard && (core = (IDataReportCore)Spdt.ofOrNull(IDataReportCore.class)) != null && this.getContext() != null) {
                    core.reportOnShowTreasureChest(this.getContext());
                }
            } else {
                MLog.info((Object)TAG, (String)"setComponentVisibility: set gone", (Object[])new Object[0]);
                this.mRootView.setVisibility(8);
            }
        }
    }

    @Override
    public void showRollResultDialog(String baseUrl) {
        this.showH5Dialog(baseUrl + "?type=prize");
    }

    @Override
    @SuppressLint(value={"CheckResult"})
    public void showUnfinishedDialog(String baseUrl, boolean hasFollow) {
        this.showH5Dialog(baseUrl + "?type=tip&follow=" + (hasFollow ? "1" : "0"));
    }

    @Override
    public void showIntroduceDialog(String baseUrl) {
        this.showH5Dialog(baseUrl + "?type=rule");
    }

    @Override
    public void showToast(String str) {
        this.toast(str);
    }

    @Override
    public void startTreasureAnimation() {
        if (this.ivTreasureSVGA == null || this.ivTreasureChest == null || ((TreasureChestPresenter)this.mPresenter).isOnlyPic()) {
            return;
        }
        this.ivTreasureSVGA.stopAnimation();
        String animFile = ((TreasureChestPresenter)this.mPresenter).getSvgaUrl();
        if (StringUtil.isNullOrEmpty((CharSequence)animFile)) {
            MLog.info((Object)TAG, (String)"startTreasureAnimation: the url of svga is null", (Object[])new Object[0]);
            return;
        }
        Glide.with((Fragment)this).load(animFile).into((Target)new SimpleTarget<Drawable>(){

            public void onResourceReady(@NonNull Drawable resource, @Nullable Transition<? super Drawable> transition) {
                TreasureChestComponent.this.ivTreasureChest.setVisibility(8);
                TreasureChestComponent.this.ivTreasureSVGA.setVisibility(0);
                TreasureChestComponent.this.ivTreasureSVGA.setImageDrawable(resource);
                TreasureChestComponent.this.ivTreasureSVGA.startAnimation();
            }
        });
    }

    @Override
    public void stopTreasureAnimation() {
        if (this.ivTreasureSVGA == null || this.ivTreasureChest == null) {
            return;
        }
        if (this.ivTreasureSVGA.getVisibility() == 0) {
            this.ivTreasureSVGA.stopAnimation();
            this.ivTreasureSVGA.setVisibility(8);
            this.ivTreasureChest.setVisibility(0);
        }
    }

    @Override
    public boolean isLandScape() {
        return this.isLandScapeMode();
    }

    @Override
    public void showH5Dialog(String url) {
        MLog.info((Object)TAG, (String)"showH5Dialog: url = %s", (Object[])new Object[]{url});
        Bundle bundle = new Bundle();
        bundle.putString("H5_URL", url);
        Fragment fragment = TreasureChestH5Dialog.Companion.show(bundle, this.getLinkDialogManager());
        if (fragment instanceof TreasureChestH5Dialog) {
            this.mH5Dialog = (TreasureChestH5Dialog)fragment;
            if (url.endsWith("prize")) {
                this.mH5Dialog.setIntercepted(true);
            }
        }
    }

    @Override
    public void showObtainTicketDialog() {
        if (this.obtainTicketDialog == null) {
            this.obtainTicketDialog = new ObtainTicketDialog();
            this.obtainTicketDialog.setOnGoRollClick(new View.OnClickListener(){

                public void onClick(View v) {
                    TreasureChestComponent.this.navigation(LinkUriProvider.TREASURE_CHEST_ROLL_DIALOG);
                    TreasureChestComponent.this.obtainTicketDialog.dismiss();
                }
            });
        }
        if (this.getFragmentManager() != null && !this.obtainTicketDialog.isAdded()) {
            this.obtainTicketDialog.show(this.getFragmentManager(), "ObtainTicketDialog");
        }
    }

    @Override
    public Context getMContext() {
        return this.getContext();
    }

    @Override
    public void navigation(String action) {
        if (this.getContext() != null) {
            if (action.startsWith("http")) {
                ((NavigationUtilApi)CoreApiManager.getInstance().getApi(NavigationUtilApi.class)).toJSSupportedWebView((Activity)this.getActivity(), action);
            } else {
                ARouter.getInstance().build(Uri.parse((String)action)).navigation(this.getContext());
            }
        }
    }

    @Override
    public void setIntercept(boolean flag) {
        if (this.mH5Dialog != null) {
            this.mH5Dialog.setIntercepted(flag);
        }
    }

    public void updateEntranceImage() {
        MLog.info((Object)TAG, (String)"updateEntreyImage", (Object[])new Object[0]);
        if (this.ivTreasureChest != null && !StringUtil.isNullOrEmpty((CharSequence)((TreasureChestPresenter)this.mPresenter).getImageUrl())) {
            Glide.with((Fragment)this).load(((TreasureChestPresenter)this.mPresenter).getImageUrl()).into(this.ivTreasureChest);
        }
    }

    public void onDestroy() {
        super.onDestroy();
        this.mRootView = null;
    }
}

