/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.publicchat.model;

import android.support.annotation.NonNull;
import com.yy.live.module.giftdanmu.LiveDanMuUtil;
import com.yy.mobile.ui.publicchat.EnterChannelMessage;
import com.yy.mobile.ui.publicchat.model.PublicChatLiveModel;
import com.yy.mobile.ui.publicchat.model.parser.NSPublicChatParser;
import com.yy.mobile.ui.publicchat.model.parser.PublicChatBaseParser;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.channel.ChannelMessage;
import com.yymobile.core.gift.GiftChannelMessage;
import com.yymobile.core.mobilelive.IMobileLiveCore;
import com.yymobile.core.mobilelive.MobileLiveType;
import org.jetbrains.annotations.NotNull;

public class NSPublicChatLiveModel
extends PublicChatLiveModel {
    private final String giftComboTextFormat = "%s \u9001\u4e86{%d}%dx%d\u7ec4";
    public static final String TAG = "NSPublicChatLiveModel";

    public NSPublicChatLiveModel(int historyType, int type) {
        super(historyType, type);
        LiveDanMuUtil.subscribleUnNeedRunningWater(LiveDanMuUtil.unSubscribeRunningWaterGiftType);
    }

    @Override
    @NonNull
    protected PublicChatBaseParser onCreateParser() {
        return new NSPublicChatParser();
    }

    @Override
    public boolean onInterceptBeforeParse(@NotNull ChannelMessage message) {
        if (message instanceof EnterChannelMessage ? !this.allowShowEnterMessage() : message instanceof GiftChannelMessage && ((GiftChannelMessage)message).type != GiftChannelMessage.GiftType.ComboGift) {
            return true;
        }
        return super.onInterceptBeforeParse(message);
    }

    @Override
    protected void onProcessBeforeParse(@NonNull ChannelMessage message) {
        if (message instanceof GiftChannelMessage && ((GiftChannelMessage)message).type == GiftChannelMessage.GiftType.ComboGift) {
            message.text = String.format("%s \u9001\u4e86{%d}%dx%d\u7ec4", "", ((GiftChannelMessage)message).giftTypeId, ((GiftChannelMessage)message).giftNumber, ((GiftChannelMessage)message).giftComboNumber);
        }
        super.onProcessBeforeParse(message);
    }

    private boolean allowShowEnterMessage() {
        return ((IMobileLiveCore)ICoreManagerBase.getCore(IMobileLiveCore.class)).isLoginUserMobileLive() && ((IMobileLiveCore)ICoreManagerBase.getCore(IMobileLiveCore.class)).getMobileLiveType() != MobileLiveType.MOBILE_LIVE_TYPE_LIAN_MAI;
    }

    @Override
    public void onLeaveChannelSuccess() {
        super.onLeaveChannelSuccess();
        LiveDanMuUtil.removeSubscribleUnNeedRunningWater(LiveDanMuUtil.unSubscribeRunningWaterGiftType);
    }
}

