/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.plugins;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.yy.android.small.Small;
import com.yy.mobile.plugin.PluginCenter;
import com.yy.mobile.plugin.PluginInfo;
import com.yy.mobile.plugin.Plugins;
import com.yy.mobile.ui.utils.AbstractViewController;
import com.yy.mobile.util.log.MLog;
import java.util.Map;
import javax.annotation.Nonnull;

public class BasePluginViewController
extends AbstractViewController {
    private static final String TAG = "BasketballController";
    Bundle bundle;
    private int mType = 0;
    private ViewGroup rootView;
    private PluginInfo mPlugin;
    private String mPluginId;
    private long mTaskId;

    public BasePluginViewController(int type, String pluginId, long taskId) {
        this.mType = type;
        this.mPlugin = Plugins.fromPluginId((String)pluginId);
        this.mPluginId = pluginId;
        this.mTaskId = taskId;
    }

    public void init(Activity context, ViewGroup viewGroup, Bundle savedInstanceState) {
        this.rootView = viewGroup;
        this.bundle = savedInstanceState;
    }

    @Nonnull
    private Map<String, String> getPluginCenterActionMap() {
        return this.mPlugin != null ? this.mPlugin.pluginCenterActionMap() : PluginCenter.defaultActionMap();
    }

    public void deliverViewGroupToPlugin() {
        MLog.info((Object)TAG, (String)"deliverViewGroupToPlugin", (Object[])new Object[0]);
        String action = this.getPluginCenterActionMap().get("ACTION_PLUGIN_VIEW");
        this.smallStart(action, this.getActivity(), this.bundle, this.rootView, this.mType);
    }

    protected View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.bundle = savedInstanceState;
        return this.rootView;
    }

    protected void onPause() {
        super.onPause();
        String action = this.getPluginCenterActionMap().get("ACTION_PLUGIN_VIEW");
        this.smallOnPuse(action, this.mType);
    }

    protected void onResume() {
        super.onResume();
        String action = this.getPluginCenterActionMap().get("ACTION_PLUGIN_VIEW");
        this.smallOnResume(action, this.mType);
    }

    public void orientationChanged(boolean isLandscape) {
        super.onOrientationChanged(isLandscape);
        String action = this.getPluginCenterActionMap().get("ACTION_PLUGIN_VIEW");
        this.smallOnOrientationChanged(action, isLandscape, this.mType);
    }

    protected void onDestroy() {
        super.onDestroy();
        String action = this.getPluginCenterActionMap().get("ACTION_PLUGIN_VIEW");
        this.smallOnDestroy(action, this.mType);
    }

    private void smallStart(String action, Activity activity, Bundle savedInstanceState, ViewGroup parentView, int type) {
        if (activity != null) {
            Intent intent = new Intent(action);
            intent.putExtra("command", "onShow");
            intent.putExtra("LIVE_STATE_KEY", type);
            this.putBaseInfo(intent);
            Small.startAction((Intent)intent, (Activity)activity, (ViewGroup)parentView);
        }
    }

    private void smallOnDestroy(String action, int type) {
        Intent intent = new Intent(action);
        intent.putExtra("command", "onDestroy");
        Bundle params = new Bundle();
        params.putInt("LIVE_STATE_KEY", type);
        this.putBaseInfo(intent);
        Small.startAction((Intent)intent, null);
    }

    private void smallOnOrientationChanged(String action, boolean isLandscape, int type) {
        Intent intent = new Intent(action);
        intent.putExtra("command", "onOrientationChanged");
        intent.putExtra("ON_ORIENTATION_CHANGED_KEY", isLandscape);
        intent.putExtra("LIVE_STATE_KEY", type);
        this.putBaseInfo(intent);
        Small.startAction((Intent)intent, null);
    }

    private void smallOnResume(String action, int type) {
        Intent intent = new Intent(action);
        intent.putExtra("command", "onResume");
        Bundle params = new Bundle();
        params.putInt("LIVE_STATE_KEY", type);
        this.putBaseInfo(intent);
        Small.startAction((Intent)intent, null);
    }

    private void smallOnPuse(String action, int type) {
        Intent intent = new Intent(action);
        intent.putExtra("command", "onPause");
        Bundle params = new Bundle();
        params.putInt("LIVE_STATE_KEY", type);
        this.putBaseInfo(intent);
        Small.startAction((Intent)intent, null);
    }

    private Intent putBaseInfo(Intent intent) {
        intent.putExtra("pluginid", this.mPluginId);
        intent.putExtra("taskid", this.mTaskId);
        return intent;
    }

    public String getPluginId() {
        return this.mPluginId;
    }

    public long getTaskId() {
        return this.mTaskId;
    }
}

