/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.plugincenter;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentActivity;
import android.text.TextUtils;
import com.kaopiz.kprogresshud.KProgressHUD;
import com.yy.android.small.Small;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.android.sniper.api.event.EventCompat;
import com.yy.mobile.RxBus;
import com.yy.mobile.plugin.main.events.IPluginCenterClient_closePluginByAndroidId_EventArgs;
import com.yy.mobile.plugin.main.events.IPluginCenterClient_closePluginByPluginId_EventArgs;
import com.yy.mobile.plugin.main.events.IPluginCenterClient_hidePluginCenter_EventArgs;
import com.yy.mobile.plugin.main.events.IPluginCenterClient_loadPluginByTaskId_EventArgs;
import com.yy.mobile.ui.plugincenter.PluginCenterController;
import com.yy.mobile.ui.plugincenter.PluginCenterLoader$$EventBinder;
import com.yy.mobile.ui.utils.SingleToastUtil;
import com.yy.mobile.ui.utils.StringUtil;
import com.yy.mobile.ui.widget.toast.Toast;
import com.yy.mobile.uniondif.AppIdConfig;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.RxUtils;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.yyprotocol.core.Uint32;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.plugincenter.IPluginCenterCore;
import com.yymobile.core.plugincenter.PluginCenterProtocol;
import com.yymobile.core.plugincenter.PluginInfo;
import com.yymobile.liveapi.plugincenter.SinglePluginInfo;
import com.yymobile.liveapi.plugincenter.event.LoadPluginListener;
import com.yymobile.liveapi.plugincenter.event.PluginCenterMutexEventArgv;
import io.reactivex.Flowable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class PluginCenterLoader
implements EventCompat {
    private static final String TAG = "PluginCenterLoader";
    private boolean isLoadingPlugin = false;
    private WeakReference<FragmentActivity> mActivity = new WeakReference<Object>(null);
    private Lock lock = new ReentrantLock();
    private Disposable mClosingDisposable = null;
    private Disposable mLoadingTimerDisposable = null;
    private KProgressHUD mLoading;
    private LoadPluginListener mLoadingListener = new LoadPluginListener(){

        public void onFinish(SinglePluginInfo plugin, LoadPluginListener.Result result) {
            MLog.info((Object)PluginCenterLoader.TAG, (String)"load plugin finish, result : %s, plugin: %s", (Object[])new Object[]{result, plugin});
            result = result == null ? LoadPluginListener.Result.UNKNOWN_FAILED : result;
            SinglePluginInfo currentPlugin = PluginCenterController.INSTANCE.getCurrentActivatedPlugin();
            if (result == LoadPluginListener.Result.HAD_STARTED || result == LoadPluginListener.Result.OTHER_PLUGIN_HAD_START) {
                RxBus.getDefault().post((Object)new PluginCenterMutexEventArgv(currentPlugin, plugin));
            } else if (result == LoadPluginListener.Result.TIME_OUT) {
                SingleToastUtil.showToast((String)"\u52a0\u8f7d\u8d85\u65f6\uff0c\u8bf7\u91cd\u8bd5\uff01");
            }
        }
    };
    private EventBinder mPluginCenterLoaderSniperEventBinder;

    public PluginCenterLoader(FragmentActivity activity) {
        MLog.info((Object)TAG, (String)"PluginCenterLoader created", (Object[])new Object[0]);
        this.mActivity = new WeakReference<FragmentActivity>(activity);
        ICoreManagerBase.addClient((Object)this);
        this.mLoading = KProgressHUD.create((Context)activity).setStyle(KProgressHUD.Style.SPIN_INDETERMINATE).setAnimationSpeed(2);
    }

    public void release() {
        MLog.info((Object)TAG, (String)"PluginCenterLoader release", (Object[])new Object[0]);
        this.closePlugin(((IPluginCenterCore)ICoreManagerBase.getCore(IPluginCenterCore.class)).getCurrentActivatedPlugin());
        ICoreManagerBase.removeClient((Object)this);
        if (this.mLoading != null) {
            this.mLoading.dismiss();
            this.mLoading = null;
        }
        this.releaseDisposable(this.mLoadingTimerDisposable);
        this.releaseDisposable(this.mClosingDisposable);
        this.mActivity.clear();
    }

    public void loadPlugin(final SinglePluginInfo plug) {
        MLog.info((Object)TAG, (String)("loadPlugin plug=" + plug), (Object[])new Object[0]);
        this.lock.lock();
        try {
            if (!this.isPluginValid(plug) || this.isLoadingPlugin) {
                MLog.info((Object)TAG, (String)"plugin is invalid or the same plugin is loading, isLoadingPlugin = %s", (Object[])new Object[]{this.isLoadingPlugin});
                return;
            }
            if (plug != null) {
                this.isLoadingPlugin = true;
                Small.addSetUpPluginRequest((String)plug.getAndroidId(), (Small.OnSetupListener)new Small.OnSetupListener(){

                    public void onSetup(Small.SetupResult result) {
                        MLog.info((Object)PluginCenterLoader.TAG, (String)("load plugin result=" + result + ", pluginid=" + plug.pluginId), (Object[])new Object[0]);
                        PluginCenterLoader.this.isLoadingPlugin = false;
                        if (result == Small.SetupResult.PluginSetupSuccess) {
                            PluginCenterLoader.this.startAction(plug);
                            RxBus.getDefault().post((Object)new IPluginCenterClient_hidePluginCenter_EventArgs());
                        } else {
                            PluginCenterLoader.this.updateCurrentPluginState(plug, LoadPluginListener.Result.SMALL_SETUP_FAILED);
                        }
                        PluginCenterLoader.this.loadPluginFinish();
                    }
                });
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean updateCurrentPluginState(@NonNull SinglePluginInfo plugin, @Nullable LoadPluginListener.Result mayResult) {
        return this.updateCurrentPluginState(plugin, mayResult, true, true);
    }

    public boolean updateCurrentPluginState(@NonNull SinglePluginInfo plugin, @Nullable LoadPluginListener.Result mayResult, boolean isDefaultListener, boolean isDefaultTimeout) {
        SinglePluginInfo currentPlugin = ((IPluginCenterCore)ICoreManagerBase.getCore(IPluginCenterCore.class)).getCurrentActivatedPlugin();
        if (currentPlugin == null) {
            MLog.info((Object)TAG, (String)"currentPlugin is null, isDefaultListener: %s, isDefaultTimeout: %s; plugin: %s", (Object[])new Object[]{isDefaultListener, isDefaultTimeout, plugin});
            if (isDefaultListener) {
                plugin.addLoadingListener(this.mLoadingListener);
            }
            ((IPluginCenterCore)ICoreManagerBase.getCore(IPluginCenterCore.class)).setCurrentActivatedPlugin(plugin);
            this.releaseDisposable(this.mLoadingTimerDisposable);
            if (isDefaultTimeout) {
                this.mLoadingTimerDisposable = Flowable.timer((long)60000L, (TimeUnit)TimeUnit.MILLISECONDS).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<Long>(){

                    public void accept(Long aLong) throws Exception {
                        MLog.info((Object)PluginCenterLoader.TAG, (String)"load plugin time out", (Object[])new Object[0]);
                        if (PluginCenterController.INSTANCE.getCurrentActivatedPlugin() != null) {
                            PluginCenterLoader.this.isLoadingPlugin = false;
                            PluginCenterLoader.this.updateCurrentPluginState(((IPluginCenterCore)ICoreManagerBase.getCore(IPluginCenterCore.class)).getCurrentActivatedPlugin(), LoadPluginListener.Result.TIME_OUT);
                            PluginCenterLoader.this.loadPluginFinish();
                        }
                    }
                }, RxUtils.errorConsumer((String)TAG, (String)"loadingPlugin error"));
            }
            return true;
        }
        MLog.info((Object)TAG, (String)"updateCurrentPluginState currentPlugin: %s; \n plugin: %s", (Object[])new Object[]{currentPlugin, plugin});
        if (mayResult == null) {
            return true;
        }
        if (mayResult == LoadPluginListener.Result.SUCCEED) {
            this.releaseDisposable(this.mLoadingTimerDisposable);
        }
        plugin.onFinish(new SinglePluginInfo(plugin), mayResult);
        if (mayResult != LoadPluginListener.Result.HAD_STARTED && mayResult != LoadPluginListener.Result.OTHER_PLUGIN_HAD_START && mayResult != LoadPluginListener.Result.SUCCEED) {
            this.releaseDisposable(this.mLoadingTimerDisposable);
            ((IPluginCenterCore)ICoreManagerBase.getCore(IPluginCenterCore.class)).setCurrentActivatedPlugin(null);
        }
        return false;
    }

    private boolean isPluginValid(SinglePluginInfo plugin) {
        if (plugin == null || !PluginCenterController.INSTANCE.isPluginConfigLoad()) {
            MLog.warn((Object)TAG, (String)"plugin is not valid", (Object[])new Object[0]);
            return false;
        }
        if (!this.isPluginInPluginCenter(plugin)) {
            MLog.info((Object)TAG, (String)" plugin not in plugin center config, plugin: %s", (Object[])new Object[]{plugin});
            plugin.onFinish(new SinglePluginInfo(plugin), LoadPluginListener.Result.NOT_IN_PLUGIN_CENTER);
            ((IPluginCenterCore)ICoreManagerBase.getCore(IPluginCenterCore.class)).setCurrentActivatedPlugin(null);
            this.releaseDisposable(this.mLoadingTimerDisposable);
            return false;
        }
        if (!Small.isPluginShouldRun((String)plugin.getAndroidId())) {
            MLog.info((Object)TAG, (String)" plugin not in small config, plugin: %s", (Object[])new Object[]{plugin});
            plugin.onFinish(new SinglePluginInfo(plugin), LoadPluginListener.Result.NOT_IN_CONFIG);
            ((IPluginCenterCore)ICoreManagerBase.getCore(IPluginCenterCore.class)).setCurrentActivatedPlugin(null);
            this.releaseDisposable(this.mLoadingTimerDisposable);
            return false;
        }
        return true;
    }

    private void fixChannelPkPlugin(@NonNull SinglePluginInfo plugin) {
        Integer androidId = ((IPluginCenterCore)ICoreManagerBase.getCore(IPluginCenterCore.class)).getAndroidId(Long.valueOf(plugin.pluginId));
        plugin.pluginId = androidId.intValue();
        plugin.setAndroidId(String.valueOf(androidId));
    }

    private void fixChannelPkPlugin(@NonNull PluginCenterProtocol.PluginOpenRsp info) {
        if (info.pluginId != null) {
            Integer androidId = ((IPluginCenterCore)ICoreManagerBase.getCore(IPluginCenterCore.class)).getAndroidId(Long.valueOf(info.pluginId.longValue()));
            MLog.info((Object)TAG, (String)("fixChannelPkPlugin: origin pluginId = " + info.pluginId + ", new androidId = " + androidId), (Object[])new Object[0]);
            if (androidId != -1) {
                info.pluginId = new Uint32(androidId.intValue());
            }
        }
    }

    @BusEvent(sync=true)
    public void loadPluginByTaskId(IPluginCenterClient_loadPluginByTaskId_EventArgs busEventArgs) {
        long taskid = busEventArgs.getTaskid();
        Bundle bundle = busEventArgs.getBundle();
        boolean showLoading = busEventArgs.getShowLoading();
        PluginInfo pluginInfo = ((IPluginCenterCore)ICoreManagerBase.getCore(IPluginCenterCore.class)).getPluginInfo();
        if (null == pluginInfo) {
            Toast.makeText((Context)((Context)this.mActivity.get()), (CharSequence)"\u52a0\u8f7d\u5931\u8d25", (int)0).show();
            return;
        }
        for (SinglePluginInfo plug1 : pluginInfo.plugs) {
            if (null == plug1 || plug1.pluginId != taskid) continue;
            this.loadPlugin(plug1, bundle, showLoading);
            break;
        }
    }

    @BusEvent(sync=true)
    public void closePluginByPluginId(IPluginCenterClient_closePluginByPluginId_EventArgs busEventArgs) {
        long pluginid = busEventArgs.getPluginid();
        SinglePluginInfo currentPlugin = PluginCenterController.INSTANCE.getCurrentActivatedPlugin();
        MLog.info((Object)TAG, (String)("closePluginByPluginId pluginid=" + pluginid + " , currentPlugin = " + currentPlugin), (Object[])new Object[0]);
        if (currentPlugin == null) {
            MLog.warn((Object)TAG, (String)"closePluginByPluginId  return , because current is not activated plugin", (Object[])new Object[0]);
            return;
        }
        if (currentPlugin.pluginId == pluginid) {
            this.closePlugin(currentPlugin);
        }
    }

    @BusEvent(sync=true)
    public void closePluginByAndroidId(IPluginCenterClient_closePluginByAndroidId_EventArgs busEventArgs) {
        String androidId = busEventArgs.getAndroidId();
        MLog.info((Object)TAG, (String)("closePluginByAndroidId androidId=" + androidId), (Object[])new Object[0]);
        SinglePluginInfo currentPlugin = PluginCenterController.INSTANCE.getCurrentActivatedPlugin();
        if (TextUtils.isEmpty((CharSequence)androidId) || currentPlugin == null) {
            MLog.info((Object)TAG, (String)"closePluginByAndroidId androidId is null or activity unvalid , or current is not activated plugin", (Object[])new Object[0]);
            return;
        }
        if (androidId.equals(currentPlugin.getAndroidId())) {
            this.closePlugin(currentPlugin);
        } else {
            MLog.info((Object)TAG, (String)"closePluginByAndroidId fail, current activated is %s, but not %s ", (Object[])new Object[]{currentPlugin.getAndroidId(), androidId});
        }
    }

    private void loadPluginFinish() {
        MLog.info((Object)TAG, (String)"loadPlugin Finish ", (Object[])new Object[0]);
        if (this.mClosingDisposable != null && !this.mClosingDisposable.isDisposed()) {
            this.mClosingDisposable.dispose();
        }
        this.mClosingDisposable = Flowable.timer((long)500L, (TimeUnit)TimeUnit.MILLISECONDS).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<Long>(){

            public void accept(Long aLong) throws Exception {
                MLog.info((Object)PluginCenterLoader.TAG, (String)"loadPluginFinish closing ", (Object[])new Object[0]);
                if (PluginCenterLoader.this.isActivityValid()) {
                    PluginCenterLoader.this.mLoading.dismiss();
                }
            }
        }, RxUtils.errorConsumer((String)TAG, (String)"closingDisposable error"));
    }

    public void loadPlugin(SinglePluginInfo plug, Bundle bundle, boolean showLoading) {
        MLog.info((Object)TAG, (String)"loadPlugin plug = %s, bundle = %s, showLoading = %s", (Object[])new Object[]{plug, bundle, showLoading});
        if (null == plug || plug.pluginId == Long.MIN_VALUE) {
            MLog.info((Object)TAG, (String)"onLoadPlugin plug is null", (Object[])new Object[0]);
            return;
        }
        SinglePluginInfo currentPlugin = null;
        if (null != this.isPluginRunning(plug.getAndroidId()) && this.isActivityValid()) {
            if (!plug.isMultiActiveSupport()) {
                Toast.makeText((Context)((Context)this.mActivity.get()), (CharSequence)(plug.pluginName + "\u5df2\u542f\u52a8"), (int)0).show();
                this.updateCurrentPluginState(plug, LoadPluginListener.Result.HAD_STARTED);
                return;
            }
            MLog.info((Object)TAG, (String)"Plugin[%s] support multi active", (Object[])new Object[]{plug.pluginName});
        } else {
            currentPlugin = PluginCenterController.INSTANCE.getCurrentActivatedPlugin();
            if (currentPlugin != null) {
                Toast.makeText((Context)((Context)this.mActivity.get()), (CharSequence)("\u6b63\u5728\u8fdb\u884c" + currentPlugin.pluginName), (int)0).show();
                return;
            }
            if (!this.updateCurrentPluginState(plug, LoadPluginListener.Result.OTHER_PLUGIN_HAD_START)) {
                return;
            }
        }
        if (showLoading) {
            this.mLoading.show();
        }
        plug.isPositive = true;
        if (bundle != null) {
            plug.extend = new Bundle(bundle);
        }
        if (PluginCenterController.INSTANCE.isPluginConfigLoad() && this.isPluginInPluginCenter(plug)) {
            this.loadPlugin(plug);
        } else {
            MLog.error((Object)TAG, (String)"loadPlugin error: pluginConfig not load or not pluginCenter ", (Object[])new Object[0]);
            this.updateCurrentPluginState(plug, LoadPluginListener.Result.PLUGIN_LOADER_NOT_INIT);
        }
    }

    public void onPluginOpen(PluginCenterProtocol.PluginOpenRsp info) {
        if (info == null) {
            MLog.info((Object)TAG, (String)"pluginOpenRsp is null", (Object[])new Object[0]);
            return;
        }
        PluginInfo pluginInfo = ((IPluginCenterCore)ICoreManagerBase.getCore(IPluginCenterCore.class)).getPluginInfo();
        if (pluginInfo == null || FP.size((Collection)pluginInfo.plugs) <= 0) {
            MLog.info((Object)TAG, (String)"pluginInfo is null", (Object[])new Object[0]);
            return;
        }
        if (this.isYiQiBoPluginAndAlreadyCancel(info.pluginId.longValue())) {
            MLog.info((Object)TAG, (String)"the resp is yiqibo plugin and already cancel", (Object[])new Object[0]);
            return;
        }
        this.fixChannelPkPlugin(info);
        SinglePluginInfo openPluginInfo = null;
        for (SinglePluginInfo singlePluginInfo : pluginInfo.plugs) {
            int androidId = ((IPluginCenterCore)ICoreManagerBase.getCore(IPluginCenterCore.class)).getAndroidId(Long.valueOf(singlePluginInfo.pluginId));
            if (singlePluginInfo.pluginId != info.pluginId.longValue() && androidId != info.pluginId.intValue()) continue;
            openPluginInfo = singlePluginInfo;
            MLog.info((Object)TAG, (String)("openPlugin found pluginId = " + openPluginInfo.pluginId + "loacal pluginId = " + singlePluginInfo.pluginId), (Object[])new Object[0]);
            break;
        }
        if (null == openPluginInfo) {
            MLog.info((Object)TAG, (String)"open pluginInfo is null", (Object[])new Object[0]);
            return;
        }
        SinglePluginInfo plug = this.isPluginRunning(openPluginInfo.getAndroidId());
        if (plug != null) {
            String action = (String)plug.getPluginCenterActionMap().get("PLUGINCNETER_PAYLOAD_INFO");
            Intent startIntent = new Intent(action);
            startIntent.putExtra("taskid", plug.pluginId);
            startIntent.putExtra("pluginid", plug.getAndroidId());
            startIntent.putExtra("payload", info.data);
            startIntent.putExtra("msgtype", new HashMap(info.extendInfo));
            startIntent.putExtra("positive", plug.isPositive);
            startIntent.putExtra("extend", plug.extend);
            startIntent.putExtra("action_plugin_filter", plug.getAndroidId());
            Small.startAction((Intent)startIntent, (Activity)((Activity)this.mActivity.get()));
            MLog.info((Object)TAG, (String)"plugin %s has started", (Object[])new Object[]{plug.pluginId});
            return;
        }
        openPluginInfo.isPositive = false;
        openPluginInfo.payload = info.data;
        openPluginInfo.msgType = new HashMap(info.extendInfo);
        openPluginInfo.extend = null;
        if (!this.updateCurrentPluginState(openPluginInfo, LoadPluginListener.Result.OTHER_PLUGIN_HAD_START, true, false)) {
            return;
        }
        this.loadPlugin(openPluginInfo);
    }

    private boolean isYiQiBoPluginAndAlreadyCancel(long pluginId) {
        return pluginId == AppIdConfig.getAppIds().getYiqiboPluginCenterId() && ((IPluginCenterCore)ICoreManagerBase.getCore(IPluginCenterCore.class)).getCurrentActivatedPlugin() == null;
    }

    private SinglePluginInfo isPluginRunning(String androidId) {
        SinglePluginInfo currentPlugin = ((IPluginCenterCore)ICoreManagerBase.getCore(IPluginCenterCore.class)).getCurrentActivatedPlugin();
        if (currentPlugin != null && StringUtil.equal((String)androidId, (String)currentPlugin.getAndroidId())) {
            return currentPlugin;
        }
        return null;
    }

    private void startAction(SinglePluginInfo plug) {
        String action = (String)plug.getPluginCenterActionMap().get("PLUGINCNETER_PLUGIN_START");
        MLog.info((Object)TAG, (String)"startAction %s action: %s", (Object[])new Object[]{plug, action});
        if (plug != null && this.isActivityValid()) {
            this.updateCurrentPluginState(plug, LoadPluginListener.Result.SUCCEED);
            Intent startIntent = new Intent(action);
            startIntent.putExtra("taskid", plug.pluginId);
            startIntent.putExtra("pluginid", plug.getAndroidId());
            startIntent.putExtra("payload", plug.payload);
            startIntent.putExtra("msgtype", (Serializable)plug.msgType);
            startIntent.putExtra("positive", plug.isPositive);
            startIntent.putExtra("extend", plug.extend);
            startIntent.putExtra("extendInfo", plug.extendInfo);
            startIntent.putExtra("pluginName", plug.pluginName);
            startIntent.putExtra("icon", plug.icon);
            startIntent.putExtra("action_plugin_filter", plug.getAndroidId());
            Small.startAction((Intent)startIntent, (Activity)((Activity)this.mActivity.get()));
            plug.payload = "";
            plug.msgType = null;
            plug.isPositive = false;
            plug.extend = null;
        }
    }

    public void closePlugin(SinglePluginInfo plug) {
        SinglePluginInfo currentPlugin = PluginCenterController.INSTANCE.getCurrentActivatedPlugin();
        if (currentPlugin != null && plug != null && currentPlugin.pluginId == plug.pluginId) {
            MLog.info((Object)TAG, (String)("closePlugin pluginid = " + plug.pluginId), (Object[])new Object[0]);
            this.updateCurrentPluginState(plug, LoadPluginListener.Result.CLOSED);
            if (!this.isActivityValid()) {
                MLog.error((Object)TAG, (String)"close plugin , but activity is not valid, ignore this", (Object[])new Object[0]);
            }
            String action = (String)plug.getPluginCenterActionMap().get("PLUGINCENTER_PLUGIN_CLOSE");
            Intent closeIntent = new Intent(action);
            closeIntent.putExtra("taskid", plug.pluginId);
            closeIntent.putExtra("pluginid", plug.getAndroidId());
            Small.startAction((Intent)closeIntent, (Activity)((Activity)this.mActivity.get()));
        } else {
            MLog.warn((Object)TAG, (String)"plug is not current plugin return", (Object[])new Object[0]);
        }
        ((IPluginCenterCore)ICoreManagerBase.getCore(IPluginCenterCore.class)).setCurrentActivatedPlugin(null);
    }

    private boolean isActivityValid() {
        FragmentActivity activity = this.mActivity != null ? (FragmentActivity)this.mActivity.get() : null;
        return activity != null && !activity.isFinishing() && (Build.VERSION.SDK_INT < 17 || !activity.isDestroyed());
    }

    private void releaseDisposable(Disposable disposable2) {
        if (disposable2 != null && !disposable2.isDisposed()) {
            disposable2.dispose();
        }
    }

    private boolean isPluginInPluginCenter(SinglePluginInfo plugin) {
        if (plugin == null) {
            MLog.error((Object)TAG, (String)"plugin is null", (Object[])new Object[0]);
            return false;
        }
        PluginInfo pluginInfo = ((IPluginCenterCore)ICoreManagerBase.getCore(IPluginCenterCore.class)).getPluginInfo();
        if (pluginInfo != null && !FP.empty((Collection)pluginInfo.plugs)) {
            if (pluginInfo.plugs.contains(plugin)) {
                return true;
            }
            for (SinglePluginInfo p : pluginInfo.plugs) {
                if (plugin.pluginId != p.pluginId) continue;
                return true;
            }
        }
        MLog.error((Object)TAG, (String)"plugin not in pluginCenter %s", (Object[])new Object[]{plugin.getAndroidId()});
        return false;
    }

    public void onEventBind() {
        if (this.mPluginCenterLoaderSniperEventBinder == null) {
            this.mPluginCenterLoaderSniperEventBinder = new PluginCenterLoader$$EventBinder();
        }
        this.mPluginCenterLoaderSniperEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        if (this.mPluginCenterLoaderSniperEventBinder != null) {
            this.mPluginCenterLoaderSniperEventBinder.unBindEvent();
        }
    }
}

