/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.plugincenter;

import android.annotation.SuppressLint;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentActivity;
import com.yy.android.small.Small;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.android.sniper.api.event.EventCompat;
import com.yy.mobile.RxBus;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.plugin.Plugins;
import com.yy.mobile.plugin.main.events.IAuthClient_onKickOff_EventArgs;
import com.yy.mobile.plugin.main.events.IAuthClient_onLoginSucceed_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_onChannelCurrentLoginRolers_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_onChannelRolesChange_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_onChannelTuoRenChanged_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_onJoinChannelSuccess_EventArgs;
import com.yy.mobile.plugin.main.events.IConnectivityClient_onConnectivityChange_EventArgs;
import com.yy.mobile.plugin.main.events.IForeBackgroundClient_onBack2foreground_EventArgs;
import com.yy.mobile.plugin.main.events.IForeBackgroundClient_onFore2background_EventArgs;
import com.yy.mobile.plugin.main.events.IPluginCenterClient_notifyStartByPluginId_EventArgs;
import com.yy.mobile.plugin.main.events.IPluginCenterClient_onOwRightChange_EventArgs;
import com.yy.mobile.plugin.manager.CustomPluginManager;
import com.yy.mobile.ui.plugincenter.PluginCenterController$$EventBinder;
import com.yy.mobile.ui.plugincenter.PluginCenterLoader;
import com.yy.mobile.ui.plugincenter.authority.PluginCenterManager;
import com.yy.mobile.ui.plugincenter.event.PluginUpdateFinishEventArgs;
import com.yy.mobile.uniondif.AppIdConfig;
import com.yy.mobile.util.RxUtils;
import com.yy.mobile.util.log.MLog;
import com.yy.small.pluginmanager.OnPluginUpdateFinishListener;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.channel.AdminInfo;
import com.yymobile.core.channel.ChannelInfo;
import com.yymobile.core.channel.ChannelLoginUserPowerInfo;
import com.yymobile.core.plugincenter.IPluginCenterCore;
import com.yymobile.core.plugincenter.PluginCenterProtocol;
import com.yymobile.core.plugincenter.PluginInfo;
import com.yymobile.core.utils.IConnectivityCore;
import com.yymobile.liveapi.plugincenter.SinglePluginInfo;
import com.yymobile.liveapi.plugincenter.event.LoadPluginListener;
import com.yymobile.liveapi.plugincenter.event.PluginCenterMutexEventArgv;
import io.reactivex.Flowable;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Action;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.internal.functions.Functions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;

public enum PluginCenterController implements EventCompat
{
    INSTANCE;

    private static final String TAG = "PluginCenterController";
    private static final int MAX_RETRY_COUNT = 2;
    private PluginCenterLoader mPluginLoader = null;
    private boolean mHasInit = false;
    private boolean needStartLoad = true;
    private boolean isConfigLoad = true;
    private boolean isGetPluginFinish = false;
    private List<Disposable> mDisposableList = new ArrayList<Disposable>();
    private Disposable mActivePluginsDisposable;
    private String mInitTag = "";
    private int configRetryCount = 0;
    private long mTopSid = 0L;
    private long mSubSid = 0L;
    private boolean needRetry = false;
    private long mLastFore2backTimestamp = 0L;
    private EventBinder mPluginCenterControllerSniperEventBinder;

    @Nullable
    public SinglePluginInfo getCurrentActivatedPlugin() {
        return ((IPluginCenterCore)ICoreManagerBase.getCore(IPluginCenterCore.class)).getCurrentActivatedPlugin();
    }

    public boolean isPluginConfigLoad() {
        if (!this.isConfigLoad || !this.isGetPluginFinish) {
            MLog.info((Object)TAG, (String)"isPluginValid false,  isConfigLoad: %b, isGetPluginFinish: %s, ", (Object[])new Object[]{this.isConfigLoad, this.isGetPluginFinish});
            return false;
        }
        return true;
    }

    public void onEventBind() {
        if (this.mPluginCenterControllerSniperEventBinder == null) {
            this.mPluginCenterControllerSniperEventBinder = new PluginCenterController$$EventBinder();
        }
        this.mPluginCenterControllerSniperEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        if (this.mPluginCenterControllerSniperEventBinder != null) {
            this.mPluginCenterControllerSniperEventBinder.unBindEvent();
        }
    }

    public void init(@NotNull String tag, @NotNull FragmentActivity context) {
        MLog.info((Object)TAG, (String)"onEntertaimentTemplateInit begin %s", (Object[])new Object[]{tag});
        this.setCurrentTag(tag);
        ICoreManagerBase.addClient((Object)((Object)this));
        this.onEventBind();
        if (this.mHasInit) {
            ((IPluginCenterCore)ICoreManagerBase.getCore(IPluginCenterCore.class)).clearPluginInfo();
        }
        if (this.mPluginLoader != null) {
            this.mPluginLoader.release();
        }
        this.mPluginLoader = new PluginCenterLoader(context);
        this.mPluginLoader.closePlugin(this.getCurrentActivatedPlugin());
        this.updatePlugins();
        this.registerEvent();
        if (ICoreManagerBase.getChannelLinkCore().getCurrentChannelInfo().topSid != 0L) {
            MLog.info((Object)TAG, (String)"init controller when channel id is not 0, get Plugs", (Object[])new Object[0]);
            this.getPlugs();
        }
        this.mHasInit = true;
        MLog.info((Object)TAG, (String)"onEntertaimentTemplateInit end", (Object[])new Object[0]);
    }

    private void setCurrentTag(@NotNull String tag) {
        MLog.info((Object)TAG, (String)"set tag : mTag= %s, tag = %s", (Object[])new Object[]{this.mInitTag, tag});
        this.mInitTag = tag;
    }

    public void unInit(@NotNull String tag) {
        MLog.info((Object)TAG, (String)"unInit : mInitTag = %s, tag = %s", (Object[])new Object[]{this.mInitTag, tag});
        if (!tag.equals(this.mInitTag)) {
            MLog.warn((Object)TAG, (String)"unInit error : mInitTag = %s, tag = %s", (Object[])new Object[]{this.mInitTag, tag});
            return;
        }
        this.mHasInit = false;
        this.needStartLoad = true;
        this.onEventUnBind();
        ICoreManagerBase.removeClient((Object)((Object)this));
        ((IPluginCenterCore)ICoreManagerBase.getCore(IPluginCenterCore.class)).clearPluginInfo();
        this.closePlugin(this.getCurrentActivatedPlugin());
        this.releaseAllDisposable();
        if (this.mPluginLoader != null) {
            this.mPluginLoader.release();
            this.mPluginLoader = null;
        }
    }

    public boolean loadPlugin(@NotNull SinglePluginInfo plug, Bundle bundle, boolean showLoading) {
        if (this.mPluginLoader != null) {
            this.mPluginLoader.loadPlugin(plug, bundle, showLoading);
        } else {
            MLog.error((Object)TAG, (String)"loadPlugin but pluginLoader is null", (Object[])new Object[0]);
        }
        return this.mPluginLoader != null;
    }

    public Observable<LoadPluginListener.Result> loadPluginFromOutLive(SinglePluginInfo pluginInfo, final boolean showDefaultLoading) {
        if (pluginInfo == null) {
            MLog.error((Object)TAG, (String)"load Plugin, but plugin is null", (Object[])new Object[0]);
            return Observable.empty();
        }
        MLog.info((Object)TAG, (String)"load Plugin showDefaultLoading = %b, pluginInfo androidId = %s", (Object[])new Object[]{showDefaultLoading, pluginInfo.getAndroidId()});
        final SinglePluginInfo plugin = new SinglePluginInfo(pluginInfo, true);
        this.needRetry = true;
        return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<LoadPluginListener.Result>(){

            public void subscribe(final @io.reactivex.annotations.NonNull ObservableEmitter<LoadPluginListener.Result> e) throws Exception {
                plugin.addLoadingListener(new LoadPluginListener(){

                    public void onFinish(SinglePluginInfo pluginInfo, LoadPluginListener.Result result) {
                        if (result == LoadPluginListener.Result.PLUGIN_LOADER_NOT_INIT && PluginCenterController.this.needRetry) {
                            PluginCenterController.this.needRetry = false;
                            PluginCenterController.this.mDisposableList.add(Flowable.timer((long)3L, (TimeUnit)TimeUnit.SECONDS).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<Long>(){

                                public void accept(Long aLong) throws Exception {
                                    MLog.info((Object)PluginCenterController.TAG, (String)"3seconds later to load plugin ", (Object[])new Object[0]);
                                    PluginCenterController.this.loadPlugin(plugin, null, showDefaultLoading);
                                }
                            }, RxUtils.errorConsumer((String)PluginCenterController.TAG)));
                        } else {
                            e.onNext((Object)result);
                            e.onComplete();
                        }
                    }
                });
                if (!PluginCenterController.this.loadPlugin(plugin, null, showDefaultLoading)) {
                    e.onNext((Object)LoadPluginListener.Result.PLUGIN_LOADER_NOT_INIT);
                    e.onComplete();
                }
            }
        }).observeOn(AndroidSchedulers.mainThread());
    }

    public Observable<LoadPluginListener.Result> loadPlugin(SinglePluginInfo pluginInfo, final boolean showDefaultLoading) {
        if (pluginInfo == null) {
            MLog.error((Object)TAG, (String)"load Plugin, but plugin is null", (Object[])new Object[0]);
            return Observable.empty();
        }
        MLog.info((Object)TAG, (String)"load Plugin showDefaultLoading = %b, pluginInfo androidId = %s", (Object[])new Object[]{showDefaultLoading, pluginInfo.getAndroidId()});
        final SinglePluginInfo plugin = new SinglePluginInfo(pluginInfo, true);
        return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<LoadPluginListener.Result>(){

            public void subscribe(final @io.reactivex.annotations.NonNull ObservableEmitter<LoadPluginListener.Result> e) throws Exception {
                plugin.addLoadingListener(new LoadPluginListener(){

                    public void onFinish(SinglePluginInfo pluginInfo, LoadPluginListener.Result result) {
                        e.onNext((Object)result);
                        e.onComplete();
                    }
                });
                if (!PluginCenterController.this.loadPlugin(plugin, null, showDefaultLoading)) {
                    e.onNext((Object)LoadPluginListener.Result.PLUGIN_LOADER_NOT_INIT);
                    e.onComplete();
                }
            }
        }).observeOn(AndroidSchedulers.mainThread());
    }

    private void releaseAllDisposable() {
        for (Disposable disposable2 : this.mDisposableList) {
            if (disposable2 == null || disposable2.isDisposed()) continue;
            disposable2.dispose();
        }
        if (null != this.mActivePluginsDisposable) {
            this.mActivePluginsDisposable.dispose();
        }
    }

    @BusEvent
    public void onNetworkConnectChange(IConnectivityClient_onConnectivityChange_EventArgs event) {
        if (!this.mHasInit) {
            return;
        }
        if (event.getPreviousState() == IConnectivityCore.ConnectivityState.NetworkUnavailable && event.getCurrentState() != IConnectivityCore.ConnectivityState.NetworkUnavailable) {
            this.getPlugs();
        }
    }

    @BusEvent
    public void onFore2BackGround(IForeBackgroundClient_onFore2background_EventArgs eventArgs) {
        this.mLastFore2backTimestamp = System.currentTimeMillis();
    }

    @BusEvent
    public void onBack2ForegroundEvent(IForeBackgroundClient_onBack2foreground_EventArgs eventArgs) {
        IConnectivityCore connectivityCore = (IConnectivityCore)ICoreManagerBase.getCore(IConnectivityCore.class);
        if (null == connectivityCore || !this.mHasInit || connectivityCore.getConnectivityState() != IConnectivityCore.ConnectivityState.NetworkUnavailable) {
            return;
        }
        if (System.currentTimeMillis() - this.mLastFore2backTimestamp >= 60000L) {
            this.getPlugs();
        }
    }

    @BusEvent(sync=true)
    public void onChannelRolesChange(IChannelLinkClient_onChannelRolesChange_EventArgs busEventArgs) {
        long uid = busEventArgs.getUid();
        AdminInfo role = busEventArgs.getRole();
        boolean isUp = busEventArgs.getIsUp();
        MLog.info((Object)TAG, (String)"onChannelRolesChange", (Object[])new Object[0]);
        if (uid == LoginUtil.getUid()) {
            this.getPlugs();
        }
    }

    @BusEvent(sync=true)
    public void onChannelCurrentLoginRolers(IChannelLinkClient_onChannelCurrentLoginRolers_EventArgs busEventArgs) {
        ChannelInfo currentChannelInfo = busEventArgs.getChannelInfo();
        ChannelLoginUserPowerInfo currentChannelLoginUserPowerInfo = busEventArgs.getChannelLoginUserPowerInfo();
        boolean isRequest = busEventArgs.getIsRequest();
        MLog.info((Object)TAG, (String)"onChannelCurrentLoginRolers ", (Object[])new Object[0]);
        this.getPlugs();
    }

    @BusEvent(sync=true)
    public void onKickOff(IAuthClient_onKickOff_EventArgs busEventArgs) {
        byte[] strReason = busEventArgs.getStrReason();
        int uReason = busEventArgs.getUReason();
        MLog.info((Object)TAG, (String)"onChannelCurrentLoginRolers", (Object[])new Object[0]);
        if (this.mHasInit) {
            ((IPluginCenterCore)ICoreManagerBase.getCore(IPluginCenterCore.class)).clearPluginInfo();
            this.getPlugs();
        }
    }

    @BusEvent(sync=true)
    public void onLoginSucceed(IAuthClient_onLoginSucceed_EventArgs busEventArgs) {
        long userId = busEventArgs.getUid();
        MLog.info((Object)TAG, (String)"onLoginSucceed %b", (Object[])new Object[]{this.mHasInit});
        if (this.mHasInit) {
            ((IPluginCenterCore)ICoreManagerBase.getCore(IPluginCenterCore.class)).clearPluginInfo();
            this.getPlugs();
        }
    }

    @BusEvent(sync=true)
    public void onJoinChannelSuccess(IChannelLinkClient_onJoinChannelSuccess_EventArgs busEventArgs) {
        ChannelInfo channelInfo = busEventArgs.getInfo();
        this.onChannelChanged(channelInfo);
    }

    @BusEvent
    public void onChannelTuoRenChanged(IChannelLinkClient_onChannelTuoRenChanged_EventArgs eventArgs) {
        this.onChannelChanged(eventArgs.getInfo());
    }

    private void onChannelChanged(ChannelInfo channelInfo) {
        MLog.info((Object)TAG, (String)"onJoinChannelSuccess %d", (Object[])new Object[]{channelInfo != null ? channelInfo.subSid : 0L});
        if (this.updateCurrentChannel(channelInfo)) {
            ((IPluginCenterCore)ICoreManagerBase.getCore(IPluginCenterCore.class)).clearPluginInfo();
            this.closePlugin(this.getCurrentActivatedPlugin());
        }
        this.needStartLoad = true;
        this.configRetryCount = 0;
        this.getPlugs();
    }

    private boolean updateCurrentChannel(ChannelInfo channelInfo) {
        if (channelInfo == null) {
            MLog.info((Object)TAG, (String)"updateCurrentChannel failed, because channelInfo is null, old topsid: %d, old subsid: %d", (Object[])new Object[]{this.mTopSid, this.mSubSid});
            return false;
        }
        if (channelInfo.topSid != this.mTopSid || channelInfo.subSid != this.mSubSid) {
            MLog.info((Object)TAG, (String)"updateCurrentChannel old topsid: %d, old subsid: %d, new topsid: %d, new subsid: %d", (Object[])new Object[]{this.mTopSid, this.mSubSid, channelInfo.topSid, channelInfo.subSid});
            this.setCurrentChannel(channelInfo);
            return true;
        }
        return false;
    }

    private void setCurrentChannel(ChannelInfo channelInfo) {
        if (channelInfo != null) {
            MLog.info((Object)TAG, (String)"setCurrentChannel old topsid: %d, old subsid: %d, new topsid: %d, new subsid: %d", (Object[])new Object[]{this.mTopSid, this.mSubSid, channelInfo.topSid, channelInfo.subSid});
            this.mTopSid = channelInfo.topSid;
            this.mSubSid = channelInfo.subSid;
        }
    }

    private void loadPlugin(@NotNull SinglePluginInfo info) {
        if (this.mPluginLoader != null) {
            this.mPluginLoader.loadPlugin(info);
        } else {
            MLog.error((Object)TAG, (String)"loadPlugin mPluginLoader is null", (Object[])new Object[0]);
        }
    }

    private void closePlugin(SinglePluginInfo info) {
        if (this.mPluginLoader != null) {
            this.mPluginLoader.closePlugin(info);
        } else {
            MLog.error((Object)TAG, (String)"closePlugin mPluginLoader is null", (Object[])new Object[0]);
        }
    }

    @BusEvent(sync=true)
    public void onOwRightChange(IPluginCenterClient_onOwRightChange_EventArgs busEventArgs) {
        long uid = busEventArgs.getUid();
        long topCid = busEventArgs.getTopCid();
        long subCid = busEventArgs.getSubCid();
        boolean owRights = busEventArgs.getOwRights();
        MLog.info((Object)TAG, (String)"onOwRightChange getPlugins", (Object[])new Object[0]);
        this.getPlugs();
    }

    public void onGetPluginInfo(PluginInfo info) {
        MLog.info((Object)TAG, (String)("onGetPlugins " + info), (Object[])new Object[0]);
        this.isGetPluginFinish = true;
        if (this.needStartLoad) {
            this.needStartLoad = false;
            if (null == info) {
                MLog.info((Object)TAG, (String)"onGetPlugs  info is null", (Object[])new Object[0]);
                return;
            }
            if (this.getCurrentActivatedPlugin() != null) {
                this.loadPlugin(this.getCurrentActivatedPlugin());
            } else {
                IPluginCenterCore core = (IPluginCenterCore)ICoreManagerBase.getCore(IPluginCenterCore.class);
                for (SinglePluginInfo plug : info.plugs) {
                    if (plug.pluginId == AppIdConfig.getAppIds().getYiqiboPluginCenterId()) {
                        MLog.info((Object)TAG, (String)"miss YiqiBo", (Object[])new Object[0]);
                        continue;
                    }
                    if (plug == null || !plug.living || plug.pluginId == Long.MIN_VALUE || core.isNotSupportPlugin(plug.pluginId)) continue;
                    MLog.info((Object)TAG, (String)"Start plugin by plugin center, plugin: %s", (Object[])new Object[]{plug.toString()});
                    if (!this.updateCurrentPluginState(plug, LoadPluginListener.Result.OTHER_PLUGIN_HAD_START, true, false)) break;
                    this.loadPlugin(plug);
                }
            }
        }
    }

    @BusEvent(sync=true)
    public void notifyStartByPluginId(IPluginCenterClient_notifyStartByPluginId_EventArgs busEventArgs) {
        long pluginid = busEventArgs.getPluginid();
        MLog.info((Object)TAG, (String)"notifyStartByAndroidId pluginId: %s", (Object[])new Object[]{pluginid});
        if (this.getCurrentActivatedPlugin() != null) {
            MLog.warn((Object)TAG, (String)"had activated plugin, can not start another plugin : %s", (Object[])new Object[]{pluginid});
            return;
        }
        PluginInfo pluginInfo = ((IPluginCenterCore)ICoreManagerBase.getCore(IPluginCenterCore.class)).getPluginInfo();
        if (pluginInfo == null || pluginInfo.plugs == null) {
            return;
        }
        for (SinglePluginInfo plug : pluginInfo.plugs) {
            if (plug == null || pluginid != plug.pluginId) continue;
            ((IPluginCenterCore)ICoreManagerBase.getCore(IPluginCenterCore.class)).setCurrentActivatedPlugin(plug);
            return;
        }
    }

    private void registerEvent() {
        Disposable disposable2 = RxBus.getDefault().register(PluginCenterMutexEventArgv.class).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<PluginCenterMutexEventArgv>(){

            public void accept(@io.reactivex.annotations.NonNull PluginCenterMutexEventArgv pluginCenterMutexEventArgv) throws Exception {
                MLog.info((Object)PluginCenterController.TAG, (String)"PluginCenterMutexEventArgv ", (Object[])new Object[0]);
                ((IPluginCenterCore)ICoreManagerBase.getCore(IPluginCenterCore.class)).requestSyncPluginState(LoginUtil.getUid(), ICoreManagerBase.getChannelLinkCore().getCurrentChannelInfo().topSid, ICoreManagerBase.getChannelLinkCore().getCurrentChannelInfo().subSid);
            }
        }, RxUtils.errorConsumer((String)TAG, (String)"PluginCenterMutexEventArgv error"));
        this.mDisposableList.add(disposable2);
    }

    @SuppressLint(value={"CheckResult"})
    private void getPlugs() {
        this.isGetPluginFinish = false;
        if (ICoreManagerBase.getChannelLinkCore().getCurrentChannelInfo().topSid > 0L) {
            ((IPluginCenterCore)ICoreManagerBase.getCore(IPluginCenterCore.class)).getPlugins(LoginUtil.getUid(), ICoreManagerBase.getChannelLinkCore().getCurrentChannelInfo().topSid, ICoreManagerBase.getChannelLinkCore().getCurrentChannelInfo().subSid).retry(2L).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<PluginInfo>(){

                public void accept(PluginInfo pluginInfo) throws Exception {
                    MLog.info((Object)PluginCenterController.TAG, (String)"getPlugins success", (Object[])new Object[0]);
                    PluginCenterController.this.onGetPluginInfo(pluginInfo);
                }
            }, (Consumer)new Consumer<Throwable>(){

                public void accept(Throwable throwable) throws Exception {
                    if (PluginCenterController.this.getCurrentActivatedPlugin() != null) {
                        PluginCenterController.this.updateCurrentPluginState(PluginCenterController.this.getCurrentActivatedPlugin(), LoadPluginListener.Result.GET_PLUGIN_INFO_FAILED, true, true);
                    }
                    MLog.error((Object)PluginCenterController.TAG, (String)"getPlugins error ", (Throwable)throwable, (Object[])new Object[0]);
                }
            });
        } else {
            MLog.info((Object)TAG, (String)"getPlugs error topSid=0", (Object[])new Object[0]);
        }
    }

    @BusEvent(busType=1, busName="Live")
    public void onPluginOpen(PluginCenterProtocol.PluginOpenRsp pluginOpenInfo) {
        MLog.info((Object)TAG, (String)"onPluginOpenRsp : %s", (Object[])new Object[]{pluginOpenInfo.toString()});
        if (this.mPluginLoader != null) {
            this.mPluginLoader.onPluginOpen(pluginOpenInfo);
        }
    }

    @BusEvent(busType=1, busName="Live")
    public void onPluginUpdateFinish(PluginUpdateFinishEventArgs event) {
        boolean result = event.getResult();
        MLog.info((Object)TAG, (String)("small load config result =" + result), (Object[])new Object[0]);
        if (result) {
            if (!this.isConfigLoad) {
                this.isConfigLoad = true;
                if (this.mPluginLoader != null) {
                    this.mPluginLoader.loadPlugin(this.getCurrentActivatedPlugin());
                } else {
                    MLog.error((Object)TAG, (String)"onPluginUpdateFinish mPluginLoader is null", (Object[])new Object[0]);
                }
            }
            this.activePluginWhenDownload();
        } else {
            MLog.info((Object)TAG, (String)("configRetryCount=" + this.configRetryCount), (Object[])new Object[0]);
            if (this.configRetryCount < 2) {
                this.updatePlugins();
            } else if (!this.isConfigLoad && this.getCurrentActivatedPlugin() != null) {
                this.updateCurrentPluginState(this.getCurrentActivatedPlugin(), LoadPluginListener.Result.SMALL_CONFIG_UPDATE_FAIL, true, true);
            }
            ++this.configRetryCount;
        }
    }

    private void activePluginWhenDownload() {
        if (this.mActivePluginsDisposable != null && !this.mActivePluginsDisposable.isDisposed()) {
            return;
        }
        List activePlugins = ((IPluginCenterCore)ICoreManagerBase.getCore(IPluginCenterCore.class)).getActivePluginsWhenDownload();
        if (null == activePlugins || activePlugins.isEmpty()) {
            return;
        }
        this.mActivePluginsDisposable = Flowable.mergeDelayError((Publisher)Flowable.fromIterable((Iterable)activePlugins).map((Function)new Function<Plugins, Flowable<Boolean>>(){

            public Flowable<Boolean> apply(Plugins plugins) throws Exception {
                return CustomPluginManager.INSTANCE.activePlugin(plugins.pluginId(), PluginCenterController.TAG, false);
            }
        })).doOnComplete(new Action(){

            public void run() throws Exception {
                MLog.info((Object)PluginCenterController.TAG, (String)"activePluginsWhenDownload complete", (Object[])new Object[0]);
            }
        }).doOnError((Consumer)new Consumer<Throwable>(){

            public void accept(Throwable throwable) throws Exception {
                MLog.error((Object)PluginCenterController.TAG, (String)("activePluginsWhenDownload:" + throwable), (Object[])new Object[0]);
            }
        }).subscribe(Functions.emptyConsumer(), RxUtils.errorConsumer((String)TAG));
    }

    private void updatePlugins() {
        MLog.info((Object)TAG, (String)"small loadConfig", (Object[])new Object[0]);
        Small.addUpdatePluginsRequest(Collections.singletonList(2), (OnPluginUpdateFinishListener)PluginCenterManager.INSTANCE);
    }

    public boolean updateCurrentPluginState(@NonNull SinglePluginInfo plugin, @Nullable LoadPluginListener.Result mayResult, boolean isDefaultListener, boolean isDefaultTimeout) {
        if (this.mPluginLoader != null) {
            return this.mPluginLoader.updateCurrentPluginState(plugin, mayResult, isDefaultListener, isDefaultTimeout);
        }
        MLog.error((Object)TAG, (String)"updateCurrentPluginState mPluginLoader is null", (Object[])new Object[0]);
        return false;
    }

    public long getCurrentActivatedPluginId() {
        try {
            return this.getCurrentActivatedPlugin().pluginId;
        }
        catch (Exception e) {
            return 0L;
        }
    }
}

