/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.meidabasicvideoview.compat.mixlayout.layoutparser.vertical;

import android.content.Context;
import com.yy.mobile.sdkwrapper.flowmanagement.base.entity.VideoRect;
import com.yy.mobile.sdkwrapper.flowmanagement.base.entity.VideoScaleMode;
import com.yy.mobile.sdkwrapper.flowmanagement.base.entity.VideoSizeInfo;
import com.yy.mobile.ui.meidabasicvideoview.MediaVideoViewSite;
import com.yy.mobile.ui.meidabasicvideoview.compat.mixlayout.layoutparser.AbsVideoLayoutParser;
import com.yy.mobile.ui.meidabasicvideoview.compat.mixlayout.layoutparser.VideoLayoutConstants;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.log.MLog;
import java.util.ArrayList;
import java.util.List;

public class Vertical4V3Parser
extends AbsVideoLayoutParser {
    private static final String TAG = "Vertical4V3Parser";

    @Override
    public String getLogTag() {
        return TAG;
    }

    @Override
    public boolean intercept(VideoSizeInfo sizeInfo) {
        return sizeInfo.isVerticalOrientation && (sizeInfo.height <= sizeInfo.width || sizeInfo.isMixture && sizeInfo.videoCount == 2 && sizeInfo.width != 544 && sizeInfo.height != 960);
    }

    @Override
    public VideoRect calculateVideoViewRect(Context context, VideoSizeInfo sizeInfo) {
        float scale = (float)sizeInfo.height / (float)sizeInfo.width;
        scale = (double)scale <= 0.75 ? scale : 0.75f;
        int offsetY = (int)((double)sizeInfo.parentWidth * (0.75 - (double)scale) / 2.0);
        VideoRect videoRect = new VideoRect();
        videoRect.videoScaleMode = this.getScaleMode(sizeInfo);
        videoRect.left = 0;
        videoRect.top = (int)ResolutionUtils.convertDpToPixel((float)VideoLayoutConstants.DEFAULT_VIDEO_TOP, (Context)context) + offsetY;
        videoRect.width = sizeInfo.parentWidth;
        videoRect.height = (int)(scale * (float)videoRect.width);
        return videoRect;
    }

    private VideoScaleMode getScaleMode(VideoSizeInfo sizeInfo) {
        if (sizeInfo.width == 800 && sizeInfo.height == 608 || sizeInfo.width == 800 && sizeInfo.height == 600) {
            return VideoScaleMode.CLIP_TO_BOUNDS;
        }
        return VideoScaleMode.ASPECT_FIT;
    }

    @Override
    public List<MediaVideoViewSite> calculateMediaVideoViewSiteCompat(Context context, VideoSizeInfo sizeInfo) {
        ArrayList<MediaVideoViewSite> list2 = new ArrayList<MediaVideoViewSite>();
        if (sizeInfo.videoCount == 0) {
            MLog.error((Object)TAG, (String)"calculateMediaVideoViewSiteCompat: video count is zero, bug!!!", (Object[])new Object[0]);
            return list2;
        }
        MediaVideoViewSite firstVideo = this.createMediaVideoViewSite(0, (int)ResolutionUtils.convertDpToPixel((float)VideoLayoutConstants.DEFAULT_VIDEO_TOP, (Context)context), sizeInfo.parentWidth / sizeInfo.videoCount, (int)(0.75 * (double)sizeInfo.parentWidth), 1);
        list2.add(firstVideo);
        if (sizeInfo.videoCount > 1) {
            MediaVideoViewSite secondVideo = this.createMediaVideoViewSite(sizeInfo.parentWidth / 2, (int)ResolutionUtils.convertDpToPixel((float)VideoLayoutConstants.DEFAULT_VIDEO_TOP, (Context)context), sizeInfo.parentWidth / sizeInfo.videoCount, (int)(0.75 * (double)sizeInfo.parentWidth), 1);
            list2.add(secondVideo);
        }
        return list2;
    }
}

