/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.gift;

import android.app.Activity;
import android.content.Context;
import android.graphics.Rect;
import android.graphics.RectF;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.bumptech.glide.Glide;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.android.sniper.api.event.EventCompat;
import com.yy.hiidostatis.api.HiidoSDK;
import com.yy.mobile.RxBus;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.plugin.main.events.IWebViewClient_closeActWindow_EventArgs;
import com.yy.mobile.plugin.main.events.IWebViewClient_openActWindow_EventArgs;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.gift.SceneGiftController$$EventBinder;
import com.yy.mobile.ui.gift.SceneGiftSVGAController;
import com.yy.mobile.ui.gift.core.IGiftUICore;
import com.yy.mobile.ui.gift.guid.ScenePacketTips;
import com.yy.mobile.ui.utils.AbstractViewController;
import com.yy.mobile.ui.utils.CommonWebPopupComponent;
import com.yy.mobile.ui.utils.DensityUtil;
import com.yy.mobile.ui.utils.ViewUtils;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.RxUtils;
import com.yy.mobile.util.ScreenUtil;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.basechannel.IChannelLinkCore;
import com.yymobile.core.scenepacket.IScenePacketCore;
import com.yymobile.core.scenepacket.SceneGiftConfig;
import com.yymobile.core.scenepacket.ScenePacketQueryNotifyEventArgs;
import com.yyproto.utils.FP;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.functions.Consumer;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import org.json.JSONException;
import org.json.JSONObject;

public class SceneGiftController
extends AbstractViewController
implements EventCompat {
    private boolean mIsLandscape = false;
    private static final String TAG = "SceneGiftController";
    public static final String UrlPloyParmaKey = "&magicPacketPloy=";
    private static final int WED_DIALOG_WIDTH = ScreenUtil.getInstance().dip2px(260);
    private static final int WEB_DIALOG_HEIGHT = ScreenUtil.getInstance().dip2px(316);
    private static final int NEED_SHOW = 1;
    private ViewGroup mContainer;
    protected ImageView mSceneGiftIcon;
    private CommonWebPopupComponent mWebDialog;
    private ScenePacketTips mScenePacketTips;
    private SceneGiftSVGAController mSceneGiftSVGAController;
    private int mSceneType;
    private String mWebUrl;
    private String mTipStr;
    private long mTipShowDuration;
    private boolean mIsCreated;
    private CompositeDisposable mCompositeDisposable = new CompositeDisposable();
    private Runnable mTipsShowDelayRunnable = new Runnable(){

        @Override
        public void run() {
            if (SceneGiftController.this.tipsIntercept()) {
                return;
            }
            if (SceneGiftController.this.mSceneType != 0) {
                ((IScenePacketCore)ICoreManagerBase.getCore(IScenePacketCore.class)).ensureIconTipsShown(SceneGiftController.this.mSceneType);
            }
            SceneGiftController.this.showScenePacketTip(SceneGiftController.this.mTipStr, SceneGiftController.this.mTipShowDuration, new View.OnClickListener(){

                public void onClick(View v) {
                    SceneGiftController.this.hideScenePacketTips();
                    SceneGiftController.this.callSceneGiftIconClick();
                }
            });
        }
    };
    SvgaDelayPlayRunnable mSvgaDelayPlayRunnable;
    private Runnable mAutoWebDialogShowRunnable = new Runnable(){

        @Override
        public void run() {
            if (((IChannelLinkCore)ICoreManagerBase.getCore(IChannelLinkCore.class)).isGameTeplate()) {
                HiidoSDK.instance().reportTimesEvent(LoginUtil.getUid(), "55101", "0014");
            }
            if (SceneGiftController.this.mSceneType != 0) {
                ((IScenePacketCore)ICoreManagerBase.getCore(IScenePacketCore.class)).ensureAutoWebShown(SceneGiftController.this.mSceneType);
            }
            StringBuilder sb = new StringBuilder(SceneGiftController.this.mWebUrl);
            sb.append("&autopopup=1");
            String ploy = ((IScenePacketCore)ICoreManagerBase.getCore(IScenePacketCore.class)).getPloyInfo(SceneGiftController.this.mSceneType);
            if (!StringUtils.isEmpty((String)ploy).booleanValue()) {
                sb.append(SceneGiftController.UrlPloyParmaKey).append(ploy);
            }
            SceneGiftController.this.mWebUrl = sb.toString();
            SceneGiftController.this.webDialogShow(true);
        }
    };
    private Runnable mIconVisibleRunnable = new Runnable(){

        @Override
        public void run() {
            SceneGiftController.this.mSceneGiftIcon.setVisibility(0);
        }
    };
    private EventBinder mSceneGiftControllerSniperEventBinder;

    public void onEventBind() {
        super.onEventBind();
        if (this.mSceneGiftControllerSniperEventBinder == null) {
            this.mSceneGiftControllerSniperEventBinder = new SceneGiftController$$EventBinder();
        }
        this.mSceneGiftControllerSniperEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        super.onEventUnBind();
        if (this.mSceneGiftControllerSniperEventBinder != null) {
            this.mSceneGiftControllerSniperEventBinder.unBindEvent();
        }
    }

    protected void onCreatePrepare(Bundle savedInstanceState) {
        super.onCreatePrepare(savedInstanceState);
        this.isInitHidden = true;
    }

    protected View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.mContainer = container;
        return inflater.inflate(R.layout.layout_scene_gift, container, false);
    }

    protected void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.mSceneGiftIcon = (ImageView)view.findViewById(R.id.gift_icon);
        this.onOrientationChanged(this.isLandScape());
        this.mIsCreated = true;
    }

    protected void onOrientationChanged(boolean isLandscape) {
        this.mIsLandscape = isLandscape;
        if (this.mRootView.getLayoutParams() instanceof RelativeLayout.LayoutParams) {
            RelativeLayout.LayoutParams lp = (RelativeLayout.LayoutParams)this.mRootView.getLayoutParams();
            lp.addRule(12);
            lp.addRule(11);
            Rect rect = ((IGiftUICore)ICoreManagerBase.getCore(IGiftUICore.class)).getGiftIconPosition();
            int sw = ResolutionUtils.getScreenWidth((Context)this.getActivity());
            if (((IChannelLinkCore)ICoreManagerBase.getCore(IChannelLinkCore.class)).isGameTeplate()) {
                if (rect != null) {
                    if (isLandscape) {
                        lp.width = DensityUtil.dip2px((Context)this.getActivity(), (float)36.0f);
                        lp.height = DensityUtil.dip2px((Context)this.getActivity(), (float)36.0f);
                        lp.rightMargin = DensityUtil.dip2px((Context)this.getActivity(), (float)56.0f);
                        lp.bottomMargin = DensityUtil.dip2px((Context)this.getActivity(), (float)8.0f);
                    } else {
                        lp.width = DensityUtil.dip2px((Context)this.getActivity(), (float)32.0f);
                        lp.height = DensityUtil.dip2px((Context)this.getActivity(), (float)32.0f);
                        lp.rightMargin = DensityUtil.dip2px((Context)this.getActivity(), (float)10.0f) + (sw - rect.left);
                        lp.bottomMargin = DensityUtil.dip2px((Context)this.getActivity(), (float)6.0f);
                    }
                }
            } else if (rect != null) {
                lp.width = DensityUtil.dip2px((Context)this.getActivity(), (float)36.0f);
                lp.height = DensityUtil.dip2px((Context)this.getActivity(), (float)36.0f);
                if (isLandscape) {
                    lp.rightMargin = DensityUtil.dip2px((Context)this.getActivity(), (float)8.0f);
                    lp.bottomMargin = DensityUtil.dip2px((Context)this.getActivity(), (float)54.0f);
                } else {
                    lp.rightMargin = DensityUtil.dip2px((Context)this.getActivity(), (float)10.0f) + (sw - rect.left);
                    lp.bottomMargin = DensityUtil.dip2px((Context)this.getActivity(), (float)8.0f);
                }
            }
            this.mRootView.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                public void onGlobalLayout() {
                    SceneGiftController.this.mRootView.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    RectF iconRect = new RectF((float)SceneGiftController.this.mRootView.getLeft(), (float)SceneGiftController.this.mRootView.getTop(), (float)SceneGiftController.this.mRootView.getRight(), (float)SceneGiftController.this.mRootView.getBottom());
                    ((IScenePacketCore)ICoreManagerBase.getCore(IScenePacketCore.class)).setSceneIconRect(iconRect);
                }
            });
            this.mRootView.requestLayout();
        }
        if (null != this.mScenePacketTips) {
            this.mScenePacketTips.orientationChanged(isLandscape);
        }
        if (null != this.mSceneGiftSVGAController) {
            this.mSceneGiftSVGAController.orientationChanged(isLandscape);
        }
    }

    public void hide() {
        super.hide();
        this.hideScenePacketTips();
        this.stopSceneGiftSvgaAnim();
    }

    @BusEvent
    public void closeActWindow(IWebViewClient_closeActWindow_EventArgs busEventArgs) {
        String params = busEventArgs.getParams();
        MLog.info((Object)"cyy", (String)("params=" + params), (Object[])new Object[0]);
        String paramData = null;
        if (!com.yy.mobile.util.FP.empty((CharSequence)params) && !params.equals("{}")) {
            try {
                JSONObject paramObj = new JSONObject(params);
                paramData = paramObj.getString("from");
            }
            catch (JSONException e) {
                MLog.error((Object)TAG, (Throwable)e);
            }
        }
        if (this.mWebDialog != null && FP.empty(paramData)) {
            this.mWebDialog.hide();
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        this.mIsCreated = false;
        this.mSceneType = 0;
        this.mTipShowDuration = 0L;
        this.mWebUrl = null;
        this.hideScenePacketTips();
        if (null != this.mScenePacketTips) {
            this.mScenePacketTips.dismiss();
            this.mScenePacketTips.destroy();
        }
        if (null != this.mSceneGiftSVGAController) {
            this.mSceneGiftSVGAController.dismiss();
            this.mSceneGiftSVGAController.destroy();
        }
        this.mCompositeDisposable.clear();
    }

    public void setSenceType(int sceneType) {
        if (this.mSceneType != sceneType) {
            this.mSceneType = sceneType;
            this.updateView();
        }
    }

    public void updateView() {
        MLog.debug((Object)TAG, (String)("updateView type:" + this.mSceneType), (Object[])new Object[0]);
        if (!this.mIsCreated) {
            return;
        }
        this.mSceneGiftIcon.setVisibility(0);
        this.mSceneGiftIcon.setOnClickListener(null);
        this.hideScenePacketTips();
        this.stopSceneGiftSvgaAnim();
        this.getHandler().removeCallbacks(this.mIconVisibleRunnable);
        if (this.mSceneType == 0) {
            this.hide();
            return;
        }
        Map scenePacketInfoMap = ((IScenePacketCore)ICoreManagerBase.getCore(IScenePacketCore.class)).getScenePacketInfoByType(this.mSceneType);
        if (!scenePacketInfoMap.isEmpty()) {
            int showFlag;
            String svgaUrl;
            this.mWebUrl = (String)scenePacketInfoMap.get("webURL");
            this.mTipStr = (String)scenePacketInfoMap.get("tips");
            try {
                this.mTipShowDuration = Long.valueOf((String)scenePacketInfoMap.get("showTime"));
                this.mTipShowDuration *= 1000L;
            }
            catch (Exception e) {
                MLog.warn((Object)TAG, (String)e.getMessage(), (Object[])new Object[0]);
            }
            long tipShowDelayTime = 1000L;
            try {
                tipShowDelayTime = Long.valueOf((String)scenePacketInfoMap.get("waitTime"));
            }
            catch (Exception e) {
                MLog.warn((Object)TAG, (String)e.getMessage(), (Object[])new Object[0]);
            }
            final String iconURL = (String)scenePacketInfoMap.get("iconURL");
            MLog.info((Object)TAG, (String)(" scene packet info webURL :" + this.mWebUrl + " tips :" + this.mTipStr + " iconURL :" + iconURL), (Object[])new Object[0]);
            if (!TextUtils.isEmpty((CharSequence)this.mWebUrl)) {
                this.mCompositeDisposable.add(ViewUtils.clicks((View)this.mSceneGiftIcon, (long)500L).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<Object>(){

                    public void accept(Object o) throws Exception {
                        if (((IChannelLinkCore)ICoreManagerBase.getCore(IChannelLinkCore.class)).isGameTeplate()) {
                            HiidoSDK.instance().reportTimesEvent(LoginUtil.getUid(), "55101", "0014");
                        }
                        SceneGiftController.this.getHandler().removeCallbacks(SceneGiftController.this.mAutoWebDialogShowRunnable);
                        SceneGiftController.this.hideScenePacketTips();
                        SceneGiftController.this.callSceneGiftIconClick();
                    }
                }, RxUtils.errorConsumer((String)TAG, (String)"click exception")));
                this.autoShowWebDialog();
            }
            this.mSceneGiftIcon.setImageResource(R.drawable.ic_scene_gift_default);
            if (!TextUtils.isEmpty((CharSequence)iconURL)) {
                this.getHandler().post(new Runnable(){

                    @Override
                    public void run() {
                        if (SceneGiftController.this.checkActivityValid()) {
                            Glide.with((Activity)SceneGiftController.this.getActivity()).load(iconURL).into(SceneGiftController.this.mSceneGiftIcon);
                        }
                    }
                });
            }
            if (!TextUtils.isEmpty((CharSequence)this.mTipStr)) {
                int showFlag2 = ((IScenePacketCore)ICoreManagerBase.getCore(IScenePacketCore.class)).queryIconTipsShownFlagByType(this.mSceneType);
                MLog.info((Object)TAG, (String)"showFlag: %d , sceneType:%d", (Object[])new Object[]{showFlag2, this.mSceneType});
                if (showFlag2 == 1) {
                    this.getHandler().removeCallbacks(this.mTipsShowDelayRunnable);
                    this.getHandler().postDelayed(this.mTipsShowDelayRunnable, tipShowDelayTime * 1000L);
                }
            }
            if (!FP.empty((CharSequence)(svgaUrl = (String)scenePacketInfoMap.get(SceneGiftConfig.AnimeUrlKey))) && (showFlag = ((IScenePacketCore)ICoreManagerBase.getCore(IScenePacketCore.class)).queryIconSvgaIsPlayedByType(this.mSceneType)) == 1) {
                if (this.mSvgaDelayPlayRunnable == null) {
                    this.mSvgaDelayPlayRunnable = new SvgaDelayPlayRunnable();
                }
                this.mSvgaDelayPlayRunnable.setSvgaUrl(svgaUrl);
                int delayTime = StringUtils.safeParseInt((String)((String)scenePacketInfoMap.get(SceneGiftConfig.AnimDelayTime)));
                this.getHandler().removeCallbacks((Runnable)this.mSvgaDelayPlayRunnable);
                this.getHandler().postDelayed((Runnable)this.mSvgaDelayPlayRunnable, (long)(delayTime * 1000));
            }
        }
    }

    protected void autoShowWebDialog() {
        boolean isAuto;
        Map scenePacketInfoMap;
        int showFlag = ((IScenePacketCore)ICoreManagerBase.getCore(IScenePacketCore.class)).queryAutoWebShowFlagByType(this.mSceneType);
        if (showFlag == 1 && !(scenePacketInfoMap = ((IScenePacketCore)ICoreManagerBase.getCore(IScenePacketCore.class)).getScenePacketInfoByType(this.mSceneType)).isEmpty() && scenePacketInfoMap.containsKey(SceneGiftConfig.SceneGiftWebDilaogAutoShowKey) && (isAuto = StringUtils.safeParseBoolean((String)((String)scenePacketInfoMap.get(SceneGiftConfig.SceneGiftWebDilaogAutoShowKey))))) {
            int autoDelayTime = StringUtils.safeParseInt((String)((String)scenePacketInfoMap.get(SceneGiftConfig.PacketWaitTimeKey)));
            this.getHandler().removeCallbacks(this.mAutoWebDialogShowRunnable);
            int delayTime = autoDelayTime * 1000;
            if (delayTime == 0) {
                this.webDialogShowByNow();
            } else {
                this.getHandler().postDelayed(this.mAutoWebDialogShowRunnable, (long)delayTime);
            }
        }
    }

    private void webDialogShowByNow() {
        if (((IScenePacketCore)ICoreManagerBase.getCore(IScenePacketCore.class)).isSceneGiftFinish()) {
            this.noticeToast("\u793c\u5305\u9886\u53d6\u5b8c");
            this.hide();
        } else {
            if (this.mSceneType != 0) {
                ((IScenePacketCore)ICoreManagerBase.getCore(IScenePacketCore.class)).ensureAutoWebShown(this.mSceneType);
            }
            StringBuilder sb = new StringBuilder(this.mWebUrl);
            sb.append("&autopopup=1");
            String ploy = ((IScenePacketCore)ICoreManagerBase.getCore(IScenePacketCore.class)).getPloyInfo(this.mSceneType);
            if (!StringUtils.isEmpty((String)ploy).booleanValue()) {
                sb.append(UrlPloyParmaKey).append(ploy);
            }
            this.showWebDialog(sb.toString(), true);
            this.recordFirstRechargePacketPageShownCount();
        }
    }

    private int webDialogShow(final boolean isContainerAutoPopup) {
        ((IScenePacketCore)ICoreManagerBase.getCore(IScenePacketCore.class)).queryScenePacketInfo();
        final int curSceneType = this.mSceneType;
        this.mCompositeDisposable.add(RxBus.getDefault().register(ScenePacketQueryNotifyEventArgs.class).observeOn(AndroidSchedulers.mainThread()).timeout(10L, TimeUnit.SECONDS).firstOrError().toMaybe().subscribe((Consumer)new Consumer<ScenePacketQueryNotifyEventArgs>(){

            public void accept(@io.reactivex.annotations.NonNull ScenePacketQueryNotifyEventArgs scenePacketNotifyEventArgs) throws Exception {
                if (scenePacketNotifyEventArgs.getType() == 0) {
                    SceneGiftController.this.noticeToast("\u793c\u5305\u9886\u53d6\u5b8c");
                    SceneGiftController.this.hide();
                } else if (curSceneType == scenePacketNotifyEventArgs.getType()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(SceneGiftController.this.mWebUrl);
                    String ploy = ((IScenePacketCore)ICoreManagerBase.getCore(IScenePacketCore.class)).getPloyInfo(SceneGiftController.this.mSceneType);
                    if (!StringUtils.isEmpty((String)ploy).booleanValue()) {
                        sb.append(SceneGiftController.UrlPloyParmaKey).append(ploy);
                    }
                    SceneGiftController.this.showWebDialog(sb.toString(), isContainerAutoPopup);
                    SceneGiftController.this.recordFirstRechargePacketPageShownCount();
                } else {
                    MLog.info((Object)SceneGiftController.TAG, (String)"update scene icon", (Object[])new Object[0]);
                }
            }
        }, RxUtils.errorConsumer((String)TAG, (String)"ScenePacketQuery exception")));
        return curSceneType;
    }

    private void callSceneGiftIconClick() {
        int curSceneType = this.webDialogShow(false);
    }

    protected int setDialogAnimationId() {
        int animationId = ((IChannelLinkCore)ICoreManagerBase.getCore(IChannelLinkCore.class)).isGameTeplate() ? (this.mIsLandscape ? R.style.LandScapeGameCustomDialogAnimation : R.style.GameCustomDialogAnimation) : (this.mIsLandscape ? R.style.LandScapeCustomDialogAnimation : R.style.CustomDialogAnimation);
        return animationId;
    }

    private void showWebDialog(@NonNull String webUrl, boolean isContainerAutoPopup) {
        MLog.info((Object)TAG, (String)("show webDialog url :" + webUrl), (Object[])new Object[0]);
        if (!this.mIsCreated) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)webUrl)) {
            return;
        }
        if (this.mWebDialog == null) {
            this.mWebDialog = new CommonWebPopupComponent();
        }
        if (this.mWebDialog.isShowing()) {
            return;
        }
        int animationId = this.setDialogAnimationId();
        this.mWebDialog.setUrl(webUrl).setWidth(WED_DIALOG_WIDTH).setHeight(WEB_DIALOG_HEIGHT).setBackground(true).setBackgroundTransparent(true).setCanceledOnTouchOutside(true).setGravity(17).setWebViewEventListener(null).setWindowAnimationId(animationId).show(this.getSupportFragmentManager(), "SenceGiftWebDialogTag");
    }

    private void recordFirstRechargePacketPageShownCount() {
        if (this.mSceneType == 1) {
            int count = ((IScenePacketCore)ICoreManagerBase.getCore(IScenePacketCore.class)).queryFirstRechargePacketPageShownCount();
            ((IScenePacketCore)ICoreManagerBase.getCore(IScenePacketCore.class)).recordFirstRechargePacketPageShownCount(++count);
        }
    }

    private void showScenePacketTip(@NonNull String tip, long duration, @NonNull View.OnClickListener listener2) {
        if (!this.mIsCreated) {
            return;
        }
        if (null == this.mScenePacketTips) {
            this.mScenePacketTips = this.creatScenePacketTips();
            this.mScenePacketTips.attach(this.getActivity());
            this.mScenePacketTips.create(null, this.mContainer);
        } else if (this.mScenePacketTips.isDetached()) {
            this.mScenePacketTips.attach(this.getActivity());
            this.mScenePacketTips.create(null, this.mContainer);
        }
        this.mScenePacketTips.setTipsMsg(tip);
        this.mScenePacketTips.setDuration(duration);
        this.mScenePacketTips.setOnClickListener(listener2);
        this.mScenePacketTips.show();
    }

    protected void hideScenePacketTips() {
        if (!this.mIsCreated) {
            return;
        }
        this.getHandler().removeCallbacks(this.mTipsShowDelayRunnable);
        if (null != this.mScenePacketTips) {
            this.mScenePacketTips.hide();
            this.mScenePacketTips.setOnClickListener(null);
            this.mScenePacketTips.setTipsMsg(null);
            this.mScenePacketTips.setDuration(0L);
        }
    }

    protected ScenePacketTips creatScenePacketTips() {
        return new ScenePacketTips();
    }

    protected boolean tipsIntercept() {
        return this.mRootView == null || this.mRootView.getVisibility() != 0;
    }

    @BusEvent
    public void openActWindow(IWebViewClient_openActWindow_EventArgs busEventArgs) {
        if (this.mSceneType == 1) {
            this.recordFirstRechargePacketPageShownCount();
        }
    }

    protected void playSceneGiftSvgaAnim(@NonNull String url) {
        MLog.info((Object)TAG, (String)("playSceneGiftSvgaAnim url :" + url), (Object[])new Object[0]);
        if (!this.mIsCreated) {
            return;
        }
        if (null == this.mSceneGiftSVGAController) {
            this.mSceneGiftSVGAController = new SceneGiftSVGAController();
            this.mSceneGiftSVGAController.attach(this.getActivity());
            this.mSceneGiftSVGAController.create(null, this.mContainer);
        } else if (this.mSceneGiftSVGAController.isDetached()) {
            this.mSceneGiftSVGAController.attach(this.getActivity());
            this.mSceneGiftSVGAController.create(null, this.mContainer);
        }
        this.mSceneGiftSVGAController.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SceneGiftController.this.callSceneGiftIconClick();
            }
        });
        this.mSceneGiftSVGAController.show();
        final int curType = this.mSceneType;
        if (!FP.empty((CharSequence)url)) {
            this.mSceneGiftIcon.setVisibility(4);
            this.mSceneGiftSVGAController.playSvgaAnim(url, new Function0<Unit>(){

                public Unit invoke() {
                    if (SceneGiftController.this.checkActivityValid()) {
                        if (curType == SceneGiftController.this.mSceneType) {
                            Map mScenePacketInfoMap;
                            SceneGiftController.this.mSceneGiftIcon.setVisibility(4);
                            if (SceneGiftController.this.mSceneType != 0) {
                                ((IScenePacketCore)ICoreManagerBase.getCore(IScenePacketCore.class)).ensureSvgaShown(SceneGiftController.this.mSceneType);
                            }
                            if (!(mScenePacketInfoMap = ((IScenePacketCore)ICoreManagerBase.getCore(IScenePacketCore.class)).getScenePacketInfoByType(SceneGiftController.this.mSceneType)).isEmpty()) {
                                long svgaDuraton = StringUtils.safeParseLong((String)((String)mScenePacketInfoMap.get(SceneGiftConfig.AnimeShowTimeKey))) * 1000L;
                                SceneGiftController.this.getHandler().removeCallbacks(SceneGiftController.this.mIconVisibleRunnable);
                                SceneGiftController.this.getHandler().postDelayed(SceneGiftController.this.mIconVisibleRunnable, svgaDuraton);
                            }
                        } else {
                            SceneGiftController.this.mSceneGiftIcon.setVisibility(0);
                        }
                    }
                    return null;
                }
            }, new Function0<Unit>(){

                public Unit invoke() {
                    SceneGiftController.this.mSceneGiftIcon.setVisibility(0);
                    return null;
                }
            });
        }
    }

    protected void stopSceneGiftSvgaAnim() {
        if (!this.mIsCreated) {
            return;
        }
        if (null != this.mSceneGiftSVGAController) {
            this.mSceneGiftSVGAController.hide();
            this.mSceneGiftSVGAController.stopSvgaAnim();
        }
    }

    class SvgaDelayPlayRunnable
    implements Runnable {
        private String svgaUrl;

        SvgaDelayPlayRunnable() {
        }

        public void setSvgaUrl(String svgaUrl) {
            this.svgaUrl = svgaUrl;
        }

        @Override
        public void run() {
            SceneGiftController.this.playSceneGiftSvgaAnim(this.svgaUrl);
        }
    }
}

