/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.gift;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.os.Handler;
import android.support.v4.view.PagerAdapter;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.RequestOptions;
import com.unionyy.mobile.spdt.Spdt;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.image.ImageConfig;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.basicchanneltemplate.Temp;
import com.yy.mobile.ui.discount.IDiscountCore;
import com.yy.mobile.ui.gift.utils.GiftViewCornerUtil;
import com.yy.mobile.ui.gift.widget.BagLayout;
import com.yy.mobile.ui.redpacket.RedPacketItem;
import com.yy.mobile.ui.weekstar.WeekStarController;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.flower.FlowerInfo;
import com.yymobile.core.flower.IFlowerCore;
import com.yymobile.core.gift.GiftConfigItemBase;
import com.yymobile.core.gift.GiftConfigParser;
import com.yymobile.core.gift.IGiftCore;
import com.yymobile.core.statistic.IHiidoStatisticCore;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class GiftItemPagerAdapter
extends PagerAdapter
implements View.OnClickListener {
    private static final String TAG = "GiftItemPagerAdapter";
    public final int countPerRowPortrait = 4;
    public final int countPerRowLandscape = 7;
    public final int rowCountPortrait = 2;
    public final int rowCountLandscape = 1;
    Map<Integer, Boolean> selectedPages = new HashMap<Integer, Boolean>();
    Handler mHandler;
    private int rowCount = 2;
    private int countPerRow = 4;
    private int countPerPage = this.countPerRow * this.rowCount;
    protected LayoutInflater mInflater;
    private Context mContext;
    private List<GiftConfigParser.PaidGiftConfigItem> mItemList = new ArrayList<GiftConfigParser.PaidGiftConfigItem>();
    private List<GiftConfigParser.FreeGiftConfigItem> mFreeItemList = new ArrayList<GiftConfigParser.FreeGiftConfigItem>();
    private List mOthers = new ArrayList();
    private List<WeakReference<View>> mFreeItemViewList = new ArrayList<WeakReference<View>>();
    private GiftConfigItemBase mSelectedGiftItem;
    private View mSelectedGiftItemView;
    private int mLastSendGiftType;
    private int mDefaultSelectedGiftType;
    private View mDefaultSelectedView;
    private OnGiftSelectListener mGiftSelectListener;
    private OnGiftDragSendListener mGiftDragSendListener;
    private View.OnLongClickListener mGiftLongClickListener;
    private int mImageSize;
    private int mGifImageSize;
    private boolean mIsFullScreen = false;
    private int mChildCount = 0;
    private ViewGroup mContainer;
    private List<WeakReference<View>> mLandPage = new ArrayList<WeakReference<View>>();
    private Map<Integer, WeakReference<View>> mPages = new HashMap<Integer, WeakReference<View>>();

    public GiftItemPagerAdapter(Context context, boolean isFullScreen, View rootView) {
        this.mInflater = LayoutInflater.from((Context)context);
        this.mContext = context;
        this.mImageSize = this.mContext.getResources().getDimensionPixelSize(R.dimen.channel_gift_grid_image_scale);
        this.mGifImageSize = this.mContext.getResources().getDimensionPixelSize(R.dimen.channel_gift_grid_gif_image_scale);
        this.initScreenMode(isFullScreen);
    }

    public void setHandler(Handler handler2) {
        this.mHandler = handler2;
    }

    public void setOnGiftSelectListener(OnGiftSelectListener listener2) {
        this.mGiftSelectListener = listener2;
    }

    public void performOnGiftSelectListener() {
        if (this.mGiftSelectListener != null && this.mSelectedGiftItem instanceof GiftConfigParser.FreeGiftConfigItem) {
            this.mGiftSelectListener.onGiftSelected(this.mSelectedGiftItem);
        }
    }

    public void setOnGiftDragSendListener(OnGiftDragSendListener listener2) {
        this.mGiftDragSendListener = listener2;
    }

    public void setOnGiftLongClickListener(View.OnLongClickListener listener2) {
        this.mGiftLongClickListener = listener2;
    }

    private void initScreenMode(boolean isFullScreen) {
        if (isFullScreen) {
            this.rowCount = 1;
            this.countPerRow = 7;
        } else {
            this.rowCount = 2;
            this.countPerRow = 4;
        }
        this.countPerPage = this.countPerRow * this.rowCount;
        this.mIsFullScreen = isFullScreen;
    }

    public void setFullScreenMode(boolean isFullScreen) {
        this.removeNullViews();
        this.initScreenMode(isFullScreen);
    }

    public void setForceUpdate(boolean forceUpdate) {
        this.mChildCount = forceUpdate ? this.getCount() : 0;
    }

    public void setLastSendGiftType(int type, int defaultType) {
        this.mLastSendGiftType = type;
        this.mDefaultSelectedGiftType = defaultType;
    }

    public void setSelectedGiftToDefault() {
        if (this.mDefaultSelectedView != null) {
            this.onClick(this.mDefaultSelectedView);
        }
    }

    private void checkLastSendGiftSelected() {
        if (this.mSelectedGiftItem instanceof GiftConfigParser.FreeGiftConfigItem) {
            for (GiftConfigParser.FreeGiftConfigItem item2 : this.mFreeItemList) {
                if (!this.mSelectedGiftItem.type.equals(item2.type)) continue;
                return;
            }
            this.setSelectedGiftToDefault();
        }
    }

    public List<GiftConfigParser.PaidGiftConfigItem> getItemList() {
        return this.mItemList;
    }

    public void setItemList(List<GiftConfigParser.PaidGiftConfigItem> items) {
        if (items == null) {
            return;
        }
        this.mItemList.clear();
        this.mItemList.addAll(items);
        for (GiftConfigParser.PaidGiftConfigItem giftItem : this.mItemList) {
            if (giftItem.type == null || giftItem.type != this.mLastSendGiftType) continue;
            this.setSelectedGiftItem((GiftConfigItemBase)giftItem);
            return;
        }
        if (this.mItemList.size() >= 1) {
            GiftConfigParser.FreeGiftConfigItem firstSendGift = ((IGiftCore)CoreFactory.getCore(IGiftCore.class)).getGiftContainer().getFirstSendGift();
            if (firstSendGift != null) {
                this.mDefaultSelectedGiftType = this.mLastSendGiftType = firstSendGift.type.intValue();
                this.setSelectedGiftItem((GiftConfigItemBase)firstSendGift);
            } else {
                GiftConfigParser.PaidGiftConfigItem paidGiftConfigItem = this.mItemList.get(0);
                this.mDefaultSelectedGiftType = this.mLastSendGiftType = paidGiftConfigItem.type.intValue();
                this.setSelectedGiftItem((GiftConfigItemBase)paidGiftConfigItem);
            }
        }
    }

    public void setSelectedGiftItemView(int type) {
        for (WeakReference<View> page : this.mPages.values()) {
            View container;
            if (page == null || !((container = (View)page.get()) instanceof BagLayout)) continue;
            BagLayout bagLayout = (BagLayout)container;
            int length = bagLayout.getChildCount();
            for (int i = 0; i < length; ++i) {
                View item2 = bagLayout.getChildAt(i);
                if (item2 == null || !(item2.getTag() instanceof GridItemViewHolder)) continue;
                GridItemViewHolder viewHolder = (GridItemViewHolder)item2.getTag();
                if (viewHolder.giftItem == null || !Integer.valueOf(type).equals(viewHolder.giftItem.type)) continue;
                this.onClick(item2);
                return;
            }
        }
    }

    public List<GiftConfigParser.FreeGiftConfigItem> getFreeItemList() {
        return this.mFreeItemList;
    }

    public void setFreePropsItemList(List<GiftConfigParser.FreeGiftConfigItem> items, boolean isTrueLoveUserAutoFlower) {
        if (items == null) {
            this.mFreeItemList.clear();
            return;
        }
        GiftConfigParser.FreeGiftConfigItem firstSendGift = ((IGiftCore)CoreFactory.getCore(IGiftCore.class)).getGiftContainer().getFirstSendGift();
        if (firstSendGift != null) {
            items.add(0, firstSendGift);
        } else if (Temp.getCurrentBussinessId() != null && "entertainment".equals(Temp.getCurrentBussinessId()) && ((IFlowerCore)ICoreManagerBase.getCore(IFlowerCore.class)).getCurrentFlowerInfo() != null && (items.size() == 0 || !(items.get(0) instanceof GiftConfigParser.FolwerFreeGiftConfigItem))) {
            GiftConfigParser.FolwerFreeGiftConfigItem folwerFreeGiftConfigItem = new GiftConfigParser.FolwerFreeGiftConfigItem();
            folwerFreeGiftConfigItem.name = "\u9c9c\u82b1";
            folwerFreeGiftConfigItem.num = ((IFlowerCore)ICoreManagerBase.getCore(IFlowerCore.class)).getCurrentFlowerInfo().getFlowerOwnedNums();
            folwerFreeGiftConfigItem.iconPath = String.valueOf(R.drawable.icon_hua);
            if (isTrueLoveUserAutoFlower) {
                folwerFreeGiftConfigItem.iconPath = String.valueOf(R.drawable.icon_hua_rose);
            }
            items.add(0, (GiftConfigParser.FreeGiftConfigItem)folwerFreeGiftConfigItem);
        }
        this.mFreeItemList = items;
        this.updateFreePropsItemNum();
        this.checkLastSendGiftSelected();
    }

    private boolean checkNeedAddFlowerGiftConfigItem(boolean hasBowknot, List<GiftConfigParser.FreeGiftConfigItem> items) {
        boolean result = false;
        if (items.size() == 0) {
            result = true;
        } else if (hasBowknot) {
            if (items.get(1) == null || !(items.get(1) instanceof GiftConfigParser.FolwerFreeGiftConfigItem)) {
                result = true;
            }
        } else if (items.get(0) instanceof GiftConfigParser.FolwerFreeGiftConfigItem) {
            result = true;
        }
        return result;
    }

    public void addFolwerFreeGiftItemList(GiftConfigParser.FolwerFreeGiftConfigItem items) {
        if (this.mFreeItemList.size() > 0 && this.mFreeItemList.get(0) instanceof GiftConfigParser.FolwerFreeGiftConfigItem) {
            this.mFreeItemList.remove(0);
            this.mFreeItemList.add(0, (GiftConfigParser.FreeGiftConfigItem)items);
        } else {
            this.mFreeItemList.add(0, (GiftConfigParser.FreeGiftConfigItem)items);
        }
        if (items.type == this.mLastSendGiftType) {
            this.setSelectedGiftItem((GiftConfigItemBase)items);
        }
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"huiping, addFolwerFreeGiftItemList ", (Object[])new Object[0]);
        }
        this.notifyDataSetChanged();
    }

    public void onCloseRedPacket(boolean close) {
        if (close) {
            this.mOthers.clear();
        } else if (!ICoreManagerBase.getChannelLinkCore().isGameTeplate()) {
            this.mOthers.add(new RedPacketItem());
        }
    }

    public void updateFreePropsItemNum() {
        if (FP.empty(this.mFreeItemViewList) || FP.empty(this.mFreeItemList)) {
            return;
        }
        for (int i = 0; i < this.mFreeItemViewList.size(); ++i) {
            GiftConfigParser.FreeGiftConfigItem item2;
            GridItemViewHolder holder;
            View view = (View)this.mFreeItemViewList.get(i).get();
            if (view == null || (holder = (GridItemViewHolder)view.getTag()) == null || (item2 = GiftConfigParser.getInstance().getFreeGiftConfigByType(holder.giftItem.type.intValue())) == null) continue;
            holder.freeGiftCountView.setText((CharSequence)String.valueOf(item2.num));
        }
    }

    public void updateFolwerFreePropsItemStatus(int availableInterval, int num, int incInterval, boolean hasMaxOwnerNums) {
        for (int i = 0; i < this.mFreeItemViewList.size(); ++i) {
            View view = (View)this.mFreeItemViewList.get(i).get();
            if (view == null) continue;
            this.setFolwerFreeGiftAvailable(view, availableInterval, num, incInterval, hasMaxOwnerNums);
        }
    }

    private void setFolwerFreeGiftAvailable(View view, int availableInterval, int num, int incInterval, boolean hasMaxOwnerNums) {
        GridItemViewHolder viewHolder = (GridItemViewHolder)view.getTag();
        if (viewHolder.giftItem instanceof GiftConfigParser.FolwerFreeGiftConfigItem) {
            if (viewHolder.freeGiftUnavailableView == null) {
                viewHolder.freeGiftUnavailableView = view.findViewById(R.id.rl_free_gift_unavailable);
                viewHolder.freeGiftCountView = (TextView)view.findViewById(R.id.tv_free_gift_count);
                viewHolder.freeFlowerProgressBar = (ProgressBar)view.findViewById(R.id.pb_flower_time_left);
            }
            viewHolder.freeGiftUnavailableView.setVisibility(8);
            viewHolder.freeGiftCountView.setText((CharSequence)String.valueOf(num));
            int progress = 100 - 100 * availableInterval / incInterval;
            if (MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)"huiping", (String)("flower progress " + progress), (Object[])new Object[0]);
            }
            viewHolder.freeFlowerProgressBar.setVisibility(0);
            viewHolder.freeFlowerProgressBar.setProgress(progress);
            if (hasMaxOwnerNums) {
                viewHolder.freeFlowerProgressBar.setVisibility(8);
            }
        }
    }

    public void updateFolwerFreePropsItemNum(int num) {
        for (int i = 0; i < this.mFreeItemViewList.size(); ++i) {
            View view = (View)this.mFreeItemViewList.get(i).get();
            if (view == null) continue;
            GridItemViewHolder viewHolder = (GridItemViewHolder)view.getTag();
            if (!(viewHolder.giftItem instanceof GiftConfigParser.FolwerFreeGiftConfigItem)) continue;
            if (viewHolder.freeGiftCountView == null) {
                viewHolder.freeGiftCountView = (TextView)view.findViewById(R.id.tv_free_gift_count);
            }
            viewHolder.freeGiftCountView.setText((CharSequence)String.valueOf(num));
            if (!MLog.isLogLevelAboveDebug()) continue;
            MLog.debug((Object)"huiping", (String)("updateFolwerFreePropsItemNum  num = " + num), (Object[])new Object[0]);
        }
    }

    public int getCount() {
        int count = this.mFreeItemList.size() + this.mItemList.size() + this.mOthers.size();
        if (count > 0) {
            return (count - 1) / this.countPerPage + 1;
        }
        return 0;
    }

    public boolean isViewFromObject(View view, Object o) {
        return view == o;
    }

    public int getItemPosition(Object object) {
        if (this.mChildCount > 0) {
            --this.mChildCount;
            return -2;
        }
        return super.getItemPosition(object);
    }

    public Object instantiateItem(ViewGroup container, int position) {
        MLog.info((Object)TAG, (String)"huiping, onEntertaimentTemplateInit page: %d", (Object[])new Object[]{position});
        this.mContainer = container;
        View pageView = this.mInflater.inflate(R.layout.gift_link_item_page, null);
        BagLayout bagLayout = (BagLayout)pageView;
        bagLayout.setRow(this.rowCount);
        bagLayout.setColumns(this.countPerRow);
        bagLayout.setDivider(0);
        this.mPages.put(position, new WeakReference<View>(pageView));
        container.addView(pageView);
        if (this.mIsFullScreen) {
            this.mLandPage.add(new WeakReference<View>(pageView));
        }
        return pageView;
    }

    public void onPageSelected(int position) {
        View page;
        MLog.info((Object)TAG, (String)("onPageSelected pos=" + position), (Object[])new Object[0]);
        if (this.selectedPages.get(position) == null && this.mPages.get(position) != null) {
            View page2 = (View)this.mPages.get(position).get();
            if (page2 != null) {
                MLog.info((Object)TAG, (String)"onPageSelected selectedPages==null", (Object[])new Object[0]);
                this.updatePage(position, page2);
            }
        } else if (this.mPages.get(position) != null && (page = (View)this.mPages.get(position).get()) != null && ((ViewGroup)page).getChildCount() == 0) {
            MLog.info((Object)TAG, (String)"onPageSelected selectedPages childCount==0", (Object[])new Object[0]);
            this.updatePage(position, page);
        }
    }

    public void forceUpdatePage(int pageIndex) {
        View page;
        if (this.mPages.get(pageIndex) != null && (page = (View)this.mPages.get(pageIndex).get()) != null) {
            MLog.info((Object)TAG, (String)"forceUpdateCurrentPage", (Object[])new Object[0]);
            this.updatePage(pageIndex, page);
        }
    }

    public void forceUpdateAllPage() {
        for (Integer page : this.mPages.keySet()) {
            this.forceUpdatePage(page);
        }
    }

    private void updatePage(final int position, final View page) {
        if (this.mHandler != null) {
            this.selectedPages.put(position, true);
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    GiftItemPagerAdapter.this.fillPage(position, (BagLayout)page, GiftItemPagerAdapter.this.countPerPage * position, 1);
                }
            }, 1L);
        }
    }

    private void fillPage(int pageIndex, BagLayout row, int startIndex, int rowIndex) {
        int i;
        int endIndex = startIndex + this.countPerPage;
        MLog.info((Object)TAG, (String)"fillPage startIndex=%d,endIndex=%d", (Object[])new Object[]{startIndex, endIndex});
        row.removeAllViews();
        int freeItemCount = this.mFreeItemList.size();
        for (i = startIndex; i < freeItemCount && i < endIndex; ++i) {
            View view = this.createGiftItemView(true, pageIndex);
            row.addView(view);
            this.decorateView(view, (GiftConfigItemBase)this.mFreeItemList.get(i));
            this.mFreeItemViewList.add(new WeakReference<View>(view));
        }
        int paidItemCount = this.mItemList.size();
        while (i < freeItemCount + paidItemCount && i < endIndex) {
            View view = this.createGiftItemView(false, pageIndex);
            row.addView(view);
            int pos = i - freeItemCount;
            if (pos < paidItemCount && pos < this.mItemList.size()) {
                this.decorateView(view, (GiftConfigItemBase)this.mItemList.get(pos));
            }
            ++i;
        }
    }

    protected View createGiftItemView(boolean isFree, int pageIndex) {
        View view = this.mInflater.inflate(R.layout.gift_link_grid_item, null);
        GridItemViewHolder viewHolder = new GridItemViewHolder();
        viewHolder.nameTextView = (TextView)view.findViewById(R.id.tv_gift_name);
        viewHolder.priceTextView = (TextView)view.findViewById(R.id.tv_gift_price);
        viewHolder.iconImageView = (RecycleImageView)view.findViewById(R.id.iv_gift_icon);
        viewHolder.selectedTagImageView = (ImageView)view.findViewById(R.id.iv_selected_tag);
        viewHolder.freeTagIv = (TextView)view.findViewById(R.id.iv_free_tag);
        viewHolder.freeFlowerProgressBar = (ProgressBar)view.findViewById(R.id.pb_flower_time_left);
        viewHolder.rlFreeGiftUnavailable = view.findViewById(R.id.rl_free_gift_unavailable);
        viewHolder.jiaobiaoHuodong = (ImageView)view.findViewById(R.id.jiaobiao_huodong);
        viewHolder.jiaobiaoBigGif = (ImageView)view.findViewById(R.id.jiaobiao_bigGif);
        viewHolder.weekStarJiaoBiao = (ImageView)view.findViewById(R.id.week_star_new_jiaobiao);
        viewHolder.discountJiaoBiao = (ImageView)view.findViewById(R.id.discount_jiaobiao);
        viewHolder.jiaobiaoArgift = (ImageView)view.findViewById(R.id.jiaobiao_argift);
        viewHolder.jiaobiaoNoblegift = (ImageView)view.findViewById(R.id.jiaobiao_noblegift);
        viewHolder.pageIndex = pageIndex;
        view.setTag((Object)viewHolder);
        view.setOnClickListener((View.OnClickListener)this);
        return view;
    }

    @SuppressLint(value={"NewApi", "SetTextI18n"})
    protected void decorateView(View view, GiftConfigItemBase giftItem) {
        if (giftItem == null) {
            return;
        }
        GridItemViewHolder viewHolder = (GridItemViewHolder)view.getTag();
        if (viewHolder.giftItem != giftItem) {
            if (giftItem instanceof GiftConfigParser.PaidGiftConfigItem) {
                boolean isbig = ((GiftConfigParser.PaidGiftConfigItem)giftItem).isBig;
                if (isbig) {
                    viewHolder.jiaobiaoBigGif.setVisibility(0);
                } else {
                    viewHolder.jiaobiaoBigGif.setVisibility(8);
                }
                viewHolder.nameTextView.setText((CharSequence)giftItem.name);
                viewHolder.priceTextView.setText((CharSequence)((float)((GiftConfigParser.PaidGiftConfigItem)giftItem).price.intValue() / 100.0f + Spdt.string((int)R.string.red_packet_price_unit_user, (Object[])new Object[0])));
                viewHolder.freeTagIv.setVisibility(8);
                viewHolder.freeFlowerProgressBar.setVisibility(8);
                viewHolder.jiaobiaoHuodong.setVisibility(8);
                if (giftItem.type != null) {
                    if (GiftConfigParser.getInstance().isArGift(giftItem.type)) {
                        viewHolder.jiaobiaoArgift.setVisibility(0);
                    } else {
                        viewHolder.jiaobiaoArgift.setVisibility(8);
                    }
                    if (GiftConfigParser.getInstance().isNobleGift(giftItem.type)) {
                        viewHolder.jiaobiaoNoblegift.setVisibility(0);
                    } else {
                        viewHolder.jiaobiaoNoblegift.setVisibility(8);
                    }
                }
            } else if (giftItem instanceof GiftConfigParser.FreeGiftConfigItem) {
                GiftConfigItemBase item2;
                GiftConfigParser.FreeGiftConfigItem freeItem = (GiftConfigParser.FreeGiftConfigItem)giftItem;
                if (giftItem instanceof GiftConfigParser.FolwerFreeGiftConfigItem) {
                    viewHolder.rlFreeGiftUnavailable.setVisibility(8);
                    viewHolder.jiaobiaoHuodong.setVisibility(8);
                    FlowerInfo flowerInfo = ((IFlowerCore)CoreFactory.getCore(IFlowerCore.class)).getCurrentFlowerInfo();
                    flowerInfo.calculate();
                    if (flowerInfo.hasMaxOwnerNums() || flowerInfo.getHasIncreasedSecs() == -1) {
                        viewHolder.freeFlowerProgressBar.setVisibility(8);
                    } else {
                        viewHolder.freeFlowerProgressBar.setVisibility(0);
                        this.setFolwerFreeGiftAvailable(view, flowerInfo.getFlowerRemainedSecs(), flowerInfo.getFlowerOwnedNums(), flowerInfo.getFlowerIncInterval(), flowerInfo.hasMaxOwnerNums());
                    }
                } else {
                    viewHolder.freeFlowerProgressBar.setVisibility(8);
                    viewHolder.jiaobiaoHuodong.setVisibility(8);
                }
                if (freeItem.name == null && (item2 = GiftConfigParser.getInstance().getGiftConfigItemByType(freeItem.type.intValue())) != null) {
                    giftItem.name = item2.name;
                    giftItem.iconPath = item2.iconPath;
                    if (item2 instanceof GiftConfigParser.FreeGiftConfigItem) {
                        freeItem.price = ((GiftConfigParser.FreeGiftConfigItem)item2).price;
                    }
                }
                viewHolder.freeGiftCountView = (TextView)view.findViewById(R.id.tv_free_gift_count);
                viewHolder.freeGiftCountView.setVisibility(0);
                viewHolder.nameTextView.setText((CharSequence)giftItem.name);
                viewHolder.freeGiftCountView.setText((CharSequence)String.valueOf(freeItem.num));
                if (MLog.isLogLevelAboveDebug()) {
                    MLog.debug((Object)TAG, (String)("freeGiftCountView num = " + freeItem.num), (Object[])new Object[0]);
                }
                if (freeItem.num < 10) {
                    viewHolder.freeGiftCountView.setBackgroundResource(R.drawable.dian_normal);
                } else {
                    viewHolder.freeGiftCountView.setBackgroundResource(R.drawable.dian1);
                }
                if (freeItem.price != 0) {
                    viewHolder.freeTagIv.setText((CharSequence)this.mContext.getString(R.string.str_gift_price_format_lt, new Object[]{Float.valueOf((float)((GiftConfigParser.FreeGiftConfigItem)giftItem).price.intValue() / 100.0f)}));
                }
                viewHolder.freeTagIv.setVisibility(0);
                viewHolder.priceTextView.setVisibility(4);
            }
            boolean isShowWeekStarGift = WeekStarController.getWeekStarGift(giftItem.type);
            viewHolder.weekStarJiaoBiao.setVisibility(isShowWeekStarGift ? 0 : 8);
            if (viewHolder.discountJiaoBiao != null) {
                boolean isDiscountGift = ((IDiscountCore)CoreFactory.getCore(IDiscountCore.class)).isDiscountGift(giftItem.type);
                viewHolder.discountJiaoBiao.setVisibility(isDiscountGift ? 0 : 8);
            }
            if (giftItem instanceof GiftConfigParser.FolwerFreeGiftConfigItem) {
                ImageLoader.loadImageResource((int)Integer.valueOf(giftItem.iconPath), (RecycleImageView)viewHolder.iconImageView, (ImageConfig)ImageConfig.smallImageConfig());
            } else if (giftItem instanceof GiftConfigParser.BowknotFreeGiftConfigItem) {
                ImageLoader.loadImageResource((int)Integer.valueOf(giftItem.iconPath), (RecycleImageView)viewHolder.iconImageView, (ImageConfig)ImageConfig.smallImageConfig());
            } else {
                final ImageConfig config = ImageConfig.smallImageConfig();
                final String url = giftItem.iconPath;
                Glide.with((Context)this.mContext).load(url).apply(new RequestOptions().placeholder(R.drawable.lr_ic_default_gift)).into((ImageView)viewHolder.iconImageView);
                BitmapDrawable drawable2 = ImageLoader.getBitmapFromCache((String)url, (ImageConfig)config);
                if (drawable2 == null) {
                    MLog.info((Object)TAG, (String)("cacheDrawable is  null! url =" + url), (Object[])new Object[0]);
                    ImageLoader.loadBitmap((Context)BasicConfig.getInstance().getAppContext(), (String)url, (ImageLoader.BitmapLoadListener)new ImageLoader.BitmapLoadListener(){

                        public void onLoadFailed(Exception e) {
                        }

                        public void onResourceReady(Bitmap bitmap) {
                            if (bitmap != null) {
                                BitmapDrawable drawable2 = new BitmapDrawable(BasicConfig.getInstance().getAppContext().getResources(), bitmap);
                                ImageLoader.addBitmapToCache((String)url, (BitmapDrawable)drawable2, (ImageConfig)config);
                            }
                        }
                    });
                } else {
                    MLog.info((Object)TAG, (String)("cacheDrawable is not null! url =" + url), (Object[])new Object[0]);
                }
            }
            FrameLayout cornerContainer = (FrameLayout)view.findViewById(R.id.fl_corners);
            GiftViewCornerUtil.INSTANCE.initCorners(cornerContainer, giftItem);
            viewHolder.giftItem = giftItem;
        }
        if (this.mSelectedGiftItem != null && viewHolder.giftItem.getType() == this.mSelectedGiftItem.getType() && viewHolder.giftItem.type.equals(this.mSelectedGiftItem.type)) {
            if (MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)TAG, (String)"setViewSelected gift: %s", (Object[])new Object[]{viewHolder.giftItem.name});
            }
            this.setViewSelected(view);
            this.mSelectedGiftItemView = view;
        }
        if (this.mDefaultSelectedGiftType == giftItem.type) {
            this.mDefaultSelectedView = view;
        }
    }

    public void setSelectedGiftItem(GiftConfigItemBase giftItem) {
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"select gift: %s", (Object[])new Object[]{giftItem.name});
        }
        if (!this.mIsFullScreen) {
            // empty if block
        }
        this.mSelectedGiftItem = giftItem;
        if (this.mGiftSelectListener != null) {
            this.mGiftSelectListener.onGiftSelected(giftItem);
        }
    }

    public void destroyItem(ViewGroup container, int position, Object object) {
        MLog.info((Object)TAG, (String)("huiping, destroyItem position = " + position), (Object[])new Object[0]);
        container.removeView((View)object);
        this.removeNullFreeItemViews();
    }

    private void removeNullFreeItemViews() {
        if (this.mFreeItemViewList != null && this.mFreeItemViewList.size() > 0) {
            Iterator<WeakReference<View>> iterator = this.mFreeItemViewList.iterator();
            while (iterator.hasNext()) {
                if (iterator.next().get() != null) continue;
                iterator.remove();
            }
        }
    }

    public void removeNullViews() {
        this.selectedPages.clear();
    }

    public GiftConfigItemBase getSelectedItem() {
        return this.mSelectedGiftItem;
    }

    public void onClick(View v) {
        GridItemViewHolder viewHolder = (GridItemViewHolder)v.getTag();
        if (viewHolder == null || viewHolder.giftItem == null) {
            return;
        }
        if (this.mSelectedGiftItemView == v) {
            return;
        }
        ((IHiidoStatisticCore)ICoreManagerBase.getCore(IHiidoStatisticCore.class)).sendEventStatistic("50020", "0013");
        this.setSelectedGiftItem(viewHolder.giftItem);
        this.setViewSelected(v);
        if (this.mSelectedGiftItemView != null) {
            this.setViewUnSelected(this.mSelectedGiftItemView);
        }
        this.mSelectedGiftItemView = v;
    }

    private void setViewSelected(View view) {
        GridItemViewHolder viewHolder = (GridItemViewHolder)view.getTag();
        if (viewHolder == null) {
            return;
        }
        if (viewHolder.isSelected) {
            return;
        }
        if (this.mContext != null) {
            viewHolder.selectedTagImageView.setBackground(this.mContext.getResources().getDrawable(R.drawable.gift_selected_bg));
        }
        viewHolder.isSelected = true;
    }

    private void setViewUnSelected(View view) {
        GridItemViewHolder viewHolder = (GridItemViewHolder)view.getTag();
        if (viewHolder == null) {
            return;
        }
        if (!viewHolder.isSelected) {
            return;
        }
        if (this.mContext != null) {
            viewHolder.selectedTagImageView.setBackground(this.mContext.getResources().getDrawable(R.drawable.gift_unselected_bg));
        }
        viewHolder.isSelected = false;
    }

    public int getPageIndex(int itemIndex) {
        return itemIndex / this.countPerPage;
    }

    public int getPageRowIndex(int itemIndex) {
        return itemIndex / this.countPerRow;
    }

    public Integer getSelectedItemPageIndex() {
        Integer mType = this.mSelectedGiftItem != null ? this.mSelectedGiftItem.type : Integer.valueOf(this.mDefaultSelectedGiftType);
        for (WeakReference<View> page : this.mPages.values()) {
            View container;
            if (page == null || !((container = (View)page.get()) instanceof BagLayout)) continue;
            BagLayout bagLayout = (BagLayout)container;
            int length = bagLayout.getChildCount();
            for (int i = 0; i < length; ++i) {
                View item2 = bagLayout.getChildAt(i);
                if (item2 == null || !(item2.getTag() instanceof GridItemViewHolder)) continue;
                GridItemViewHolder viewHolder = (GridItemViewHolder)item2.getTag();
                if (viewHolder.giftItem == null || !viewHolder.giftItem.type.equals(mType)) continue;
                this.mSelectedGiftItem = viewHolder.giftItem;
                return viewHolder.pageIndex;
            }
        }
        return null;
    }

    public static class GridItemViewHolder {
        public TextView nameTextView;
        public TextView priceTextView;
        public RecycleImageView iconImageView;
        public TextView freeTagIv;
        public ImageView selectedTagImageView;
        public TextView freeGiftCountView;
        public View freeGiftUnavailableView;
        public TextView freeTimeLeft;
        public ProgressBar freeProgressBar;
        public GiftConfigItemBase giftItem;
        public boolean isSelected = false;
        public ProgressBar freeFlowerProgressBar;
        public View rlFreeGiftUnavailable;
        public ImageView jiaobiaoHuodong;
        public ImageView jiaobiaoBigGif;
        public ImageView weekStarJiaoBiao;
        public ImageView discountJiaoBiao;
        public ImageView jiaobiaoArgift;
        public ImageView jiaobiaoNoblegift;
        public int pageIndex;
    }

    public static interface OnGiftDragSendListener {
        public void onGiftDragSend(GiftConfigItemBase var1);
    }

    public static interface OnGiftSelectListener {
        public void onGiftSelected(GiftConfigItemBase var1);
    }
}

