/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.fullservicebroadcast;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Point;
import android.os.Build;
import android.text.SpannableString;
import android.util.AttributeSet;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.RelativeLayout;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.fullservicebroadcast.AirplaneBCLinearLayout;
import com.yy.mobile.ui.y2a.Y2AFileDownloader;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.RxUtils;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.log.MLog;
import com.yy.y2aplayerandroid.Y2APlayer;
import com.yy.y2aplayerandroid.Y2APlayerListener;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.basechannel.IChannelLinkCore;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import java.io.File;

public class BcAnimationView
extends RelativeLayout {
    private static final String TAG = "BcAnimationView";
    private static final int PLAY_SVGA = 1;
    private Context mContext;
    private Y2APlayer mPlayer;
    private AirplaneBCLinearLayout banner;
    private int screenW = 0;
    private int level = 0;
    private boolean isStop = true;
    private String[] svgaFileNames = new String[]{"plane.y2a", "plane_gold.y2a", "plane_silver.y2a"};
    private Disposable y2aFileDisposable;
    private Runnable bannerRunnable = new Runnable(){

        @Override
        public void run() {
            if (BcAnimationView.this.banner != null) {
                BcAnimationView.this.banner.playTotalAnim();
            }
        }
    };
    private Runnable visibleRunnable = new Runnable(){

        @Override
        public void run() {
            if (BcAnimationView.this.isStop) {
                BcAnimationView.this.setVisibility(8);
            } else {
                BcAnimationView.this.setVisibility(0);
            }
        }
    };
    private Runnable scaleRunnable = new Runnable(){

        @Override
        public void run() {
            if (BcAnimationView.this.mPlayer == null) {
                return;
            }
            Point p = BcAnimationView.this.mPlayer.getY2ASizer();
            MLog.info((Object)BcAnimationView.TAG, (String)("screenW=" + BcAnimationView.this.screenW + " x=" + p.x + " y=" + p.y), (Object[])new Object[0]);
            int height = 0;
            if (p.x > 0) {
                height = Math.round((float)BcAnimationView.this.screenW * ((float)p.y / (float)p.x));
                RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(BcAnimationView.this.screenW, height);
                lp.topMargin = BcAnimationView.this.level == 2 || BcAnimationView.this.level == 3 ? -((int)ResolutionUtils.convertDpToPixel((float)18.0f, (Context)BasicConfig.getInstance().getAppContext())) : -((int)ResolutionUtils.convertDpToPixel((float)43.0f, (Context)BasicConfig.getInstance().getAppContext()));
                BcAnimationView.this.mPlayer.setLayoutParams((ViewGroup.LayoutParams)lp);
                BcAnimationView.this.mPlayer.requestLayout();
            }
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(BcAnimationView.this.screenW, -2);
            if (!((IChannelLinkCore)ICoreManagerBase.getCore(IChannelLinkCore.class)).isGameTeplate()) {
                layoutParams.topMargin = BcAnimationView.this.level == 2 || BcAnimationView.this.level == 3 ? (int)ResolutionUtils.convertDpToPixel((float)80.0f, (Context)BasicConfig.getInstance().getAppContext()) - BcAnimationView.this.banner.getMeasuredHeight() + (int)ResolutionUtils.convertDpToPixel((float)17.0f, (Context)BasicConfig.getInstance().getAppContext()) : (int)ResolutionUtils.convertDpToPixel((float)80.0f, (Context)BasicConfig.getInstance().getAppContext());
            }
            layoutParams.addRule(14);
            BcAnimationView.this.banner.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        }
    };
    private Y2APlayerListener y2APlayerListener = new Y2APlayerListener(){

        public void onLoaded(int errorCode) {
        }

        public void onPlayed(int errorCode) {
            BcAnimationView.this.isStop = false;
            BcAnimationView.this.post(BcAnimationView.this.scaleRunnable);
        }

        public void onStopped() {
            BcAnimationView.this.isStop = true;
            if (BcAnimationView.this.mPlayer != null) {
                BcAnimationView.this.mPlayer.stop();
            }
        }

        public void onDestroyed() {
        }
    };

    public BcAnimationView(Context context) {
        super(context);
        this.mContext = context;
        this.initView();
    }

    public BcAnimationView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.initView();
    }

    private void initView() {
        if (this.mContext == null) {
            return;
        }
        this.screenW = this.getScreenWidth();
        this.banner = new AirplaneBCLinearLayout(this.mContext);
        this.addView((View)this.banner);
        if (this.mPlayer == null) {
            this.mPlayer = new Y2APlayer(this.mContext);
            this.mPlayer.setListener(this.y2APlayerListener);
            this.addView((View)this.mPlayer);
        }
    }

    public View getBanner() {
        return this.banner;
    }

    public void setBannerData(int level, long sid, SpannableString span) {
        this.level = level;
        if (this.banner == null) {
            return;
        }
        if (span != null) {
            this.banner.setTxtInfo(span);
        }
        this.banner.setSid(sid);
        if (level == 2) {
            this.banner.setHengFuBg(R.drawable.silver_hengfu);
            this.banner.setSidBg(R.drawable.pingdaopiao3);
        } else if (level == 3) {
            this.banner.setHengFuBg(R.drawable.gold_hengfu);
            this.banner.setSidBg(R.drawable.pingdaopiao2);
        } else if (level == 4) {
            this.banner.setHengFuBg(R.drawable.hengfu_bg);
            this.banner.setSidBg(R.drawable.pingdaopiao);
        }
    }

    public void updateBannerSpan(SpannableString span) {
        if (this.banner == null) {
            return;
        }
        if (span != null) {
            this.banner.setTxtInfo(span);
        }
    }

    public void play() {
        if (this.mPlayer == null || this.svgaFileNames.length < 3) {
            return;
        }
        if (this.level == 2) {
            this.playSvgaAnimation(this.svgaFileNames[2]);
            this.postDelayed(this.bannerRunnable, 500L);
        } else if (this.level == 3) {
            this.playSvgaAnimation(this.svgaFileNames[1]);
            this.postDelayed(this.bannerRunnable, 800L);
        } else if (this.level == 4) {
            this.playSvgaAnimation(this.svgaFileNames[0]);
            this.postDelayed(this.bannerRunnable, 800L);
        }
    }

    @SuppressLint(value={"CheckResult"})
    public void playSvgaAnimation(String fileName) {
        if (StringUtils.isEmpty((String)fileName).booleanValue()) {
            return;
        }
        this.y2aFileDisposable = Y2AFileDownloader.downloadY2AFile((String)fileName).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<File>(){

            public void accept(File file) throws Exception {
                if (BcAnimationView.this.mPlayer != null) {
                    if (!((IChannelLinkCore)ICoreManagerBase.getCore(IChannelLinkCore.class)).isGameTeplate()) {
                        BcAnimationView.this.mPlayer.load(file.getAbsolutePath());
                        BcAnimationView.this.mPlayer.play(1.0f, 1);
                    } else {
                        BcAnimationView.this.post(BcAnimationView.this.scaleRunnable);
                    }
                }
            }
        }, RxUtils.errorConsumer((String)TAG));
    }

    private int getScreenWidth() {
        Point p = this.getScreenSize(this.mContext, null);
        return p.x < p.y ? p.x : p.y;
    }

    public Point getScreenSize(Context context, Point outSize) {
        WindowManager wm = (WindowManager)context.getSystemService("window");
        Point ret = outSize == null ? new Point() : outSize;
        Display defaultDisplay = wm.getDefaultDisplay();
        if (Build.VERSION.SDK_INT >= 13) {
            defaultDisplay.getSize(ret);
        } else {
            ret.x = defaultDisplay.getWidth();
            ret.y = defaultDisplay.getHeight();
        }
        return ret;
    }

    public void onDestroy() {
        this.removeCallbacks(this.bannerRunnable);
        this.removeCallbacks(this.scaleRunnable);
        this.removeCallbacks(this.visibleRunnable);
        if (this.mPlayer != null) {
            this.mPlayer.stop();
            this.mPlayer.close();
            this.mPlayer = null;
        }
        if (this.banner != null) {
            this.banner.onDestroy();
            this.banner = null;
        }
        if (this.y2aFileDisposable != null) {
            this.y2aFileDisposable.dispose();
        }
    }
}

