/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.channellinklist;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.SystemClock;
import android.view.View;
import android.widget.ExpandableListAdapter;
import android.widget.ExpandableListView;
import com.duowan.mobile.entlive.events.IDispenseChannelClient_onRequestChannelType_EventArgs;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_onChangeChannelError_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_onCurrentMultiKick_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_onJoinChannelSuccess_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_onRequestCurrentChannelInfoList_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_updateCurrentChannelOnlineCount_EventArgs;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.BasePluginEntLiveActivity;
import com.yy.mobile.ui.channellinklist.ChannelLinkSubListActivity$$EventBinder;
import com.yy.mobile.ui.channellinklist.ChannelLinkSubListAdapter;
import com.yy.mobile.ui.utils.dialog.BaseDialog;
import com.yy.mobile.ui.utils.dialog.DialogLinkManager;
import com.yy.mobile.ui.utils.dialog.ProgressDialog;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.CoreError;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.basechannel.SessMultiKick;
import com.yymobile.core.channel.ChannelInfo;
import com.yymobile.core.dispensechannel.IDispenseChannelCore;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class ChannelLinkSubListActivity
extends BasePluginEntLiveActivity {
    public static final String TAG = "ChannelLinkSubListActivity";
    public static final int REQUEST_CODE_FROM_CHANNEL = 10001;
    private static final long SHOW_JOINING_DIALOG_DELAY_MILLIS = 3500L;
    private static final long REQUEST_TIME_OUT_MILLIS = 10000L;
    private static final long JOIN_CHANNEL_TIME_OUT_MILLIS = 15000L;
    private static final long UPDATE_ONLINE_COUNT_MILLIS = 4000L;
    private static final String PRE_JOIN_INFO = "pre_join_info";
    private ExpandableListView mListView;
    private ChannelLinkSubListAdapter mAdapter;
    private ChannelInfo prepareJoinInfo;
    private boolean isCheckingPwd = false;
    private boolean isJoiningShowing = false;
    private long mLastUpdateOnlineCountTime = 0L;
    private Runnable checkJoinTimeoutTask = new Runnable(){

        @Override
        public void run() {
            if (ChannelLinkSubListActivity.this.isJoiningShowing) {
                ChannelLinkSubListActivity.this.getDialogLinkManager().hideProgressDialog();
                ChannelLinkSubListActivity.this.isJoiningShowing = false;
                ChannelLinkSubListActivity.this.toast(R.string.str_change_sub_channel_error);
            }
        }
    };
    private Runnable showJoiningTask = new Runnable(){

        @Override
        public void run() {
            if (ChannelLinkSubListActivity.this.getDialogLinkManager() != null) {
                ChannelLinkSubListActivity.this.getDialogLinkManager().showDialog((BaseDialog)new ProgressDialog((CharSequence)ChannelLinkSubListActivity.this.getString(R.string.str_change_sub_channel_ing), false));
            }
            ChannelLinkSubListActivity.this.isJoiningShowing = true;
            ChannelLinkSubListActivity.this.getHandler().removeCallbacks(ChannelLinkSubListActivity.this.checkJoinTimeoutTask);
            ChannelLinkSubListActivity.this.getHandler().postDelayed(ChannelLinkSubListActivity.this.checkJoinTimeoutTask, 15000L);
        }
    };
    private Runnable mRequestChannelTypeRunnable = new Runnable(){

        @Override
        public void run() {
            ChannelLinkSubListActivity.this.changeSubChannel("");
        }
    };
    private Runnable checkRequestTimeoutTask = new Runnable(){

        @Override
        public void run() {
            ChannelLinkSubListActivity.this.hideStatus();
            if (ChannelLinkSubListActivity.this.mAdapter.getGroupCount() == 0) {
                ChannelLinkSubListActivity.this.showReload();
            }
        }
    };
    private EventBinder mChannelLinkSubListActivitySniperEventBinder;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_sub_channel_list);
        if (savedInstanceState != null) {
            this.prepareJoinInfo = (ChannelInfo)savedInstanceState.getSerializable(PRE_JOIN_INFO);
        }
        this.initTitleBar();
        this.initListView();
        this.requestData();
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putSerializable(PRE_JOIN_INFO, (Serializable)this.prepareJoinInfo);
    }

    private void initTitleBar() {
        View mBackBtn = this.findViewById(R.id.iv_back);
        mBackBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                ChannelLinkSubListActivity.this.finish();
            }
        });
    }

    private void initListView() {
        this.mListView = (ExpandableListView)this.findViewById(R.id.list_sub_channel);
        this.mAdapter = new ChannelLinkSubListAdapter((Context)this, this.mListView);
        this.mListView.setAdapter((ExpandableListAdapter)this.mAdapter);
        this.mListView.setDescendantFocusability(262144);
        this.mListView.setGroupIndicator(null);
        this.mListView.setOnChildClickListener(new ExpandableListView.OnChildClickListener(){

            public boolean onChildClick(ExpandableListView parent, View v, int groupPosition, int childPosition, long id2) {
                ChannelLinkSubListActivity.this.findChannelType(ChannelLinkSubListActivity.this.mAdapter.getChild(groupPosition, childPosition));
                return true;
            }
        });
        this.mListView.setOnGroupClickListener(new ExpandableListView.OnGroupClickListener(){

            public boolean onGroupClick(ExpandableListView parent, View v, int groupPosition, long id2) {
                ChannelLinkSubListActivity.this.findChannelType(ChannelLinkSubListActivity.this.mAdapter.getGroup(groupPosition));
                return true;
            }
        });
    }

    private void requestData() {
        if (FP.empty((Collection)ICoreManagerBase.getChannelLinkCore().getChannelInfoList())) {
            this.showLoading();
            ICoreManagerBase.getChannelLinkCore().requestChannelInfoList();
            this.getHandler().removeCallbacks(this.checkRequestTimeoutTask);
            this.getHandler().postDelayed(this.checkRequestTimeoutTask, 10000L);
        } else {
            this.onRequestCurrentChannelInfoList(ICoreManagerBase.getChannelLinkCore().getChannelInfoList(), null);
        }
    }

    private void findChannelType(ChannelInfo info) {
        if (this.checkNetToast()) {
            if (info == null) {
                return;
            }
            if (ICoreManagerBase.getChannelLinkCore().getCurrentChannelInfo().topSid == info.topSid && ICoreManagerBase.getChannelLinkCore().getCurrentChannelInfo().subSid == info.subSid) {
                this.finish();
                return;
            }
            this.requstChangeSubChannel(info);
        }
    }

    private void requstChangeSubChannel(ChannelInfo info) {
        if (this.prepareJoinInfo != null && info.topSid == this.prepareJoinInfo.topSid && info.subSid == this.prepareJoinInfo.subSid) {
            this.changeSubChannel("");
        } else {
            this.prepareJoinInfo = info;
            ((IDispenseChannelCore)ICoreManagerBase.getCore(IDispenseChannelCore.class)).requestChannelType(String.valueOf(info.topSid), String.valueOf(info.subSid), null);
            this.getHandler().removeCallbacks(this.mRequestChannelTypeRunnable);
            this.getHandler().postDelayed(this.mRequestChannelTypeRunnable, 5000L);
        }
    }

    @BusEvent(busType=1, busName="plugin_pluginunionlive", sync=true)
    public void onRequestChannelType(IDispenseChannelClient_onRequestChannelType_EventArgs busEventArgs) {
        String topCid = busEventArgs.mTopCid;
        String subCid = busEventArgs.mSubCid;
        String reTopCid = busEventArgs.mReTopCid;
        String reSubCid = busEventArgs.mReSubCid;
        int type = busEventArgs.mType;
        long uid = busEventArgs.mUid;
        Map extendInfo = busEventArgs.mExtendInfo;
        MLog.info((Object)TAG, (String)("receive requestChannelType topCid:" + topCid + ",subCid:" + subCid + ",reTopCid:" + reTopCid + ",reSubCid:" + reSubCid + ",type:" + type + ",uid:" + uid + " extendInfo = " + extendInfo), (Object[])new Object[0]);
        this.getHandler().removeCallbacks(this.mRequestChannelTypeRunnable);
        if (!this.checkActivityValid()) {
            MLog.info((Object)TAG, (String)"checkActivityValid", (Object[])new Object[0]);
            return;
        }
        if (extendInfo != null && extendInfo.containsKey("template_id") && this.prepareJoinInfo != null) {
            this.prepareJoinInfo.templateid = (String)extendInfo.get("template_id");
        }
        this.changeSubChannel("");
    }

    private void changeSubChannel(String password) {
        if (null == this.prepareJoinInfo) {
            MLog.error((Object)TAG, (String)"changeSubChannel prepareJoinInfo is null", (Object[])new Object[0]);
            return;
        }
        HashMap<String, String> extendInfo = new HashMap<String, String>();
        extendInfo.put("channel_from", "18");
        ICoreManagerBase.getChannelLinkCore().changeSubChannel(this.prepareJoinInfo.topSid, this.prepareJoinInfo.subSid, this.prepareJoinInfo.hasPassWord.booleanValue(), password, this.prepareJoinInfo.templateid, extendInfo);
        this.startShowJoining();
    }

    private void startShowJoining() {
        this.getHandler().removeCallbacks(this.showJoiningTask);
        this.getHandler().removeCallbacks(this.checkJoinTimeoutTask);
        this.getHandler().postDelayed(this.showJoiningTask, 3500L);
    }

    private void stopShowJoining() {
        this.getHandler().removeCallbacks(this.showJoiningTask);
        this.getHandler().removeCallbacks(this.checkJoinTimeoutTask);
        if (this.isJoiningShowing) {
            this.getDialogLinkManager().hideProgressDialog();
            this.isJoiningShowing = false;
        }
    }

    @Override
    public View.OnClickListener getLoadListener() {
        return new View.OnClickListener(){

            public void onClick(View v) {
                ChannelLinkSubListActivity.this.hideStatus();
                ChannelLinkSubListActivity.this.requestData();
            }
        };
    }

    @BusEvent
    public void onRequestCurrentChannelInfoList(IChannelLinkClient_onRequestCurrentChannelInfoList_EventArgs busEventArgs) {
        List infoList = busEventArgs.getInfoList();
        CoreError error = busEventArgs.getError();
        this.onRequestCurrentChannelInfoList(infoList, error);
    }

    private void onRequestCurrentChannelInfoList(List<ChannelInfo> infoList, CoreError error) {
        if (error == null && infoList != null) {
            this.getHandler().removeCallbacks(this.checkRequestTimeoutTask);
            this.hideStatus();
            this.mAdapter.setData(infoList);
            this.mAdapter.setOnlineCountMap(ICoreManagerBase.getChannelLinkCore().getSubChannelOnline());
            this.mAdapter.notifyDataSetChanged();
            this.selectCurrentChannel();
        }
    }

    @BusEvent
    public void updateCurrentChannelOnlineCount(IChannelLinkClient_updateCurrentChannelOnlineCount_EventArgs busEventArgs) {
        int onlineCount = busEventArgs.getOnlineCount();
        TreeMap subOnlineCountMap = busEventArgs.getSubOnlineCountMap();
        long now = SystemClock.elapsedRealtime();
        if (now - this.mLastUpdateOnlineCountTime > 4000L) {
            this.mLastUpdateOnlineCountTime = now;
            this.mAdapter.setOnlineCountMap(subOnlineCountMap);
        }
    }

    @BusEvent(sync=true)
    public void onJoinChannelSuccess(IChannelLinkClient_onJoinChannelSuccess_EventArgs busEventArgs) {
        ChannelInfo info = busEventArgs.getInfo();
        MLog.info((Object)TAG, (String)("onJoinChannelSuccess info = " + info), (Object[])new Object[0]);
        if (this.isFinishing()) {
            return;
        }
        this.stopShowJoining();
        this.setResultToChannel();
        this.finish();
    }

    @BusEvent(sync=true)
    public void onChangeChannelError(IChannelLinkClient_onChangeChannelError_EventArgs busEventArgs) {
        long topSid = busEventArgs.getTopSid();
        long subSid = busEventArgs.getSubSid();
        ChannelInfo beforeChannelInfo = busEventArgs.getBeforeChannelInfo();
        CoreError error = busEventArgs.getError();
        MLog.info((Object)TAG, (String)("parseJoinError SUB_Channel_Join_NoChannel = " + error.code), (Object[])new Object[0]);
        this.stopShowJoining();
        if (this.isFinishing()) {
            return;
        }
        if (error.code == 6 || error.code == 401) {
            this.showPasswordErrorToast();
            this.getDialogLinkManager().showInputDialog(this.getString(R.string.str_user_need_passwd), false, true, true, new DialogLinkManager.InputDialogListener(){

                public void cancel() {
                    ChannelLinkSubListActivity.this.isCheckingPwd = false;
                }

                public boolean confirm(String password) {
                    if (ChannelLinkSubListActivity.this.prepareJoinInfo != null) {
                        if (password == null) {
                            password = "";
                        }
                        ChannelLinkSubListActivity.this.isCheckingPwd = true;
                        ChannelLinkSubListActivity.this.changeSubChannel(password);
                    }
                    return true;
                }

                public void onExit() {
                }
            });
        } else if (error.code == 405) {
            this.toast("\u62b1\u6b49\uff0c\u8be5\u9891\u9053\u4eba\u6570\u5df2\u8fbe\u5230\u4e0a\u9650");
        } else if (error.code == 403) {
            this.toast(R.string.str_join_channel_error_forbid_guest);
        } else if (error.code >= 400) {
            this.toast(R.string.str_change_sub_channel_error);
        } else {
            this.toast(R.string.str_change_sub_channel_error);
        }
    }

    private void setResultToChannel() {
        if (this.prepareJoinInfo != null) {
            Intent intent = new Intent();
            intent.putExtra("channel_sid", this.prepareJoinInfo.topSid);
            intent.putExtra("channel_ssid", this.prepareJoinInfo.subSid);
            intent.putExtra("channel_templateId", this.prepareJoinInfo.templateid);
            this.setResult(-1, intent);
        } else {
            MLog.error((Object)TAG, (String)"setResultToChannel is null", (Object[])new Object[0]);
        }
    }

    @BusEvent(sync=true)
    public void onCurrentMultiKick(IChannelLinkClient_onCurrentMultiKick_EventArgs busEventArgs) {
        SessMultiKick kick = busEventArgs.getKick();
        this.finish();
    }

    private void showPasswordErrorToast() {
        if (this.isCheckingPwd) {
            this.toast(R.string.str_channel_password_error_please_re_input);
            this.isCheckingPwd = false;
        }
    }

    private void selectCurrentChannel() {
        for (int i = 0; i < this.mAdapter.getGroupCount(); ++i) {
            if (this.mAdapter.isCurrentChannel(this.mAdapter.getGroup(i))) {
                this.mListView.setSelectedGroup(i);
                return;
            }
            for (int j = 0; j < this.mAdapter.getChildrenCount(i); ++j) {
                if (!this.mAdapter.isCurrentChannel(this.mAdapter.getChild(i, j))) continue;
                this.mListView.expandGroup(i);
                this.mListView.setSelectedChild(i, j, true);
                return;
            }
        }
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        this.mAdapter = null;
        this.prepareJoinInfo = null;
        if (this.getHandler() != null) {
            this.getHandler().removeCallbacks(this.checkRequestTimeoutTask);
            this.getHandler().removeCallbacks(this.showJoiningTask);
            this.getHandler().removeCallbacks(this.checkJoinTimeoutTask);
            this.getHandler().removeCallbacks(this.mRequestChannelTypeRunnable);
            this.getHandler().removeCallbacksAndMessages(null);
        }
    }

    @Override
    public void onEventBind() {
        super.onEventBind();
        if (this.mChannelLinkSubListActivitySniperEventBinder == null) {
            this.mChannelLinkSubListActivitySniperEventBinder = new ChannelLinkSubListActivity$$EventBinder();
        }
        this.mChannelLinkSubListActivitySniperEventBinder.bindEvent((Object)this);
    }

    @Override
    public void onEventUnBind() {
        super.onEventUnBind();
        if (this.mChannelLinkSubListActivitySniperEventBinder != null) {
            this.mChannelLinkSubListActivitySniperEventBinder.unBindEvent();
        }
    }
}

