/*
 * Decompiled with CFR 0.152.
 */
package com.yy.live.module.treasure;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.BaseAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.handmark.pulltorefresh.library.PullToRefreshBase;
import com.handmark.pulltorefresh.library.PullToRefreshListView;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.live.module.treasure.TreasureCardFragment$$EventBinder;
import com.yy.live.module.treasure.TrueLoveAnchorUtil;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.image.CircleImageView;
import com.yy.mobile.image.ImageConfig;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.imageloader.ImageLoader;
import com.yy.mobile.plugin.main.events.IAuthClient_onLoginSucceed_EventArgs;
import com.yy.mobile.plugin.main.events.ITrueLoveClient_onQueryTreasureGroupInfo_EventArgs;
import com.yy.mobile.plugin.main.events.ITrueLoveClient_onQueryTreasureGroupUserInfoError_EventArgs;
import com.yy.mobile.plugin.main.events.ITrueLoveClient_onQueryTreasureGroupUserInfo_EventArgs;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.basicchanneltemplate.component.Component;
import com.yy.mobile.ui.widget.EndlessListScrollListener;
import com.yy.mobile.ui.widget.SimpleTitleBar;
import com.yy.mobile.ui.widget.StatusLayout;
import com.yy.mobile.util.SafeDispatchHandler;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.ylink.bridge.CoreApiManager;
import com.yy.mobile.ylink.bridge.coreapi.BaseFragmentApi;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.basechannel.IChannelLinkCore;
import com.yymobile.core.ent.EntError;
import com.yymobile.core.truelove.ITrueLoveCore;
import com.yymobile.core.truelove.TrueLoveInfo;
import java.util.ArrayList;
import java.util.List;

public class TreasureCardFragment
extends Component {
    private static final String TAG = "TreasureCardFragment";
    public static final String TREASURECARD = "card";
    final int requestPerTime = 20;
    TrueLoveInfo.TreasureGroupData treasureGroupData;
    int requestStart;
    private RecycleImageView myHeadImage;
    private EndlessListScrollListener mEndlessListScrollListener;
    private TextView nickAndGroupName;
    private TextView score;
    private TextView rank;
    private TextView joinTime;
    private TextView endTime;
    private PullToRefreshListView groupMemberList;
    private GroupMemberListViewAdapter groupMemberListViewAdapter;
    private boolean mIsLastPage = false;
    private boolean isFistReq = true;
    private boolean shouldClear;
    private Handler handler;
    private Runnable runnable;
    private Runnable runnable1;
    private View view;
    private IChannelLinkCore channelLinkCore;
    private EventBinder mTreasureCardFragmentSniperEventBinder;

    public static TreasureCardFragment newInstance() {
        TreasureCardFragment treasureCardFragment = new TreasureCardFragment();
        return treasureCardFragment;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.view = inflater.inflate(R.layout.treasure_fragment_groupcard, null);
        this.channelLinkCore = ICoreManagerBase.getChannelLinkCore();
        this.treasureGroupData = (TrueLoveInfo.TreasureGroupData)TrueLoveInfo.MyTrueLoveInfo.treasureGroupDataArrayMap.get((Object)(String.valueOf(LoginUtil.getUid()) + String.valueOf(this.channelLinkCore.getCurrentTopMicId())));
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)("[onCreateView],treasureGroupData" + this.treasureGroupData), (Object[])new Object[0]);
        }
        this.handler = new SafeDispatchHandler();
        this.initViews();
        this.runnable = new Runnable(){

            @Override
            public void run() {
                TreasureCardFragment.this.groupMemberList.onRefreshComplete();
            }
        };
        this.runnable1 = new Runnable(){

            @Override
            public void run() {
                TreasureCardFragment.this.mEndlessListScrollListener.onLoadComplete();
                if (TreasureCardFragment.this.checkNetToast()) {
                    TreasureCardFragment.this.toast("\u5df2\u7ecf\u5230\u5e95\u4e86");
                }
            }
        };
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)"wangke", (String)"onCreat", (Object[])new Object[0]);
        }
        if (this.treasureGroupData != null) {
            this.onQueryTreasureGroupInfo(this.treasureGroupData);
        }
        this.initPullList();
        return this.view;
    }

    private void initViews() {
        this.myHeadImage = (RecycleImageView)this.view.findViewById(R.id.GroupHeader_image);
        this.nickAndGroupName = (TextView)this.view.findViewById(R.id.GroupName);
        this.score = (TextView)this.view.findViewById(R.id.GroupScore);
        this.rank = (TextView)this.view.findViewById(R.id.GroupRank);
        this.joinTime = (TextView)this.view.findViewById(R.id.InGroupTime);
        this.endTime = (TextView)this.view.findViewById(R.id.outGroupTime);
        this.groupMemberList = (PullToRefreshListView)this.view.findViewById(R.id.GroupMemberlist);
        this.groupMemberList.setShowIndicator(false);
        SimpleTitleBar mTitleBar1 = (SimpleTitleBar)this.view.findViewById(R.id.title_bar1);
        mTitleBar1.setTitlte("\u7c89\u4e1d");
        mTitleBar1.setLeftBtn(R.drawable.icon_nav_back, new View.OnClickListener(){

            public void onClick(View v) {
                TreasureCardFragment.this.finishTreasureCard();
            }
        });
        mTitleBar1.setVisibility(0);
        boolean isGroupLeader = TrueLoveAnchorUtil.isMyselfTopMicAndAnchor();
        if (isGroupLeader) {
            RelativeLayout relativeLayout = (RelativeLayout)this.view.findViewById(R.id.title);
            relativeLayout.setVisibility(8);
            SimpleTitleBar mTitleBar = (SimpleTitleBar)this.view.findViewById(R.id.title_bar);
            mTitleBar.setTitlte("\u7c89\u4e1d");
            mTitleBar.setLeftBtn(R.drawable.icon_nav_back, new View.OnClickListener(){

                public void onClick(View v) {
                    TreasureCardFragment.this.finishTreasureCard();
                }
            });
            mTitleBar.setVisibility(0);
        }
    }

    private void initPullList() {
        this.groupMemberListViewAdapter = new GroupMemberListViewAdapter((Activity)this.getActivity());
        this.groupMemberList.setScrollingWhileRefreshingEnabled(true);
        this.groupMemberList.setOnRefreshListener((PullToRefreshBase.OnRefreshListener)new PullToRefreshBase.OnRefreshListener<ListView>(){

            public void onRefresh(PullToRefreshBase<ListView> refreshView) {
                if (TreasureCardFragment.this.isNetworkAvailable()) {
                    TreasureCardFragment.this.refreshAllListAndRequest();
                } else {
                    TreasureCardFragment.this.checkNetToast();
                    TreasureCardFragment.this.handler.postDelayed(TreasureCardFragment.this.runnable, 300L);
                }
            }
        });
        this.mEndlessListScrollListener = new EndlessListScrollListener((StatusLayout)this.view.findViewById(R.id.status_layout_groupcard_fragment));
        this.mEndlessListScrollListener.setListener(new EndlessListScrollListener.EndlessListener(){

            public void onLoadData() {
                TreasureCardFragment.this.loadFixedItem();
            }

            public boolean shouldLoadData() {
                if (TreasureCardFragment.this.mIsLastPage) {
                    if (MLog.isLogLevelAboveDebug()) {
                        MLog.debug((Object)"wangke", (String)"loadComplete", (Object[])new Object[0]);
                    }
                    TreasureCardFragment.this.handler.postDelayed(TreasureCardFragment.this.runnable1, 500L);
                    return false;
                }
                return true;
            }
        });
        this.groupMemberList.setOnScrollListener((AbsListView.OnScrollListener)this.mEndlessListScrollListener);
        this.groupMemberList.setAdapter((ListAdapter)this.groupMemberListViewAdapter);
        this.loadFixedItem();
    }

    private void refreshAllListAndRequest() {
        this.requestStart = 0;
        this.shouldClear = true;
        this.requestTreasureGroupUserInfo(this.requestStart, 20);
    }

    private void loadFixedItem() {
        this.shouldClear = false;
        this.requestTreasureGroupUserInfo(this.requestStart, 20);
    }

    private void requestMyTreasureGroupInfo() {
        if (this.isNetworkAvailable()) {
            if (this.isLogined()) {
                Long uid = LoginUtil.getUid();
                if (uid > 0L) {
                    if (MLog.isLogLevelAboveDebug()) {
                        MLog.debug((Object)"wangke", (String)("onQueryTreasureGroupInforequestStart" + uid), (Object[])new Object[0]);
                    }
                    this.onQueryTreasureGroupInfo(this.treasureGroupData);
                }
            } else if (CoreApiManager.getInstance() != null && CoreApiManager.getInstance().getApi(BaseFragmentApi.class) != null) {
                ((BaseFragmentApi)CoreApiManager.getInstance().getApi(BaseFragmentApi.class)).showLoginDialog((Activity)this.getActivity());
            }
        } else {
            this.checkNetToast();
        }
    }

    private void requestTreasureGroupUserInfo(int offset, int size) {
        if (this.isNetworkAvailable()) {
            if (this.isLogined()) {
                long micId = this.channelLinkCore.getCurrentTopMicId();
                if (micId > 0L) {
                    if (this.isFistReq) {
                        this.showLoading();
                    }
                    micId = this.channelLinkCore.getCurrentTopMicId();
                    if (MLog.isLogLevelAboveDebug()) {
                        MLog.debug((Object)TAG, (String)("TreasureGroupUserInfo" + micId), (Object[])new Object[0]);
                    }
                    ((ITrueLoveCore)ICoreManagerBase.getCore(ITrueLoveCore.class)).queryTreasureGroupUserInfo(micId, offset, size);
                } else {
                    this.handler.postDelayed(this.runnable, 300L);
                }
            } else if (CoreApiManager.getInstance() != null && CoreApiManager.getInstance().getApi(BaseFragmentApi.class) != null) {
                ((BaseFragmentApi)CoreApiManager.getInstance().getApi(BaseFragmentApi.class)).showLoginDialog((Activity)this.getActivity());
            }
        } else {
            this.checkNetToast();
            if (this.isFistReq) {
                this.showReload();
            } else {
                this.mEndlessListScrollListener.onLoadComplete();
                this.groupMemberList.onRefreshComplete();
            }
        }
    }

    @BusEvent(sync=true)
    public void onQueryTreasureGroupInfo(ITrueLoveClient_onQueryTreasureGroupInfo_EventArgs busEventArgs) {
        TrueLoveInfo.TreasureGroupData treasureGroupData = busEventArgs.getTreasureGroupData();
        this.onQueryTreasureGroupInfo(treasureGroupData);
    }

    public void onQueryTreasureGroupInfo(TrueLoveInfo.TreasureGroupData treasureGroupData) {
        if (treasureGroupData != null) {
            if (MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)"wangke", (String)("onQueryMyGroupInfo" + treasureGroupData.toString()), (Object[])new Object[0]);
            }
            if (treasureGroupData.groupNick != null) {
                this.nickAndGroupName.setText((CharSequence)treasureGroupData.groupNick);
            }
            this.score.setText((CharSequence)("\u6d3b\u8dc3\u5ea6 : " + String.valueOf(treasureGroupData.scoreRank)));
            this.rank.setText((CharSequence)("\u6d3b\u8dc3\u5ea6\u6392\u540d : " + String.valueOf(treasureGroupData.usrRank)));
            if (treasureGroupData.joinTime != null && treasureGroupData.joinTime.contains(" ") && treasureGroupData.joinTime.split(" ").length > 0) {
                String tmp = treasureGroupData.joinTime.split(" ")[0];
                this.joinTime.setText((CharSequence)(tmp + "\u5165\u56e2"));
            }
            if (treasureGroupData.endTime != null) {
                this.endTime.setText((CharSequence)(treasureGroupData.endTime + "\u7279\u6743\u5230\u671f"));
            }
            String faceUrl = treasureGroupData.groupPic;
            ImageLoader.loadImage((String)faceUrl, (RecycleImageView)this.myHeadImage, (ImageConfig)new ImageConfig(140, 140), (int)R.drawable.info_header_bg);
        }
    }

    @BusEvent(sync=true)
    public void onQueryTreasureGroupUserInfo(ITrueLoveClient_onQueryTreasureGroupUserInfo_EventArgs busEventArgs) {
        long result = busEventArgs.getResult();
        long anchorid = busEventArgs.getAnchorid();
        ArrayList rankInfos = busEventArgs.getRankInfos();
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)"wangke", (String)("onQueryMyGroupInfo" + rankInfos.toString()), (Object[])new Object[0]);
        }
        if (result == 0L && anchorid == this.channelLinkCore.getCurrentTopMicId()) {
            if (rankInfos.size() == 0 && this.isFistReq) {
                this.showNoData(0, R.string.truelove_group_zero_member);
                return;
            }
            this.isFistReq = false;
            this.hideStatus();
            if (this.shouldClear) {
                this.groupMemberListViewAdapter.clearAll();
                this.shouldClear = false;
            }
            this.groupMemberListViewAdapter.addData(rankInfos);
            this.mEndlessListScrollListener.onLoadComplete();
            this.requestStart += rankInfos.size();
            this.mIsLastPage = rankInfos.size() < 20;
            this.groupMemberListViewAdapter.notifyDataSetChanged();
            this.groupMemberList.onRefreshComplete();
        }
    }

    @BusEvent(sync=true)
    public void onLoginSucceed(IAuthClient_onLoginSucceed_EventArgs busEventArgs) {
        long userId = busEventArgs.getUid();
        this.requestMyTreasureGroupInfo();
        this.refreshAllListAndRequest();
    }

    @BusEvent(sync=true)
    public void onQueryTreasureGroupUserInfoError(ITrueLoveClient_onQueryTreasureGroupUserInfoError_EventArgs busEventArgs) {
        EntError entError = busEventArgs.getEntError();
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)"wangke", (String)("onQueryMyGroupInfo error=" + entError), (Object[])new Object[0]);
        }
        if (entError != null) {
            this.hideStatus();
            if (!this.isNetworkAvailable() && this.isFistReq) {
                this.showReload();
            }
            this.mEndlessListScrollListener.onLoadComplete();
            this.groupMemberList.onRefreshComplete();
        }
    }

    public View.OnClickListener getLoadListener() {
        return new View.OnClickListener(){

            public void onClick(View view) {
                if (MLog.isLogLevelAboveDebug()) {
                    MLog.debug((Object)"wangke", (String)"Reload onclick", (Object[])new Object[0]);
                }
                TreasureCardFragment.this.refreshAllListAndRequest();
            }
        };
    }

    public void onDestroy() {
        this.hideStatus();
        this.handler.removeCallbacks(this.runnable);
        this.handler.removeCallbacks(this.runnable1);
        super.onDestroy();
    }

    private void finishTreasureCard() {
        FragmentManager fm = this.getActivity().getSupportFragmentManager();
        Fragment fragment = fm.findFragmentByTag(TREASURECARD);
        FragmentTransaction ft = fm.beginTransaction();
        if (fragment != null && !fragment.isHidden()) {
            ft.hide(fragment);
        }
        ft.commitAllowingStateLoss();
    }

    protected void onViewCreated(View view, Bundle bundle) {
        if (this.mTreasureCardFragmentSniperEventBinder == null) {
            this.mTreasureCardFragmentSniperEventBinder = new TreasureCardFragment$$EventBinder();
        }
        this.mTreasureCardFragmentSniperEventBinder.bindEvent((Object)this);
        super.onViewCreated(view, bundle);
    }

    protected void onDestroyView() {
        super.onDestroyView();
        if (this.mTreasureCardFragmentSniperEventBinder != null) {
            this.mTreasureCardFragmentSniperEventBinder.unBindEvent();
        }
    }

    class GroupMemberListViewAdapter
    extends BaseAdapter {
        public List<TrueLoveInfo.TreasureGroupUserInfo> groupList = new ArrayList<TrueLoveInfo.TreasureGroupUserInfo>();
        private LayoutInflater mLayoutInflater;

        GroupMemberListViewAdapter(Activity ctx) {
            this.mLayoutInflater = LayoutInflater.from((Context)ctx);
        }

        public int getCount() {
            if (this.groupList != null) {
                return this.groupList.size();
            }
            return 0;
        }

        public View getView(int position, View convertView, ViewGroup viewGroup) {
            TrueLoveInfo.TreasureGroupUserInfo tempInfo;
            GroupMemberItemHolder holder;
            if (convertView != null && convertView.getTag() != null) {
                holder = (GroupMemberItemHolder)convertView.getTag();
            } else {
                if (convertView == null) {
                    convertView = this.mLayoutInflater.inflate(R.layout.list_treasure_item_groupmumber, null);
                }
                holder = new GroupMemberItemHolder();
                holder.nameText = (TextView)convertView.findViewById(R.id.Name);
                holder.headimage = (CircleImageView)convertView.findViewById(R.id.img);
                holder.scoreText = (TextView)convertView.findViewById(R.id.ScoreValue);
                convertView.setTag((Object)holder);
            }
            if (this.groupList != null && position >= 0 && position < this.groupList.size() && (tempInfo = this.groupList.get(position)) != null) {
                if (MLog.isLogLevelAboveDebug()) {
                    MLog.debug((Object)"wangke", (String)("onQueryMyGroupInfo error=" + holder.headimage.getTag() + "=" + tempInfo.icon), (Object[])new Object[0]);
                }
                ImageLoader.loadImage((String)tempInfo.icon, (RecycleImageView)holder.headimage, (ImageConfig)ImageConfig.fullImageConfig(), (int)R.drawable.default_portrait);
                holder.nameText.setText((CharSequence)tempInfo.nick);
                holder.scoreText.setText((CharSequence)("\u6d3b\u8dc3\u5ea6 : " + tempInfo.score));
            }
            return convertView;
        }

        public Object getItem(int position) {
            if (this.groupList != null && position >= 0 && position < this.groupList.size()) {
                return this.groupList.get(position);
            }
            return null;
        }

        public long getItemId(int position) {
            return position;
        }

        public void addData(List<TrueLoveInfo.TreasureGroupUserInfo> list2) {
            if (list2 != null) {
                this.groupList.addAll(list2);
            }
        }

        public void clearAll() {
            this.groupList.clear();
        }

        class GroupMemberItemHolder {
            CircleImageView headimage;
            TextView nameText;
            TextView scoreText;

            GroupMemberItemHolder() {
            }
        }
    }
}

