/*
 * Decompiled with CFR 0.152.
 */
package com.yy.live.module.talentscout;

import android.content.Context;
import android.graphics.Typeface;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.duowan.mobile.entlive.events.IDanmuViewBasicClient_setDanMuLines_EventArgs;
import com.duowan.mobile.entlive.events.ITalentScoutClient_onTalentScoutInfo_EventArgs;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.android.sniper.api.event.EventCompat;
import com.yy.live.module.talentscout.TalentScoutController$$EventBinder;
import com.yy.mobile.RxBus;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_leaveCurrentChannel_EventArgs;
import com.yy.mobile.plugin.main.events.IGiftUIListener_onHideGiftComponent_EventArgs;
import com.yy.mobile.plugin.pluginunionlive.PluginBus;
import com.yy.mobile.plugin.pluginunionlive.R;
import com.yy.mobile.ui.utils.AbstractViewController;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.channel.ChannelInfo;
import com.yymobile.core.talentscout.TalentScoutInfo;
import java.util.ArrayList;
import java.util.List;

public class TalentScoutController
extends AbstractViewController
implements EventCompat {
    public static final String TAG = "TalentScoutController";
    private ViewGroup rootView;
    private View talentScoutBar;
    private List<ImageView> imageViews;
    private int[] mResIds = new int[]{R.drawable.time_num_0, R.drawable.time_num_1, R.drawable.time_num_2, R.drawable.time_num_3, R.drawable.time_num_4, R.drawable.time_num_5, R.drawable.time_num_6, R.drawable.time_num_7, R.drawable.time_num_8, R.drawable.time_num_9};
    private TextView diamondNum;
    private int mSeconds;
    Runnable deadLineRunable = new Runnable(){

        @Override
        public void run() {
            TalentScoutController.this.setNumImage(--TalentScoutController.this.mSeconds);
        }
    };
    private EventBinder mTalentScoutControllerSniperEventBinder;

    public void onEventBind() {
        super.onEventBind();
        if (this.mTalentScoutControllerSniperEventBinder == null) {
            this.mTalentScoutControllerSniperEventBinder = new TalentScoutController$$EventBinder();
        }
        this.mTalentScoutControllerSniperEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        super.onEventUnBind();
        if (this.mTalentScoutControllerSniperEventBinder != null) {
            this.mTalentScoutControllerSniperEventBinder.unBindEvent();
        }
    }

    protected View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.rootView = (RelativeLayout)LayoutInflater.from((Context)this.getActivity()).inflate(R.layout.pk_layout, container, false);
        return this.rootView;
    }

    public void setNumImage(int seconds) {
        this.mSeconds = seconds;
        if (this.mSeconds == 0) {
            this.closeTalentScoutBar();
            return;
        }
        int ss = seconds % 60;
        int mm = seconds / 60;
        this.setImageRes(0, mm);
        this.setImageRes(2, ss);
        this.getHandler().postDelayed(this.deadLineRunable, 1000L);
    }

    private void setImageRes(int index, int time) {
        if (time < 10) {
            this.imageViews.get(index).setImageResource(this.mResIds[0]);
            this.imageViews.get(index + 1).setImageResource(this.mResIds[time]);
        } else {
            if (time / 10 > 10) {
                this.imageViews.get(index).setImageResource(this.mResIds[0]);
            } else {
                this.imageViews.get(index).setImageResource(this.mResIds[time / 10]);
            }
            this.imageViews.get(index + 1).setImageResource(this.mResIds[time % 10]);
        }
    }

    protected void onPause() {
        super.onPause();
    }

    protected void onResume() {
        super.onResume();
    }

    @BusEvent(busType=1, busName="plugin_pluginunionlive", sync=true)
    public void onTalentScoutInfo(ITalentScoutClient_onTalentScoutInfo_EventArgs busEventArgs) {
        TalentScoutInfo info = busEventArgs.mInfo;
        if (info == null) {
            return;
        }
        if (ICoreManagerBase.getChannelLinkCore().getCurrentTopMicId() <= 0L) {
            MLog.info((Object)TAG, (String)("topm=" + ICoreManagerBase.getChannelLinkCore().getCurrentTopMicId() + ",suid=" + info.scoutUid + ",tuid=" + info.talentUid), (Object[])new Object[0]);
            return;
        }
        if (info.status == 1) {
            if (this.talentScoutBar == null) {
                this.talentScoutBar = LayoutInflater.from((Context)this.getActivity()).inflate(R.layout.talent_scout_act_bar_layout, null);
                RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -2);
                if (this.isLandScape()) {
                    layoutParams.addRule(14);
                    layoutParams.addRule(12);
                } else {
                    layoutParams.addRule(13);
                }
                this.talentScoutBar.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            }
            if (this.talentScoutBar.getParent() == null) {
                this.rootView.addView(this.talentScoutBar);
            }
            if (this.imageViews == null) {
                this.imageViews = new ArrayList<ImageView>();
                this.imageViews.add((ImageView)this.talentScoutBar.findViewById(R.id.time_01));
                this.imageViews.add((ImageView)this.talentScoutBar.findViewById(R.id.time_02));
                this.imageViews.add((ImageView)this.talentScoutBar.findViewById(R.id.time_03));
                this.imageViews.add((ImageView)this.talentScoutBar.findViewById(R.id.time_04));
                TextView diamondNumTxt = (TextView)this.talentScoutBar.findViewById(R.id.red_diamond_num_txt);
                diamondNumTxt.setTypeface(Typeface.DEFAULT, 3);
                TextView deadLineTxt = (TextView)this.talentScoutBar.findViewById(R.id.dead_line_txt);
                deadLineTxt.setTypeface(Typeface.DEFAULT, 3);
                this.diamondNum = (TextView)this.talentScoutBar.findViewById(R.id.red_diamond_num);
                this.diamondNum.setTypeface(Typeface.DEFAULT, 3);
            }
            this.diamondNum.setText((CharSequence)String.valueOf(info.totalGiftNum));
            this.getHandler().removeCallbacks(this.deadLineRunable);
            this.setNumImage(info.leftSec);
            PluginBus.INSTANCE.get().post((Object)new IDanmuViewBasicClient_setDanMuLines_EventArgs(2, null, false));
        } else {
            this.getHandler().removeCallbacks(this.deadLineRunable);
            this.closeTalentScoutBar();
            RxBus.getDefault().post((Object)new IGiftUIListener_onHideGiftComponent_EventArgs());
        }
    }

    private void closeTalentScoutBar() {
        if (this.mRootView instanceof ViewGroup) {
            this.mRootView.post(new Runnable(){

                @Override
                public void run() {
                    ((ViewGroup)TalentScoutController.this.mRootView).removeAllViews();
                }
            });
        }
        PluginBus.INSTANCE.get().post((Object)new IDanmuViewBasicClient_setDanMuLines_EventArgs(3, null, false));
    }

    public void orientationChanged(boolean isLandscape) {
        super.onOrientationChanged(isLandscape);
        if (this.talentScoutBar != null && this.talentScoutBar.getParent() != null && this.talentScoutBar.getLayoutParams() != null && this.talentScoutBar.getLayoutParams() instanceof RelativeLayout.LayoutParams) {
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -2);
            if (this.isLandScape()) {
                layoutParams.addRule(14);
                layoutParams.addRule(12);
            } else {
                layoutParams.addRule(13);
            }
            this.talentScoutBar.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        }
    }

    protected void onDestroy() {
        this.mSeconds = 0;
        super.onDestroy();
    }

    @BusEvent(sync=true)
    public void leaveCurrentChannel(IChannelLinkClient_leaveCurrentChannel_EventArgs busEventArgs) {
        ChannelInfo channelInfo = busEventArgs.getInfo();
        this.mSeconds = 0;
        this.closeTalentScoutBar();
    }
}

