/*
 * Decompiled with CFR 0.152.
 */
package com.yy.live.module.giftdanmu;

import android.content.Context;
import android.text.Spannable;
import com.yy.live.module.giftdanmu.DanmuAirTicketFilter;
import com.yy.mobile.ui.widget.CustomImageSpan;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.log.MLog;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GroupAirTicketFilter
extends DanmuAirTicketFilter {
    private static final String PREFIX = "Y\u7fa4";
    private static final String GROUP_TICKET_REG = "(((?i)yy)://qun-\\[gaid=([0-9]+)&action=add])";
    private static final Pattern GROUP_TICKET_PATTERN = Pattern.compile("(((?i)yy)://qun-\\[gaid=([0-9]+)&action=add])");
    private static final String NUMBER_REG = "[0-9]+";
    private static final Pattern NUMBER_PATTERN = Pattern.compile("[0-9]+");

    public GroupAirTicketFilter(int id2) {
        super(id2);
    }

    public static List<GroupTicketInfo> parseGroupTicket(String msg) {
        ArrayList<GroupTicketInfo> infoList = new ArrayList<GroupTicketInfo>();
        Matcher matcher = GROUP_TICKET_PATTERN.matcher(msg);
        while (matcher.find()) {
            String groupMsg = msg.substring(matcher.start(), matcher.end());
            Matcher m = NUMBER_PATTERN.matcher(groupMsg);
            try {
                if (!m.find()) continue;
                infoList.add(new GroupTicketInfo(matcher.start(), matcher.end(), Long.parseLong(groupMsg.substring(m.start(), m.end()))));
            }
            catch (NumberFormatException e) {
                MLog.error((Object)"hjinw", (String)"parse Channel sid or subSid error :%s", (Throwable)e, (Object[])new Object[0]);
            }
        }
        return infoList;
    }

    public static boolean isYGroupTicketMessage(CharSequence msg) {
        return GROUP_TICKET_PATTERN.matcher(msg).find();
    }

    public static String replaceGroupTicketWithGivenStr(String message, String givenStr) {
        Matcher m = GROUP_TICKET_PATTERN.matcher(message);
        return m.replaceAll(givenStr).trim();
    }

    @Override
    public Spannable filterSpan(Context context, Spannable spannable) {
        if (!GroupAirTicketFilter.isYGroupTicketMessage((CharSequence)spannable)) {
            return spannable;
        }
        if (this.ticketDrawable == null) {
            this.ticketDrawable = this.getTicketDrawable(context);
        }
        return spannable;
    }

    public void parseSpannable(Context context, Spannable spannable, int maxWidth) {
        this.parseSpannable(context, spannable, maxWidth, null);
    }

    public void parseSpannable(Context context, Spannable spannable, int maxWidth, Object tag) {
        if (!GroupAirTicketFilter.isYGroupTicketMessage((CharSequence)spannable)) {
            return;
        }
        if (this.ticketDrawable == null) {
            this.ticketDrawable = this.getTicketDrawable(context);
        }
        this.setSpannable(spannable, maxWidth);
    }

    private void setSpannable(Spannable spannable) {
        this.setSpannable(spannable, Integer.MAX_VALUE);
    }

    private void setSpannable(Spannable spannable, int maxWidth) {
        List<GroupTicketInfo> infos = GroupAirTicketFilter.parseGroupTicket(spannable.toString());
        for (GroupTicketInfo info : infos) {
            CustomImageSpan airTicketSpan = new CustomImageSpan(this.ticketDrawable, String.valueOf(info.groupAliasId));
            this.setSpannable(FP.toList((Object[])new Object[]{airTicketSpan}), spannable, info.start, info.end, 33);
        }
    }

    public static class GroupTicketInfo {
        public int start;
        public int end;
        public long groupAliasId;

        public GroupTicketInfo(int start2, int end, long aliasId) {
            this.start = start2;
            this.end = end;
            this.groupAliasId = aliasId;
        }

        public String toString() {
            return "[start = " + this.start + "; end = " + this.end + "; groupId = " + this.groupAliasId + "]";
        }
    }
}

