package com.yy.mobile.heytap

import android.app.Activity
import android.app.Application
import android.app.Dialog
import android.app.ProgressDialog
import android.content.Context
import android.util.Log
import com.yy.android.small.pluginbase.IPluginEntryPoint
import com.yy.hiidostatis.api.HiidoSDK
import com.yy.hiidostatis.api.StatisLogWriter
import com.yy.hiidostatis.inner.util.log.L
import com.yy.mobile.crash.CrashSdk
import com.yy.mobile.replugin.ApiBridge
import com.yy.mobile.unionsdk.FinishListener
import com.yy.mobile.unionsdk.UnionYYSdk
import com.yy.mobile.util.DontProguardClass
import com.yy.mobile.util.DontProguardMethod
import com.yy.mobile.util.log.MLog
import java.lang.reflect.Proxy

/**
 * Created by wangfeihang on 2019-06-19.
 */
@DontProguardClass
object OPYYSDK : UnionYYSdk() {

    private const val TAG = "OPYYSDK"

    var isDebug = true
        set(value) {
            if (!isInstalled.get() && !isInstalling.get()) {
                field = value
            }
        }

    /**
     * OPPO获取我方实现的方法。
     * 调用该方法后，如果yy的sdk还没有被初始化，会先进行sdk的初始化，然后再执行接口内的业务逻辑
     * [actionCls] 双方定义的接口类的class
     * [application] 用来进行sdk的初始化
     * [context] 用来show sdk加载时的loading弹窗
     */
    fun <Action : Any> obtainAction(
        actionCls: Class<Action>,
        application: Application,
        context: Context? = null,
        showLoading: Boolean = false
    ): Action? {
        if (isInstalling.get()) {
            Log.e(TAG, "sdk is isInstalling")
            return null
        }

        val invocationHandler = ApiInvocationHandler(
            realObj = { ApiBridge.getApi(actionCls) },
            beforeInvoke = { _, _ ->
                var loadingDialog: Dialog? = null
                if (showLoading && context != null) {
                    loadingDialog = showSDKLoadingDialog(context)
                }

                !initYYSdkSuc(application, object : FinishListener {
                    override fun onFinish() {
                        if (showLoading) {
                            loadingDialog?.dismiss()
                            MLog.info(TAG, "dialog dismiss")
                        }
                    }
                })
            }
        )
        return Proxy.newProxyInstance(
            invocationHandler.javaClass.classLoader,
            arrayOf(actionCls),
            invocationHandler
        ) as Action
    }

    private fun showSDKLoadingDialog(context: Context): Dialog? {
        if (context is Activity && !context.isFinishing) {
            val progressDialog = ProgressDialog(context).apply {
                //                this.setMessage("正在加载中...")
                this.setCancelable(false)
            }
            progressDialog.show()
            MLog.info(TAG, "dialog showing")
            return progressDialog
        }
        return null
    }

    /**
     * This method will be invoked by inflection. (Magnet/RestartUnionSDK)
     */
    @JvmStatic
    @JvmOverloads
    @DontProguardMethod
    fun initYYSdk(
        application: Application,
        finishListener: FinishListener? = null,
        context: Context? = null,
        showLoading: Boolean = false
    ) {
        CrashSdk.initCrashSDK(application)
        var loadingDialog: Dialog? = null
        if (showLoading && context != null) {
            loadingDialog = showSDKLoadingDialog(context)
        }
        initYYSdkSuc(application, object : FinishListener {
            override fun onFinish() {
                MLog.info(TAG, "initYYSdk, onFinish")
                if (showLoading) {
                    loadingDialog?.dismiss()
                }
                finishListener?.onFinish()
            }
        })
    }

    override fun initYYSdkSuc(application: Application, finishListener: FinishListener): Boolean {
        MLog.info(TAG, "initYYSdk")
        if (isInstalling.get()) {
            this.addFinishListener(finishListener)
        } else if (!isInstalled.get()) {
            MLog.info(TAG, "not isInstalled")
            this.init(application, isDebug)
            this.initAsync {
                finishListener.onFinish()
                // 自动化测试日志开关
                if (isDebug) {
                    L.setLogOn(true)
                    HiidoSDK.instance().setLogWriter(object : StatisLogWriter {
                        override fun write(p0: Int, p1: String?) {}

                        override fun outputDebug(): Boolean {
                            return true
                        }
                    })
                }
            }
            return true
        } else {
            finishListener.onFinish()
            return true
        }
        return false
    }

    override fun dealWithSvcState(pluginMap: Map<String, Pair<Set<String>?, IPluginEntryPoint>>) {
        finish(pluginMap.keys.toList())
    }
}

