package com.yy.mobile.heytap

import android.Manifest
import android.annotation.SuppressLint
import android.content.Intent
import android.os.Bundle
import android.support.v4.app.FragmentActivity
import android.view.View
import com.gyf.immersionbar.ImmersionBar
import com.sembozdemir.permissionskt.askPermissions
import com.unionyy.mobile.heytap.api.OP2YYAuthAction
import com.unionyy.mobile.heytap.api.OP2YYChannelAction
import com.unionyy.mobile.heytap.api.OP2YYFeedbackAction
import com.unionyy.mobile.heytap.personalcard.OPPersonalCardComponent
import com.unionyy.mobile.magnet.core.state.CrossProcessLoginState
import com.unionyy.mobile.magnet.core.state.InterruptState
import com.unionyy.mobile.magnet.core.state.LoginState
import com.unionyy.mobile.magnet.core.state.LogoutState
import com.unionyy.mobile.magnet.southpole.Magnet
import com.unionyy.opensdk.BuildConfig
import com.yy.mobile.baseapi.AuthCallback
import com.yy.mobile.baseapi.Union2YYSettingAction
import com.yy.mobile.bizmodel.login.LoginUtil
import com.yy.mobile.ui.widget.toast.Toast
import com.yy.mobile.util.log.MLog
import com.yy.mobile.util.pref.CommonPref
import com.yy.mobile.ylink.bridge.CoreApiManager
import com.yy.mobile.ylink.bridge.coreapi.NavigationUtilApi
import kotlinx.android.synthetic.main.oppo_activity_demo.*

class DemoActivity : FragmentActivity() {

    companion object {
        private const val TAG = "DemoActivity"
    }

    @SuppressLint("CheckResult")
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.oppo_activity_demo)

        ImmersionBar.with(this).init()
        et_channel_sid.autoSaveLastModifyRecord()

        askPermissions(
            Manifest.permission.READ_PHONE_STATE,
            Manifest.permission.WRITE_EXTERNAL_STORAGE,
            Manifest.permission.READ_EXTERNAL_STORAGE,
            Manifest.permission.INTERNET
        ) {}

        btnLogin.setOnClickListener {
            if (LoginUtil.isLogined()) {
                Toast.makeText(this, "已登录!", Toast.LENGTH_SHORT).show()
            }
            startActivity(Intent(this, PasswordLoginActivity::class.java))
        }

        feedBack.setOnClickListener {
            OPYYSDK.obtainAction(OP2YYFeedbackAction::class.java, application)?.startFeedbackActivity(this)
        }

        h5Test.setOnClickListener {
            CoreApiManager.getInstance().getApi(NavigationUtilApi::class.java)?.toJSSupportedWebView(
                this,
                "http://webtest.yy.com/app_doc/index.html"
            )
        }

        refreshState()
        tv_app_version.text = "YY版本号：${BuildConfig.YYSDK_VER}"

        cb_show_user_id.apply {
            setOnCheckedChangeListener { _, isChecked ->
                CommonPref.instance().putBoolean(OPPersonalCardComponent.OPPO_SHOW_USER_ID, isChecked)
            }
            try {
                val checkedPref = CommonPref.instance()
                    .getBoolean(OPPersonalCardComponent.OPPO_SHOW_USER_ID, false)
                MLog.info(TAG, "checkedPref = $checkedPref")
                isChecked = checkedPref
            } catch (e: NullPointerException) {
                MLog.error(TAG, "please init yy sdk first.")
            }
        }
    }

    fun gotoChannel(v: View) {
        val sid = et_channel_sid.text.toString().toLongOrNull() ?: 1493896955
        val ssid = 0L
        OPYYSDK.obtainAction(OP2YYChannelAction::class.java, application)?.run {
            instance(sid, ssid).joinChannel(this@DemoActivity)
        }

    }

    fun gotoSetting(v: View) {
        OPYYSDK.obtainAction(Union2YYSettingAction::class.java, application)?.gotoSettingActivity(this)
    }

    fun login(v: View) {
        OPYYSDK.obtainAction(OP2YYAuthAction::class.java, application)
            ?.bindLogin(et_access_token.text.toString(), object : AuthCallback {
                override fun onSuccess(yyUid: Long, ticket: String, isNewUser: Boolean) {
                    Toast.makeText(
                        this@DemoActivity, "登录成功: $yyUid", Toast.LENGTH_SHORT
                    ).show()
                    refreshState()
                }

                override fun onFail(reason: String?) {
                    Toast.makeText(
                        this@DemoActivity, "登录失败 $reason", Toast.LENGTH_SHORT
                    ).show()
                }
            })
    }

    @SuppressLint("SetTextI18n")
    private fun refreshState() {
        val state = Magnet.getCurrentState()
        when (state) {
            is LoginState ->
                currentStateText.text =
                    "登录中-当前uid:${state.currentUid}, 第三方openId:${state.thirdPartyInfo?.openId}"
            is InterruptState ->
                currentStateText.text =
                    "匿名登录中-匿名uid:${state.anonymousUid}, 错误:${state.error?.message}"
            is LogoutState ->
                currentStateText.text = "匿名登录中-匿名uid:${state.anonymousUid}"
            is CrossProcessLoginState ->
                currentStateText.text = "跨进程登录中-当前uid:${state.currentUid}"
        }
    }
}