/*
 * Decompiled with CFR 0.152.
 */
package com.duowan.mobile.basemedia.watchlive.activity;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Bundle;
import com.duowan.mobile.basemedia.swipe.SwipeViewDelegate;
import com.duowan.mobile.basemedia.watchlive.activity.IViewingRoom;
import com.duowan.mobile.basemedia.watchlive.template.AbstractComponentContainer;
import com.duowan.mobile.basemedia.watchlive.template.ChannelBaseParam;
import com.duowan.mobile.basemedia.watchlive.template.ComponentRoot;
import com.duowan.mobile.basemedia.watchlive.template.FindSceneStrategy;
import com.duowan.mobile.basemedia.watchlive.template.IChannelBaseParam;
import com.duowan.mobile.basemedia.watchlive.template.IViewScene;
import com.duowan.mobile.basemedia.watchlive.template.ViewingRoomContext;
import com.yy.android.sniper.api.event.EventCompat;
import com.yy.mobile.ui.utils.dialog.DialogLinkManager;
import com.yy.mobile.util.DontProguardClass;
import com.yy.mobile.util.RxUtils;
import com.yy.mobile.util.log.MLog;
import io.reactivex.Flowable;
import io.reactivex.functions.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@DontProguardClass
public abstract class BaseViewingRoom
implements IViewingRoom<IChannelBaseParam>,
EventCompat {
    protected static final String TAG = "BaseViewingRoom";
    private ComponentRoot mCurrentRoot;
    private Activity activity;
    private DialogLinkManager mDialogManager;
    protected Bundle savedInstanceState;
    protected final FindSceneStrategy mStrategy;
    protected IViewScene<IChannelBaseParam> currentScene;
    protected final IChannelBaseParam param;
    protected int mState;

    public void onEventBind() {
    }

    public void onEventUnBind() {
    }

    public BaseViewingRoom(ComponentRoot currentRoot, Bundle bundle, FindSceneStrategy strategy) {
        this.mCurrentRoot = currentRoot;
        this.param = new ChannelBaseParam(bundle);
        this.mStrategy = strategy;
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        this.onEventBind();
        this.mState = 1;
        this.savedInstanceState = savedInstanceState;
    }

    @Override
    public void onStart() {
        this.mState = 4;
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
    }

    @Override
    public void onResume() {
        this.mState = 5;
    }

    @Override
    public void onPause() {
    }

    @Override
    public void onStop() {
    }

    @Override
    public void onDestroy() {
        this.onEventUnBind();
        if (this.mCurrentRoot != null) {
            this.mCurrentRoot.clear();
        }
        this.mState = 0;
    }

    @Override
    public void attach(Activity proxyActivity) {
        this.activity = proxyActivity;
    }

    @Override
    public void onSaveInstanceState(Bundle outState) {
    }

    @Override
    @SuppressLint(value={"CheckResult"})
    public void onNewIntent(Intent intent) {
        Bundle extras = intent.getExtras();
        if (extras != null) {
            this.param.updateInfo(extras);
        }
        this.updateChannelInfo(this.param).subscribe((Consumer)new Consumer<IViewScene>(){

            public void accept(IViewScene scene) {
                BaseViewingRoom.this.applySceneToRoot(scene);
            }
        }, RxUtils.errorConsumer((String)TAG, (String)"update channel info"));
    }

    @Override
    public void onRestoreInstanceState(Bundle savedInstanceState) {
    }

    @Override
    public boolean onBackPressed() {
        return false;
    }

    @Override
    public void onConfigurationChanged(Configuration newConfig) {
    }

    @Override
    public boolean interceptFinish() {
        return false;
    }

    @Override
    public long getSid() {
        return this.param.getSid();
    }

    @Override
    public long getSSid() {
        return this.param.getSsid();
    }

    @Override
    public String getTemplateId() {
        return this.param.getTemplateId();
    }

    @Override
    public IViewScene<IChannelBaseParam> getCurrentScene() {
        return this.currentScene;
    }

    @Override
    public AbstractComponentContainer getCurrentTemplate() {
        return this.mCurrentRoot.getContainer();
    }

    @Override
    public ComponentRoot getRoot() {
        return this.mCurrentRoot;
    }

    @Override
    public long getAnchorUid() {
        return this.param.getAnchorUid();
    }

    @Override
    public IChannelBaseParam getChannelBaseParam() {
        return this.param;
    }

    @Override
    public Activity getActivity() {
        return this.activity;
    }

    @Override
    public DialogLinkManager getDialogManager() {
        if (this.mDialogManager == null) {
            this.mDialogManager = new DialogLinkManager((Context)this.getActivity());
        }
        return this.mDialogManager;
    }

    @Override
    public int getState() {
        return this.mState;
    }

    @Override
    public Bundle getSavedInstanceState() {
        return this.savedInstanceState;
    }

    @Override
    public Flowable<IViewScene<IChannelBaseParam>> updateChannelInfo(IChannelBaseParam param) {
        MLog.info((Object)TAG, (String)("updateChannelInfo param = " + param), (Object[])new Object[0]);
        return this.mStrategy.findScene(new ViewingRoomContext(){

            @Override
            @NotNull
            public String getTAG() {
                return BaseViewingRoom.TAG;
            }

            @Override
            public void applySceneToRoot(@NotNull IViewScene<IChannelBaseParam> scene) {
                BaseViewingRoom.this.applySceneToRoot((IViewScene)scene);
            }

            @Override
            @Nullable
            public IViewScene<IChannelBaseParam> getCurrentScene() {
                return BaseViewingRoom.this.currentScene;
            }

            @Override
            public void setCurrentScene(@Nullable IViewScene<IChannelBaseParam> scene) {
                BaseViewingRoom.this.currentScene = scene;
            }
        }, param);
    }

    @Override
    public Flowable<IViewScene<IChannelBaseParam>> updateChannelInfo(Bundle bundle) {
        this.param.updateInfo(bundle);
        return this.updateChannelInfo(this.param);
    }

    @Override
    public Flowable<IViewScene<IChannelBaseParam>> updateChannelInfo(String templateId, long sid, long ssid) {
        this.param.updateSidAndSSid(sid, ssid);
        this.param.updateTemplateId(templateId);
        return this.updateChannelInfo(this.param);
    }

    @Override
    public Flowable<IViewScene<IChannelBaseParam>> updateChannelInfo(String templateId, long sid, long ssid, int liveType) {
        this.param.updateTemplateId(templateId);
        this.param.updateSidAndSSid(sid, ssid);
        this.param.updateLiveType(liveType);
        return this.updateChannelInfo(this.param);
    }

    @Override
    public void applySceneToRoot(String functionName) {
        this.applySceneToRoot(this.currentScene, functionName, 0);
    }

    @Override
    public void applySceneToRoot(IViewScene scene) {
        this.applySceneToRoot(scene, this.param.getFunction(), 0);
    }

    @Override
    public void applySceneToRoot(IViewScene scene, String functionName) {
        this.applySceneToRoot(scene, functionName, 0);
    }

    @Override
    public void applySceneToRoot(String functionName, int transit) {
        this.applySceneToRoot(this.currentScene, functionName, transit);
    }

    @Override
    public void onAllUIComponentDone() {
    }

    private void applySceneToRoot(IViewScene scene, String functionName, int transit) {
        MLog.info((Object)TAG, (String)"applySceneToRoot: scene=%s, functioName=%s, transit=%s", (Object[])new Object[]{scene, functionName, transit});
        this.param.updateFunction(functionName);
        scene.applyTo(this.mCurrentRoot, this.param, transit);
    }

    @Override
    public void onWindowFocusChanged(boolean hasFocus) {
    }

    @Override
    public void autoSwapToNextChannel() {
    }

    @Override
    public SwipeViewDelegate getSwipeListener() {
        return null;
    }
}

