/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivesdk4cloud.log;

import com.yy.yylivesdk4cloud.ThunderAPI;
import com.yy.yylivesdk4cloud.helper.ThunderLog;
import com.yy.yylivesdk4cloud.log.LogConfig;
import org.json.JSONObject;

public class LogConfigManager {
    private static final String TAG = "cfg_LogConfigManager";
    private static final String ARGO_CONFIG_KEY_LOG_CTRL_STRATEGY = "thunder_log_control_strategy";
    private LogConfig mConfig = null;
    public static final String[] ARGO_CONFIG_KEYS = new String[]{"thunder_log_control_strategy"};

    public static LogConfigManager instance() {
        return SingletonHolder.INSTANCE;
    }

    private LogConfigManager() {
    }

    public void onConfig(String key, String config) {
        if (key == null || config == null) {
            return;
        }
        if (key.equals(ARGO_CONFIG_KEY_LOG_CTRL_STRATEGY)) {
            this.parseLogConfig(config);
        }
    }

    private void parseLogConfig(String config) {
        try {
            JSONObject jsonObject = new JSONObject(config);
            this.mConfig = new LogConfig();
            this.mConfig.freelyWriteLogCount = jsonObject.optInt("freelyWriteLogCount");
            this.mConfig.maxQueueSize = jsonObject.optInt("maxQueueSize");
            this.mConfig.limitingInterval = jsonObject.optInt("limitingInterval");
            this.mConfig.audioengineLimit = jsonObject.optInt("audioengineLimit");
            this.mConfig.transsdkLimit = jsonObject.optInt("transsdkLimit");
            this.mConfig.platformLimit = jsonObject.optInt("platformLimit");
            ThunderLog.info(TAG, this.mConfig.toString());
            ThunderAPI.sharedInstance().fetchedLogConfig();
        }
        catch (Exception e) {
            ThunderLog.error(TAG, " parseLogConfig error :" + e.toString());
        }
    }

    public LogConfig getLogConfig() {
        return this.mConfig;
    }

    private static class SingletonHolder {
        private static final LogConfigManager INSTANCE = new LogConfigManager();

        private SingletonHolder() {
        }
    }
}

