/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivesdk4cloud.audio;

import com.yy.yylivesdk4cloud.audio.AudioCodecConfig;
import com.yy.yylivesdk4cloud.audio.AudioConfigManager;
import com.yy.yylivesdk4cloud.audio.AudioEffectConfig;
import com.yy.yylivesdk4cloud.audio.AudioPreProcConfig;
import com.yy.yylivesdk4cloud.helper.ThunderLog;
import java.util.Arrays;

public class ThunderAudioEngineImp {
    private AudioEncodeConfig m_currentEncodeCofig = null;
    private AudioPrePConfig m_currentPrePConfig = null;
    private AudioSoundEffectConfig m_currentEffectConfig = null;

    public void init() {
    }

    private AudioEncodeConfig getAudioCodecConfigByType(int type) {
        AudioCodecConfig config = AudioConfigManager.instance().getAudioCodecConfigByType(type);
        if (config != null) {
            this.m_currentEncodeCofig = new AudioEncodeConfig(config.codecId, config.bitRate, config.sampleRate, config.channels);
            ThunderLog.info("ThunderAudioEngineImp", " getAudioCodecConfigByType :" + this.m_currentEncodeCofig.toString());
            return this.m_currentEncodeCofig;
        }
        return null;
    }

    private AudioPrePConfig getAudioPreProcConfigByType(int type) {
        AudioPreProcConfig config = AudioConfigManager.instance().getAudioPreProcConfigByType(type);
        if (config != null) {
            this.m_currentPrePConfig = new AudioPrePConfig(config.sceneId, config.aec, config.agc, config.vad);
            ThunderLog.info("ThunderAudioEngineImp", " getAudioPreProcConfigByType :" + this.m_currentPrePConfig.toString());
            return this.m_currentPrePConfig;
        }
        return null;
    }

    private AudioSoundEffectConfig getAudioEffectConfigByType(int type) {
        AudioEffectConfig config = AudioConfigManager.instance().getAudioEffectConfigByType(type);
        if (config != null) {
            this.m_currentEffectConfig = new AudioSoundEffectConfig(config.useHighProfile, config.id, config.reverbHigh, config.eqgainHigh, config.limiterHigh, config.reverbLow, config.eqgainLow, config.limiterLow);
            ThunderLog.info("ThunderAudioEngineImp", " getAudioEffectConfigByType :" + this.m_currentEffectConfig.toString());
            return this.m_currentEffectConfig;
        }
        return null;
    }

    private static class AudioSoundEffectConfig {
        public boolean useHighProfile;
        public int id;
        public float[] reverbHigh;
        public float[] eqgainHigh;
        public float[] limiterHigh;
        public float[] reverbLow;
        public float[] eqgainLow;
        public float[] limiterLow;

        public AudioSoundEffectConfig(boolean useHighProfile, int id, float[] reverbHigh, float[] eqgainHigh, float[] limiterHigh, float[] reverbLow, float[] eqgainLow, float[] limiterLow) {
            this.useHighProfile = useHighProfile;
            this.id = id;
            this.reverbHigh = reverbHigh;
            this.eqgainHigh = eqgainHigh;
            this.limiterHigh = limiterHigh;
            this.reverbLow = reverbLow;
            this.eqgainLow = eqgainLow;
            this.limiterLow = limiterLow;
        }

        public String toString() {
            String tmp = "AudioEffectConfig:[useHighProfile: " + this.useHighProfile + ",id: " + this.id + ",reverbHigh:" + Arrays.toString(this.reverbHigh) + ",eqgainHigh:" + Arrays.toString(this.eqgainHigh) + ",limiterHigh:" + Arrays.toString(this.limiterHigh) + ",reverbLow:" + Arrays.toString(this.reverbLow) + ",eqgainLow:" + Arrays.toString(this.eqgainLow) + ",limiterLow:" + Arrays.toString(this.limiterLow) + "]";
            return tmp;
        }
    }

    private static class AudioPrePConfig {
        int sceneId;
        int aec;
        int agc;
        int vad;

        public AudioPrePConfig(int id, int aec, int agc, int vad) {
            this.sceneId = id;
            this.aec = aec;
            this.agc = agc;
            this.vad = vad;
        }

        public String toString() {
            String tmp = "AudioPrePConfig:[sceneId:" + this.sceneId + ",aec:" + this.aec + ",agc:" + this.agc + ",vad:" + this.vad + "]";
            return tmp;
        }
    }

    private static class AudioEncodeConfig {
        int codecId;
        int bitRate;
        int sampleRate;
        int channels;

        public AudioEncodeConfig(int id, int bitRate, int sampleRate, int channels) {
            this.codecId = id;
            this.bitRate = bitRate;
            this.sampleRate = sampleRate;
            this.channels = channels;
        }

        public String toString() {
            String tmp = "AudioEncodeConfig:[codecId:" + this.codecId + ",bitRate:" + this.bitRate + ",sampleRate:" + this.sampleRate + ",channels:" + this.channels + "]";
            return tmp;
        }
    }
}

