/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivesdk4cloud;

import android.content.Context;
import com.yy.platform.baseservice.IChannel;
import com.yy.platform.baseservice.IChannelListener;
import com.yy.platform.baseservice.IRPCChannel;
import com.yy.platform.baseservice.YYServiceCore;
import com.yy.platform.baseservice.profile.ChannelProfile;
import com.yy.platform.baseservice.profile.LogProfile;
import com.yy.platform.baseservice.profile.ServiceProfileFactory;
import com.yy.platform.baseservice.task.BroadSubOrUnSubTask;
import com.yy.platform.baseservice.task.RPCTask;
import com.yy.platform.baseservice.utils.UserGroupType;
import com.yy.yylivesdk4cloud.ThunderEngine;
import com.yy.yylivesdk4cloud.helper.ThunderLog;
import com.yy.yylivesdk4cloud.helper.ThunderNative;
import java.util.ArrayList;

public class ThunderServiceChannel
implements IChannelListener.IServiceBroadcastNotify,
IRPCChannel.RPCCallback<BroadSubOrUnSubTask.ResponseParam> {
    private IChannel mServiceChannel;
    private int mServiceChannelStatus = 0;
    private ArrayList<UserGroupType> mGrps = new ArrayList();
    private long mAppid = 0L;
    public static final int Init = 0;
    public static final int OnConnecting = 1;
    public static final int OnConnecttimeout = 2;
    public static final int OnConnected = 3;
    public static final int OnClosed = 4;
    public static final int Close = 5;
    public static final int Binded = 6;

    public void init(Context appContext, long appid) {
        this.mAppid = appid;
        YYServiceCore.setUseTrans((boolean)false);
        this.mServiceChannel = YYServiceCore.init((Context)appContext, (long)appid, (String)"", (ServiceProfileFactory)new ServiceProfileFactory(){

            public LogProfile logProfile() {
                return new LogProfile(){

                    public LogProfile.ILog getLog() {
                        return new LogProfile.ILog(){

                            public void outputLog(String log) {
                                ThunderLog.error("ycall-Java", log);
                            }
                        };
                    }

                    public String logPath() {
                        return null;
                    }

                    public boolean isLogCat() {
                        return false;
                    }
                };
            }

            public ChannelProfile channelProfile() {
                return null;
            }
        }, (IChannelListener.IChannelStatusNotify)new IChannelListener.IChannelStatusNotify(){

            public void onStatus(int status) {
                ThunderServiceChannel.this.mServiceChannelStatus = status;
                ThunderEngine.notifyServiceLinkStatus(status);
                ThunderLog.error("ycall-Java", "ThunderServiceChannel  init status =  %d", status);
            }
        });
    }

    public void fini() {
        YYServiceCore.deInit();
        this.mAppid = 0L;
        this.mGrps.clear();
        this.mServiceChannel = null;
        this.mServiceChannelStatus = 0;
    }

    public int getServiceChannelStatus() {
        return this.mServiceChannelStatus;
    }

    public void registBroadcastListener() {
        ThunderLog.error("ycall-Java", "ThunderServiceChannel registBroadcastListener");
        this.mServiceChannel.registBroadcastListener((IChannelListener.IServiceBroadcastNotify)this);
    }

    public void unregistBroadcastListener() {
        ThunderLog.error("ycall-Java", "ThunderServiceChannel unregistBroadcastListener");
        this.mServiceChannel.unregistBroadcastListener((IChannelListener.IServiceBroadcastNotify)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int subscribeBroadcast(String channelId, String uid) {
        String strAppid = Long.toString(this.mAppid);
        String hashValue = strAppid + "-" + channelId;
        int hashChan = this.hashString(hashValue);
        UserGroupType groupTypes = new UserGroupType(2147483686L, this.toUnsigned(hashChan));
        ArrayList<UserGroupType> arrayList = this.mGrps;
        synchronized (arrayList) {
            if (!this.mGrps.contains(groupTypes)) {
                RPCTask.RequestParam requestParam = new RPCTask.RequestParam("", "svcLog", uid, "".getBytes(), "", null, null, null);
                this.mServiceChannel.rpcCall(requestParam, null, (IRPCChannel.RPCCallback)new IRPCChannel.RPCCallback<RPCTask.ResponseParam>(){

                    public void onSuccess(int requestId, RPCTask.ResponseParam response) {
                    }

                    public void onFail(int requestId, int sdkResCode, int srvResCode, Exception e) {
                    }
                });
                this.mGrps.add(groupTypes);
                ThunderLog.error("ycall-Java", "ThunderServiceChannel subscribeBroadcast channelid = %s, hashchanid = %d , gid = %d", channelId, hashChan, groupTypes.mGroupId);
                return this.mServiceChannel.subscribeBroadcast(this.mGrps, (IRPCChannel.RPCCallback)this);
            }
            ThunderLog.error("ycall-Java", "has already subscribeBroadcast roomId: %s", channelId);
            return -2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int unSubscribeBroadcast() {
        ThunderLog.error("ycall-Java", "ThunderServiceChannel unSubscribeBroadcast all");
        ArrayList<UserGroupType> arrayList = this.mGrps;
        synchronized (arrayList) {
            int ret = this.mServiceChannel.unSubscribeBroadcast(this.mGrps, (IRPCChannel.RPCCallback)this);
            this.mGrps.clear();
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int unSubscribeBroadcast(String channelId) {
        String strAppid = Long.toString(this.mAppid);
        String hashValue = strAppid + "-" + channelId;
        int hashChan = this.hashString(hashValue);
        UserGroupType removeGroupType = new UserGroupType(2147483686L, this.toUnsigned(hashChan));
        ArrayList<UserGroupType> arrayList = this.mGrps;
        synchronized (arrayList) {
            if (this.mGrps.contains(removeGroupType)) {
                this.mGrps.remove(removeGroupType);
                ArrayList<UserGroupType> grps = new ArrayList<UserGroupType>();
                grps.add(removeGroupType);
                ThunderLog.info("ycall-Java", "unSubscribeBroadcast roomId: %s", channelId);
                return this.mServiceChannel.unSubscribeBroadcast(grps, (IRPCChannel.RPCCallback)this);
            }
            ThunderLog.error("ycall-Java", "not subscribeBroadcast roomId: %s", channelId);
            return -2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onBroadCast(long uid, long grpType, long grpId, String serviceName, String functionName, String protoType, byte[] data) {
        ArrayList<UserGroupType> arrayList = this.mGrps;
        synchronized (arrayList) {
            for (UserGroupType entry : this.mGrps) {
                if (entry.mGroupId != grpId || entry.mGroupType != grpType) continue;
                if (serviceName == null || serviceName.length() == 0 || functionName == null || functionName.length() == 0 || data.length == 0) break;
                try {
                    ThunderNative.resolveServiceData(String.valueOf(uid), Integer.parseInt(functionName), data);
                }
                catch (Exception e) {
                    ThunderLog.error("ycall-Java", "onBroadCast exception %s", e.toString());
                }
                break;
            }
        }
    }

    public void onSuccess(int requestId, BroadSubOrUnSubTask.ResponseParam response) {
        ThunderLog.error("ycall-Java", "ThunderServiceChannel registBroadcastListener Success mResCode =  %d", response.mResCode);
    }

    public void onFail(int requestId, int sdkResCode, int srvResCode, Exception e) {
        ThunderLog.error("ycall-Java", "ThunderServiceChannel registBroadcastListener Fail requestId = %d sdkResCode = %d srvResCode =  %d", requestId, sdkResCode, srvResCode);
    }

    private long toUnsigned(int s) {
        return (long)s & 0xFFFFFFFFL;
    }

    private int hashString(String channelId) {
        int lHash = -236792892;
        for (int i = 0; i < channelId.length(); ++i) {
            char c = channelId.charAt(i);
            lHash <<= 1;
            lHash += c;
        }
        return lHash;
    }
}

