/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylivesdk4cloud;

import com.yy.videoplayer.utils.YMFLog;
import com.yy.yylivesdk4cloud.ThunderGroup;
import com.yy.yylivesdk4cloud.ThunderStream;
import com.yy.yylivesdk4cloud.helper.ThunderLog;
import com.yy.yylivesdk4cloud.helper.ThunderNative;
import com.yy.yylivesdk4cloud.video.IVideoDecodeObserver;
import com.yy.yylivesdk4cloud.video.ThunderVideoLogCallback;
import java.util.ArrayList;

public class ThunderPlayer {
    public ArrayList<ThunderStream> subscribeStreams = null;

    ThunderPlayer() {
        YMFLog.registerLogger((Object)ThunderVideoLogCallback.sharedInstance());
        this.subscribeStreams = new ArrayList(0);
    }

    public int startPlayStreams(ArrayList<ThunderStream> streamList, ArrayList<ThunderGroup> groupList) {
        if (streamList == null) {
            streamList = new ArrayList(0);
        }
        if (groupList == null) {
            groupList = new ArrayList(0);
        }
        if (streamList.size() == 0 && groupList.size() == 0) {
            ThunderLog.warn("ycall-Java", "startPlayStreams both stream list and group list is empty");
            return -1;
        }
        for (ThunderStream oneStream : streamList) {
            if (!oneStream.bVideo) continue;
            oneStream.startSubscribeTime = System.currentTimeMillis();
            this.subscribeStreams.add(oneStream);
            ThunderLog.release("ycall-Java", "startPlayStreams video streamName " + oneStream.streamName + "spkUid:" + oneStream.speakerUid + "toVideo: " + oneStream.toView);
        }
        ThunderLog.release("ycall-Java", "startPlayStreams list size: %d %d", streamList.size(), groupList.size());
        return ThunderNative.startPlayStreams(streamList, groupList);
    }

    public int stopPlayStreams(ArrayList<ThunderStream> streamList, ArrayList<ThunderGroup> groupList) {
        if (streamList == null) {
            streamList = new ArrayList(0);
        }
        if (groupList == null) {
            groupList = new ArrayList(0);
        }
        if (streamList.size() == 0 && groupList.size() == 0) {
            ThunderLog.warn("ycall-Java", "stopPlayStreams both stream list and group list is empty");
            return -1;
        }
        block0: for (ThunderStream oneStream : streamList) {
            if (!oneStream.bVideo) continue;
            for (ThunderStream rmStream : this.subscribeStreams) {
                if (!rmStream.bVideo || rmStream.speakerUid != oneStream.speakerUid) continue;
                this.subscribeStreams.remove(rmStream);
                continue block0;
            }
        }
        ThunderLog.release("ycall-Java", "stopPlayStreams list size: %d %d", streamList.size(), groupList.size());
        return ThunderNative.stopPlayStreams(streamList, groupList);
    }

    public boolean enableHardwareDecoder(boolean enable) {
        ThunderLog.release("ycall-Java", "enableHardwareDecoder:%b", enable);
        return ThunderNative.enableHardwareDecoder(enable, 1);
    }

    public boolean enableMute(boolean enable, ThunderStream stream) {
        if (stream == null) {
            return false;
        }
        ThunderLog.release("ycall-Java", "enableMute %b for stream %s", enable, stream.streamName);
        return ThunderNative.enableMuteStream(enable, stream);
    }

    public boolean enableMute(boolean enable, String uid) {
        ThunderLog.release("ycall-Java", "enableMute %b for %s", enable, uid);
        return ThunderNative.enableMuteStringUid(enable, uid);
    }

    public boolean enableAllMute(boolean enable) {
        ThunderLog.release("ycall-Java", "enableAllMute %b", enable);
        ThunderNative.enableAllMute(enable);
        return true;
    }

    public boolean setPlayVolume(int volume, ThunderStream stream) {
        if (stream == null) {
            return false;
        }
        if (volume < 0) {
            volume = 0;
        } else if (volume > 100) {
            volume = 100;
        }
        ThunderLog.release("ycall-Java", "setPlayVolume %d for stream %s", volume, stream.streamName);
        return ThunderNative.setStreamPlayVolume(volume, stream);
    }

    public boolean setSpeakerVolume(int volume) {
        if (volume < 0) {
            volume = 0;
        } else if (volume > 100) {
            volume = 100;
        }
        ThunderLog.release("ycall-Java", "setSpeakerVolume %d", volume);
        return ThunderNative.setSpeakerVolume(volume);
    }

    public void enableLoudSpeaker(boolean enable) {
        ThunderLog.release("ycall-Java", "enableLoudSpeaker %b", enable);
        ThunderNative.enableLoudSpeaker(enable);
    }

    public boolean getLoudSpeakerEnabled() {
        ThunderLog.release("ycall-Java", "getLoudSpeakerEnabled");
        return ThunderNative.getLoudSpeakerEnabled();
    }

    public boolean isSupportPlayH265() {
        return ThunderNative.isSupportPlayH265();
    }

    public void setSubscribeStreamWHByUid(long uid, int _width, int _height) {
        for (ThunderStream oneStream : this.subscribeStreams) {
            if (!oneStream.bVideo || oneStream.speakerUid != uid) continue;
            oneStream.width = _width;
            oneStream.height = _height;
        }
    }

    public ThunderStream getSubscribeStreamByUid(long uid) {
        for (ThunderStream oneStream : this.subscribeStreams) {
            if (!oneStream.bVideo || oneStream.speakerUid != uid) continue;
            return oneStream;
        }
        return null;
    }

    public void removeSubscribeStreamByUid(long uid) {
        ThunderStream findStream = null;
        for (ThunderStream oneStream : this.subscribeStreams) {
            if (!oneStream.bVideo || oneStream.speakerUid != uid) continue;
            findStream = oneStream;
        }
        if (findStream != null) {
            this.subscribeStreams.remove(findStream);
        }
    }

    public void setVideoFrameObserver(String uid, IVideoDecodeObserver observer) {
        ThunderNative.setVideoFrameObserver(uid, observer);
    }
}

